// Demonstration 2: How to use buffers to program a screensaver
//                  Retrieving a pointer to the buffer memory
//                  Setting up a palette
//////////////////////////////////////////////////////////////////////

#define NUM_OF_VERTEXES 3 //The number of vertexes on the screen

BUFFERINFO info;          //Holds the pointer to the backbuffer

unsigned short vx  [NUM_OF_VERTEXES],vy  [NUM_OF_VERTEXES];
char           vxdi[NUM_OF_VERTEXES],vydi[NUM_OF_VERTEXES];
//Global variables needed for the screensaver

bool Initialize2(HWND hwnd){
   if (!CreateEngine(Gfx)) return(false);
   if (!Gfx->RegisterWindow(hwnd)) return(false);
   if (!Gfx->CreateScreen(Screen)) return(false);
   if (!Screen->SetGfxMode(320,240,8)) return(false);
   if (!Screen->AttachBuffer(Buffer)) return(false);
   if (!Buffer->GetInfo(&info)) return(false);
   return(true);
};//Prepare the program

void Cleanup2(void){
   if (Gfx!=NULL){
      if (Screen!=NULL){
         if (Buffer!=NULL) Buffer->Release();
         Screen->CloseGfxMode();
         Screen->Release();
      };
      Gfx->Release();
   };
};//Prepare to exit the program

void MakePalette(void){
   unsigned char Ctr;//Counter variable

   for (Ctr=0;Ctr<64;Ctr++){
      Pal[Ctr*3]=Ctr;
      Pal[Ctr*3+1]=0;
      Pal[Ctr*3+2]=0;       //Black->Red
      Pal[192+Ctr*3]=63;
      Pal[192+Ctr*3+1]=Ctr;
      Pal[192+Ctr*3+2]=0;   //Red->Yellow
      Pal[384+Ctr*3]=63;
      Pal[384+Ctr*3+1]=63;
      Pal[384+Ctr*3+2]=Ctr; //Yellow->White
      Pal[576+Ctr*3]=63;
      Pal[576+Ctr*3+1]=63;
      Pal[576+Ctr*3+2]=63;  //White
   };
   Screen->SetPalette(Pal);
};//Make a nice white-yellow-red-black 256 color palette

void BlurBuffer(void){
   _asm{
	  mov edi, info.Data8
	  mov esi, info.Data8
      add edi, 320
	  add esi, 320
      mov ecx, 76160
      xor eax, eax
      xor ebx, ebx
   };
   Looper:
   _asm{
      dec esi
      lodsb
      mov bx, ax
      inc esi
      lodsb
      add bx, ax
      sub esi, 322
      lodsb
      add bx, ax
      add esi, 639
      lodsb
      sub esi, 320
      add ax, bx
      shr ax, 2
      jz Nolower
      dec ax
   };
   Nolower:
   _asm{
      stosb
      dec ecx
      jnz Looper
   };
};//Use blurring to get a smooth fading effect

void InitScreenSaver(void){
   unsigned char Ctr;//Counter variable

   for (Ctr=0;Ctr<NUM_OF_VERTEXES;Ctr++){
      vx[Ctr]=rand()%300+10;
      vy[Ctr]=rand()%220+10;
      if (rand()%2==0) vxdi[Ctr]=-1; else vxdi[Ctr]=1;
      if (rand()%2==1) vydi[Ctr]=-1; else vydi[Ctr]=1;
   };//Determine vertex positions and directions
};//Initialize the screensaver

void UpdateFrame(void){
   unsigned char Ctr;//Counter variable

   for (Ctr=0;Ctr<NUM_OF_VERTEXES;Ctr++){
      vx[Ctr]+=vxdi[Ctr];
      vy[Ctr]+=vydi[Ctr];
      if (vx[Ctr]<5 || vx[Ctr]>314) vxdi[Ctr]=-vxdi[Ctr];
      if (vy[Ctr]<5 || vy[Ctr]>234) vydi[Ctr]=-vydi[Ctr];
   };//Move vertexes and collision detection from the sides of the screen

   //Draw the vertexes
   for (Ctr=0;Ctr<NUM_OF_VERTEXES-1;Ctr++) Buffer->Line(vx[Ctr],vy[Ctr],vx[Ctr+1],vy[Ctr+1],255);
   Buffer->Line(vx[0],vy[0],vx[NUM_OF_VERTEXES-1],vy[NUM_OF_VERTEXES-1],255);

   //Blur and send it to the screen
   BlurBuffer();
   Screen->VSync();
   Screen->Flip(Buffer);
};//Run the screensaver

void rundemo2(HWND hwnd){
   //Run the screensaver until a user presses a key
   if (Initialize2(hwnd)){
      Buffer->Clear();
      MakePalette();
      InitScreenSaver();
	  emptykeystate();
      while (!keypressed()) UpdateFrame();
   };
   Cleanup2();
};
