// Demonstration 3: Load a font and write graphics text to the screen
//                  Aligned font writing
//                  Grab an image from a buffer
//                  Blitting images
//////////////////////////////////////////////////////////////////////

bool Initialize3(HWND hwnd){
   if (!CreateEngine(Gfx)) return(false);
   if (!Gfx->RegisterWindow(hwnd)) return(false);
   if (!Gfx->CreateScreen(Screen)) return(false);
   if (!Screen->SetGfxMode(640,480,8)) return(false);
   if (!Screen->CreateFont(Font)) return(false);
   Font->Load("std8bit.fnt");
   if (!Screen->CreateImage(Image)) return(false);
   return(true);
};//Prepare the program

void Cleanup3(void){
   if (Gfx!=NULL){
      if (Image!=NULL) Image->Release();
      if (Font!=NULL) Font->Release();
      if (Screen!=NULL){
         Screen->CloseGfxMode();
         Screen->Release();
      };
      Gfx->Release();
   };
};//Prepare to exit the program

void rundemo3(HWND hwnd){
   unsigned short XCtr,YCtr;//Counter variables

   if (Initialize3(hwnd)){
      //Clear screen and draw a pattern
      Screen->Clear();
      Screen->HLine(0,7,0,63);
      Screen->VLine(0,15,0,63);
      Screen->HLine(0,7,15,255);
      Screen->VLine(0,15,7,255);
      Screen->Bar(1,1,6,14,2+8+32);
      Screen->WriteFont(0,32,"Press a key to see the whole pattern...",Font);
      emptykeystate();
	  while (!keypressed());

      //Grab the pattern into an image
      Image->Grab(0,0,7,15,Screen);
      Screen->Clear();

      //And repeat it on the screen
      for (YCtr=0;YCtr<30;YCtr++) for (XCtr=0;XCtr<80;XCtr++) Screen->Blit(XCtr*8,YCtr*16,0,Image);
      Screen->WriteFont(0,0,"Press any key to exit...",Font);
      emptykeystate();
	  while (!keypressed());
   };
   Cleanup3();
};
