// Demonstration 4: Advanced image operations
//////////////////////////////////////////////////////////////////////

#define  STARS 50  //The number of stars on the screen

unsigned short sx[STARS],sy[STARS];
unsigned char  sf[STARS];
//Globals needed to hold the star positions

bool Initialize4(HWND hwnd){
   if (!CreateEngine(Gfx)) return(false);
   if (!Gfx->RegisterWindow(hwnd)) return(false);
   if (!Gfx->CreateScreen(Screen)) return(false);
   if (!Screen->SetGfxMode(640,480,16)){
	  Screen->CloseGfxMode();
      if (!Screen->SetGfxMode(640,480,15)) return(false);
   };
   if (!Screen->AttachBuffer(Buffer)) return(false);
   if (!Screen->AttachBuffer(Saved)) return(false);
   if (!Screen->CreateImage(Image)) return(false);
   if (!Screen->CreateFont(Font)) return(false);
   Font->Load("std16bit.fnt");
   return(true);
};//Prepare the program

void Cleanup4(void){
   if (Gfx!=NULL){
      if (Font!=NULL) Font->Release();
      if (Image!=NULL) Image->Release();
      if (Saved!=NULL) Saved->Release();
      if (Buffer!=NULL) Buffer->Release();
      if (Screen!=NULL){
         Screen->CloseGfxMode();
         Screen->Release();
      };
      Gfx->Release();
   };
};//Prepare to exit the program

void InitStars(void){
   unsigned char SCtr;//Star counter
   for (SCtr=0;SCtr<STARS;SCtr++){
      sx[SCtr]=rand()%620;
      sy[SCtr]=rand()%440;
      sf[SCtr]=rand()%17;
   };
};//Calculate star positions etc.

void UpdateStarFrame(void){
   unsigned char SCtr;//Star counter
   Saved->Flip(Buffer);
   for (SCtr=0;SCtr<STARS;SCtr++){
      sf[SCtr]++;
      if (sf[SCtr]==17){
         sx[SCtr]=rand()%620;
         sy[SCtr]=rand()%440;
         sf[SCtr]=0;
      };
      if (sf[SCtr]<9) Buffer->AlphaBlendAdd(sx[SCtr],sy[SCtr]+20,sf[SCtr],0,Image);
      else Buffer->AlphaBlendAdd(sx[SCtr],sy[SCtr]+20,16-sf[SCtr],0,Image);
   };
   Screen->VSync();
   Screen->Flip(Buffer);
   Buffer->Flip(Saved);
};//Update the stars

void MakeImagePattern(void){
   unsigned short *Ptr;     //Stores the image information
   unsigned short YCtr,XCtr;//x and y position counters
   Ptr=(unsigned short *)malloc(2048);
   for (YCtr=0;YCtr<32;YCtr++) for (XCtr=0;XCtr<32;XCtr++){
      if (XCtr<YCtr) Ptr[YCtr*32+XCtr]=YCtr*64;
      else Ptr[YCtr*32+XCtr]=XCtr*64;
   };
   Image->Make(32,32,Ptr);
   free(Ptr);
};

void rundemo4(HWND hwnd){
   unsigned short XCtr,YCtr;//x and y position counter
   if (Initialize4(hwnd)){
      //Create a 'dark sky' pattern on the screen and some info text
      for (YCtr=0;YCtr<480;YCtr++) Buffer->HLine(0,639,YCtr,YCtr/15);
      Buffer->WriteFontAlign(0,0,"Press any key to proceed...",Font);

      //Load 4 stars images from the 24 bits 'stars.bmp' bitmap file
      //The engine converts it automatically at the first blit
      Image->LoadMultiBmp("stars.bmp",20,20);

      //Alphablend the images for a starry night until the user presses a key
      InitStars();
      emptykeystate();
      while (!keypressed()) UpdateStarFrame();

      //Creates a pattern on the screen using alpha blending
      MakeImagePattern();
      for (YCtr=0;YCtr<480;YCtr++) Buffer->HLine(0,639,YCtr,63488-YCtr/15*2048+YCtr/15);
      for (YCtr=0;YCtr<15;YCtr++) for (XCtr=0;XCtr<20;XCtr++) Buffer->AlphaBlendAdd(XCtr*32,YCtr*32,0,0,Image);
      Buffer->WriteFontAlign(0,0,"Press any key to proceed...",Font);
      Screen->Flip(Buffer);
      emptykeystate();
	  while (!keypressed());
   };
   Cleanup4();
};
