// Demonstration 5: 8-bit alpha blending
//////////////////////////////////////////////////////////////////////

bool Initialize5(HWND hwnd){
   if (!CreateEngine(Gfx)) return(false);
   if (!Gfx->RegisterWindow(hwnd)) return(false);
   if (!Gfx->CreateScreen(Screen)) return(false);
   if (!Screen->SetGfxMode(640,480,8)) return(false);
   if (!Screen->CreateImage(Image)) return(false);
   Image->LoadBmp("pattern.bmp");
   return(true);
};//Prepare the program

void Cleanup5(void){
   if (Gfx!=NULL){
      if (Image!=NULL) Image->Release();
      if (Screen!=NULL){
         Screen->CloseGfxMode();
         Screen->Release();
      };
      Gfx->Release();
   };
};//Prepare to exit the program

void rundemo5(HWND hwnd){
   unsigned short YCtr,XCtr;//x and y position counters
   if (Initialize5(hwnd)){
      //Draw a background pattern
      Screen->Lock();
	  for (YCtr=0;YCtr<480;YCtr++) for (XCtr=0;XCtr<640;XCtr++) Screen->PutPixel(XCtr,YCtr,XCtr+YCtr);
	  Screen->Lock();

      //Creating a palette lookup table:
      //Call this function before a conversion or alpha blend procedure,
      //when the screen is initialized or when a palette is changed.
      Screen->CreatePaletteLookupTable();

      //Alpha blend the pattern
      for (YCtr=0;YCtr<8;YCtr++) for (XCtr=0;XCtr<10;XCtr++) Screen->AlphaBlend(XCtr*64,YCtr*64,0,1,Image);
      emptykeystate();
	  while (!keypressed());
   };
   Cleanup5();
};
