// Windows example
//
// A part of the graphics engine GFX.H
// CopyRight (c) 2001, Johan Bos
// www.sludgesoft.com/johan
// bosjoh@fcmail.com
//////////////////////////////////////////////////////////////////////

#include <gfx.h>
#include "resource.h"
#include "globals.h"
#include "demo1.h"
#include "demo2.h"
#include "demo3.h"
#include "demo4.h"
#include "demo5.h"

BOOL WINAPI MainMsgHandler(HWND hwnd,UINT wmessage,WPARAM wparam,LPARAM lparam){
    switch(wmessage){
	    case WM_COMMAND:
			switch(wparam){
			    case IDC_DEMO1:
					MessageBox(hwnd,"Windows videomode test example\nClick on OK to proceed...","Demonstration 1",0);
					rundemo1(hwnd);
					return(TRUE);
					break;
			    case IDC_DEMO2:
					MessageBox(hwnd,"Windows screensaver example\nClick on OK to proceed...","Demonstration 2",0);
					rundemo2(hwnd);
					return(TRUE);
					break;
			    case IDC_DEMO3:
					MessageBox(hwnd,"Windows font and image example\nClick on OK to proceed...","Demonstration 3",0);
					rundemo3(hwnd);
					return(TRUE);
					break;
			    case IDC_DEMO4:
					MessageBox(hwnd,"Windows advanced image handling example\nClick on OK to proceed...","Demonstration 4",0);
					rundemo4(hwnd);
					return(TRUE);
					break;
			    case IDC_DEMO5:
					MessageBox(hwnd,"Windows 8bit Alphablend example\nClick on OK to proceed...","Demonstration 5",0);
					rundemo5(hwnd);
					return(TRUE);
					break;
			    case IDC_QUIT:
			        EndDialog(hwnd,IDABORT);
				    return(TRUE);
				    break;
			};
		case WM_CLOSE:
			EndDialog(hwnd,IDABORT);
			return(TRUE);
			break;
		case WM_DESTROY:
			MessageBox(hwnd,"Visit my website at: www.sludgesoft.com/johan","Windows example",0);
			return(TRUE);
			break;
	};
	return(FALSE);
};//Handles the messages from the window

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd){
	DialogBox(hInstance,MAKEINTRESOURCE(IDD_MAIN),NULL,MainMsgHandler);
    return(0);
};//Create the main window