// Example program 1: Reading the keyboard
//
// A part of the input library INPUT.H
// CopyRight (c) 2000, Johan Bos
// www.sludgesoft.com/johan
// bosjoh@fcmail.com
//////////////////////////////////////////////////////////////////////////////

#include <input.h> //For all input functions
#include <stdio.h> //For textmode I/O
#include <conio.h> //For textmode I/O
//Needed libraries

INPUTCONTROL Input = NULL; //Controls all input
KEYBOARD  KeyBoard = NULL; //Handles the keyboard
//All variables needed for input

bool Initialize(void){
   if (!CreateInputControl(Input)) return(false);
   if (!Input->CreateKeyBoard(KeyBoard)) return(false);
   return(true);
};//Prepare the program

void Cleanup(void){
   if (Input!=NULL){
      if (KeyBoard!=NULL) KeyBoard->Release();
      Input->Release();
   };
};//Prepare to exit the program

void main(){
   unsigned char key=0;//Holds the key pressed
   if (Initialize()){
      //Show some copyright information
      clrscr();
      printf("%s","Reading the keyboard example\n");
      printf("%s","Made using the INPUT.H DJGPP input library\n");
      printf("%s","CopyRight (c) 2000, Johan Bos\n");
      printf("%s","\nPress any key to continue...\n");
      KeyBoard->Read();

      //Tell the user which key is pressed, escape exits the program
      clrscr();
      printf("%s","Press escape to exit the program\n");
      printf("%s","Keycode pressed key: 0");
      do{
         key=KeyBoard->Read();
         gotoxy(22,2);
         printf("%s","    ");
         gotoxy(22,2);
         if (key==0) printf("%s","none");
         else printf("%U",key);
      }while(key!=27);

      //Exit message
      printf("%s","\n\nMade by Johan Bos\n");
      printf("%s","Visit my website at http://www.sludgesoft.com/johan\n");
   };
   Cleanup();
};
