// Example program 2: Reading pressed keys from the keyboard
//                    Retrieving the keys currently hold by the user
//
// A part of the input library INPUT.H
// CopyRight (c) 2000, Johan Bos
// www.sludgesoft.com/johan
// bosjoh@fcmail.com
//////////////////////////////////////////////////////////////////////////////

#include <input.h>  //For all input functions
#include <unistd.h> //For a delay routine
#include <stdio.h>  //For textmode I/O
#include <conio.h>  //For textmode I/O
//Needed libraries

INPUTCONTROL Input = NULL; //Controls all input
KEYBOARD  KeyBoard = NULL; //Handles the keyboard
//All variables needed for input

bool Initialize(void){
   if (!CreateInputControl(Input)) return(false);
   if (!Input->CreateKeyBoard(KeyBoard)) return(false);
   return(true);
};//Prepare the program

void Cleanup(void){
   if (Input!=NULL){
      if (KeyBoard!=NULL) KeyBoard->Release();
      Input->Release();
   };
};//Prepare to exit the program

void main(){
   unsigned char x=1,y=3;//Holds the position of the cursor
   unsigned char key=0;//Holds the key pressed
   if (Initialize()){
      //Show some copyright information
      clrscr();
      printf("%s","Advanced keyboard reading example\n");
      printf("%s","Made using the INPUT.H DJGPP input library\n");
      printf("%s","CopyRight (c) 2000, Johan Bos\n");
      printf("%s","\nPress any key to continue...\n");
      KeyBoard->Read();

      //Move the cursor over the screen using pressed keys on the keyboard
      clrscr();
      printf("%s","Move the cursor using the arrow keys\n");
      printf("%s","Press enter to move on to held keys\n");
      do{
         key=KeyBoard->Pressed();
         if (key==200 && y>3) y--;
         if (key==203 && x>1) x--;
         if (key==205 && x<80) x++;
         if (key==208 && y<25) y++;
         gotoxy(x,y);
      }while(key!=13);

      //Move the cursor over the screen using the held key method
      clrscr();
      printf("%s","Move the cursor using the arrow keys\n");
      printf("%s","Press escape to exit the program\n");
      x=1;
      y=3;
      do{
         if (KeyBoard->Hold(72) && y>3) y--;
         if (KeyBoard->Hold(75) && x>1) x--;
         if (KeyBoard->Hold(77) && x<80) x++;
         if (KeyBoard->Hold(80) && y<25) y++;
         gotoxy(x,y);
         usleep(16000);
      }while(!KeyBoard->Hold(0x1));

      //Exit message
      clrscr();
      printf("%s","Made by Johan Bos\n");
      printf("%s","Visit my website at http://www.sludgesoft.com/johan\n");
   };
   Cleanup();
};
