// Example program 3: Retrieving mouse information
//
// A part of the input library INPUT.H
// CopyRight (c) 2000, Johan Bos
// www.sludgesoft.com/johan
// bosjoh@fcmail.com
//////////////////////////////////////////////////////////////////////////////

#include <input.h> //For all input functions
#include <stdio.h> //For textmode I/O
#include <conio.h> //For textmode I/O
//Needed libraries

INPUTCONTROL Input = NULL; //Controls all input
KEYBOARD  KeyBoard = NULL; //Handles the keyboard
MOUSE        Mouse = NULL; //Handles mouse input
//All variables needed for input

bool Initialize(void){
   if (!CreateInputControl(Input)) return(false);
   if (!Input->CreateKeyBoard(KeyBoard)) return(false);
   if (!Input->CreateMouse(Mouse)) return(false);
   return(true);
};//Prepare the program

void Cleanup(void){
   if (Input!=NULL){
      if (Mouse!=NULL) Mouse->Release();
      if (KeyBoard!=NULL) KeyBoard->Release();
      Input->Release();
   };
};//Prepare to exit the program

void main(){
   unsigned short x,y; //Holds the mouse position
   if (Initialize()){
      //Show some copyright information
      clrscr();
      printf("%s","Retrieving mouse information example\n");
      printf("%s","Made using the INPUT.H DJGPP input library\n");
      printf("%s","CopyRight (c) 2000, Johan Bos\n");
      printf("%s","\nPress any key to continue...\n");
      KeyBoard->Read();

      //Show the mouse position, and display the mousebutton state
      _setcursortype(_NOCURSOR);
      clrscr();
      printf("%s","Position    :\n");
      printf("%s","Left Button :\n");
      printf("%s","Mid Button  :\n");
      printf("%s","Right Button:\n");
      do{
         Mouse->GetXY(x,y);
         gotoxy(15,1);
         printf("%s","       ");
         gotoxy(15,1);
         printf("%s","(");
         printf("%U",x/8);
         printf("%s",",");
         printf("%U",y/8);
         printf("%s",")");
         gotoxy(15,2);
         printf("%s","    ");
         gotoxy(15,3);
         printf("%s","    ");
         gotoxy(15,4);
         printf("%s","    ");
         gotoxy(15,2);
         if (Mouse->LeftButtonHold()) printf("%s","Hold");
         gotoxy(15,3);
         if (Mouse->MidButtonHold()) printf("%s","Hold");
         gotoxy(15,4);
         if (Mouse->RightButtonHold()) printf("%s","Hold");
      }while(KeyBoard->Pressed()!=27);

      //Exit message
      _setcursortype(_NORMALCURSOR);
      clrscr();
      printf("%s","Made by Johan Bos\n");
      printf("%s","Visit my website at http://www.sludgesoft.com/johan\n");
   };
   Cleanup();
};
