//***************************************************************************
//* Library made by Johan Bos.                                              *
//* --------------------------                                              *
//* This is a (almost) complete input/output library. Pascal programmers    *
//* may find it easier to learn C++ because the pascal function names are   *
//* remained.                                                               *
//*                                                                         *
//* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *
//* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *
//***************************************************************************

#include <malloc.h> //The only needed lib

//types
typedef enum {false,true} boolean;
typedef struct {
   unsigned char b1;
   unsigned char b2;
   unsigned char b3;
   unsigned char b4;
   unsigned char b5;
   unsigned char b6;
   unsigned char b7;
   unsigned char b8;
   unsigned char b9;
   unsigned char b10;
   unsigned char b11;
   unsigned char b12;
   unsigned char b13;
   unsigned char b14;
   unsigned char b15;
   unsigned char b16;
} CHARDATA;

//global variables
unsigned char far *screen=(unsigned char far *) 0xB8000000L;
unsigned char *buffer;
unsigned short o[25];
unsigned char wherex,wherey,textcolor,bgcolor;

//function prototypes
void initialize(void);
boolean keypressed(void);
char readkey(void);
char readkeyecho(void);
void putcharxy(unsigned char,unsigned char,char);
void putcolxy(unsigned char,unsigned char,unsigned char, unsigned char);
void cls(void);
void cursoron(void);
void cursoroff(void);
void largecursor(void);
void changechar(unsigned short, CHARDATA &);
unsigned char stringlen(char *);
void val_to_str(unsigned long,char *);
void str_to_val(unsigned long &,char *);
void write(char *);
void writeln(char *);
void gotoxy(unsigned char, unsigned char);
void scroll(void);
void fillmem(void *,unsigned char, unsigned short);
void memcopy(void *,void *,unsigned short);
void blinkon(void);
void blinkoff(void);
void vsync(void);
void colorscreen(unsigned char, unsigned char);

//functions
void initialize(void){
   unsigned char r;
   buffer=(unsigned char *)malloc(4000);
   for (r=0;r<25;r++) o[r]=(r<<7)+(r<<5);
   textcolor=7;
   bgcolor=0;
   asm{
      mov ax, 3
      int 0x10
   };
   cls();
};//Always call this function first!

boolean keypressed(void){
   unsigned short retval=0;
   asm{
      mov ax, 0x100
      int 0x16
      jz nokey
      mov retval, ax
   };
   nokey:
   if (retval) return(true); else return(false);
};//Checks if a key is pressed.

char readkey(void){
   unsigned short retval;
   do {} while (!keypressed());
   asm{
      xor ax, ax
      int 0x16
      mov retval, ax
      cmp al, 0
      jz extkey
      jmp normkey
   };
   extkey:
      return(128+(retval>>8));
   normkey:
      return(retval%256);
};//Reads a key scancode. Extended key returns +128.

char readkeyecho(void){
   unsigned short retval;
   boolean handled;
   handled=false;
   do {} while (!keypressed());
   asm{
      xor ax, ax
      int 0x16
      mov retval, ax
      cmp al, 0
      jz extkey
      jmp normkey
   };
   extkey:
      retval=128+(retval>>8);
   normkey:
      retval=retval%256;
   if (wherex>79){
      wherex=0;
      wherey++;
   };
   if (wherey>24){
      scroll();
      wherey=24;
      gotoxy(wherex,wherey);
   };
   if (retval==8){
      wherex--;
      if (wherex>79){
	 if (wherey>0){
	    wherey--;
	    wherex=79;
	 } else wherex=0;
      };
      putcolxy(wherex,wherey,bgcolor,textcolor);
      putcharxy(wherex,wherey,0);
      gotoxy(wherex,wherey);
      handled=true;
   };
   if (retval==13){
      wherex=0;
      wherey++;
      if (wherey>24){
	 scroll();
	 wherey=24;
      };
      gotoxy(wherex,wherey);
      handled=true;
   };
   if (!handled){
      putcolxy(wherex,wherey,bgcolor,textcolor);
      putcharxy(wherex,wherey,retval);
      wherex++;
      if (wherex>79){
	 wherex=0;
	 wherey++;
      };
      if (wherey>24){
	 scroll();
	 wherey=24;
	 gotoxy(wherex,wherey);
      };
      gotoxy(wherex,wherey);
   };
   return(retval);
};//Reads a key scancode. Extended key returns +128. With echo to the screen.

void putcharxy(unsigned char x,unsigned char y,char chr){
   if (x<80 & y<25) screen[o[y]+(x<<1)]=chr;
};//Put a char at point [X,Y]. Textcolor is ignored.

void putcolxy(unsigned char x,unsigned char y,unsigned char bg, unsigned char fg){
   if (x<80 & y<25) screen[o[y]+(x<<1)+1]=bg*16+fg;
};//Defines the background and textcolor at point [X,Y].

void cls(void){
   asm{
      mov cx, 2000
      les di, screen
      mov ax, 0x0700
   };
   Loop:
   asm{
      stosw
      loop Loop
   };
   gotoxy(0,0);
};//Clears the screen.

void cursoron(void){
   asm{
      mov ah, 1
      mov ch, 0x1E
      mov cl, 0x1F
      int 0x10
   };
};//Turns blinking underscore cursor on.

void cursoroff(void){
   asm{
      mov ah, 1
      mov ch, 0x20
      mov cl, 0x1F
      int 0x10
   };
};//Turns blinking cursor off.

void largecursor(void){
   asm{
      mov ah, 1
      mov ch, 0x1F
      mov cl, 1
      int 0x10
   };
};//Turns blinking solid cursor on.

void changechar(unsigned short chr, CHARDATA &data){
   asm{
      mov cx, 1
      mov dx, chr
      mov ah, 0x11
      mov al, 0
      les di, data
      mov bp, di
      mov bl, 0
      mov bh, 16
      int 0x10
   };
};//Change a character.

unsigned char stringlen(char *txt){
   unsigned char retval=0;
   while (txt[retval]) retval++;
   return(retval);
};//Returns the length of a string.

void val_to_str(unsigned long value,char *valstr){
   unsigned char pos,r;
   unsigned long tval;
   tval=value;
   pos=0;
   do {
      pos++;
      tval=tval/10;
   } while (tval>0);
   for (r=0;r<pos;r++){
      valstr[pos-r-1]=48+value%10;
      value=value/10;
   };
   valstr[pos]=0;
};//Converts a value to a string.

void str_to_val(unsigned long &value,char *valstr){
   unsigned char stln,r;
   unsigned long tval;
   stln=stringlen(valstr);
   tval=0;
   for(r=0;r<stln;r++){
      tval=tval*10;
      tval=tval+valstr[r];
      tval=tval-48;
   };
   value=tval;
};//Converts a string to a value.

void write(char *txt){
   unsigned char r,chr;
   chr=stringlen(txt);
   for (r=0;r<chr;r++){
      if (wherex>79){
	 wherex=0;
	 wherey++;
      };
      if (wherey>24){
	 scroll();
	 wherey=24;
	 gotoxy(wherex,wherey);
      };
      putcolxy(wherex,wherey,bgcolor,textcolor);
      putcharxy(wherex,wherey,txt[r]);
      wherex++;
   };
   gotoxy(wherex,wherey);
};//Write on the screen at the cursor position.

void writeln(char *txt){
   write(txt);
   wherex=0;
   wherey++;
   if (wherey>24){
      scroll();
      wherey=24;
   };
   gotoxy(wherex,wherey);
};//Write on the screen at the cursor position and goes to the next line.

void gotoxy(unsigned char x,unsigned char y){
   wherex=x;
   wherey=y;
   asm{
      mov ah, 2
      xor bh, bh
      mov dl, x
      mov dh, y
      int 0x10
   };
};//Put the cursor at point [X,Y].

void scroll(void){
   unsigned char r;
   for (r=0;r<24;r++) memcopy(screen+r*160,screen+r*160+160,160);
   for (r=0;r<80;r++){
      screen[o[24]+r*2]=0;
      screen[o[24]+r*2+1]=7;
   };
   if (wherey>0) wherey--;
   gotoxy(wherex,wherey);
};//Scrolls the screen.

void fillmem(void *dest,unsigned char val,unsigned short count){
   asm{
      mov al, val
      mov cx, count
      les di, dest
   };
   Loop:
   asm{
      stosb
      loop Loop
   };
};//Moves [count] bytes with value [val] to [dest].

void memcopy(void *dest,void *src,unsigned short count){
   asm{
      mov cx, count
      mov dx, ds
      lds si, src
      les di, dest
   };
   Loop:
   asm{
      lodsb
      stosb
      loop Loop
      mov ds, dx
   };
};//Copies [count] bytes from [src] to [dest].

void blinkon(void){
   asm{
      mov dx, 0x3DA
      in al, dx
      mov dx, 0x3C0
      mov al, 0x10
      out dx, al
      mov al, 0xC
      out dx, al
   };
};//Turns blink on.

void blinkoff(void){
   asm{
      mov dx, 0x3DA
      in al, dx
      mov dx, 0x3C0
      mov al, 0x10
      out dx, al
      mov al, 4
      out dx, al
   };
};//Turns blink off.

void vsync(void){
   Loop1:
   asm{
      mov dx, 0x3da
      in al, dx
      and al, 8
      cmp al, 0
      jz Loop1
   };
   Loop2:
   asm{
      mov dx, 0x3da
      in al, dx
      and al, 8
      cmp al, 0
      jnz Loop2
   };
};//Wait for vertical retrace.

void colorscreen(unsigned char bg, unsigned char fg){
   unsigned char x,y;
   for (y=0;y<25;y++) for (x=0;x<80;x++) putcolxy(x,y,bg,fg);
};//Colors the screen.
