{***************************************************************************}
{* Program made by Johan Bos.                                              *}
{* --------------------------                                              *}
{* This program demonstrates the wellknown 'fading' effect often seen on   *}
{* the Super Nintendo System and shows it on your PC!                      *}
{*                                                                         *}
{* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *}
{* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *}
{*                                                                         *}
{* SNES and SUPER NINTENDO are trademarks from Nintendo of America.        *}
{***************************************************************************}

program SNESeffect;
uses crt;                  {Needed for I/O}
type XMSrec=record
        Amount:LongInt;    {Amount of bytes to move}
        SrcHandle:Word;    {Handle of the source XMS block.}
        SrcOffset:LongInt; {Source conventional memory address.}
        DestHandle:Word;   {Handle of the destination XMS block.}
        DestOffset:LongInt;{Destination conventional memory address.}
     end;
const MAXFADE=15;     {Change this for a longer fading (don't go to high!)}
var XMSControl:pointer;    {The pointer to the XMScontrol API}
    XMSMoveInfo:XMSrec;    {XMS move structure}

function GetXMSControlAPI:pointer;
var address,offsetptr:word;
Begin
   asm
      mov ax, $4310
      int $2F
      mov address, es
      mov offsetptr, bx
   end;
   GetXMSControlAPI:=ptr(address,offsetptr);
End;{This function returns the pointer to the XMS control API}

function XMSGetMem(kb:word):word;
var handle:word;
Begin
   asm
      mov ah, 9
      mov dx, kb
      call [XMSControl]
      mov handle, dx
   end;
   XMSGetMem:=handle;
End;{Allocates some Kb of XMS}

function Ptr2Long(p:pointer):LongInt;Assembler;
Asm
   Mov AX, P.WORD[0]
   Mov DX, P.WORD[2]
End;{Pointer to LongInt conversion}

procedure XMSFreeMem(handle:word);
Begin
   asm
      mov ah, $A
      mov dx, handle
      call [XMSControl]
   end;
End;{Frees the allocated XMS block}

procedure XMSMoveBlock(var movstruct:XMSrec);
begin
   asm
      lds si, movstruct
      mov ah, $0B
      call [XMSControl]
   end;
end;{Move XMS blocks around in the memory}

procedure Conventional2XMS(Amount:LongInt;var handle:word;p:pointer);
Begin
   XMSMoveInfo.Amount:=Amount;
   XMSMoveInfo.SrcHandle:=0;
   XMSMoveInfo.SrcOffset:=Ptr2Long(p);
   XMSMoveInfo.DestHandle:=handle;
   XMSMoveInfo.DestOffset:=0;
   XMSMoveBlock(XMSMoveInfo);
End;{Moves a memory block in the conventional memory to the XMS}

procedure XMS2Conventional(Amount:LongInt;handle:word;p:pointer);
Begin
   XMSMoveInfo.Amount:=Amount;
   XMSMoveInfo.SrcHandle:=handle;
   XMSMoveInfo.SrcOffset:=0;
   XMSMoveInfo.DestHandle:=0;
   XMSMoveInfo.DestOffset:=Ptr2Long(p);
   XMSMoveBlock(XMSMoveInfo);
End;{Moves an XMS-block to the conventional memory}

procedure VGAscreen;assembler;
Asm
   mov ax, $13
   int $10
End;{Sets up the VGA-screen: 320x200  256 colors}

procedure Textscreen;assembler;
Asm
   mov ax, $3
   int $10
End;{Restores the textscreen}

procedure BufferPutPixel(buffer:pointer;x,y:word;col:byte);
var Longy:LongInt;
    ToMem:Word;
    address,offset:word;
Begin
   if (x<320) and (y<200) then begin
      address:=seg(buffer^);
      offset:=ofs(buffer^);
      Longy:=y;            {Word to LongInt conversion. Needed for multiply}
      ToMem:=Longy*320+x;
      Mem[address:offset+ToMem]:=col;
   end;
End;{Simulates a putpixel, but saves it in a buffer}

function BufferGetPixel(buffer:pointer;x,y:word):byte;
var Longy:LongInt;
    ToMem:Word;
    address,offset:word;
Begin
   if (x<320) and (y<200) then begin
      address:=seg(buffer^);
      offset:=ofs(buffer^);
      Longy:=y;            {Word to LongInt conversion. Needed for multiply}
      ToMem:=Longy*320+x;
      BufferGetPixel:=Mem[address:offset+ToMem];
   end;
End;{Simulates a getpixel, but gets it from a buffer}

procedure Emptybuffers(buf1,buf2:pointer);
var r,address,offset,address2,offset2:word;
Begin
   address:=seg(buf1^);
   offset:=ofs(buf1^);
   address2:=seg(buf2^);
   offset2:=ofs(buf2^);
   For r:=0 to 63999 do begin
      Mem[address:offset+r]:=0;
      Mem[address2:offset2+r]:=0;
   end;
End;{empties the buffers}

{MAIN}
var r,x,y,x2,y2:word;
    fp:longint; {The file pointer}
    bmpfile:file of byte;
    pix:byte;
    buffer1,buffer2:pointer;
    XMSbuf1,XMSbuf2:word;
Begin
   XMSControl:=GetXMSControlAPI; {Gets the XMS-control address       }
   GetMem(buffer1,64000);        {Allocates 128000 Kb of conventional}
   GetMem(buffer2,64000);        {memory and 128000 Kb of XMS memory }
   XMSbuf1:=XMSGetMem(64);       {for using screen buffers.          }
   XMSbuf2:=XMSGetMem(64);
   Emptybuffers(buffer1,buffer2);
   VGAscreen;
   For y:=0 to 199 do
      For x:=0 to 319 do
         BufferPutPixel(buffer1,x,y,random(256));{Fills the screen}
   Conventional2XMS(64000,XMSbuf1,buffer1);{Saves the buffer to an XMS-buffer}
   XMS2Conventional(64000,XMSbuf1,ptr($A000,0));{Send XMS-buffer to screen}
   While keypressed do readkey;                 {Empty keyboard buffer}
   Repeat
      For r:=2 to MAXFADE do begin
         For y:=0 to trunc(200/r) do
            For x:=0 to trunc(320/r) do begin
               pix:=BufferGetPixel(buffer1,x*r,y*r);
               For y2:=0 to r-1 do For x2:=0 to r-1 do BufferPutPixel(buffer2,x*r+x2,y*r+y2,pix);
            end;
         Conventional2XMS(64000,XMSbuf2,buffer2);
         XMS2Conventional(64000,XMSbuf2,ptr($A000,0));
         delay(10);
      end;
      For r:=MAXFADE-1 downto 1 do begin
         For y:=0 to trunc(200/r) do
            For x:=0 to trunc(320/r) do begin
               pix:=BufferGetPixel(buffer1,x*r,y*r);
               For y2:=0 to r-1 do For x2:=0 to r-1 do BufferPutPixel(buffer2,x*r+x2,y*r+y2,pix);
            end;
         Conventional2XMS(64000,XMSbuf2,buffer2);
         XMS2Conventional(64000,XMSbuf2,ptr($A000,0));
         delay(10);
      end;
   Until keypressed;
   XMSFreeMem(XMSbuf1);
   XMSFreeMem(XMSbuf2);
   FreeMem(buffer1,64000);
   FreeMem(buffer2,64000);{Frees all your allocated memory}
   Textscreen;
End.