//***************************************************************************
//* Program made by Johan Bos.                                              *
//* --------------------------                                              *
//* Marry Christmas folks! This is a snow demo program that fits in these   *
//* times. This also demonstrates some OOP.                                 *
//*                                                                         *
//* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *
//* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *
//***************************************************************************

#include <stdlib.h>
#include <conio.h>
#include <malloc.h>
#include <iostream.h> //Needed libs

const unsigned int NUM_OF_FLAKES=300; //Number of snowflakes visible

class VGA{
   private:
      unsigned char far *screen;
      unsigned char far *buffer;
   public:
      VGA(void);
      ~VGA(void);
      void VSync(void);
      void BufPutPixel(unsigned short x,unsigned short y,unsigned char color);
      void BufLine(unsigned short x1,unsigned short y1,unsigned short x2,unsigned short y2,unsigned char color);
      unsigned char BufGetPixel(unsigned short x,unsigned short y);
      void BufToScreen(void);
};//The VGA class handles all graphical screen output

class SNOW : VGA{
   private:
      float flakex[NUM_OF_FLAKES];
      unsigned char flakey[NUM_OF_FLAKES],flakew[NUM_OF_FLAKES];
      float wind;
      unsigned int flakesvisible;
      unsigned char ctr;
   public:
      SNOW(void);
      void NewFlake(void);
      void FreeFlake(unsigned int nr);
      void Move(void);
      void Show(void);
      void DrawText(void);
      void FillText(void);
};//Handles all the snow. It is derived from VGA, because it uses graphics

VGA::VGA(void){
   asm{
      mov ax, 0x13
      int 0x10
   };
   screen=(unsigned char far *)0xA0000000L;
   buffer=(unsigned char far *)_fmalloc(64000);
   _fmemset(screen,0,64000);
   _fmemset(buffer,0,64000);
};//Sets up the VGA-screen: 320x200x256 and allocates buffer memory

VGA::~VGA(void){
   _ffree(buffer);
   asm{
      mov ax, 3
      int 0x10
   };
};//Restores the textscreen, release buffer

void VGA::VSync(void){
   while (inp(0x3da) & 8);
   while (!(inp(0x3da) & 8));
};//Wait for vertical retrace (no ugly screen)

void VGA::BufPutPixel(unsigned short x,unsigned short y,unsigned char color){
   if (y<200) if (x<320) buffer[(y<<6)+(y<<8)+x]=color;
};//Plots a pixel in the buffer

void VGA::BufLine(unsigned short x1,unsigned short y1,unsigned short x2,unsigned short y2,unsigned char color){
   short xlen,ylen,xup,yup,r,step;
   unsigned short tomem;
   tomem=(y1<<8)+(y1<<6)+x1;
   step=0;
   xlen=x2-x1;
   ylen=y2-y1;
   if (xlen>=0) xup=1; else{
      xup=-1;
      xlen=-xlen;
   };
   if (ylen>=0) yup=320; else{
      yup=-320;
      ylen=-ylen;
   };
   if (xlen>ylen){
      for (r=0;r<=xlen;r++){
	 buffer[tomem]=color;
	 step=step+ylen;
	 if (step>xlen){
	    step=step-xlen;
	    tomem=tomem+yup;
	 };
	 tomem=tomem+xup;
      };
   } else {
      for (r=0;r<=ylen;r++){
	 buffer[tomem]=color;
	 step=step+xlen;
	 if (step>0){
	    step=step-ylen;
	    tomem=tomem+xup;
	 };
	 tomem=tomem+yup;
      };
   };
};//Draw a line in the buffer. Don't draw off-screen

unsigned char VGA::BufGetPixel(unsigned short x,unsigned short y){
   if (y<200) if (x<320) return(buffer[(y<<6)+(y<<8)+x]);
   return(0);
};//Retrieves a pixel from the buffer

void VGA::BufToScreen(void){
   _fmemcpy(screen,buffer,64000);
};//Send the virtual screen to the real screen

SNOW::SNOW(void){
   randomize();
   flakesvisible=0;
   wind=0;
   ctr=0;
};//Makes the snow ready for use

void SNOW::NewFlake(void){
   flakex[flakesvisible]=random(640)-160;
   flakey[flakesvisible]=0;
   flakew[flakesvisible]=random(5)+1;
   flakesvisible++;
};//Create a new snowflake

void SNOW::FreeFlake(unsigned int nr){
   flakesvisible--;
   flakex[nr]=flakex[flakesvisible];
   flakey[nr]=flakey[flakesvisible];
   flakew[nr]=flakew[flakesvisible];
};//Release a snowflake that has fallen

void SNOW::Move(void){
   float relwind;
   unsigned int r;
   signed char forcemove[NUM_OF_FLAKES];
   for (r=0;r<NUM_OF_FLAKES;r++) forcemove[r]=0;
   ctr++;
   if (ctr%8==0) switch (random(3)){
      case 0:{
	 if (wind>-1) wind-=.2;
	 break;
      };
      case 1: if (wind<1) wind+=.2;
   };
   if (flakesvisible<NUM_OF_FLAKES) NewFlake();
   for (r=0;r<flakesvisible;r++) if (flakey[r]>198) FreeFlake(r);
   for (r=0;r<flakesvisible;r++) if (BufGetPixel(flakex[r],flakey[r]+1)){
      if (BufGetPixel(flakex[r]-1,flakey[r]+1)) if (BufGetPixel(flakex[r]+1,flakey[r]+1)) FreeFlake(r);
      if (BufGetPixel(flakex[r]-1,flakey[r]+1)) if (!BufGetPixel(flakex[r]+1,flakey[r]+1)) forcemove[r]=1;
      if (!BufGetPixel(flakex[r]-1,flakey[r]+1)) if (BufGetPixel(flakex[r]+1,flakey[r]+1)) forcemove[r]=-1;
      if (!BufGetPixel(flakex[r]-1,flakey[r]+1)) if (!BufGetPixel(flakex[r]+1,flakey[r]+1)) {
	 if (random(2)) forcemove[r]=1; else forcemove[r]=-1;
      };
   };
   for (r=0;r<flakesvisible;r++) BufPutPixel(flakex[r],flakey[r],0);
   for (r=0;r<flakesvisible;r++){
      if (!forcemove[r]){
	 relwind=wind/flakew[r];
	 flakex[r]+=relwind;
	 flakey[r]++;
      } else {
	 flakey[r]++;
	 flakex[r]+=forcemove[r];
      };
   };
   for (r=0;r<flakesvisible;r++){
      relwind=wind/flakew[r];
      if (BufGetPixel(flakex[r],flakey[r])) flakex[r]-=relwind;
   };
};//Use some grafity work and wind, so the snow can fall realistic.

void SNOW::Show(void){
   unsigned int r;
   for (r=0;r<flakesvisible;r++) BufPutPixel(flakex[r],flakey[r],21+flakew[r]*2);
   VSync();
   BufToScreen();
};//Display the lot on the screen

void SNOW::DrawText(void){
   BufLine(10,50,10,100,14);
   BufLine(10,50,20,50,14);
   BufLine(10,100,20,100,14);
   BufLine(20,65,20,100,14);
   BufLine(20,50,35,65,14);
   BufLine(35,65,50,50,14);
   BufLine(20,65,35,80,14);
   BufLine(35,80,50,65,14);
   BufLine(60,50,60,100,14);
   BufLine(50,50,60,50,14);
   BufLine(50,100,60,100,14);
   BufLine(50,65,50,100,14);   //The 'M'
   BufLine(70,50,120,50,14);
   BufLine(70,50,70,100,14);
   BufLine(70,100,120,100,14);
   BufLine(120,50,120,60,14);
   BufLine(120,90,120,100,14);
   BufLine(100,70,100,80,14);
   BufLine(80,60,120,60,14);
   BufLine(80,90,120,90,14);
   BufLine(80,70,100,70,14);
   BufLine(80,80,100,80,14);
   BufLine(80,60,80,70,14);
   BufLine(80,80,80,90,14);    //The 'E'
   BufLine(130,50,130,100,14);
   BufLine(172,100,180,100,14);
   BufLine(180,92,180,100,14);
   BufLine(172,100,152,80,14);
   BufLine(180,92,168,80,14);
   BufLine(130,50,180,50,14);
   BufLine(140,60,170,60,14);
   BufLine(140,80,140,100,14);
   BufLine(180,50,180,80,14);
   BufLine(180,80,168,80,14);
   BufLine(140,80,152,80,14);
   BufLine(130,100,140,100,14);
   BufLine(140,60,140,70,14);
   BufLine(170,60,170,70,14);
   BufLine(140,70,170,70,14);  //The 'R'
   BufLine(190,50,190,100,14);
   BufLine(232,100,240,100,14);
   BufLine(240,92,240,100,14);
   BufLine(232,100,212,80,14);
   BufLine(240,92,228,80,14);
   BufLine(190,50,240,50,14);
   BufLine(200,60,230,60,14);
   BufLine(230,60,230,70,14);
   BufLine(240,50,240,80,14);
   BufLine(240,80,228,80,14);
   BufLine(200,80,212,80,14);
   BufLine(190,100,200,100,14);
   BufLine(200,80,200,100,14);
   BufLine(200,60,200,70,14);
   BufLine(200,70,230,70,14);  //The 'R'
   BufLine(250,50,258,50,14);
   BufLine(250,50,250,58,14);
   BufLine(292,50,300,50,14);
   BufLine(300,50,300,58,14);
   BufLine(258,50,275,67,14);
   BufLine(275,67,292,50,14);
   BufLine(250,58,270,78,14);
   BufLine(280,78,300,58,14);
   BufLine(270,78,270,100,14);
   BufLine(280,78,280,100,14);
   BufLine(270,100,280,100,14);//The 'Y'
   BufLine(20,130,28,130,14);
   BufLine(20,130,20,138,14);
   BufLine(62,130,70,130,14);
   BufLine(70,130,70,138,14);
   BufLine(20,180,28,180,14);
   BufLine(20,172,20,180,14);
   BufLine(62,180,70,180,14);
   BufLine(70,172,70,180,14);
   BufLine(28,130,45,147,14);
   BufLine(45,147,62,130,14);
   BufLine(28,180,45,163,14);
   BufLine(45,163,62,180,14);
   BufLine(20,138,37,155,14);
   BufLine(37,155,20,172,14);
   BufLine(70,138,53,155,14);
   BufLine(53,155,70,172,14);  //The 'X'
   BufLine(80,150,110,150,14);
   BufLine(80,150,80,160,14);
   BufLine(80,160,110,160,14);
   BufLine(110,150,110,160,14);//The '-'
   BufLine(120,130,120,180,14);
   BufLine(120,130,130,130,14);
   BufLine(120,180,130,180,14);
   BufLine(130,145,130,180,14);
   BufLine(130,130,145,145,14);
   BufLine(145,145,160,130,14);
   BufLine(130,145,145,160,14);
   BufLine(145,160,160,145,14);
   BufLine(170,130,170,180,14);
   BufLine(160,130,170,130,14);
   BufLine(160,180,170,180,14);
   BufLine(160,145,160,180,14);//The 'M'
   BufLine(180,130,230,130,14);
   BufLine(180,130,180,180,14);
   BufLine(230,130,230,180,14);
   BufLine(180,180,195,180,14);
   BufLine(215,180,230,180,14);
   BufLine(195,160,195,180,14);
   BufLine(215,160,215,180,14);
   BufLine(195,160,215,160,14);
   BufLine(195,140,215,140,14);
   BufLine(195,150,215,150,14);
   BufLine(195,140,195,150,14);
   BufLine(215,140,215,150,14);//The 'A'
   BufLine(240,130,290,130,14);
   BufLine(240,160,280,160,14);
   BufLine(240,180,290,180,14);
   BufLine(240,170,280,170,14);
   BufLine(250,140,290,140,14);
   BufLine(250,150,290,150,14);
   BufLine(240,130,240,160,14);
   BufLine(290,150,290,180,14);
   BufLine(290,130,290,140,14);
   BufLine(250,140,250,150,14);
   BufLine(280,160,280,170,14);
   BufLine(240,170,240,180,14);//The 'S'
};//Draw Outline Merry X-Mas of course! Hard coded...

void SNOW::FillText(void){
   unsigned char filled;
   unsigned short x,y;
   BufPutPixel(15,60,32);
   BufPutPixel(75,60,32);
   BufPutPixel(135,60,32);
   BufPutPixel(195,60,32);
   BufPutPixel(255,60,32);
   BufPutPixel(25,140,32);
   BufPutPixel(85,155,32);
   BufPutPixel(125,140,32);
   BufPutPixel(185,140,32);
   BufPutPixel(245,140,32);
   do{
      filled=0;
      for (y=0;y<200;y++) for (x=0;x<320;x++) if (BufGetPixel(x,y)>14){
	 if (!BufGetPixel(x,y-1)){
	    BufPutPixel(x,y-1,32);
	    filled=1;
	 };
	 if (!BufGetPixel(x-1,y)){
	    BufPutPixel(x-1,y,32);
	    filled=1;
	 };
	 if (!BufGetPixel(x,y+1)){
	    BufPutPixel(x,y+1,32);
	    filled=1;
	 };
	 if (!BufGetPixel(x+1,y)){
	    BufPutPixel(x+1,y,32);
	    filled=1;
	 };
      };
   }while(filled);
};//Fill the text with a color.

void main(void){
   SNOW snow;
   snow.DrawText();
   snow.FillText();
   do{
      snow.Move();
      snow.Show();
   }while (!kbhit());
};