{***************************************************************************}
{* Program made by Johan Bos.                                              *}
{* --------------------------                                              *}
{* This program demonstrates the wellknown star simulation. The stars can  *}
{* go, unlike other demo's, into all directions.                           *}
{*                                                                         *}
{* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *}
{* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *}
{***************************************************************************}
program starfield_simulation;
uses crt;         {Needed for I/O}
const STARS=100;  {Number of stars to show}

procedure VGAscreen;assembler;
Asm
   mov ax, $13
   int $10
End;{Sets up the VGA-screen: 320x200  256 colors}

procedure Textscreen;assembler;
Asm
   mov ax, $3
   int $10
End;{Restores the textscreen}

procedure PutPixel(x,y:word;col:byte);
var ToMem:LongInt;
Begin
   If (x>=0) then if (x<320) then if (y>=0) then if (y<200) then begin
      ToMem:=y*320+x;
      Mem[$A000:ToMem]:=col;
   end;
End;{Procedure for plotting a pixel}

procedure Put3DPixel(x,y,z:word);
Begin
   PutPixel(x+trunc(z*((-x+160)/(320+z))),y+trunc(z*((-y+100)/(200+z))),31-trunc(z/51));
End;{Plotting white pixels with 3D effect}

procedure Kill3DPixel(x,y,z:word);
Begin
   PutPixel(x+trunc(z*((-x+160)/(320+z))),y+trunc(z*((-y+100)/(200+z))),0);
End;{Remove pixel with 3D effect}

{main}
var x,y,z:array[1..STARS]of integer;
    r:word;
Begin
   randomize;
   For r:=1 to STARS do begin
      x[r]:=random(320);
      y[r]:=random(200);
      z[r]:=random(800);
   end;{Initialize the stars}
   VGAscreen;
   Repeat
      For r:=1 to STARS do begin
         Kill3DPixel(x[r],y[r],z[r]);
         dec(z[r],1);  {Lower or higher the x, y or z values to go into}
                       {different directions.                          }
         if (z[r]<0) or (z[r]>800) then begin
            x[r]:=random(320);
            y[r]:=random(200);
            z[r]:=800; {change to ZERO when stars are going away, change to}
                       {800 when stars are coming at you.                  }
         end;{If the star is behind you or too far away, make a new one}
         Put3DPixel(x[r],y[r],z[r]);
      end;
   Until keypressed;
   Textscreen;
End.