//***************************************************************************
//* Program made by Johan Bos.                                              *
//* --------------------------                                              *
//* This program will display moving vertexes with a really cool blurring   *
//* effect.                                                                 *
//*                                                                         *
//* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *
//* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *
//***************************************************************************

#include <stdlib.h>
#include <conio.h>
#include <malloc.h>
#include <iostream.h> //Needed libs

unsigned char far *screen=(unsigned char far *)0xA0000000L;
unsigned char far *buffer;
const unsigned char NUM_OF_VERTEXES=3; //Put the number of vertexes here
short x[NUM_OF_VERTEXES],y[NUM_OF_VERTEXES];
signed char xdi[NUM_OF_VERTEXES],ydi[NUM_OF_VERTEXES];
unsigned char red[256],green[256],blue[256];

void setpalette(unsigned char col,unsigned char red,unsigned char gre,unsigned char blu){
   outp(0x3C8,col);
   outp(0x3C9,red);
   outp(0x3C9,gre);
   outp(0x3C9,blu);
};//Set one palette DAC entry

void getpalette(unsigned char col,unsigned char &red,unsigned char &gre,unsigned char &blu){
   outp(0x3C7,col);
   red=inp(0x3C9);
   gre=inp(0x3C9);
   blu=inp(0x3C9);
};//Get the RGB values of one palette DAC entry

void vgascreen(void){
   asm{
      mov ax, 0x13
      int 0x10
   };
};//Sets up the VGA-screen: 320x200  256 colors

void textscreen(void){
   asm{
      mov ax, 3
      int 0x10
   };
};//Restores the textscreen

void blur(void){
   asm{
      les di, buffer
      add di, 320
      mov cx, 63360
      xor ax, ax
      xor bx, bx
   };
   Loop:
   asm{
      mov al, [es:di-1]
      mov bl, [es:di+1]
      add ax, bx
      mov bl, [es:di-320]
      add ax, bx
      mov bl, [es:di+320]
      add ax, bx
      shr ax, 2
      jz Done
      dec ax
   };
   Done:
   asm{
      stosb
      loop Loop
   };
};//Makes a really cool blurring effect, and it's fast!

void vsync(void){
   while (inp(0x3da) & 8);
   while (!(inp(0x3da) & 8));
};//Wait for vertical retrace (no ugly screen).

void bufline(short x1,short y1,short x2,short y2,unsigned char color){
   short xlen,ylen,xup,yup,r,step;
   unsigned short tomem;
   tomem=(y1<<8)+(y1<<6)+x1;
   step=0;
   xlen=x2-x1;
   ylen=y2-y1;
   if (xlen>=0) xup=1; else{
      xup=-1;
      xlen=-xlen;
   };
   if (ylen>=0) yup=320; else{
      yup=-320;
      ylen=-ylen;
   };
   if (xlen>ylen){
      for (r=0;r<=xlen;r++){
	 buffer[tomem]=color;
	 step=step+ylen;
	 if (step>xlen){
	    step=step-xlen;
	    tomem=tomem+yup;
	 };
	 tomem=tomem+xup;
      };
   } else {
      for (r=0;r<=ylen;r++){
	 buffer[tomem]=color;
	 step=step+xlen;
	 if (step>0){
	    step=step-ylen;
	    tomem=tomem+xup;
	 };
	 tomem=tomem+yup;
      };
   };
};//Draws a line in the buffer

void initpalette(void){
   unsigned char dump,r;
   dump=random(6);
   if (dump==0){
	 for(r=0;r<64;r++) setpalette(r,r,0,0);
	 for(r=0;r<64;r++) setpalette(r+64,63,r,0);
	 for(r=0;r<64;r++) setpalette(r+128,63,63,r);
	 for(r=0;r<64;r++) setpalette(r+192,63,63,63);
   };
   if (dump==1){
	 for(r=0;r<64;r++) setpalette(r,0,r,0);
	 for(r=0;r<64;r++) setpalette(r+64,r,63,0);
	 for(r=0;r<64;r++) setpalette(r+128,63,63,r);
	 for(r=0;r<64;r++) setpalette(r+192,63,63,63);
   };
   if (dump==2){
	 for(r=0;r<64;r++) setpalette(r,r,0,0);
	 for(r=0;r<64;r++) setpalette(r+64,63,0,r);
	 for(r=0;r<64;r++) setpalette(r+128,63,r,63);
	 for(r=0;r<64;r++) setpalette(r+192,63,63,63);
   };
   if (dump==3){
	 for(r=0;r<64;r++) setpalette(r,0,0,r);
	 for(r=0;r<64;r++) setpalette(r+64,r,0,63);
	 for(r=0;r<64;r++) setpalette(r+128,63,r,63);
	 for(r=0;r<64;r++) setpalette(r+192,63,63,63);
   };
   if (dump==4){
	 for(r=0;r<64;r++) setpalette(r,0,r,0);
	 for(r=0;r<64;r++) setpalette(r+64,0,63,r);
	 for(r=0;r<64;r++) setpalette(r+128,r,63,63);
	 for(r=0;r<64;r++) setpalette(r+192,63,63,63);
   };
   if (dump==5){
	 for(r=0;r<64;r++) setpalette(r,0,0,r);
	 for(r=0;r<64;r++) setpalette(r+64,0,r,63);
	 for(r=0;r<64;r++) setpalette(r+128,r,63,63);
	 for(r=0;r<64;r++) setpalette(r+192,63,63,63);
   };
};//Makes a nice palette

void initnewpalette(void){
   unsigned short dump,r;
   for(r=0;r<192;r++){
      red[r]=0;
      green[r]=0;
      blue[r]=0;
   };
   for (r=192;r<256;r++){
      red[r]=63;
      green[r]=63;
      blue[r]=63;
   };
   dump=random(6);
   if (dump==0){
	 for(r=0;r<64;r++) red[r]=r;
	 for(r=0;r<64;r++){
	    red[r+64]=63;
	    green[r+64]=r;
	 };
	 for(r=0;r<64;r++){
	    red[r+128]=63;
	    green[r+128]=63;
	    blue[r+128]=r;
	 };
   };
   if (dump==1){
	 for(r=0;r<64;r++) green[r]=r;
	 for(r=0;r<64;r++){
	    red[r+64]=r;
	    green[r+64]=63;
	 };
	 for(r=0;r<64;r++){
	    red[r+128]=63;
	    green[r+128]=63;
	    blue[r+128]=r;
	 };
   };
   if (dump==2){
	 for(r=0;r<64;r++) red[r]=r;
	 for(r=0;r<64;r++){
	    red[r+64]=63;
	    blue[r+64]=r;
	 };
	 for(r=0;r<64;r++){
	    red[r+128]=63;
	    green[r+128]=r;
	    blue[r+128]=63;
	 };
   };
   if (dump==3){
	 for(r=0;r<64;r++) blue[r]=r;
	 for(r=0;r<64;r++){
	    red[r+64]=r;
	    blue[r+64]=63;
	 };
	 for(r=0;r<64;r++){
	    red[r+128]=63;
	    green[r+128]=r;
	    blue[r+128]=63;
	 };
   };
   if (dump==4){
	 for(r=0;r<64;r++) green[r]=r;
	 for(r=0;r<64;r++){
	    green[r+64]=63;
	    blue[r+64]=r;
	 };
	 for(r=0;r<64;r++){
	    red[r+128]=r;
	    green[r+128]=63;
	    blue[r+128]=63;
	 };
   };
   if (dump==5){
	 for(r=0;r<64;r++) blue[r]=r;
	 for(r=0;r<64;r++){
	    green[r+64]=r;
	    blue[r+64]=63;
	 };
	 for(r=0;r<64;r++){
	    red[r+128]=r;
	    green[r+128]=63;
	    blue[r+128]=63;
	 };
   };
};//Makes a new palette to fade to

void initbuffer(void){
   buffer=(unsigned char far *)_fmalloc(64000);
   _fmemset(screen,0,64000);
   _fmemset(buffer,0,64000);
};//Makes the buffer ready for use

void initvertexes(void){
   unsigned char r;
   for(r=0;r<NUM_OF_VERTEXES;r++){
      xdi[r]=random(2)+1;
      ydi[r]=random(2)+1;
      if (!random(2)) xdi[r]=-xdi[r];
      if (!random(2)) ydi[r]=-ydi[r];
      x[r]=random(310)+5;
      y[r]=random(190)+5;
   };
};//Initialize the vertexes

void movevertexes(void){
   unsigned char r;
   for (r=0;r<NUM_OF_VERTEXES;r++){
      x[r]=x[r]+xdi[r];
      y[r]=y[r]+ydi[r];
      if (x[r]<=5 | x[r]>=314) xdi[r]=-xdi[r];
      if (y[r]<=5 | y[r]>=194) ydi[r]=-ydi[r];
   };
};//Moving, bouncing vertex routine

void vertexes_to_screen(void){
   unsigned char r;
   for (r=0;r<NUM_OF_VERTEXES-1;r++) bufline(x[r],y[r],x[r+1],y[r+1],255);
   bufline(x[NUM_OF_VERTEXES-1],y[NUM_OF_VERTEXES-1],x[0],y[0],255);
   vsync();
   blur();
   _fmemcpy(screen,buffer,64000);
};//Make the vertexes go to the screen

void newpalette(void){
   unsigned short fade,r;
   unsigned char re[256],gr[256],bl[256];
   for(r=0;r<256;r++) getpalette(r,re[r],gr[r],bl[r]);
   initnewpalette();
   fade=0;
   do{
      fade++;
      for(r=0;r<256;r++){
	 if (re[r]>red[r]) re[r]--;
	 if (gr[r]>green[r]) gr[r]--;
	 if (bl[r]>blue[r]) bl[r]--;
	 if (re[r]<red[r]) re[r]++;
	 if (gr[r]<green[r]) gr[r]++;
	 if (bl[r]<blue[r]) bl[r]++;
	 setpalette(r,re[r],gr[r],bl[r]);
      };
      movevertexes();
      vertexes_to_screen();
   }while (fade<64);
};//Starts a new fading session

void killvertexes(void){
   unsigned short fade,r;
   unsigned char re[256],gr[256],bl[256];
   for(r=0;r<256;r++) getpalette(r,re[r],gr[r],bl[r]);
   fade=0;
   do{
      fade++;
      for (r=0;r<256;r++){
	 if (re[r]>0) re[r]--;
	 if (gr[r]>0) gr[r]--;
	 if (bl[r]>0) bl[r]--;
	 setpalette(r,re[r],gr[r],bl[r]);
      };
      movevertexes();
      vertexes_to_screen();
   }while (fade<64);
};//Exit fade-out

void main(void){
   unsigned short ctr;
   vgascreen();
   initpalette();
   initbuffer();
   initvertexes();
   vertexes_to_screen();
   ctr=0;
   do{
      movevertexes();
      vertexes_to_screen();
      ctr++;
      if (ctr>=400){
	 newpalette();
	 ctr=0;
      };
   }while (!kbhit());
   killvertexes();
   textscreen();
};