//********************************************************************
//* Program made by Johan Bos.                                       *
//* --------------------------                                       *
//* This program will display moving vertexes with a really cool     *
//* blurring effect. Press ESC to exit.                              *
//*                                                                  *
//* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.       *
//* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379         *
//********************************************************************
#include <windows.h>              // Of course!
#include <ddraw.h>                // Direct Draw library
#include <dinput.h>               // Direct Input library
// globals variables
HINSTANCE instancehandle;         // Instance handler
HWND windowhandle;                // Window handler
LPDIRECTDRAW lpDD;                // DirectDraw object
LPDIRECTDRAWSURFACE lpDDSPrimary; // DirectDraw primary surface
LPDIRECTDRAWSURFACE lpDDSBack;    // DirectDraw back surface
LPDIRECTDRAWPALETTE lpPAL;        // Palette object
DDSURFACEDESC ddsd;               // The SurfaceDesc
DDSCAPS ddscaps;                  // Attached surface
LPDIRECTINPUT lpDI;               // DirectInput object
LPDIRECTINPUTDEVICE lpKeyboard;   // DirectInput Keyboard device
PALETTEENTRY pe[256];             // Palette data
const unsigned char NUM_OF_VERTEXES=3; //Place the number of vertexes you want to see here
unsigned char *screen;            // Pointer to the screen
unsigned char *buffer;            // The back buffer
unsigned long offstable[240];     // Table containing screen offsets
short vx[NUM_OF_VERTEXES],vy[NUM_OF_VERTEXES];
signed char vxdi[NUM_OF_VERTEXES],vydi[NUM_OF_VERTEXES];

void InitPalette(){
   unsigned short r;
   for (r=0;r<64;r++){
      pe[r].peRed=r%256*4;
	  pe[r].peGreen=0;
	  pe[r].peBlue=0;
   };
   for (r=0;r<64;r++){
      pe[r+64].peRed=255;
	  pe[r+64].peGreen=r%256*4;
	  pe[r+64].peBlue=0;
   };
   for (r=0;r<64;r++){
      pe[r+128].peRed=255;
	  pe[r+128].peGreen=255;
	  pe[r+128].peBlue=r%256*4;
   };
   for (r=0;r<64;r++){
      pe[r+192].peRed=255;
	  pe[r+192].peGreen=255;
	  pe[r+192].peBlue=255;
   };
};//Set up a nice palette

long WINAPI WindowMessageHandler (HWND hWnd, UINT wMessage, WPARAM wParam, LPARAM lParam)
{
   return (DefWindowProc (hWnd, wMessage, wParam, lParam));
};//The window message handler

bool Initialize(void){
   HRESULT retval;
   WNDCLASS wndclass;
   unsigned long r;
   wndclass.style=0;
   wndclass.lpfnWndProc=(WNDPROC)WindowMessageHandler;
   wndclass.cbClsExtra=0;
   wndclass.cbWndExtra=0;
   wndclass.hInstance=instancehandle;
   wndclass.hIcon=LoadIcon(NULL,IDI_APPLICATION);
   wndclass.hCursor=LoadCursor(NULL,IDC_ARROW);
   wndclass.hbrBackground=(HBRUSH__*)GetStockObject(LTGRAY_BRUSH);
   wndclass.lpszMenuName=NULL;
   wndclass.lpszClassName="screensaver";
   RegisterClass(&wndclass);
   windowhandle=CreateWindow("screensaver","vertexes",WS_OVERLAPPED,CW_USEDEFAULT,0,0,0,NULL,NULL,instancehandle,NULL);
   ShowWindow (windowhandle, SW_SHOWMAXIMIZED);
   for (r=0;r<240;r++) offstable[r]=r*320;
   retval=DirectInputCreate((HINSTANCE)GetWindowLong(windowhandle,GWL_HINSTANCE),DIRECTINPUT_VERSION,&lpDI,NULL);
   if (retval!=DI_OK) return(false);
   retval=lpDI->CreateDevice(GUID_SysKeyboard,&lpKeyboard,NULL);
   if (retval!=DI_OK) return(false);
   retval=lpKeyboard->SetDataFormat(&c_dfDIKeyboard);
   if (retval!=DI_OK) return(false);
   retval=lpKeyboard->SetCooperativeLevel(windowhandle,DISCL_EXCLUSIVE|DISCL_FOREGROUND);
   if (retval!=DI_OK) return(false);
   lpKeyboard->Acquire();
   retval=DirectDrawCreate(NULL,&lpDD,NULL);
   if (retval!=DD_OK) return(false);
   retval=lpDD->SetCooperativeLevel(windowhandle,DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
   if (retval!=DD_OK) return(false);
   retval=lpDD->SetDisplayMode(320,240,8);
   if (retval!=DD_OK) return(false);
   memset(&ddsd,0,sizeof(ddsd));
   ddsd.dwSize=sizeof(ddsd);
   ddsd.dwFlags=DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
   ddsd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX;
   ddsd.dwBackBufferCount=1;
   retval=lpDD->CreateSurface(&ddsd,&lpDDSPrimary,NULL);
   if (retval!=DD_OK) return(false);
   ddscaps.dwCaps=DDSCAPS_BACKBUFFER;
   retval=lpDDSPrimary->GetAttachedSurface(&ddscaps,&lpDDSBack);
   if (retval!=DD_OK) return(false);
   InitPalette();
   retval=lpDD->CreatePalette(DDPCAPS_8BIT,pe,&lpPAL,NULL);
   if (retval!=DD_OK) return(false);
   lpDDSPrimary->SetPalette(lpPAL);
   retval=lpDDSPrimary->Lock(NULL,&ddsd,DDLOCK_WAIT,NULL);
   if (retval!=DD_OK) return(false);
   screen=(unsigned char *)ddsd.lpSurface;
   buffer=(unsigned char *)malloc(76800);
   memset(buffer,0,76800);
   return(true);
};//Opens a window and initializes DirectX

void Buf_to_screen(){
   _asm{
      mov esi, buffer
	  mov edi, screen
	  mov ecx, 19200
      rep movsd
   };
};//A fast buffer to screen transfer

void Blur(void){
   _asm{
      mov edi, buffer
      add edi, 320
      mov ecx, 76160
      xor ax, ax
      xor bx, bx
   };
   Looper:
   _asm{
	  mov al, [edi-1]
      mov bl, [edi+1]
      add ax, bx
      mov bl, [edi-320]
      add ax, bx
      mov bl, [edi+320]
      add ax, bx
      shr ax, 2
      jz Done
      dec ax
   };
   Done:
   _asm{   
	  stosb
	  loop Looper
   };
   Buf_to_screen();
};//A blurring effect

void BufLine(unsigned short x1,unsigned short y1,unsigned short x2,unsigned short y2){
   short xlen,ylen,xup,yup,r,step;
   unsigned long tomem;
   tomem=offstable[y1]+x1;
   step=0;
   xlen=x2-x1;
   ylen=y2-y1;
   if (xlen>=0) xup=1; else{
      xup=-1;
      xlen=-xlen;
   };
   if (ylen>=0) yup=320; else{
      yup=-320;
      ylen=-ylen;
   };
   if (xlen>ylen){
      for (r=0;r<=xlen;r++){
         buffer[tomem]=255;
         step=step+ylen;
         if (step>xlen){
            step=step-xlen;
            tomem=tomem+yup;
         };
         tomem=tomem+xup;
      };
   } else {
      for (r=0;r<=ylen;r++){
         buffer[tomem]=255;
         step=step+xlen;
         if (step>0){
            step=step-ylen;
            tomem=tomem+xup;
         };
         tomem=tomem+yup;
      };
   };
};//Draws a line in the backbuffer

void InitVertexes(void){
   unsigned char r;
   for (r=0;r<NUM_OF_VERTEXES;r++){
      vx[r]=rand()%280+20;
      vy[r]=rand()%200+20;
      if (rand()%2) vxdi[r]=-1; else vxdi[r]=1;
      if (rand()%2) vydi[r]=-1; else vydi[r]=1;
   };
};//Initialize the vertexes

void MoveVertexes(void){
   unsigned char r;
   for (r=0;r<NUM_OF_VERTEXES;r++){
      vx[r]=vx[r]+vxdi[r];
	  vy[r]=vy[r]+vydi[r];
	  if (vx[r]<20 || vx[r]>300) vxdi[r]=-vxdi[r];
	  if (vy[r]<20 || vy[r]>220) vydi[r]=-vydi[r];
   };
   for (r=0;r<NUM_OF_VERTEXES-1;r++) BufLine(vx[r],vy[r],vx[r+1],vy[r+1]);
   BufLine(vx[NUM_OF_VERTEXES-1],vy[NUM_OF_VERTEXES-1],vx[0],vy[0]);
   Blur();
};//Bouncing vertexes, display them on the screen

void Destroy(void){
   if (lpDD!=NULL){
	  if (lpPAL!=NULL){
	     lpPAL->Release();
		 lpPAL=NULL;
	  }
	  if (lpDDSPrimary!=NULL){
         lpDDSPrimary->Unlock(NULL);
         lpDDSPrimary->Release();
         lpDDSPrimary=NULL;
      };
      lpDD->Release();
      lpDD=NULL;
   } 
   if (lpDI!=NULL){
	  if (lpKeyboard!=NULL){
	     lpKeyboard->Unacquire();
		 lpKeyboard->Release();
		 lpKeyboard=NULL;
	  };
	  lpDI->Release();
	  lpDI=NULL;
   };
};//Cleans up

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow){
   unsigned char DIbuf[256];
   instancehandle=hInstance;
   if (Initialize()){
      InitVertexes();
      do{
         MoveVertexes();
   	     lpKeyboard->GetDeviceState(sizeof(DIbuf),&DIbuf);
	  }while (!DIbuf[1]);
   };
   Destroy();
   return(0);
};