{***************************************************************************}
{* Program made by Johan Bos.                                              *}
{* --------------------------                                              *}
{* This program will display moving vertexes with a really cool blurring   *}
{* effect.                                                                 *}
{*                                                                         *}
{* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *}
{* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *}
{***************************************************************************}

program vertexes;
uses smallcrt;           {Needed for I/O}
const NUM_OF_VERTEXES=3; {Put the number of vertexes you want to see here}
type XMSrec=record
        Amount:LongInt;
        SrcHandle:Word;
        SrcOffset:LongInt;
        DestHandle:Word;
        DestOffset:LongInt;
     end;
var x,y:array[1..NUM_OF_VERTEXES]of word;
    xdi,ydi:array[1..NUM_OF_VERTEXES]of ShortInt;
    red,green,blue:array[0..255]of byte;
    buffer,screen,XMScontrol:pointer;
    XMSmoveInfo:XMSrec;

procedure SetPalette(col,red,gre,blu:byte);
Begin
   Port[$3C8]:=col;
   Port[$3C9]:=red;
   Port[$3C9]:=gre;
   Port[$3C9]:=blu;
End;{Set one palette DAC entry}

procedure GetPalette(col:byte;var red,gre,blu:byte);
Begin
   Port[$3C7]:=col;
   red:=Port[$3C9];
   gre:=Port[$3C9];
   blu:=Port[$3C9];
End;{Get the RGB values of one palette DAC entry}

procedure VGAscreen;assembler;
Asm
   mov ax, $13
   int $10
End;{Sets up the VGA-screen: 320x200  256 colors}

procedure Textscreen;assembler;
Asm
   mov ax, $3
   int $10
End;{Restores the textscreen}

procedure blur;
var address:word;
Begin
   address:=seg(buffer^);
   asm
      mov es, address
      mov di, 0
      add di, 320
      mov cx, 63360
      xor ax, ax
      xor bx, bx
      @Loop:
      mov al, [es:di-1]
      mov bl, [es:di+1]
      add ax, bx
      mov bl, [es:di-320]
      add ax, bx
      mov bl, [es:di+320]
      add ax, bx
      shr ax, 2
      jz @Done
      dec ax
      @Done:
      stosb
      loop @Loop
   end;
End;{Makes a really cool fading effect, and it's fast!}

function XMSInstalled:boolean;
var return:byte;
Begin
   asm
      mov ax, $4300
      int $2F
      mov return, al
   end;
   if return=$80 then XMSInstalled:=TRUE else XMSInstalled:=FALSE;
End;{Check wether XMS is installed or not}

function GetXMSControlAPI:pointer;
var address,offsetptr:word;
Begin
   asm
      mov ax, $4310
      int $2F
      mov address, es
      mov offsetptr, bx
   end;
   GetXMSControlAPI:=ptr(address,offsetptr);
End;{Get the address of XMS-control}

function Ptr2Long(p:pointer):LongInt;Assembler;
Asm
  Mov AX, P.WORD[0]
  Mov DX, P.WORD[2]
End;{Convert a pointer to a LongInt (32 bit decimal number)}

procedure XMSMoveBlock(var movstruct:XMSrec);
begin
   asm
      lds si, movstruct
      mov ah, $0B
      call [XMSControl]
   end;
end;{Move blocks around in the XMS but also in Conventional}

procedure MoveMem(Amount:LongInt;p1:pointer;p2:pointer);
Begin
   XMSMoveInfo.Amount:=Amount;
   XMSMoveInfo.SrcHandle:=0;
   XMSMoveInfo.SrcOffset:=Ptr2Long(p1);
   XMSMoveInfo.DestHandle:=0;
   XMSMoveInfo.DestOffset:=Ptr2Long(p2);
   XMSMoveBlock(XMSMoveInfo);
End;{Moves a memory block}

procedure VSync;
Begin
   while (Port[$3da] and $8)=0 do;
   while not (Port[$3da] and $8)=0 do;
End;{Wait for vertical retrace (no ugly screen).}

procedure BufLine2(x1,y1,x2,y2:integer;Color:byte);
var xlen,ylen,xup,yup,r,step:integer;
    address,ToMem:word;
Begin
   address:=seg(buffer^);
   ToMem:=y1 shl 8+y1 shl 6+x1;
   step:=0;
   xlen:=x2-x1;
   ylen:=y2-y1;
   if xlen>=0 then xup:=1 else begin
      xup:=-1;
      xlen:=-xlen;
   end;
   if ylen>=0 then yup:=320 else begin
      yup:=-320;
      ylen:=-ylen;
   end;
   if (xlen>ylen) then begin
      for r:=0 to xlen do begin
         Mem[address:ToMem]:=color;
         inc(step,ylen);
         if (step>xlen) then begin
            step:=step-xlen;
            ToMem:=ToMem+yup;
         end;
         ToMem:=ToMem+xup;
      end;
   end else begin
      for r:=0 to ylen do begin
         Mem[address:ToMem]:=color;
         inc(step,xlen);
         if (step>0) then begin
            step:=step-ylen;
            ToMem:=ToMem+xup;
         end;
         ToMem:=ToMem+yup;
      end;
   end;
End;{Draws a line in the buffer}

procedure InitPalette;
var r,dump:byte;
Begin
   Randomize;
   dump:=random(6);
   if dump=0 then
      Begin
         For r:=0 to 63 do SetPalette(r,r,0,0);
         For r:=0 to 63 do SetPalette(r+64,63,r,0);
         For r:=0 to 63 do SetPalette(r+128,63,63,r);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
   if dump=1 then
      Begin
         For r:=0 to 63 do SetPalette(r,0,r,0);
         For r:=0 to 63 do SetPalette(r+64,r,63,0);
         For r:=0 to 63 do SetPalette(r+128,63,63,r);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
   if dump=2 then
      Begin
         For r:=0 to 63 do SetPalette(r,r,0,0);
         For r:=0 to 63 do SetPalette(r+64,63,0,r);
         For r:=0 to 63 do SetPalette(r+128,63,r,63);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
   if dump=3 then
      Begin
         For r:=0 to 63 do SetPalette(r,0,0,r);
         For r:=0 to 63 do SetPalette(r+64,r,0,63);
         For r:=0 to 63 do SetPalette(r+128,63,r,63);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
   if dump=4 then
      Begin
         For r:=0 to 63 do SetPalette(r,0,r,0);
         For r:=0 to 63 do SetPalette(r+64,0,63,r);
         For r:=0 to 63 do SetPalette(r+128,r,63,63);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
   if dump=5 then
      Begin
         For r:=0 to 63 do SetPalette(r,0,0,r);
         For r:=0 to 63 do SetPalette(r+64,0,r,63);
         For r:=0 to 63 do SetPalette(r+128,r,63,63);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
End;{Makes a nice palette}

procedure InitNewPalette;
var r:byte;
    dump:byte;
Begin
   For r:=0 to 191 do begin
      red[r]:=0;
      green[r]:=0;
      blue[r]:=0;
   end;
   For r:=192 to 255 do begin
      red[r]:=63;
      green[r]:=63;
      blue[r]:=63;
   end;
   Randomize;
   dump:=random(6);
   if dump=0 then
      Begin
         For r:=0 to 63 do red[r]:=r;
         For r:=0 to 63 do begin
            red[r+64]:=63;
            green[r+64]:=r;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=63;
            green[r+128]:=63;
            blue[r+128]:=r;
         end;
      End;
   if dump=1 then
      Begin
         For r:=0 to 63 do green[r]:=r;
         For r:=0 to 63 do begin
            red[r+64]:=r;
            green[r+64]:=63;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=63;
            green[r+128]:=63;
            blue[r+128]:=r;
         end;
      End;
   if dump=2 then
      Begin
         For r:=0 to 63 do red[r]:=r;
         For r:=0 to 63 do begin
            red[r+64]:=63;
            blue[r+64]:=r;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=63;
            green[r+128]:=r;
            blue[r+128]:=63;
         end;
      End;
   if dump=3 then
      Begin
         For r:=0 to 63 do blue[r]:=r;
         For r:=0 to 63 do begin
            red[r+64]:=r;
            blue[r+64]:=63;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=63;
            green[r+128]:=r;
            blue[r+128]:=63;
         end;
      End;
   if dump=4 then
      Begin
         For r:=0 to 63 do green[r]:=r;
         For r:=0 to 63 do begin
            green[r+64]:=63;
            blue[r+64]:=r;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=r;
            green[r+128]:=63;
            blue[r+128]:=63;
         end;
      End;
   if dump=5 then
      Begin
         For r:=0 to 63 do blue[r]:=r;
         For r:=0 to 63 do begin
            green[r+64]:=r;
            blue[r+64]:=63;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=r;
            green[r+128]:=63;
            blue[r+128]:=63;
         end;
      End;
End;{Makes a new palette to fade to}

procedure InitBuffer;
Begin
   XMScontrol:=GetXMSControlAPI;
   screen:=Ptr($A000,0);
   GetMem(buffer,64000);
   movemem(64000,screen,buffer);
End;{Makes the buffer ready for use}

procedure InitVertexes;
var r:byte;
Begin
   For r:=1 to NUM_OF_VERTEXES do begin
      xdi[r]:=random(2)+1;
      ydi[r]:=random(2)+1;
      if random(2)=0 then xdi[r]:=-xdi[r];
      if random(2)=0 then ydi[r]:=-ydi[r];
      x[r]:=random(310)+5;
      y[r]:=random(190)+5;
   end;
End;{Initialize the vertexes}

procedure MoveVertexes;
var r:byte;
Begin
   For r:=1 to NUM_OF_VERTEXES do begin
      x[r]:=x[r]+xdi[r];
      y[r]:=y[r]+ydi[r];
      if (x[r]<=5) or (x[r]>=314) then xdi[r]:=-xdi[r];
      if (y[r]<=5) or (y[r]>=194) then ydi[r]:=-ydi[r];
   end;
End;{Moving, bouncing vertex routine}

procedure Vertexes2Screen;
var r:byte;
Begin
   For r:=1 to NUM_OF_VERTEXES-1 do begin
      BufLine2(x[r],y[r],x[r+1],y[r+1],255);
   end;
   BufLine2(x[NUM_OF_VERTEXES],y[NUM_OF_VERTEXES],x[1],y[1],255);
   Vsync;
   blur;
   MoveMem(64000,buffer,ptr($A000,0));
End;{Make the vertexes go to the screen}

procedure NewPalette;
var fade,r:byte;
    re,gr,bl:array[0..255]of byte;
Begin
   For r:=0 to 255 do GetPalette(r,re[r],gr[r],bl[r]);
   InitNewPalette;
   fade:=0;
   Repeat
      inc(fade);
      For r:=0 to 255 do begin
         if re[r]>red[r] then dec(re[r]);
         if gr[r]>green[r] then dec(gr[r]);
         if bl[r]>blue[r] then dec(bl[r]);
         if re[r]<red[r] then inc(re[r]);
         if gr[r]<green[r] then inc(gr[r]);
         if bl[r]<blue[r] then inc(bl[r]);
         SetPalette(r,re[r],gr[r],bl[r]);
      end;
      MoveVertexes;
      Vertexes2Screen;
   Until fade=64;
End;{Starts a new fading session}

procedure KillVertexes;
var fade,r:byte;
    re,gr,bl:array[0..255]of byte;
Begin
   For r:=0 to 255 do GetPalette(r,re[r],gr[r],bl[r]);
   fade:=0;
   Repeat
      inc(fade);
      For r:=0 to 255 do begin
         if re[r]>0 then dec(re[r]);
         if gr[r]>0 then dec(gr[r]);
         if bl[r]>0 then dec(bl[r]);
         SetPalette(r,re[r],gr[r],bl[r]);
      end;
      MoveVertexes;
      Vertexes2Screen;
   Until fade=64;
End;{Exit fade-out}

{main}
var ctr:word;
Begin
   VGAscreen;
   InitPalette;
   InitBuffer;
   InitVertexes;
   Vertexes2Screen;
   ctr:=0;
   Repeat
      MoveVertexes;
      Vertexes2Screen;
      inc(ctr);
      if ctr>=400 then begin
         NewPalette;
         ctr:=0;
      end;
   Until keypressed;
   KillVertexes;
   Textscreen;
End.