{***************************************************************************}
{* Program made by Johan Bos.                                              *}
{* --------------------------                                              *}
{* This program simulates water when it is out of balance (like rain).     *}
{* I've written the most important routine in assembler and pascal.        *}
{* Pick the one you like.                                                  *}
{*                                                                         *}
{* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *}
{* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *}
{***************************************************************************}

program water_effect;
uses smallcrt;    {Needed for I/O}
type XMSrec=record
        Amount:LongInt;
        SrcHandle:Word;
        SrcOffset:LongInt;
        DestHandle:Word;
        DestOffset:LongInt;
     end;
var wavemap:array[0..1]of pointer;
    NM,CM:ShortInt;
    XMSmoveinfo:XMSrec;
    XMScontrol,screen:pointer;

procedure SetPalette(col,red,gre,blu:byte);
Begin
   Port[$3C8]:=col;
   Port[$3C9]:=red;
   Port[$3C9]:=gre;
   Port[$3C9]:=blu;
End;{Set one palette DAC entry}

procedure GetPalette(col:byte;var red,gre,blu:byte);
Begin
   Port[$3C7]:=col;
   red:=Port[$3C9];
   gre:=Port[$3C9];
   blu:=Port[$3C9];
End;{Get the RGB values of one palette DAC entry}

procedure VGAscreen;assembler;
Asm
   mov ax, $13
   int $10
End;{Sets up the VGA-screen: 320x200  256 colors}

procedure Textscreen;assembler;
Asm
   mov ax, $3
   int $10
End;{Restores the textscreen}

procedure Move_Water_Asm;
var address,address2,x:word;
Begin
   address:=seg(wavemap[CM]^);
   address2:=seg(wavemap[NM]^); {Get the addresses of the maps}
   x:=0;
   asm
      mov cx, 63161      {Initialize counter (with cutting edges)}
      mov di, 321        {Start at position (1,1) (1*320+1)}
      xor ax, ax
      xor bx, bx         {Set ax and bx to ZERO}
     @loop:              {Looper}
      add x, 1           {increase horizontal line checker}
      cmp x, 319         {Look for an edge}
      jz @skip           {If so, skip 2 pixels}
      mov es, address    {mov current map to memory}
      mov al, [es:di-1]  {mov pixel left to lo(ax) = al}
      mov bl, [es:di+1]  {mov pixel right to lo(bx) = bl}
      add ax, bx         {ax = ax + bx}
      mov bl, [es:di-320]{mov pixel above to lo(bx) = bl}
      add ax, bx         {ax = ax + bx}
      mov bl, [es:di+320]{move pixel below to lo(bx) = bl}
      add ax, bx         {ax = ax + bx}
      mov es, address2   {move previous map to memory}
      shr ax, 1          {divide ax with 2}
      jz @done           {if ZERO jump to done}
      mov bl, [es:di]    {mov current value to lo(bx)}
      sub ax, bx         {ax = ax - bx}
      cmp ah, 0          {test for a underflow (if ax<0 then ah <hi(ax)> >0)}
      jnz @restore       {if so, jump to restore}
      mov bx, ax         {bx = ax}
      shr bx, 4          {divide bx with 16}
      sub ax, bx         {ax = ax - bx}
      cmp ah, 0          {test for a underflow (if ax<0 then ah <hi(ax)> >0)}
      jnz @restore       {if so jump to restore}
     @done:              {label done}
      stosb              {store al at [es:di] and increase di}
      loop @loop         {loop until the screen is done (cx=0)}
      jmp @exit          {jump to exit (to avoid an infinite loop)}
     @skip:              {skip label}
      mov x, 0           {set horizontal line checker to 0 again}
      inc di
      inc di             {and skip 2 pixel writes}
      loop @loop         {loop}
     @restore:
      xor ax, ax         {set ax to ZERO}
      jmp @done          {and jump to done}
     @exit:              {exit label}
   end;
End;{Water effect using fast assembler code}

procedure Move_Water_Pas;
var address,address2,x,y,mempos,value:word;
Begin
   address:=seg(wavemap[CM]^);
   address2:=seg(wavemap[NM]^);
   For y:=1 to 198 do for x:=1 to 318 do begin
      mempos:=y*320+x;
      value:=Mem[address:mempos-1]+Mem[address:mempos+1]+Mem[address:mempos-320]+Mem[address:mempos+320];
      value:=value shr 1;
      if value<Mem[address2:mempos] then value:=0 else value:=value-Mem[address2:mempos];
      if value<value shr 4 then value:=0 else value:=value-value shr 4;
      Mem[address2:mempos]:=value;
   end;
End;{Water effect using slow pascal code}

function XMSInstalled:boolean;
var return:byte;
Begin
   asm
      mov ax, $4300
      int $2F
      mov return, al
   end;
   if return=$80 then XMSInstalled:=TRUE else XMSInstalled:=FALSE;
End;{Check wether XMS is installed or not}

function GetXMSControlAPI:pointer;
var address,offsetptr:word;
Begin
   asm
      mov ax, $4310
      int $2F
      mov address, es
      mov offsetptr, bx
   end;
   GetXMSControlAPI:=ptr(address,offsetptr);
End;{Get the address of XMS-control}

function Ptr2Long(p:pointer):LongInt;Assembler;
Asm
  Mov AX, P.WORD[0]
  Mov DX, P.WORD[2]
End;{Convert a pointer to a LongInt (32 bit decimal number)}

procedure XMSMoveBlock(var movstruct:XMSrec);
begin
   asm
      lds si, movstruct
      mov ah, $0B
      call [XMSControl]
   end;
end;{Move blocks around in the XMS but also in Conventional}

procedure MoveMem(Amount:LongInt;p1:pointer;p2:pointer);
Begin
   XMSMoveInfo.Amount:=Amount;
   XMSMoveInfo.SrcHandle:=0;
   XMSMoveInfo.SrcOffset:=Ptr2Long(p1);
   XMSMoveInfo.DestHandle:=0;
   XMSMoveInfo.DestOffset:=Ptr2Long(p2);
   XMSMoveBlock(XMSMoveInfo);
End;{Moves a memory block}

procedure VSync;
Begin
   while (Port[$3da] and $8)=0 do;
   while not (Port[$3da] and $8)=0 do;
End;{Wait for vertical retrace (no ugly screen).}

procedure MapPutPixel2(x2,y2:word;col,map:byte);
var address:word;
    ToMem:LongInt;
Begin
   address:=seg(wavemap[map]^);
   If (x2>=0) then if (x2<320) then if (y2>=0) then if (y2<200) then begin
      ToMem:=y2 shl 6+y2 shl 8+x2;
      Mem[address:ToMem]:=col;
   end;
End;{Plots a pixel in a map (Only 0 or 1)}

procedure InitPalette;
var r:byte;
Begin
   For r:=0 to 63 do SetPalette(r,0,0,r);
   For r:=0 to 63 do SetPalette(r+64,0,0,63);
   For r:=0 to 63 do SetPalette(r+128,0,0,63);
   For r:=0 to 63 do SetPalette(r+192,0,0,63);
End;{Makes a nice blue watercolored palette}

procedure InitMaps;
var r:byte;
Begin
   XMScontrol:=GetXMSControlAPI;
   screen:=Ptr($A000,0);
   For r:=0 to 1 do begin
      GetMem(wavemap[r],64000);
      movemem(64000,screen,wavemap[r]);
   end;
   NM:=1;
   CM:=0;
End;{Makes the maps ready for use}

procedure Water2Screen;
Begin
   MoveMem(64000,wavemap[NM],screen);
End;{Makes the right buffer go to the screen}

procedure SwapMap;
var t:byte;
Begin
   t:=CM;
   CM:=NM;
   NM:=t;
End;{Swap the maps (needed for water movement)}

{main}
var r:byte;
Begin
   VGAscreen;
   InitPalette;
   InitMaps;
   Repeat
      MapPutPixel2(random(318)+1,random(198)+1,255,CM);
      Move_Water_Asm;
      Water2Screen;
      SwapMap;
      Vsync;
   Until keypressed;
   For r:=0 to 19 do begin
      Move_Water_Asm;
      Water2Screen;
      SwapMap;
      Vsync;
   end;
   TextScreen;
End.