//***************************************************************************
//* Program made by Johan Bos.                                              *
//* --------------------------                                              *
//* This program will display a moving waterfall using palette              *
//* operations.                                                             *
//*                                                                         *
//* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *
//* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *
//***************************************************************************
#include <stdlib.h>
#include <conio.h>//needed libs

unsigned char far *screen=(unsigned char far *) 0xA0000000L;//pointer to the screen
unsigned long offs[200]; //table of screen Y position offsets

void putpixel(unsigned short x, unsigned short y, unsigned char col){
   screen[offs[y]+x]=col;
};//puts a pixel at [X,Y]. Putting a pixel out of the screen can crash the system.

void VGAscreen(void){
   asm{
      mov ax, 0x13
      int 0x10
   };
};//sets screenmode 320x200x256 graphics

void Textscreen(void){
   asm{
      mov ax, 3
      int 0x10
   };
};//back to text

void vsync(void){
   Loop1:
   asm{
      mov dx, 0x3da
      in al, dx
      and al, 8
      cmp al, 0
      jz Loop1
   };
   Loop2:
   asm{
      mov dx, 0x3da
      in al, dx
      and al, 8
      cmp al, 0
      jnz Loop2
   };
};//Wait for vertical retrace.

void setpalette(unsigned char nr, unsigned char r, unsigned char g, unsigned char b){
   asm{
      mov dx, 0x3c8
      mov al, nr
      out dx, al
      mov dx, 0x3c9
      mov al, r
      out dx, al
      mov al, g
      out dx, al
      mov al, b
      out dx, al
   };
};//set one palette entry

void drawwater(void){
   unsigned short x,y;
   unsigned char col,speed;
   for (x=0;x<320;x++){
      col=random(64)+1;
      speed=random(3)+1;
      for (y=0;y<200;y++){
	 putpixel(x,y,col);
	 col=col+speed;
	 if (col>64) col=1;
      };
   };
};//draws the actual waterfall

void main(void){
   unsigned short r;
   unsigned char blue;
   for (r=0;r<200;r++) offs[r]=r*320;
   VGAscreen();
   drawwater();
   blue=0;
   do{
      blue--;
      vsync();
      for (r=1;r<65;r++) setpalette(r,0,0,r+blue);
   }while(!kbhit());
   Textscreen();
};