
/*
 * NTcrack takes files output by pwdump and grinds passwords
 * Version 2.0
 * Written by Jonathan Wilkins <jwilkins@secnet.com>
 *        and Jesse Burns      <burnsj@cuug.ab.ca>
 *   Thanks go to Oliver Freidrichs, Alfred Huger and
 *                Aaron Spangler.
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "proto.h"

#define MAX_LINE 1024

void E_P16fast(uchar *p14,uchar *p16)
{
  uchar x1[] = {0x4B,0x47,0x53,0x21,0x40,0x23,0x24,0x25};

  E1(p14,   x1, p16);
  E1(p14+7, x1, p16+8);
}

int main(int argc, char *argv[])
{
  FILE          *wordfile = NULL;
  FILE          *passfile = NULL;
  unsigned char *currword;
  unsigned char *currpass;
  unsigned char *testpass;
  char           currline[MAX_LINE]; /* For reading password from file */
  char	         tempword[MAX_LINE]; /* For reading words from file */
  char          *temp;
  char          *current;
  char          *username;
  char		*p;
  char           tempb[17];
  int            userid;

  unsigned char *users;
  int		numusers=0,counta,countb;

  if(argc!=3){
    printf("Usage : NTcrack <wordfile> <passfile> \n");
    return(-1);
  } else {
    currword = (unsigned char *)malloc(16);
    currpass = (unsigned char *)malloc(16);
    testpass = (unsigned char *)malloc(16);
    username = (char *)malloc(64);
    temp     = (char *)malloc(64);

    /* Open the wordfile (argv[1]) and passfile (argv[2]) */
    if (!(wordfile = fopen(argv[1], "r")) || !(passfile = fopen(argv[2], "r"))) {
      if (!wordfile){
        printf("*** wordfile could not be opened ***\n");
      } else {
        printf("*** passfile could not be opened ***\n");
      }
      return(-1);
    }

    /* Count number of users */
    while(!feof(passfile) && !ferror(passfile)) {
      fgets(currline, MAX_LINE, passfile);
      numusers++;
    }

    numusers--;
    rewind(passfile);
    users = malloc(numusers*16*2);
    memset(users, 0, (numusers*16*2));

    counta = -1;
    countb =  0;
    printf("\n\nNTCrack v2.0 is running .... \n\n");
    while(!feof(passfile) && !ferror(passfile)) {
      counta++; 
      fgets(currline, MAX_LINE, passfile);

      if (!(current = strtok(currline, ":")))
         continue;
      strcpy(username, current);

      /* init the current user */
      memcpy((users+counta*16*2),username,16);
      if (!(current = strtok(NULL, ":")))
        continue;
      userid = atoi(current);
      if (!(current = strtok(NULL, ":")))
        continue;

      if(strstr(current,"NO PASSWORD")){
        printf("User %s has no password\n",username);
	numusers--;
	counta--;
      } else {
        sscanf(current,"%2X%2X%2X%2X%2X%2X%2X%2X%2X%2X%2X%2X%2X%2X%2X%2X", 
            &currpass[ 0], &currpass[ 1], &currpass[ 2], &currpass[ 3], 
            &currpass[ 4], &currpass[ 5], &currpass[ 6], &currpass[ 7], 
            &currpass[ 8], &currpass[ 9], &currpass[10], &currpass[11], 
            &currpass[12], &currpass[13], &currpass[14], &currpass[15]);
      }
      memcpy((users+counta*32+16),currpass,16);
    } 
    fclose(passfile);

    /* Test for password == username */
    for(counta = 0; counta < numusers; counta++){
      memcpy(tempword, (users+32*counta),16);
      for(p = tempword; *p; p++){
        if(isalpha(*p)) {
          *p = toupper(*p);
        } else {
          if(*p == '\n') {
            *p =  '\0';
          }
        }
      }
      strncpy(currword, tempword, 16);
      E_P16fast(currword, testpass);
      if(!memcmp(testpass, (users+16+32*counta), 16)){
        memcpy(tempb, (users+32*counta),16);
	tempb[17] = '\0';
        printf("Cracked %s : %s\n",tempb , tempb);
      }
    }

    /*
     * Start the scan on the wordfile
     */

    /* While we still have entries in the wordfile */
    while(!feof(wordfile) && !ferror(wordfile)) {
      fgets(tempword, MAX_LINE, wordfile);
      for(p = tempword; *p; p++){
        if(isalpha(*p)) {
          *p = toupper(*p);
        } else {
          if(*p == '\n') {
            *p =  '\0';
          }
        }
      }
      strncpy(currword, tempword, 16);
      E_P16fast(currword, testpass);
      for(counta = 0; counta < numusers; counta++){
        if(!memcmp(testpass, (users+16+32*counta), 16)) {
	  memcpy(tempb, (users+32*counta),16);
	  tempb[17] = '\0';
          printf("Cracked %s : %s\n",tempb , tempword);
        }
      }
    }  
  }
  fclose(wordfile);
  return(0);
}