      program pvmcollect1
      !
      !	  Let us have N tasks. To collect the distributed array 
      ! 
      !	  N-th task send its local part to (N-1)th task
      !
      !     (N-1)th task add its part to message
      !              and send it to (N-2)th task
      !     ....
      !
      !
      !	  1-th task add its local part to message 
      !           and send it to 0-th task
      !
      !	  Then  0-th task send collected array to mailbox 
      !		and all another tasks read it
      !	   ( 0-th task don't receive array )
      !
      !
      !   PVM calls :
      !
      !					 call pvmfmytid(iMyTid)
      !					 call pvmfJoinGroup('group',iMyInst)
      !					 call pvmfparent(iParentTid)
      !					 call pvmfspawn('PVMcollect1',PvmTaskDefault,	...)
      !					 call pvmfbarrier('group',iNtask,info)
      !					 call pvmfgettid( 'group',i,iTids(i+1))
      !					 call pvmfinitsend( PvmDataDefault, iBufid )
      !					 call pvmfpack(INTEGER4,iMyInst   ,1   ,1, info ) 
      !					 call pvmfrecv(iTids(iMyInst+2),1234, iRecvBufid  )
      !					 call pvmfpkmesgbody( iRecvBufid, info )
      !					 call pvmfputinfo('mail',iSendBufid,PvmMboxDefault,index)
      !					 call pvmfmcast(iNtask,iTids, 4321, info )
      !					 call pvmfsend( iTids(iMyInst),1234, info )
      !					 call pvmfunpack(INTEGER4,index   ,1   ,1, info )
      !					 call pvmfrecvinfo('mail',index,PvmMboxDefault,ibufid)
      !					 call pvmflvgroup('group' ,info)
      !					 call pvmfexit(info)
      !
      include 'fpvm3.h'

      parameter(iNtask=6)         ! number of tasks
      parameter(iDim=600)         ! dimension of local  array
      parameter(iStep=10)         ! variation of the message size 
      parameter(iGlobalDim=iDim*iNtask)	! dimension of global array
      parameter(MaxTrials=50)				! 

      integer(4) iGArray(iGlobalDim)	   ! Global array
      integer(4) iTempArray(iDim)       ! temporary array
      integer(4) iSendArray(iDim)       ! temporary array

      integer(4) iTids(iNtask)          ! Tids of child-tasks

      integer(4) iMyTid,iMyInst

      real(8) BeginTime,EndTime




      !
      !	enroll in the PVM
      !
      call pvmfmytid(iMyTid)

      !
      !	 join group
      !
      call pvmfJoinGroup('group',iMyInst)	



      !
      !===============================================================
      !     Try get parent's tid      
      !	  if this task has not a parent then spawn all another tasks
      !
      call pvmfparent(iParentTid)						 
      if (iParentTid.eq.PvmNoParent) then
          call pvmfspawn('pvmcollect1',
     .     PvmTaskDefault,
     .     '*',
     .     iNtask-1,
     .     iTids,
     .     numt)
          write(*,*)'  Spawn',numt,' tasks'
          open(UNIT=12,file='pvmcollect1.out',status='REPLACE')
          write(12,*)' TimingList[',numt,']={'
      end if

      ! synchronization
      call pvmfbarrier('group',iNtask,info)	   

      !================================================================
      !
      !  get all tids
      !
      do i=0,iNtask-1  
          call pvmfgettid( 'group',i,iTids(i+1))
      end do

      !================================================================
      !  set some data in the local array
      !
      do i=1,iDim
          iSendArray(i)=iTids(iMyInst+1) 
      end do 


      !================================================================	
      !================================================================	
      !================================================================	
      !================================================================	
      !	try various message sizes
      !
      DO iSize=1,iDim,iStep

          iErrors=0  ! Error counter

          !============================================================	
          !
          !
          if (iMyInst.eq.0) then
              CALL GETTIME(isec, iusec)
              BeginTime=1.0D0*isec+1.0D-6*iusec
          end if
          !============================================================
          !
          DO Itrials=1,MaxTrials
              !========================================================
              !   COMMUNICATION
              !
              !	pack message
              !
              if (iMyInst.eq.iNtask-1) then
                  !====================================================					
                  ! last task starts communication
                  !
                  call pvmfinitsend( PvmDataDefault, iBufid )
                  call pvmfpack(INTEGER4,iMyInst   ,1   ,1, info ) 
                  call pvmfpack(INTEGER4,iSendArray,iSize,1, info )  
              else
                  !====================================================									
                  !  next task continues
                  !
                  call pvmfrecv(iTids(iMyInst+2),1234, iRecvBufid  )
                  !====================================================								
                  !	add local data
                  !
                  call pvmfinitsend( PvmDataDefault, iSendBufid )
                  call pvmfpack(INTEGER4,iMyInst   ,1   ,1, info ) 
                  call pvmfpack(INTEGER4,iSendArray,iSize,1, info ) 
                  !====================================================								
                  ! re-pack message from iRecvBufid to iSendBufid
                  !
                  call pvmfpkmesgbody( iRecvBufid, info )		 
              end if
              !========================================================	
              !
              !   send message
              !
              if (iMyInst.eq.0) then
                  !====================================================									
                  !  first member of the lattice put data 
                  !  into mailbox 'mail'
                  call pvmfputinfo('mail',
     .             iSendBufid,PvmMboxDefault,index)
                  !write(*,*)'  pvm putinfo ',index
                  !
                  ! and multicast index to all tasks
                  call pvmfinitsend( PvmDataDefault, iSendBufid )
                  call pvmfpack(INTEGER4,index   ,1   ,1, info ) 
                  call pvmfmcast(iNtask,iTids, 4321, info ) 
                  !
              else
                  !====================================================									
                  !  send data to the next member of the group
                  !
                  call pvmfsend( iTids(iMyInst),1234, info )

                  !====================================================									
                  ! receive index from first task
                  !
                  call pvmfrecv(iTids(1),4321, iRecvBufid  )
                  call pvmfunpack(INTEGER4,index   ,1   ,1, info ) 
              end if

              !========================================================								
              ! receive final information from mailbox
              !
              call pvmfrecvinfo('mail',index,PvmMboxDefault,ibufid)
              do i=1,iNtask
                  call pvmfunpack(INTEGER4,iInst   ,1   ,1, info ) 

                  iShift=iInst*iDim

                  call pvmfunpack(INTEGER4,iTempArray,iSize,1, info ) 
                  do ind=1,iSize
	                iGArray(iShift+ind)=iTempArray(ind)
                  end do
                  !====================================================									
                  !  Verify received data
                  !
                  do j=1,iSize
                      if(iTempArray(j).ne.iTids(iInst+1)) 
     .                    iErrors=iErrors+1
                  end do
                  !====================================================									
              end do


          END DO ! iTrials

          !============================================================	
          !
          if (iMyInst.eq.0)  then
              CALL GETTIME(isec, iusec)
              EndTime=1.0D0*isec+1.0D-6*iusec
              write(*,'(2H {,I7,1H,,F10.5,1H})')iSize*4,
     .         (EndTime-BeginTime)/MaxTrials
              write(12,'(2H {,I7,1H,,F10.5,1H})')iSize*4,
     .         (EndTime-BeginTime)/MaxTrials
              !========================================================
              !  receive retcodes
              !
              do j=2,iNtask
                  call pvmfrecv(iTids(j),2222, iRecvBufid  )
                  call pvmfunpack(INTEGER4,iErrors   ,1   ,1, info ) 
                  write(*,*)'task',iTids(j),
     .             'inst=',j-1,' Errors ',iErrors
              end do 
              !========================================================
          else
              !========================================================
              !  send retcode to first(parent) task
              !
              call pvmfinitsend( PvmDataDefault, iBufid )
              call pvmfpack(INTEGER4,iErrors  ,1   ,1, info ) 
              call pvmfsend( iTids(1),2222, info )
              !========================================================
          end if

      END DO ! iSize

      if (iMyInst.eq.0) then
          write(12,*)'};'
          close(12)
      end if
      call pvmflvgroup('group' ,info)
      call pvmfexit(info)
      stop
      end