      program PVMCollect2
      !
      !  Collect a distributed array 
      !
      !   Each task create its own mailbox
      !   When all mailboxes have been created 
      !   each task get information 
      !   from mailboxes
      !
      !   PVM calls
      !
      !		call pvmfmytid(iMyTid)
      !		call pvmfjoingroup('group',iMyInst)
      !		call pvmfparent(iParentTid)
      !		call pvmfspawn('PVMcollect2',PvmTaskDefault,	
      !		call pvmfbarrier('group',iNtask,info)
      !		call pvmfinitsend(PVMDATADEFAULT,iSendBufid)
      !		call pvmfpack(INTEGER4,iSendArray,iSize,1, info )
      !		call pvmfputinfo(MBoxName,iSendBufid,PvmMboxDefault,index)	 
      !		call pvmfrecvinfo(MBoxName,0,PvmMboxFirstAvail,ibuf)
      !		call pvmfunpack(INTEGER4,iInst   ,1   ,1, info )
      !
      !
      !		call pvmflvgroup('group',info)
      !		call pvmfexit(info)
      !
      include 'fpvm3.h'  !  PVM header file

      !  maximal size of the local array
      parameter(iDim=600)	
      				
      !  variation of the message size
      parameter(iStep=50)					
      parameter(MaxTrials=7)


      !  number of tasks
      parameter(iNtask=7 )
      				
      ! dimension of the global array
      parameter(iGArrayDim=iDim*iNtask)	


      ! Array  to send
      integer iSendArray(iDim)
      					
      ! Temp array
      integer iTempArray(iDim)			


      ! global array
      integer iGlobalArray(iGArrayDim)	

      ! size of the local array
      integer iSize						

      ! name of the mailbox
      character*8 MBoxName	
      			
      real(8) begintime,endtime

      integer(4) iTids(iNtask)

      ! enroll process in PVM
      call pvmfmytid(iMyTid)	
      			      
      ! join group
      call pvmfjoingroup('group',iMyInst)	
      !========================================================================
      !     Try get parent's tid      
      !	  if this task has not a parent then spawn all another tasks
      !
      call pvmfparent(iParentTid)						 
      if (iParentTid.eq.PvmNoParent) then
          call pvmfspawn('pvmcollect2',
     .        PvmTaskDefault,
     .        '*',
     .        iNtask-1,
     .        iTids,
     .        numt)
          write(*,*)'  Spawn',numt,' tasks'
          open(UNIT=12,file='PVMcollect2.out',status='REPLACE')
          write(12,*)' TimingList[',numt,']={'
      end if

      ! synchronization
      call pvmfbarrier('group',iNtask,info)	   

      !================================================================
      !  set some data in the local array
      !
      do i=1,iDim
          iSendArray(i)=iMyInst 
      end do
      !================================================================
      do iSize=0,iDim,iStep
          iErrors=0
          !============================================================	
          !
          if (iMyInst.eq.0) then
              CALL GETTIME(isec, iusec)
              BeginTime=1.0D0*isec+1.0D-6*iusec
          end if
          !============================================================	
          !
          do iTrials=1,MaxTrials
              !
              !========================================================

              !if (iMyInst.eq.0) write(*,*) iTrials

              !
              !	 create message
              !
              call pvmfinitsend(PVMDATADEFAULT,iSendBufid)
              call pvmfpack(INTEGER4,iMyInst,1,1,info) 
              call pvmfpack(INTEGER4,iSendArray,iSize,1, info ) 
              !
              !  create name	of the mailbox
              !
              write(MBoxName,'(1HM,I3)') iMyInst	  
              !
              !	 put information into mailbox
              !
              call pvmfputinfo(MBoxName,iSendBufid,
     .             PvmMboxDefault,index)	  															  
              !
              ! synchronization
              !
              call pvmfbarrier('group',iNtask,info) 
              !
              !========================================================									
              !
              !	collect information	
              !
              do inst=iMyInst+1,iNtask-1
                  !
                  !  create name	of the mailbox
                  !
                  write(MBoxName,'(1HM,I3)') Inst	  
                  !
                  !  get information from mailbox
                  !  
                  call pvmfrecvinfo(MBoxName,0,PvmMboxFirstAvail,ibuf)
                  !
                  !		unpack it
                  !
                  call pvmfunpack(INTEGER4,iInst   ,1   ,1, info ) 
                  call pvmfunpack(INTEGER4,iTempArray,iSize,1, info ) 

                  iShift=iInst*iDim
                  do ind=1,iSize
                      iGlobalArray(iShift+ind)=iTempArray(i)
                  end do
                  !									
                  !  Verify received data
                  !
                  do j=1,iSize
                      if(iTempArray(j).ne.iInst) iErrors=iErrors+1
                  end do
                  !
                  !
              end do ! Inst
              !========================================================									


              !========================================================									
              do inst=0,iMyInst-1
                  !
                  !  create name	of the mailbox
                  !
                  write(MBoxName,'(1HM,I3)') Inst	  
                  !
                  !  get information from mailbox
                  !  
                  call pvmfrecvinfo(MBoxName,0,PvmMboxFirstAvail,ibuf)
                  !
                  !		unpack it
                  !
                  call pvmfunpack(INTEGER4,iInst   ,1   ,1, info ) 
                  call pvmfunpack(INTEGER4,iTempArray,iSize,1, info ) 

                  iShift=iInst*iDim
                  do ind=1,iSize
                      iGlobalArray(iShift+ind)=iTempArray(i)
                  end do
                  !====================================================									
                  !  Verify received data
                  !
                  do j=1,iSize
                      if(iTempArray(j).ne.iInst) iRetCode=iRetCode-1
                  end do
              !========================================================									

              end do
              call pvmfbarrier('group',iNtask,info)

          end do ! iTrials
          !============================================================
          !
          if (iMyInst.eq.0) then
              CALL GETTIME(isec, iusec)
              EndTime=1.0D0*isec+1.0D-6*iusec

              write(*,'(2H {,I7,1H,,F10.5,2H},)')iSize*4,
     .         (EndTime-BeginTime)/MaxTrials
              write(12,'(2H {,I7,1H,,F10.5,2H},)')iSize*4,
     .         (EndTime-BeginTime)/MaxTrials
              !========================================================
              !  receive retcodes
              !
              do j=2,iNtask
                  call pvmfrecv(-1,j-1, iRecvBufid  )
                  call pvmfunpack(INTEGER4,iRetCode   ,1   ,1, info ) 
                  write(*,*)'task:',j-1,'  Errors: ',iRetCode
              end do 
              !========================================================
          else
              !========================================================
              !  send retcode to parent task
              !
              call pvmfinitsend( PvmDataDefault, iBufid )
              call pvmfpack(INTEGER4,iRetCode   ,1   ,1, info ) 
              call pvmfsend( iParentTid,iMyInst, info )
              !========================================================
          end if

      end do ! iSize 

	! leave the group
      call pvmflvgroup('group',info)

      ! exit PVM
      call pvmfexit(info)  


      if (iMyInst.eq.0) then
          Write(12,*)' };'
          close(12)
      end if

      stop
      end