      program PVMcollect4   
      ! 
      !
      !
      !	  Let us have N tasks. To collect the distributed array 
      ! 
      !	  N-th task send its local part to "Collector" 
      !          and signal message to (N-1)-th task
      !
      !	  (N-1)-th task send its local part to "Collector" 
      !          and signal message to (N-2)-th task
      !
      !     ....
      !
      !
      !	  1-th task send its local part to "Collector" 
      !
      !	  Then  0-th task send collected array to mailbox
      !
      !
      include  'fpvm3.h'

      ! number of tasks
      parameter(iNtask=5)
      			 
      ! dimension of local  array
      parameter(iDim=1001)
      		   
      ! variation of the message size
      parameter(iStep=50)			

      ! dimension of global array
      parameter(iGlobalDim=iDim*iNtask)	

      parameter(MaxTrials=20)


      ! Global array
      integer iGArray(iGlobalDim)	   

	! array to send
      integer iSendArray(iDim)

	! temporary array
      integer iTempArray(iDim)

      ! Tids of child-tasks
      integer iTids(0:iNtask+1)		   


      real(8) BeginTime,EndTime



      !	enroll in the PVM
      call pvmfmytid(iMyTid)
      					
      !   join group
      call pvmfJoinGroup('group',iMyInst)		
      !
      !================================================================
      !	  if this task is first in the group then it is COLLECTOR
      !
      if (iMyInst.eq.0) then
      !================================================================	
      !
      !
      !	COLLECTOR
      !
      !
      call pvmfspawn('pvmcollect4',
     . PvmTaskDefault,
     . '*',
     . iNtask,
     . iTids,
     . numt)
	
      call pvmfbarrier('group',iNtask+1,info)	   ! synchronization


      write(*,*)'  Spawn',numt,' tasks'


      open(UNIT=12,file='pvmcollect4.out',status='REPLACE')
      write(12,*)' TimingList[',iNtask,']={'
      !================================================================	
      !
      !  get all tids
      !
      do Inst=0,iNtask  
        call pvmfgettid( 'group',Inst,iTids(Inst))
      end do
      !================================================================	
      !	try various message sizes
      !
      DO iSize=1,iDim,iStep
          iErrors=0
          !============================================================	
          !  Time count
          !
          CALL GETTIME(isec, iusec)
          BeginTime=1.0D0*isec+1.0D-6 * iusec
          !============================================================	
          !
          DO Itrials=1,MaxTrials

              !
              ! send signal message to first task
              !
              call pvmfinitsend( PvmDataDefault, iSendBufid )
              call pvmfpack(INTEGER4,iMyInst   ,1   ,1, info )
              call pvmfsend(iTids(1),123, info )

              !========================================================	
              !
              !  collect messages
              !
              !	 
              !	initiate send buffer
              call pvmfinitsend( PvmDataDefault, iSendBufid )	

              do Inst=1,iNtask

                  ! receive message
                  call pvmfrecv(iTids(Inst),1234, iRecvBufid  )

                  ! re-pack message from iRecvBufid to iSendBufid
                  call pvmfpkmesgbody( iRecvBufid, info )		 
		              
              end do

              !  put information into mailbox
              call pvmfputinfo( 'GArray',iSendBufid,
     .         PvmMboxDefault, index ) 
              !
              ! end collection
              !
              !========================================================
              !	
              !========================================================
              !
              ! send signal message to first task
              !
              call pvmfinitsend( PvmDataDefault, iSendBufid )
              call pvmfpack(INTEGER4,iMyInst   ,1   ,1, info )
              call pvmfsend(iTids(1),123, info )

          END DO ! iTrials

          !============================================================	
          !  Time count
          !
          CALL GETTIME(isec, iusec)
          EndTime=1.0D0*isec+1.0D-6 * iusec
          write(*,'(2H {,I7,1H,,F10.5,2H},)')iSize*4,
     .     (EndTime-BeginTime)/MaxTrials
          write(12,'(2H {,I7,1H,,F10.5,2H},)')iSize*4,
     .     (EndTime-BeginTime)/MaxTrials
          !				!====================================================
          !				!  receive retcodes
          !				!
          !	 			do j=1,iNtask
          !					call pvmfrecv(iTids(j),2222, iRecvBufid  )
          !					call pvmfunpack(INTEGER4,iErrors   ,1   ,1, info ) 
          !	 				write(*,*)'task',iTids(j),
          !	.					' inst=',j-1,' have ',iErrors,' Errors ' 
          !				end do 
          !
      call pvmfbarrier('group',iNtask+1,info)	   ! synchronization
      END DO ! iSize

      call pvmflvgroup(	'group', info)
      call pvmfexit(info)
      write(12,*)'};'	 
      close(12)
      !
      !  END COLLECTOR
      !
      !================================================================	
      else
      !================================================================	
      !
      !
      !	SLAVE TASK
      !
      !
      !write(*,*)'  My Tid is',iMyTid,'       My inst is ',imyinst
      call pvmfbarrier('group',iNtask+1,info)	   ! synchronization
      !================================================================	
      !
      !  get all tids
      !
      do i=0,iNtask  
          call pvmfgettid( 'group',i,iTids(i))
      end do
      !================================================================
      !	try various message sizes
      !
      DO iSize=1,iDim,iStep
          iErrors=0
          !============================================================	
          !
          DO Itrials=1,MaxTrials

              !========================================================
              !  set some data in the local array
              !
              do i=1,iDim
                  iSendArray(i)=iMyInst 
              end do 
              !========================================================
              !  wait for signal message
              !
              call pvmfrecv(iTids(iMyInst-1),123,iRecvBufid  )
              !========================================================	
              !
              !  send local part to COLLECTOR
              !
              call pvmfinitsend( PvmDataDefault, iSendBufid )
              call pvmfpack(INTEGER4,iMyInst   ,1   ,1, info ) 
              call pvmfpack(INTEGER4,iTempArray,iSize,1, info )
              call pvmfsend( iTids(0),1234, info )
              !========================================================	
              !
              ! send signal message to next task
              !
              if (iMyInst.lt.iNtask) then
                  call pvmfsetsbuf(iRecvBufid,iOldBuf)
                  call pvmfsend(iTids(iMyInst+1),123, info )
              end if
              !
              !  Now all local parts are sent to COLLECTOR
              !
              !========================================================

              !========================================================	
              !  wait for signal message
              !
              call pvmfrecv(iTids(iMyInst-1),123, iRecvBufid  )
              !========================================================	
              !
              !  get global array from mailbox
              !
              call pvmfrecvinfo('GArray', index,
     .         PvmMboxFirstAvail , iRecvBufid ) 

              do i=1,iNtask
                  call pvmfunpack(INTEGER4,iInst   ,1   ,1, info ) 
                  call pvmfunpack(INTEGER4,iTempArray,iSize,1, info )
                  do ind=1,iSize
                      iGArray((iInst-1)*iDim+ind)=iTempArray	(ind)
                  end do
                  !====================================================									
                  !  Verify received data
                  !
                  do j=1,iSize
                      if (iTempArray(j).ne.iInst) iErrors=iErrors+1
                  end do
                  !====================================================									
              end do
              !========================================================	
              !  send signal message to next task in the group
              !
              if (iMyInst.lt.iNtask) then
                  call pvmfsetsbuf(iRecvBufid,iOldBuf)
                  call pvmfsend(iTids(iMyInst+1),123, info )
              else
                  call pvmffreebuf(iRecvBufid,info)
              end if
              !
              !  Now all local parts are collected
              !
              !========================================================	
          END DO ! iTrials

          !			!======================================================
          !			!  send retcode to parent task
          !			!
          !				call pvmfinitsend( PvmDataDefault, iBufid )
          !				call pvmfpack(INTEGER4,iErrors   ,1   ,1, info ) 
          !				call pvmfsend( iTids(0),2222, info )
          !			!======================================================
          call pvmfbarrier('group',iNtask+1,info)	   ! synchronization
      END DO ! iSize

      call pvmflvgroup(	'group', info)
      call pvmfexit(info)
      end if
      stop
      end