      program PVMcollect4    
      ! 
      !
      !
      !	  Let us have N tasks. To collect the distributed array 
      ! 
      !	  each task wait for message - signal from 	"Collector"
      !          		 and  then send its local part to "Collector"
      !
      !
      !	  Then  "Collector" task send collected array to first task 
      !
      !
      !	  1-th task re-sends array to 2-th task and unpack data
      !	  2-th task re-sends array to 3-th task and unpack data
      !	  3-th task re-sends array to 4-th task and unpack data
      !
      !	  etc.
      !
      include  'fpvm3.h'

      ! number of tasks
      parameter(iNtask=5)	
      		 
      ! dimension of local  array
      parameter(iDim=1001)
      		 
      ! variation of the message size
      parameter(iStep=50)			 

      ! dimension of global array
      parameter(iGlobalDim=iDim*iNtask)	

      parameter(MaxTrials=10)


      ! Global array
      integer iGArray(iGlobalDim)	   

      ! Tids of child-tasks
      integer iTids(0:iNtask)		   

	! array to send
      integer iSendArray(iDim)
      						
      ! the temporary array
      integer iTempArray(iDim)				    !

      real(8) BeginTime,EndTime





      !	enroll in the PVM
      call pvmfmytid(iMyTid)					

      !   join group
      call pvmfJoinGroup('group',iMyInst)		
      !
      !================================================================
      !	  if this task is first in the group then it is COLLECTOR
      !
      if (iMyInst.eq.0) then
          !============================================================	
          !
          !
          !	COLLECTOR
          !
          !
          call pvmfspawn('PVMcollect4',
     .     PvmTaskDefault,
     .     '*',
     .     iNtask,
     .     iTids,
     .     numt)

          ! synchronization
          call pvmfbarrier('group',iNtask+1,info)	   


          write(*,*)'  Spawn',numt,' tasks'


          open(UNIT=12,file='pvmcollect4.out',status='REPLACE')
          write(12,*)' TimingList[K]={'
          !============================================================
          !
          !  get all tids
          !
          do Inst=0,iNtask  
              call pvmfgettid( 'group',Inst,iTids(Inst))
          end do
          !============================================================	
          !	try various message sizes
          !
          DO iSize=1,iDim,iStep
              iErrors=0
              !========================================================
              !  Time count
              !
              CALL GETTIME(isec, iusec)
              BeginTime=1.0D0*isec+1.0D-6*iusec
              !========================================================
              !
              DO Itrials=1,MaxTrials

                  !====================================================
                  !
                  !  collect messages
                  !
                  !	 
                  !	initiate send buffer to collect messages
                  call pvmfinitsend( PvmDataDefault, iSendBufid )	
                  !  
                  ! buffer for signal message
                  ! 
                  call pvmfmkbuf(PvmDataDefault,iSendSignalBuf)
                  call pvmfsetsbuf(iSendSignalBuf, iOldbuf )
                  call pvmfpack(INTEGER4,iMyInst   ,1   ,1, info )

                  do Inst=1,iNtask
                      !
                      ! send signal message to task
                      !
                      call pvmfsetsbuf(iSendSignalBuf, iOldbuf )
                      call pvmfsend(iTids(Inst),123, info )

                      ! switch to collector buffer
                      call pvmfsetsbuf(iSendBufid, iOldbuf )

                      ! receive message
                      call pvmfrecv(iTids(Inst),1234, iRecvBufid  )

                      ! re-pack message from iRecvBufid to iSendBufid
                      call pvmfpkmesgbody( iRecvBufid, info )		 
									                  
                  end do
                  !
                  ! end collection
                  !
                  !====================================================
                  !
                  ! send array to first task
                  !
                  call pvmfsend(iTids(1),123, info )

                  !	call pvmfsetrbuf(iSendBufid, iOldbuf )
                  !   here anyone can unpack collected array

                  CALL PVMFFREEBUF(iSendBufid, INFO ) 

                  !
                  !  clear signal message buffer
                  !
                  CALL PVMFFREEBUF(iSendSignalBuf, INFO ) 
              END DO ! iTrials

              !========================================================	
              !  Time count
              !
              CALL GETTIME(isec, iusec)
              EndTime=1.0D0*isec+1.0D-6*iusec
              write(*,'(2H {,I7,1H,,F10.5,2H},)')iSize*4,
     .         (EndTime-BeginTime)/MaxTrials
              write(12,'(2H {,I7,1H,,F10.5,2H},)')iSize*4,
     .         (EndTime-BeginTime)/MaxTrials
              !========================================================	
              !
              ! synchronization
              !
              call pvmfbarrier('group',iNtask+1,info)	   
          END DO ! iSize

          call pvmflvgroup('group',info)
          call pvmfexit(info)
          write(12,*)'};'	 
          close(12)
          !
          !  END "COLLECTOR"
          !
          !============================================================	
      else
          !============================================================	
          !
          !
          !	     SLAVE TASK
          !
          !
          !write(*,*)'  My Tid is',iMyTid,'       My inst is ',imyinst
          call pvmfbarrier('group',iNtask+1,info)	   ! synchronization
          !============================================================	
          !
          !  get all tids
          !
          do i=0,iNtask  
              call pvmfgettid( 'group',i,iTids(i))
          end do
          !============================================================	
          !	try various message sizes
          !
          DO iSize=1,iDim,iStep
              iErrors=0
              !========================================================	
              !
              DO Itrials=1,MaxTrials

                  !====================================================
                  !  set some data in the local array
                  !
                  do i=1,iDim
                      iSendArray(i)=iMyInst 
                  end do 
                  !====================================================	
                  !  wait for signal message from "Collector"
                  !
                  call pvmfrecv(iTids(0),123,iRecvBufid  )
                  CALL pvmffreebuf(iRecvBufid, INFO ) 
                  !====================================================	
                  !
                  !  send local part to COLLECTOR
                  !
                  call pvmfinitsend( PvmDataDefault, iSendBufid )
                  call pvmfpack(INTEGER4,iMyInst   ,1   ,1, info ) 
                  call pvmfpack(INTEGER4,iTempArray,iSize,1, info )
                  call pvmfsend( iTids(0),1234, info )
                  CALL pvmffreebuf(iSendBufid, INFO ) 
                  !
                  !  Now all local parts are sent to COLLECTOR
                  !
                  !====================================================	

                  !====================================================	
                  !  receive message from "Collector"
                  !
                  call pvmfrecv(iTids(iMyInst-1),123,iRecvBufid)

                  !====================================================	
                  !  re-send  message to the next task in the group
                  !

                  if (iMyInst.lt.iNtask) then
                      call pvmfsetsbuf(iRecvBufid,iOldBuf)
                      call pvmfsend(iTids(iMyInst+1),123, info )
                      call pvmfsetrbuf(iRecvBufid,iOldBuf)
                  end if
                  !
                  !  unpack and verify global array
                  !		  
                  do i=1,iNtask
                      call pvmfunpack(INTEGER4,iInst   ,1   ,1, info ) 
                      call pvmfunpack(INTEGER4,iTempArray,iSize,1,info)  
                      ishift=(iInst-1)*iDim
                      do ind=1,iSize
                          iGArray(ishift+ind)=iTempArray(ind)
                      end do
                      !================================================									
                      !  Verify received data
                      !
                      do j=1,iSize
                          if(iTempArray(j).ne.iInst) iErrors=iErrors+1
                      end do
                      !================================================								
                      end do
                  !  clear buffer
                  call pvmffreebuf(iRecvBufid,info)
                  !
                  !  Now all local parts are collected
                  !
              !========================================================	
              END DO ! iTrials
              ! synchronization
              call pvmfbarrier('group',iNtask+1,info)	   
          END DO ! iSize

          call pvmflvgroup('group',info)
          call pvmfexit(info)
      end if
      stop
      end