      program PVMcollect5 	   
      ! 
      !
      !
      !	  Let us have N tasks. To collect the distributed array 
      ! 	 the fan-in/out algorithm is used
      !	  
      !
      include  'fpvm3.h'

      ! number of tasks
      parameter(iNtask=16)
      				
      ! dimension of local  array
      parameter(iDim=4001)			

      ! variation of the message size
      parameter(iStep=50)				

      ! dimension of global array
      parameter(iGlobalDim=iDim*iNtask)	

      parameter(MaxTrials=1)

      ! define type of action 
      parameter(iSend=5432)	 

      ! define type of action 
      parameter(iRecv=6543)	 

      ! define type of action 
      parameter(iIdle=7654)	 


      ! Global array
      integer iGArray(iGlobalDim)	   

      ! Tids of all tasks
      integer iTids(0:iNtask-1)		   

      integer iSendArray(iDim)
      integer iTempArray(iDim)

      real(8) BeginTime,EndTime




      !	enroll in the PVM
      call pvmfmytid(iMyTid)
      					      
      !   join group
      call pvmfJoinGroup('group',iMyInst)		
      !
      !!write(*,*)'   iMyInst=',iMyInst,'   iMyTid=',iMyTid
      !================================================================
      !	  if this task is first in the group then it must spawn 
      !   all another tasks
      if (iMyInst.eq.0) then
          !============================================================	
          !
          call pvmfspawn('PVMcollect5',
     .     PvmTaskDefault,
     .     '*',
     .     iNtask-1,
     .     iTids,
     .     numt)
          write(*,*)'  Spawn',numt,' tasks'

          open(UNIT=12,file='pvmcollect5.out',status='REPLACE')
          write(12,*)' TimingList[K]={'
      end if

      ! synchronization
      call pvmfbarrier('group',iNtask,info)	   
      !================================================================	
      !
      !  get all tids
      !
      do Inst=0,iNtask-1  
          call pvmfgettid( 'group',Inst,iTids(Inst))
      end do









      !================================================================	
      !	try various message sizes
      !
      DO iSize=1,iDim,iStep
          iErrors=0
          !============================================================	
          !  Time count
          !
          if (iMyInst.eq.0) then
          CALL GETTIME(isec, iusec)
          BeginTime=1.0D0*isec+1.0D-6*iusec
          end if
          !============================================================
          !
          DO Itrials=1,MaxTrials


              !========================================================
              !  set some data in the local array
              !
              do i=1,iDim
                  iSendArray(i)=iMyInst 
              end do 

              !========================================================	
              !
              !  pack local part into buffer
              !
              call pvmfinitsend( PvmDataDefault, iSendBufid )
              call pvmfpack(INTEGER4,iMyInst   ,1   ,1, info ) 
              call pvmfpack(INTEGER4,iSendArray,iSize,1, info )


              !========================================================	
              !
              !  collect messages
              !
               	 
              !  number of loops
              Kmax= Int(LOG (1.0*iNtask)/LOG (2.0))	 

              do K=0,Kmax
                  Mult=2**K
                  Nmax=Int( iNtask/ (2.0 * Mult) -  0.5    )
                  !====================================================
                  !	define action
                  iAction=iIdle
                  do n=0,Nmax
                      if ( iMyInst.eq.(2*n+1)*Mult) iAction=iSend

                      !
                      !  if iMyInst match  and sender exists 
                      !     then receive
                      if (( iMyInst.eq.   2*n *Mult).AND.
     .                  (iMyInst+Mult.lt.iNtask) ) iAction=iRecv
                  end do	!  n-loop



                  ACTION: SELECT CASE (iAction)
                  CASE (iSend)         
                  !====================================================
                  !	send part of the global array
                  !
                   !
                   !	Tid of the destination process
                   !
                   iTid = iTids(iMyInst-Mult)
                   !!write(*,*)'  send to  ',iTid,iMyInst-Mult
                   call pvmfsend(iTid,1234,info)


                  CASE (iRecv)          
                  !====================================================
                  !	receive part of the global array
                  !
                   !
                   !	Tid of task which send message
                   !
                   iTid = iTids(iMyInst+Mult)
                   !!write(*,*)'  receive from ',iTid,iMyInst+Mult

                   ! receive message
                   call pvmfrecv(iTid,1234, iRecvBufid  )

                   ! re-pack message from iRecvBufid to iSendBufid
                   call pvmfpkmesgbody( iRecvBufid, info )		 

                  END SELECT ACTION
              end do  !  K - loop





              if(iMyInst.eq.0) then
                  iRecvBufid=iSendBufid
              else 
                  CALL PVMFFREEBUF(iSendBufid, INFO )
              end if

              !
              !  end collection
              !
              !========================================================



              !========================================================
              !
              !  broadcast message using fun algorithm
              !
              do K=Kmax,0,-1
                  Mult=2**K
                  Nmax=Int( iNtask/ (2.0 * Mult) -  0.5    )
                  !====================================================
                  !	define action
                  iAction=iIdle
                  do n=0,Nmax
                      if ( iMyInst.eq.(2*n+1)*Mult) iAction=iRecv 
                      !
                      !  if iMyInst match  and receiver exists 
                      !     then send
                      if (( iMyInst.eq.   2*n *Mult).AND.
     .                  (iMyInst+Mult.lt.iNtask) ) iAction=iSend
                  end do	!  n-loop



                  ACTION1: SELECT CASE (iAction)
                  CASE (iSend)         
                  !====================================================
                  !	(re)send the global array
                  !
                   !
                   !	Task identifier of the destination process
                   !
                   iTid = iTids(iMyInst+Mult)
                   !!write(*,*)'  send to  ',iTid,iMyInst+Mult
                   call pvmfsetsbuf(iRecvBufid,iOldBuf)
                   call pvmfsend(iTid,1234,info)


                  CASE (iRecv)          
                  !====================================================
                  !	receive the global array
                  !
                   !
                   !	Task identifier of sending process
                   !
                   iTid = iTids(iMyInst-Mult)
                   !!write(*,*)'  receive from ',iTid,iMyInst-Mult

                   ! receive message
                   call pvmfrecv(iTid,1234, iRecvBufid  )

                  END SELECT ACTION1
              end do  !  K - loop

              !
              !  END broadcasting
              !
              !========================================================

              !========================================================
              !
              !  unpack and verify global array
              !
              call pvmfsetrbuf(iRecvBufid,iOldBuf)
              do i=1,iNtask

              call pvmfunpack(INTEGER4,iInst   ,1   ,1, info ) 
              call pvmfunpack(INTEGER4,iTempArray,iSize,1, info )
              iShift=iInst*iDim
              do ind=1,iSize
                  iGArray(iShift+ind)=iTempArray(ind)
              end do 
              !========================================================									
              !  Verify received data
              !
              do j=1,iSize
              if (iTempArray(j).ne.iInst) iErrors=iErrors+1
              end do
              !========================================================									
              end do
              !  clear buffer
              call pvmffreebuf(iRecvBufid,info)


          END DO ! iTrials
          call pvmfbarrier('group',iNtask,info)	   

          !============================================================	
          !  Time count
          !
          if (iMyInst.eq.0) then

              CALL GETTIME(isec, iusec)
              EndTime=1.0D0*isec+1.0D-6*iusec

              ! output to file
              write(*,100)iSize*4,(EndTime-BeginTime)/MaxTrials
              write(12,100)iSize*4,(EndTime-BeginTime)/MaxTrials	 			
 100          FORMAT('{', I5, ',', F12.7, '},')
          end if
      END DO ! iSize


      call pvmflvgroup('group',info)
      call pvmfexit(info)

      if (iMyInst.eq.0) then
          write(12,*)'};'	 
          close(12)
      end if

      stop
      end