Welcome to the FastLynx On-line Reference Guide.  Much of the material in
this guide is already included in FastLynx's excellent context-sensitive
help facility.	If you want to jump right in and start using the program
now, feel free to do so.  This guide is provided for the following reasons:

    1) It organizes the material in the help screens into a single place so
    that you can browse through it in its entirety should you feel inclined.

    2) Since this guide is in an ASCII text file (guide.fx), you can
    print it using the DOS "print" command if you so desire.

    3) Some additional material not found in the help screens is included
    for those who want a more in-depth understanding of FastLynx operation.

--------------------------------- Contents ---------------------------------

This guide is organized into sections in the following order:

  * What's new in FastLynx
  * Choosing between parallel or serial
  * Cable specifications
  * Troubleshooting communication problems and using diagnostics
  * Split-screen mode
  * Form mode
  * Command mode
  * Slave mode
  * Configuration
  * Upload
  * Key functionality list
  * Hidden, system and read-only files

-------------------------- What's new in FastLynx --------------------------

The name!  FastLynx is the new name for Fastwire II.  If you are a veteran
Fastwire II user, you will find the same features you have used before plus
some new and improved ones.  Described below are some of these features.
For more detailed information, see the specific section in the On-Line
Reference or the appropriate help screens.

Faster:  The speed of serial 7-wire transfers and parallel transfers has
been increased by approximately 2 to 10 percent, depending on the speed of
the machines involved.

One Program:  Now you only have to remember one program name.  To
communicate between 2 computers, you simply type "fx" on both machines - the
"slave" is built into the program.  Diagnostics are also available from the
main menu to help solve communication problems.

Local copy:  In order to make copying files on the same computer easier, we
have added a local copy feature.  This gives you the option of using
FastLynx's Split-screen, Form or Command mode to copy files between
directories or drives on the same machine.  See the documentation on the
particular mode for more information.

Upload:  You can now transfer FastLynx to another computer that does not
have FastLynx on it, without using a floppy disk!  See the upload section.

Split-screen keys:  FastLynx has changed some of the keys used in this mode.
	Function	    Old key	New FastLynx key
	--------	    -------	----------------
	change directory    Ins 	F2 (Ins will still work)
	rename file	    End 	F6
	view file	    Home	F8
	go to Split-screen  F2		Alt-S
	go to Form mode     F4		Alt-F
	go to Command mode  F6		Alt-C

Split-screen delete:  FastLynx will now allow you to delete non-empty
directories.  In other words, you can delete directories and all of
their files and subordinate subdirectories in one operation.  Of course
you are prompted for confirmation before the delete operation proceeds.

Make directory in Split-screen mode:  Using the F4 key, you can make a
new directory directly from Split-screen mode.

Form file:  The form file is now named "fx.cmd" (instead of fw2.cmd).  If
you are a previous Fastwire II user, you may want to use the forms you had
created previously.  To do this, locate fw2.cmd on your disk and issue the
DOS command:  "rename fw2.cmd fx.cmd".  This will allow you to use your old
forms instead of having to re-create them.  If FastLynx cannot find the
"fx.cmd" form file, it will create one in the directory that the FastLynx
program is in.

Continuous retry:  If FastLynx cannot connect to the remote computer, it
will continue to try to establish communications, but will not bother you
with any questions.  It will keep looking for the other computer while
allowing you to move around within the program.

-------------------- Choosing between parallel or serial -------------------

				    Speed

The main difference between parallel and serial mode is speed.	Parallel
runs 25% to 4 times faster than serial mode, depending on the speed of the
computer.  You will see less improvement if you are running on standard
PC-type machines than if you are running on faster 80286 or 80386 based
machines.

				Cable length

If you are planning to do transfers over cables greater than 15 feet long,
you may want to use serial transfer mode.  Parallel transfers under these
conditions sometimes get more transmission errors, and sometimes even fail
to communicate entirely.  7-wire serial cables have a similar problem with
length.  You may have to transfer in 3-wire mode if the 7-wire cable
is unshielded or excessively long.

There are specially shielded cables available in lengths up to 100 feet that
will work at full speed for both the parallel and the 7-wire serial
communications.  Contact Rupp Corporation for details.


				 Port usage

In choosing between serial and parallel, you should consider what ports are
most readily available on the machines you will be using.  For instance, if
you only have one parallel port and do a lot of printing with it, you may
want to choose serial transfer.  On the other hand, if you only have one
serial port and you have a mouse hooked up to it, using the parallel port
for data transfer might be easier.

Additional serial or parallel cables may be purchased as a separate item
from Rupp Corporation for $39.95.  You may also choose to have your own
cables made using the specifications below.

-------------------------- Cable Specifications ----------------------------

Following is a description of the pin connections for a FastLynx 7-wire
serial cable.  The cable is a 4-headed cable with a 9-pin and 25-pin
female connector on both ends.	The cable is wired as follows:

    9 pin   25 pin	    25 pin  9 pin
    -----   ------	    ------  -----
    pin 5   pin 7   <---->  pin 7   pin 5   (Ground - Ground)

    pin 3   pin 2   <---->  pin 3   pin 2   (Transmit - Receive)
    pin 7   pin 4   <---->  pin 5   pin 8   (RTS - CTS)
    pin 6   pin 6   <---->  pin 20  pin 4   (DSR - DTR)

    pin 2   pin 3   <---->  pin 2   pin 3   (Receive - Transmit)
    pin 8   pin 5   <---->  pin 4   pin 7   (CTS - RTS)
    pin 4   pin 20  <---->  pin 6   pin 6   (DTR - DSR)

The ground wire is connected to the same pin on both ends.  The last
three wires are a reverse of the prior three.

Following is a description of the pin connections for a FastLynx
parallel cable.  The cable has a male DB25 connector at both ends.

	    25 pin	    25 pin
	    ------	    ------
	    pin 2   <---->  pin 15
	    pin 3   <---->  pin 13
	    pin 4   <---->  pin 12
	    pin 5   <---->  pin 10
	    pin 6   <---->  pin 11

	    pin 15  <---->  pin 2
	    pin 13  <---->  pin 3
	    pin 12  <---->  pin 4
	    pin 10  <---->  pin 5
	    pin 11  <---->  pin 6

	    pin 25  <---->  pin 25

The second set of 5 wires is the reverse of the first set.

------------------ Troubleshooting communication problems ------------------

If you are having trouble getting your machines to communicate properly, you
should make sure that:

    1.	Both computers and their parallel/serial ports are 100% IBM
	compatible.
    2.	"fx" is running on both machines.
    3.	The cable is connected correctly.  If you are doing serial transfer,
	connect the two serial ports (male 9 or 25 pin) with the FastLynx
	cable (or a compatible cable).	If you are doing parallel transfer,
	connect the two parallel ports (female 25 pin) with FastLynx's
	special parallel cable.  Sometimes machines have other ports that
	look like serial or parallel ports but are really not, so make
	sure you are connected to the right type of port.  By default,
	FastLynx automatically determines which port to use.  If you
	have specifically selected a port instead of using auto-port
	select, make sure your cables are connected accordingly.
	(If you configured FastLynx to use COM1, make sure cable is not
	connected to COM2.)
    4.	Each serial device in your machine should be set to a different base
	address.  For instance, don't have 2 serial ports set to COM1.
    5.	The machines are not in Local Copy mode.
    6.	The machine to be the slave is NOT in any of the following:
		Split-Screen with LOCAL COPY on
		Viewing the On-Line Reference Guide
		Diagnostics
		Upload
		Viewing a help screen
		Configuration

			    Hardware limitations

    A small number of computers have serial port hardware limitations that
    prevent them from using the top baud rate.	One such machine is the IBM
    PS/2 Model 80 (and Model 70), which can only run at 38400 baud.
    Usually FastLynx's auto-baud will detect this and run successfully at
    the lower baud rate.  You may have to set the baud rate manually,
    however.  See the configuration section for more information on how to
    do this.

    In order for FastLynx to get the tremendous speeds that it does, it
    disables interrupts for a while.  Some computers do not operate
    correctly if interrupts are disabled for too long.	If your computer has
    this limitation, then you should try running FastLynx in the normal
    operating speed mode.  If the problem persists, try the slow operating
    mode.  Note that this particular problem applies only to serial port
    transmissions.  See the section on configuration to find out how to set
    operating speed.

			*** FastLynx Diagnostics ***

If you still have not been able to establish communications, FastLynx
provides its own diagnostics option.  This option provides several tests
that will help you find hardware problems that may be keeping FastLynx from
operating properly.  These tests are described briefly here.

			 Serial port loop-back test

    This is the first test you should run if your serial communications are
    not working correctly.  This test runs a self-test on each serial port
    chip in your system and displays the results.  If you have a serial port
    at a non-standard address, you must specify this in the configuration
    menu.

    If a serial port in your system consistently fails the self-test, it
    probably needs to be replaced or serviced.	You can also expect this
    test to fail if the serial port chip is not IBM-compatible.

    Note that occasionally a serial port will pass the self-test and still
    not function properly.  If the self-test passes, but you are still
    unable to communicate using FastLynx, try the serial character
    transmission test.

		     Serial character transmission test

    The serial transmission test sends a sentence across a serial port to
    another machine.  The characters being sent are displayed in one box,
    and the characters received are displayed in another box.  To run this
    test successfully, make sure that you connect the cable to the ports
    you are interested in testing, and specify the same baud rate on both
    machines.  You must run the character transmission test simultaneously
    on both machines for it to function properly.

    If are not receiving characters and are sure the cable is connected
    properly, try reducing the baud rate on both machines.

    NOTE:  It is quite unlikely that the sentences will be transmitted and
    received in perfect synchronization.  If you see this condition, stop
    the test on one of the machines.  If the sentence is still being
    "received" on the other machine, then they are not properly connected
    (the machine is receiving an echo back from itself).

    If the serial character transmission test passes, but you are still
    unable to communicate using FastLynx, try the Block transmission
    test.

			     Parallel wire test

    The parallel wire option tests the ability to send data across the
    parallel port.  It shows the current state (high or low) of the input
    and output bits used during parallel transfer.  Correct operation is
    indicated by one "HIGH" bit rotating through the set of bits (one for
    output, one for input).  Any other display (such as more than one bit
    high or a bit that does not go high at all) indicates some sort of error
    condition.	To run this test successfully, make sure you connect the
    parallel cable to the ports you are interested in and run the
    Parallel Wire Test on both machines.

    WARNING:  You may have problems transmitting with a normal cable over 15
    feet long.	If this happens you may want to use a shorter cable (if
    possible) or try serial transmission.  Specially shielded cables are
    available up to 100 feet in length.  Contact Rupp Corporation for
    details.

    If the parallel wire test passes, but you are still unable to
    communicate using FastLynx, try the Block transmission test.

		Block transmission and auto port select test

    This option tests the ability of your machines to send large blocks of
    information.  It exchanges information using the same protocol that
    FastLynx does, so if you have determined that the machines are able
    to communicate, but FastLynx still does not work correctly, this test
    should tell you why.  The direction of transfer is from the machine
    running the block transmission diagnostic to the machine just running
    "fx" (only run block transmission test on one side).

    This test uses the timer chip in your PC to report very accurate
    timing results on the transmission test.  The machine running the
    diagnostics must be 100% IBM-compatible for this test to work.

    To run this test successfully, make sure you do the following:
    On one machine:

	1.  Connect the appropriate cable to a serial or parallel port.
	2.  Run the program "fx" (just start program, don't try to
	    communicate from the fx side).

    On the other machine:

	1.  Connect the appropriate cable to a serial or parallel port.
	    Just like normal FastLynx operation, this test automatically
	    selects the correct port and baud rate, so you don't need to
	    worry about configuration.
	2.  Run the block transfer test in diagnostics.

    You can also use this option to see how fast your machines can transfer
    data.  The figures shown include software overhead, but do not include
    disk overhead.

----------------------------- Split-screen mode ----------------------------

The split-screen mode is a beginner's interface which is popular with
all types of users because of its ease of use.	It shows you a directory
listing from each machine and allows you to move around with the arrow keys
and "point-and-shoot".

The left side of the screen will contain a listing of files on the local
machine, the right a listing of files on the remote machine.  You can mark
files you want to transfer using the F5 key and then transfer those files to
the other system by pressing the F3 key.  If you only want to send
one file, you can position the inverse bar over the file and press F3
without marking it first.  If no files are marked, the file under the
inverse bar is considered to be marked.  It is not considered marked if
other files have been explicitly marked.

You can also use split-screen mode to transfer files between two
directories on the same computer.  To enter this "Local Copy" mode, simply
press Alt-L while in split-screen mode.  Press Alt-L again when you wish to
establish communications with the remote computer again.  You may also
switch between Local Copy and Remote mode by using an option described
below in the F9 split-screen options section.  If you switch modes using
the F9 options, the mode change will be remembered next time you start the
program.  Switching using the Alt-L key is a temporary change which is not
remembered next time you start the program.  When you are in Local Copy
mode, all of the same activities and options are available, they just
operate on 2 local directories instead of 1 local directory and 1 remote
directory.

Note that files marked on the local listing will be copied to the remote
system, whereas files marked on the remote listing will be copied to the
local system.

You can use the Shift-F5 key to do a wildcard mark.  FastLynx will prompt
you to enter a wildcard specification, and any files matching that
specification will be marked.

Similarly, you can use Shift-F7 to do a wildcard unmark.  FastLynx will
prompt you to enter a wildcard specification, and any files matching that
specification will be unmarked.

You can use the F7 key to cancel all marks on any file or directory.

The F4 key allows you to create a new directory from split-screen mode.

To move to a different directory, position the inverse bar over the
directory you want to go to and press the Enter key, or use the F2 key to
enter a new drive and directory.  To switch the active directory listing,
use the Tab key, or the left/right arrow keys.

The split-screen mode contains some extra functions that help you to
maintain the files on your disk. You can delete, rename, or view a file
without having to leave the split-screen mode.	If you want to delete or
rename several files, you can mark them using the F5 key and then use the
Del or F6 key to perform the desired operation.  The Local Copy mode is
useful for copying files between drives or directories on the same computer.
(See description of Local Copy above.)

The delete function allows you to delete subordinate directories and files.
If you press the Del key when you are on an empty directory, it will delete
it.  If the directory has files or subdirectories in it, FastLynx will tell
you how many subordinate files and directories there are, and then prompt
you to see if you want to delete them all.  You may choose to go ahead and
delete them all or abort the operation.

If you want to get quickly to one of the other modes, you can use Alt-F to
get to Form mode or Alt-C to get to Command mode.

The first entry in the directory listings is "*".  This is not actually part
of the directory, but means "all files in the directory".  So if you
transfer this item, it will transfer all files in the current directory.  If
you mark this item, you will notice that all files in the directory are
marked also.

Files in the directory listing are sorted according to the specification
in the split-screen options menu.  As shipped, this setting sorts files
alphabetically.  You can change this setting so that the directory is sorted
by date, size, extension, or not sorted at all.  If you want to find a
particular file, you can also do so by typing the name of the file, and the
inverse bar will move to the first file that matches the characters you have
typed.	If no match is found, the program will beep.

There are several options that you can use to customize the split-screen
mode.  These options can be called up by pressing the F9 key.  The first
group of options are automatically saved whenever you change them, and
remain in effect the next time you run the program.  These options are:

			       Date comparison

    You can choose to always copy files (default), or to have FastLynx
    compare the source and target file dates, transferring only files that
    are newer.

				 Directories

    There are three options for copying subdirectories.  The option to
    transfer subdirectories, creating new ones as needed, is like the "/S"
    option of command mode, or of the DOS "backup" or "xcopy" commands.  The
    option to not transfer subdirectories is similar to DOS "backup" or
    "xcopy" without the "/S".  The third options (like "/R" of command mode)
    is unique to FastLynx.  It allows you to transfer only subdirectories
    that already exist on the target computer.	Use of this option allows
    you to maintain a directory structure on one machine that is a subset of
    the directory structure on the other machine.  The default is to not
    transfer subdirectories.

				   Sort by

    This option allows you to choose the order in which files and
    directories will be displayed.  The different methods of sorting are:
	name	    - sort by the name and then extension
	extension   - sort by the extension and then name
	size	    - sort by size of the file
	date	    - sort by date and then time of modification

    For each of these sorting options, you can sort forward or backward.
    For instance, you can sort by size with the smallest file first or
    the largest file first.  Directory names are sorted separately, and are
    displayed before the file names.  There is also an option not to sort,
    which shows files and directories in the order they occur on the disk.


				 Prompt Mode

    This option allows you to select a level of prompting.  By default,
    FastLynx comes configured to prompt before overwriting a file. There are
    four levels to select from:

	Do not prompt before transfers -- This level does no prompting at
	all.

	Prompt before subdirectories -- This level prompts you before
	sending a subdirectory.  You can choose how to be prompted (if at
	all) for files in the subdirectory or choose to skip the
	subdirectory all together.

	Prompt before overwriting files -- This level prompts before
	sending subdirectories (as above) and also causes FastLynx to
	prompt before a file is overwritten.  At transfer time you can
	choose whether or not to send the file.  The filename and the dates
	of the files on both machines will be displayed with the prompt.
	This is the default prompt mode for Split-Screen.

	Prompt before each transfer -- This prompt level also prompts
	before sending subdirectories (as above) and also causes FastLynx
	to prompt before any file is transferred (whether it exists on the
	receiving system or not).  With this prompt level you can decide
	on a file by file basis whether to transfer the file or not.

				Local/Remote

    By default, FastLynx comes configured to transfer files between two
    computers connected by a serial or parallel cable.	This is the
    "Remote Copy" setting for this option.  You can, however, switch
    FastLynx into a "Local Copy" mode which allows you to copy files
    between two different directories (or drives) on the local system.
    The Alt-L hotkey is provided as a quicker way to switch between
    these two modes.

The rest of the split-screen options are temporary settings that remain in
effect only while you are running the program.	The next time you run the
program they will default back to their original settings.
These options are:

				Fake It Mode

    This option allows you to tell FastLynx to "fake" a transfer and report
    what files would have been sent (without actually sending them).

				Exclude list

    Any files or directories that you specify in this list will NOT be
    shown in the directory listing, although they may exist on the machine.
    Wildcards are accepted.  IMPORTANT NOTE:  you must specify only the
    root portion of the files or directories that you want to exclude.
    Leading drive letter or path name prefixes are not allowed and will
    cause the exclude to fail if entered.
	Valid names: data *.doc
	Invalid names: c:\data c:\data\*.doc \data\subdir


				 Date cutoff

    This option allows you to send only files modified after a specified
    date.  If you want to send files regardless of modification time, leave
    the cutoff date set to its default value of January 1, 1980, 12:00 am.
    Any files before the date cutoff will NOT be shown in the directory
    listing, although they may exist on the machine.


--------------------------------- Form mode --------------------------------

The form mode is an intermediate interface which allows you to create, edit
and execute customized command sequences called "forms".  This powerful mode
enables you to build your own list of frequently used transfer commands and
call them up quickly whenever you need them.  This can save you a lot of
time because you can quickly call up any form you have used before and
execute it again.

On the left of the screen is a list of forms that have already been created.
On the right side of the screen is a display indicating the contents of the
form that the inverse bar is currently on.  As you use the up and down
arrows to move through the list of forms, the currently highlighted one will
be displayed at the right.  You can modify an existing form by pressing the
Enter key.  You can add forms to the list using the Ins (or F2) key, and
delete forms from the list using the Del key.  You can execute forms with
the F3 key.

The forms are shown alphabetically.  If you want to find a particular form,
you can also do so by typing the name, and the inverse bar will move to the
first form that matches the characters you have typed.	If no match is
found, the program will beep.

When executing or deleting multiple forms, you can mark the forms you want
and then execute or delete them all at once.  You can do this using the '+'
and '-' keys, which mark and unmark items, or you can use the F5 key, which
toggles the marked state for the current item.

Once you have selected a form to edit, your arrow keys will move you through
the fields containing the form information.  Modifying or creating a form is
simply a matter of filling in information in these fields.  Use the up and
down arrow keys to highlight the field you want to change, and then press
the Enter key to edit the field.  You should see a cursor appear in the
field after it has been selected.  Use the up arrow, down arrow, or Enter
keys to move out of a field that you have edited and save the changes.	To
get out of a selected field and cancel any changes to the field, use the Esc
key.  After you have edited all desired fields, use the Esc key to get out
of the form, and then select the "Save and Exit" option if you want to save
the changes you made.  Note that pressing Esc while a field is selected
exits you from that field.  Pressing Esc when no field is selected exits you
from the entire form.

Form mode has an F9 option key which allows you to change one temporary
setting.  This option is Fake it Mode.	If you select fake file transfers,
FastLynx will "fake" the form transfer and report what files would have been
sent without actually sending them.  Note that this option does not effect
the split-screen or command mode transfers.

If you want to get quickly to one of the other modes, you can use Alt-S to
get to Split-Screen mode or Alt-C to get to Command mode.

There are several transfer fields that you can use to customize the forms.
These options are:

				Local/Remote

    Choose whether to transfer files between the local and remote computer
    or copy between directories on the local system (Local Copy).  This
    selection affects the next 3 fields.
    If you select Remote, the next 3 fields will be:
		Send/Receive
		Local Drive
		Remote Drive
    If you select Local, the next 3 fields will be:
		(Send/Receive) - not applicable
		Source
		Destination

			 Send/Receive (Remote Copy)

    Choose to have the files sent to or received from the remote (other)
    machine.  If you have picked Local Copy mode for this form, this field
    is not applicable, because files will always be copied from the Source
    drive to the Destination drive.

			  Local drive (Remote Copy)

    Specify a drive and/or directory name which will be used as the default
    local drive and directory for file names which do not specify a drive or
    directory.	If not specified, FastLynx will use the current drive and
    directory on the local system.  Does not affect file names that contain
    a complete path name.

			 Remote drive (Remote Copy)

    Specify a drive and/or directory name which will be used as the default
    remote drive and directory for file names which do not specify a drive
    or directory.  If not specified, FastLynx will use the current drive and
    directory on the remote system.  This field does not affect file names
    that contain a complete path name.

			     Source (Local Copy)

    Specify a drive and/or directory name which will be used as the default
    sending drive and directory for file names which do not specify a drive
    or directory.  If not specified, FastLynx will use the current drive and
    directory on the local system.  Does not affect file names that contain
    a complete path name.

			  Destination (Local Copy)

    Specify a drive and/or directory name which will be used as the
    destination drive and directory for files to be copied.  You must
    specify a destination for the Local Copy transfer to be successful.

				 Select list

    This is a list of files to be transferred.	Any combination of drive,
    directory, and file name (including wildcards) is accepted.  Specifying
    a directory name selects all files in the directory.

				Exclude list

    Any files or directories that you specify in this list will NOT be
    transferred.  Wildcards are accepted.  IMPORTANT NOTE:  you must
    specify only the root portion of the files or directories that you want
    to exclude.  Leading drive letter or path name prefixes are not allowed
    and will cause the exclude to fail if entered.
	Valid names: data *.doc
	Invalid names: c:\data c:\data\*.doc \data\subdir


				 Directories

    There are three options for copying subdirectories.  The option to
    transfer subdirectories, creating new ones as needed, is like the "/S"
    option of command mode, or of the DOS "backup" or "xcopy" commands.  The
    option to not transfer subdirectories is similar to DOS "backup" or
    "xcopy" without the "/S".  The third options (like "/R" of command mode)
    is unique to FastLynx.  It allows you to transfer only subdirectories
    that already exist on the target computer.	Use of this option allows
    you to maintain a directory structure on one machine that is a subset of
    the directory structure on the other machine.

				 Prompt Mode

    The prompt level for a form can be selected on a form by form basis.
    The available prompt mode levels are the same as for split-screen mode.

			       Date comparison

    You can choose to copy all selected files or to have FastLynx
    compare the source and target file dates, transferring only files that
    are newer.

				 Date cutoff

    This option allows you to send only files modified after a specified
    date.  If you want to send files regardless of modification time, leave
    the cutoff date set to its default value of January 1, 1980, 12:00 am.
    Any files before the date cutoff will not be transferred.

In addition to transfer options, each form has a place for comments (so you
can remember what the form is supposed to do) and also keeps track of the
last time that you ran the form (run date and time).

You can run FastLynx forms directly from DOS, so you can set up batch files
to do routine transfers.  Simply remember to precede the form name with
"fx".  Example:  to run form "partback" from DOS, at the DOS
prompt type "fx partback".

If FastLynx cannot find the "fx.cmd" form file, it will create one in the
directory that the FastLynx program is in.  The file is no longer included
on the release diskette, but is created (if not found) by FastLynx with
three default forms.

NOTE:  If you are a previous Fastwire II user, you may want to use the forms
you had created previously.  To do this, locate fw2.cmd on your disk and
issue the DOS command:	"rename fw2.cmd fx.cmd".  This will allow you to use
your old forms instead of having to re-create them.

------------------------------- Command mode -------------------------------

This mode is an advanced command-driven interface which allows you to type
in commands directly.  You can use build-in FastLynx commands to send or
receive files.	You can also execute forms created in form mode, or execute
DOS commands or programs.

The following built-in commands are recognized by FastLynx:
	xm	(sends files to remote computer)
	rq	(requests files from remote computer)
	do	(executes DOS commands and programs on remote computer)
	exit	(causes remote FastLynx to exit back to DOS)

"xm" and "rq" have identical syntax.  The only difference is that "xm" sends
files to the remote computer and "rq" receives files from the remote
computer.  The syntax is as follows:

	[xm or rq] [options ...] <file specifications>

		      Command mode file specifications

    Multiple file and directory names may be included in the same command.
    A file name may include a drive and/or directory name and may also
    include wildcards.	If a directory name is specified, all files in
    that directory are transferred.  If the directory name does not exist on
    the receiving system it will be created, but subdirectories will only be
    transferred if /S is specified.  If a filename is specified, only files
    matching that name are transferred.

			    Command mode options

    /C	Do not create files which do not already exist on target system.
    /D	Transfer files whose date is same or later than specified date:
	/D:mm-dd-yy[,hh:mm]
    /E	Exclude specified files or directories (wildcards OK, path names
	and drive letters not OK):
	/E:filename1,filename2,dirname1[,...]
    /F	Force file transfer even if source date is same or older than
	target.
    /L	Specify default drive and/or directory for local system.  If
	receiving, directory will be created if necessary.
	/L:pathname
    /N	Fake transfer and report what would have been transferred.
    /O	Specify default drive and/or directory for remote (other) system.
	If sending, directory will be created if necessary.
	/O:pathname
    /Pn Prompt mode:  n = 1 prompt before subdirectories, n = 2 prompt
	before overwriting, n = 3 prompt before transferring.  If n is
	not specified (but the /P is), n defaults to 3.
    /R	Transfer files in subdirectories, but DO NOT create new directories.
    /S	Transfer files in subdirectories, creating subdirectories as needed.
    /T	Specify second drive and/or directory for a local copy.
	(Use with /L)
	/T:pathname
    /W	Allow read-only files to be overwritten.

    These options can also be specified with '-' instead of '/'.  For
    instance, "-S" means the same as "/S".

The "do" command will send whatever command you type after "do" to the
remote machine, and execute it just as if you had typed it at the DOS
prompt.  For instance, "do cd \" would change the remote system to the root
directory.

The "exit" command is like a built-in form name which causes the remote
FastLynx program to exit.

Examples:
    rq *.* /p2
	Requests all files in from the current directory on the remote
	system, but prompts before overwriting.

    xm /S /F /Ecommand.com,config.sys,autoexec.bat c:\
	Does the same transfer as form "fullback".

    do cd \data
	Executes the command "cd \data" on the remote computer as if it
	had been typed at the DOS prompt on the other computer.

    exit
	Will cause the FastLynx running on the remote computer to exit
	back to DOS.

If the command you type is not recognized as one of the above built-in
FastLynx commands, but matches the name of a form you have created (in
form mode), the form will be executed. Any other command will be passed
on to DOS.  When the DOS command is done, control will return to FastLynx.

Any command that can be run from command mode can also be executed directly
from DOS, so you can set up batch files to do routine transfers.  Simply
remember to precede the command with "fx".

If you want to get quickly to one of the other modes, you can use Alt-S to
get to Split-Screen mode or Alt-F to get to Form mode.

-------------------------------- Slave mode --------------------------------

While the two computers are connected, one will be the master and one will
be the slave, even though they will both be running "fx".  The master
computer is the one that is in Split-Screen, Form, or Command mode and
issues the transfer commands.  The other computer will display "SLAVE MODE"
at the top of the screen.  This means that it is the slave and just does
what the other computer tells it to do.

There are several keys available from Slave mode.

Esc will cause you to exit FastLynx.

Pressing Alt-S will make that computer master and then go to Split-Screen
mode.

Pressing Alt-F will make that computer master and then go to Form mode.

Pressing Alt-C will make that computer master and then go to Command mode.

Pressing Alt-M will make that computer master and then go to the Main menu.

If you type a key other than these pre-defined ones, the computer will
become master and go back to the previous mode it was in (Main menu, Split
screen, Form or Command).  The key you typed will be swallowed, and the
program will wait for the next input.  The exception to this is if you were
previously in Command mode and started typing alpha-numeric keys.  This will
cause you to be put back into Command mode, but instead of ignoring the key
typed, it will be passed along and treated as if you had typed the key from
the command line.

The ability to switch the master-slave roles allows you to initiate
transfers from either computer if you wish, but remember that you can send
files either way from the same computer.  See the sections on Split-screen,
Form or Command mode for more information on transferring files.

There are a few places in the FastLynx program that will not go into slave
mode, and could therefore cause the computers to fail to communicate.  If
you have FastLynx running on both computers and are not able to communicate,
make sure that the computer you want to be the slave is NOT in any of these
places:
	Split-Screen with LOCAL COPY on
	Viewing the On-Line Reference Guide
	Diagnostics
	Upload
	Viewing a help screen
	Configuration

------------------------------ Configuration -------------------------------

The configuration option allows you to change FastLynx's default settings.
The configuration menu can be reached from the main menu, or with F10 from
any of the three modes.

Once you are inside the configuration option, arrow keys will move you
through the fields containing the default information.	Use the up and down
arrow keys to highlight the field you want to change, and then press the
Enter key to edit the field.  You should see a cursor appear in the field
after it has been selected.  Use the up arrow, down arrow, or Enter keys to
move out of a field that you have edited and save the changes.	To get out
of a selected field and cancel any changes to the field, use the Esc key.
After you have edited all desired fields, use the Esc key to get out, and
then select the "Save and Exit" option if you want to save the changes you
made.  Note that pressing Esc while a field is selected exits you from that
field.	Pressing Esc when no field is selected exits you from the entire
configuration menu.

When you save the changes to the configuration, they are automatically
remembered for the next time you call up the program.  When the
configuration is saved, it updates "fx.exe" on the same machine.  It does
NOT update the program on the machine you are communicating with.  To do
this, you must run FastLynx on the other machine and change the
configuration there.

If FastLynx is unable to update the program, it will give you an error
message and then continue with normal execution.  Usually the only reason
for this type of problem is if there is a disk error or if you have removed
the disk containing "fx.exe".  If this error occurs, the configuration
options will still remain in effect for FastLynx until you exit the program,
but they will not be saved permanently.

IMPORTANT NOTE:  FastLynx supports both parallel and serial transfer.  There
is no configuration option to tell FastLynx whether to operate in parallel
or serial transfer mode.  FastLynx will figure that out automatically after
you have plugged in the appropriate cable.  However, you can tell FastLynx
which ports it can and cannot use.  See the port list configuration for
details.


The following options are available in the configuration screen:

			   Port List Configuration

    In most cases you will want to leave the port list set to LPT*,COM*.
    This tells FastLynx to automatically select which port to use.
    FastLynx does this by looking to see what ports you have in your
    system and then experimentally determining which port is connected to
    a system running another FastLynx program.	There are two cases where
    you may want to supply information in the port list field.

    The first case is if you have an active device such as an on-line
    printer or a mouse connected to one of your serial ports.  In this
    case you should tell FastLynx which ports it can use so that it does
    not send test characters to the on-line device.  To tell FastLynx
    which ports it can use, simply enter the port's name (such as "COM1"
    or "LPT2") in the port list.  Multiple port names can be entered
    separated by commas.  Entering a '*' instead of a port number tells
    FastLynx to try all ports of that type.

    Example:  "COM1,COM3,LPT*" tells FastLynx to try serial ports COM1 and
    COM3, all parallel ports, but not COM2.

    Another case where you will want to enter information in the port list
    is if you are using a port with a base address other than the
    standard BIOS addresses.  This situation normally occurs when you
    have three or more serial ports in the machine.  To tell FastLynx to
    use non-standard serial port address, enter a 'C' followed by the
    base address (in hexadecimal) of the port.	FastLynx ignores port
    addresses that are not divisible by eight or fall outside of the
    range 200H-8000H (this check can be overridden by entering an '!'
    after the port address).

    Non-standard parallel ports can be entered by typing an 'L' followed
    by the port address (in hexadecimal).  Similar range checking and
    divisibility rules apply.

    Suppose you add two serial ports to a machine that already has two
    standard serial ports and that the two new port addresses are 300 and
    30A.  If you want FastLynx to automatically select between any of the
    four ports, you would enter "COM*,C300,C30A!" in the port list (30A
    would normally be ignored by FastLynx, but is accepted because of the
    '!').

			   Baud Rate Configuration

    The baud rate option applies only to serial port transfers.

    There are several baud rate choices, ranging from 9600 to 115200.
    FastLynx also has a special AUTO baud option.  Choosing AUTO
    (the default) is normally the easiest way to select a baud rate.
    This allows FastLynx to experimentally determine the fastest
    possible baud rate.  Normally this will be 115200 baud.

    You may also tell FastLynx to operate at a specific baud rate.
    However, if one of the serial port chips cannot operate at that
    high of a baud rate, FastLynx will not be able to establish
    communication.  If you choose a specific baud rate and want to
    use 7-wire mode, select a baud rate with a '+' after it.  If you are
    having problems with 7-wire mode (possibly due to a long cable), select
    a baud rate without a '+' after it to force FastLynx to use 3-wire
    mode.

			Error Checking Configuration

    FastLynx has two basic methods of detecting errors:  checksum or
    CRC.  The CRC method is much better at detecting transmission errors.
    The checksum method, though not nearly as good at detecting errors
    as a CRC, is generally considered adequate for a direct line
    connection (since error rates are so low).	It is also much faster.
    Several of our competitors offer only this method (or some variant
    thereof).

    FastLynx offers three error detection modes using the above 2 methods:

	1)  Auto - use checksum until an error is detected, then use CRC.
	2)  Use checksum only.
	3)  Use CRC only.

    The "CRC only" mode is the safest possible way to transfer your files.
    The default "auto" mode is recommended for users who want more speed
    and rarely experience transmission errors.	The "checksum only" mode
    is not recommended, but is provided for users who insist on the fastest
    possible speed.

			Operating Speed Configuration

    There are three operating speeds for FastLynx:  slow, normal and
    turbo.  The default "slow" operating speed is the safest (and slowest)
    way to transfer files, because FastLynx sends information in very small
    blocks.  The "normal" and "turbo" speeds use progressively larger block
    sizes to speed the transfer.  Most systems can handle the larger block
    sizes without any problems, but some cannot.  If speed is a concern, we
    recommend that you experiment with "normal" and then "turbo" mode.  If
    you experience excessive transmission errors or other problems, drop
    back to a lower speed setting.

			 Default Mode Configuration

    FastLynx operates in one of three different modes:	 Split-Screen,
    Form or Command.  By default, FastLynx starts out at the main menu,
    and you can move to the three basic modes from there.  You can
    configure FastLynx so that it bypasses the main menu and starts
    out immediately in any of the three modes.

---------------------------------- Upload ----------------------------------

The upload option is designed to allow you to transfer FastLynx to another
system which does not already have FastLynx on it.  This unique capability
is particularly useful when you encounter a need to transfer files and do
not have a FastLynx disk (of the right size) with you.

The Upload option can be selected from the Main Menu or from SPLIT SCREEN
mode when the remote system is not connected.

1)  First make sure the FastLynx serial cable is connected between the two
    computers.	If you are using your own cable, it must be a 7-wire cable
    compatible with the FastLynx cable.  You may use COM1 or COM2 on either
    machine, but not COM3 or COM4 (although regular FastLynx transfers can
    use COM3 and COM4).

2)  Please indicate which serial port (COM1 or COM2) the remote computer is
    using.  FastLynx can automatically determine which local serial port
    you are using, but cannot tell which port you selected on the remote
    machine.

3)  If you selected COM1 for the remote machine, type the following DOS
    command on the remote system:

	  mode com1:2400,n,8,1,p	 (and press the Enter key)

    If you selected COM2 for the remote machine, type the following DOS
    command on the remote system:

	  mode com2:2400,n,8,1,p	 (and press the Enter key)

    You should see one of the following responses from DOS:

	  COM1:2400,N,8,1    or   COM2:2400,N,8,1

    The intent of this step is to initialize the serial port to 2400 baud, no
    parity, 8 data bits, and 1 stop bit.

    If you saw a "Bad command" error message from DOS, you will need to
    find a DOS diskette that has the DOS "mode" command on it and try again.

4)  If you selected COM1 for the remote system, type the following DOS
    command on the remote system:

	  ctty com1			 (and press the Enter key)

    If you selected COM2 for the remote system, type the following DOS
    command on the remote system:

	  ctty com2			 (and press the Enter key)

You should see a "Loading bootstrap ..." message shortly after typing the
above command--this means that communication has been established and
the upload is in progress.

Note:  If the upload process does not complete successfully, it will be
necessary for you to re-boot (reset) the remote machine.

The following FastLynx files will be transferred into the currently
selected drive and directory.  If there is enough disk space available,
FastLynx will transfer the following files:

    FX.EXE	(the FastLynx program file)
    FX.HLP	(the FastLynx help file)
    GUIDE.FX	(the FastLynx on-line guide)

The on-line guide will be transferred if it is found, otherwise just the
program and help file will be sent.

There are several reasons why the upload can fail.  If you are having
problems please check the following list:

    1)	Insure serial cable is FastLynx compatible and securely connected.
    2)	Insure the remote serial port you specified is really the one to
	which the cable is connected.
    3)	Insure that the "mode" and "ctty" commands were typed exactly as
	specified.
    4)	If the upload fails consistently, try it again without the ",p" at
	the end of the "mode" command.
    5)	If the bootstrap program seems to transfer OK, but the subsequent
	file transfers fail, try lowering the baud rate.  This can be done
	by  selecting the "Configuration" option from the main menu and
	changing the "Baud Rate" field.

If the upload feature fails, try loading FastLynx onto the remote system
using floppy disks or whatever other methods are available to you.  There
are a few situations where FastLynx itself can transfer files even though
the upload process does not work.

-------------------------- Key functionality list --------------------------

The following is a definition of all keys used by FastLynx:

Press:		When you want:
--------------	------------------------------------------------------------
F1		General help information
F2 or Ins	To changes drives and/or subdirectories while in SPLIT
		SCREEN MODE
		Create a new form in FORM MODE
F3		To transfer files(s) or execute form(s)
F4		To Create a directory while in SPLIT SCREEN MODE
F5		To mark or unmark the file(s) to be transferred while in
		SPLIT SCREEN MODE or form(s) to be executed in FORM MODE
		(toggles current state)
Shift-F5	To mark files using wildcards in SPLIT SCREEN MODE
F6		To Rename a file in SPLIT SCREEN MODE
F7		To unmark all files in SPLIT SCREEN MODE or all forms
		in FORM MODE
Shift-F7	To unmark files using wildcards in SPLIT SCREEN MODE
F8		To View a file while in SPLIT SCREEN MODE
F9		To call up the options screen in SPLIT SCREEN or FORM MODE
F10		To enter the CONFIGURATION menu to change default settings
Esc		To return to previous menu or exit program
Ctrl-Break	To return to previous menu or exit program
Ins		To add a new form in FORM MODE
Del		To delete a file or directory in SPLIT SCREEN MODE
		To delete a form in FORM MODE
Tab		To move cursor between local/remote drive listings in the
		SPLIT SCREEN MODE
Left/Rt arrows	To move cursor between local/remote drive listings in the
		SPLIT SCREEN MODE
'+'             To select the file(s) to be transferred while in SPLIT
		SCREEN MODE or form(s) to be executed in FORM MODE
'-'             To unselect the file(s) to be transferred while in SPLIT
		SCREEN MODE or form(s) to be executed in FORM MODE
Enter		To change to directory or re-read directory in SPLIT SCREEN
		MODE.  Select an item to be edited or modified in FORM MODE
		and configuration menu
PgUp, PgDn	To move the cursor up/down a page at a time
Home		To move the cursor to top of list
End		To move the cursor to bottom of list
Alt-C		To go to COMMAND MODE from SPLIT SCREEN MODE or FORM MODE
		or SLAVE MODE
Alt-S		To go to SPLIT SCREEN MODE from COMMAND MODE or FORM MODE
		or SLAVE MODE
Alt-F		To go to FORM MODE from SPLIT SCREEN MODE or COMMAND MODE
		or SLAVE MODE
Alt-L		To switch between Local Copy and Remote Copy in SPLIT SCREEN
		MODE
Alt-M		To toggle monochrome/color output from MAIN MENU
		To go to MAIN MENU from SLAVE MODE

-------------------- Read-only, hidden and system files --------------------

FastLynx can transfer files and directories that are read-only,
hidden or system.  Because these are special files, FastLynx handles
them a bit differently than normal files and directories.  A
read-only, hidden or system file will only be transferred if it
doesn't exist on the target machine.  This is to prevent unwanted
over-writing or moving of this type of files.  This behavior can be
partially overridden in Command Mode with the /W switch.  If
the /W switch is present, Read-Only files will be overwritten even if
they exist on the receiving system.

FastLynx will also delete system, hidden and read-only
files and directories, but will ask for additional verification to make
sure you really want the file or directory deleted.
