/*------------------------------------------------------------------------------
								  Advance Diploma In Computer
							 Object-Oriented Programming (OP216)
											 ASSIGNMENT
										 TERM THREE 2000
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Student Name: Irene Nancy Kuek Ik Ching
Student ID  : 0206-0100-1026
Class Code  : T300FGAOP216
------------------------------------------------------------------------------*/

//-----------------------Library included into the program----------------------
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <stdio.h>
#include <dos.h>

//-----------------------------Constant Declaration-----------------------------
const sizearr = 20; //Range of array

//--------------------------Classes used in the program-------------------------
class Member
 {
  private:
	char* memid;
	char* memname;
	char* memage;
	char* memstatus;
  public:
	Member(){memid = "x"; memname = "x"; memage = "x"; memstatus = "x";};
	void setID (char* id)
	 {memid = new char[strlen(id)+1]; strcpy(memid,id);};
	void setName (char* name)
	 {memname = new char[strlen(name)+1]; strcpy(memname,name);};
	void setAge (char* age)
	 {memage = new char[strlen(age)+1]; strcpy(memage,age);};
	void setStatus (char* status)
	 {memstatus = new char[strlen(status)+1]; strcpy(memstatus,status);};
	void setMember (char* id, char* name, char* age, char* status)
	 {
	  memid     = new char[strlen(id)+1]; strcpy(memid,id);
	  memname   = new char[strlen(name)+1]; strcpy(memname,name);
	  memage    = new char[strlen(age)+1]; strcpy(memage,age);
	  memstatus = new char[strlen(status)+1]; strcpy(memstatus,status);
	 };
	char* getID     (void){return memid;};
	char* getName   (void){return memname;};
	char* getAge    (void){return memage;};
	char* getStatus (void){return memstatus;};
 };

class Book
 {
  private:
	char* bid;
	char* btitle;
	char* bauthor;
	char* btype;
	char* bstatus;
	char* bprice;
  public:
	Book(){bid = "x"; btitle = "x"; bauthor = "x"; btype = "x"; bstatus = "x"; bprice = "x";};
	void setID (char* id)
	 {bid = new char[strlen(id)+1]; strcpy(bid,id);};
	void setTitle (char* title)
	 {btitle = new char[strlen(title)+1]; strcpy(btitle,title);};
	void setAuthor (char* author)
	 {bauthor = new char[strlen(author)+1]; strcpy(bauthor,author);};
	void setType (char* type)
	 {btype = new char[strlen(type)+1]; strcpy(btype,type);};
	void setStatus (char* status)
	 {bstatus = new char[strlen(status)+1]; strcpy(bstatus,status);};
	void setPrice (char* price)
	 {bprice = new char[strlen(price)+1]; strcpy(bprice,price);};
	void setBook (char* id, char* title, char* author, char* type, char* status,
					  char* price)
	 {
	  bid     = new char[strlen(id)+1]; strcpy(bid,id);
	  btitle  = new char[strlen(title)+1]; strcpy(btitle,title);
	  bauthor = new char[strlen(author)+1]; strcpy(bauthor,author);
	  btype   = new char[strlen(type)+1]; strcpy(btype,type);
	  bstatus = new char[strlen(status)+1]; strcpy(bstatus,status);
	  bprice  = new char[strlen(price)+1]; strcpy(bprice,price);
	 };
	char* getID     (void){return bid;};
	char* getTitle  (void){return btitle;};
	char* getAuthor (void){return bauthor;};
	char* getType   (void){return btype;};
	char* getStatus (void){return bstatus;};
	char* getPrice  (void){return bprice;};
 };

class Inventory
 {
  private:
	char* invid;
	char* invtitle;
	char* invtype;
	char* invqty;
  public:
	Inventory(){invid = "x"; invtitle = "x"; invtype = "x"; invqty = "x";};
	void setID (char* id)
	 {invid = new char[strlen(id)+1]; strcpy(invid,id);};
	void setTitle (char* title)
	 {invtitle = new char[strlen(title)+1]; strcpy(invtitle,title);};
	void setType (char* type)
	 {invtype = new char[strlen(type)+1]; strcpy(invtype,type);};
	void setQty (char* qty)
	 {invqty = new char[strlen(qty)+1]; strcpy(invqty,qty);};
	void setInventory (char* id, char* title, char* type, char* qty)
	 {
	  invid    = new char[strlen(id)+1]; strcpy(invid,id);
	  invtitle = new char[strlen(title)+1]; strcpy(invtitle,title);
	  invtype  = new char[strlen(type)+1]; strcpy(invtype,type);
	  invqty   = new char[strlen(qty)+1]; strcpy(invqty,qty);
	 };
	char* getID    (void){return invid;};
	char* getTitle (void){return invtitle;};
	char* getType  (void){return invtype;};
	char* getQty   (void){return invqty;};
 };

class Transaction
 {
  private:
	char* tmemid;
	char* tbid;
	char* tdate;
  public:
	Transaction()
	 {
	  tmemid = "x"; tbid = "x"; tdate = "x";
	 };
	void setMID (char* mid)
	 {tmemid = new char[strlen(mid)+1]; strcpy(tmemid,mid);};
	void setBID (char* bkid)
	 {tbid = new char[strlen(bkid)+1]; strcpy(tbid,bkid);};
	void setDate (char* date)
	 {tdate = new char[strlen(date)+1]; strcpy(tdate,date);};
	void setTransaction (char* mid, char* bkid, char* date)
	 {
	  tmemid = new char[strlen(mid)+1]; strcpy(tmemid,mid);
	  tbid   = new char[strlen(bkid)+1]; strcpy(tbid,bkid);
	  tdate  = new char[strlen(date)+1]; strcpy(tdate,date);
	 };
	char* getMID  (void){return tmemid;};
	char* getBID  (void){return tbid;};
	char* getDate (void){return tdate;};
 };

//-------------------------Prototype used in the program------------------------
char mainmenu        (void);
void dis_err_msg     (char*);
int  check_char      (char);
void retrievemember  (Member);
void retrievebook    (Book);
void retrieveinv     (Inventory);
void retrievetrans   (Transaction);
char member_mainmenu (void);
char book_mainmenu   (void);
char inv_mainmenu    (void);
char trans_mainmenu  (void);
char rep_mainmenu    (void);
void call_member     (Member);
void call_book       (Book);
void call_inv        (Inventory);
void call_trans      (Member, Book, Transaction);
void call_rep        (Member, Book, Inventory, Transaction);
int  yesno           (char);
int  check_id        (char*);
int  check_nta       (char*);
void storemember     (Member);
void storebook       (Book);
void storeinv        (Inventory);
void storetrans      (Transaction);

//-------------------------------Function mainmenu------------------------------
char mainmenu (void)
//Display the main menu.
 {
  char num = '0';
  gotoxy(24,4); cout<<"Orchard Rental Bookshop";
  gotoxy(24,5); cout<<"~~~~~~~~~~~~~~~~~~~~~~~";
  gotoxy(31,6); cout<<"Main Menu";
  gotoxy(25,8); cout<<"(1) Membership Module";
  gotoxy(25,9); cout<<"(2) Book Module";
  gotoxy(25,10); cout<<"(3) Inventory Module";
  gotoxy(25,11); cout<<"(4) Transaction Module";
  gotoxy(25,12); cout<<"(5) Report Module";
  gotoxy(25,13); cout<<"(6) Exit";
  gotoxy(27,15); cout<<"Enter choice : [ ]";
  gotoxy(43,15); cin>>num;
  return num;
 };

//-----------------------------Function dis_err_msg-----------------------------
void dis_err_msg (char* errmsg)
//Display error message according to the alignment.
 {
  int size = 0;
  size = (80 - strlen(errmsg))/2;
  gotoxy(size,22); cout<< errmsg <<endl;
  gotoxy(25,23);   cout<<"[Press Any Key To Continue]"<<endl;
  getch();
  gotoxy(1,22); clreol();
  gotoxy(1,23); clreol();
 };

//------------------------------Function check_char-----------------------------
int check_char (char check)
//Check if character entered is alphabetic or symbol. If yes return 0 else 1.
 {
  if ((check>=65) && (check<=91))
	 return 0;
  else
	if ((check>=97) && (check<=123))
	  return 0;
	else
	  return 1;
 };

//----------------------------Function retrievemember---------------------------
void retrievemember (Member *mbrarray)
//Retrieve member records from file and store into the array of objects.
 {
  char id[6];
  char name[20];
  char age[2];
  char status[1];

  ifstream mbrFile("Member.txt");
  if (mbrFile)
	 {
	  for (int count=0; count<sizearr; count++)
		{
		 mbrFile.getline(id, 10, '\n');
		 mbrFile.getline(name, 30, '\n');
		 mbrFile.getline(age, 5, '\n');
		 mbrFile.getline(status, 5, '\n');
		 mbrarray[count].setMember(id, name, age, status);
		}
	 }
 };

//-----------------------------Function retrievebook----------------------------
void retrievebook (Book *bkarray)
//Retrieve book records from file and store into the array of objects.
 {
  char id[6];
  char title[20];
  char author[20];
  char type[3];
  char status[1];
  char price[8];

  ifstream bkFile("Book.txt");
  if (bkFile)
	 {
	  for (int count=0; count<sizearr; count++)
		{
		 bkFile.getline(id, 10, '\n');
		 bkFile.getline(title, 30, '\n');
		 bkFile.getline(author, 30, '\n');
		 bkFile.getline(type, 5, '\n');
		 bkFile.getline(status, 5, '\n');
		 bkFile.getline(price, 5, '\n');
		 bkarray[count].setBook(id, title, author, type, status, price);
		}
	 }
 };

//-----------------------------Function retrieveinv-----------------------------
void retrieveinv (Inventory *invarray)
//Retrieve inventory records from file and store into the array of objects.
 {
  char id[6];
  char title[20];
  char type[3];
  char qty[2];

  ifstream invFile("Inventory.txt");
  if (invFile)
	 {
	  for (int count=0; count<sizearr; count++)
		{
		 invFile.getline(id, 10, '\n');
		 invFile.getline(title, 30, '\n');
		 invFile.getline(type, 5, '\n');
		 invFile.getline(qty, 5, '\n');
		 invarray[count].setInventory(id, title, type, qty);
		}
	 }
 };

//----------------------------Function retrievetrans----------------------------
void retrievetrans (Transaction *transarray)
//Retrieve transaction records from file and store into the array of objects.
 {
  char mid[6];
  char bid[6];
  char date[10];

  ifstream transFile("Transaction.txt");
  if (transFile)
	 {
	  for (int count=0; count<sizearr; count++)
		{
		 transFile.getline(mid, 10, '\n');
		 transFile.getline(bid, 10, '\n');
		 transFile.getline(date, 20, '\n');
		 transarray[count].setTransaction(mid, bid, date);
		}
	 }
 };

//---------------------------Function member_mainmenu---------------------------
char member_mainmenu (void)
//Display the membership module main menu.
 {
  char num = '0';
  gotoxy(24,4); cout<<"Orchard Rental Bookshop";
  gotoxy(24,5); cout<<"~~~~~~~~~~~~~~~~~~~~~~~";
  gotoxy(24,6); cout<<"Membership Module Menu";
  gotoxy(22,8); cout<<"(1) Add New Members Module";
  gotoxy(22,9); cout<<"(2) Delete Membership Module";
  gotoxy(22,12); cout<<"(3) Exit";
  gotoxy(27,14); cout<<"Enter choice : [ ]";
  gotoxy(43,14); cin>>num;
  return num;
 };

//----------------------------Function book_mainmenu----------------------------
char book_mainmenu (void)
//Display the book module main menu.
 {
  char num = '0';
  gotoxy(24,4); cout<<"Orchard Rental Bookshop";
  gotoxy(24,5); cout<<"~~~~~~~~~~~~~~~~~~~~~~~";
  gotoxy(27,6); cout<<"Book Module Menu";
  gotoxy(24,8); cout<<"(1) Add New Book Module";
  gotoxy(24,9); cout<<"(2) Delete Book Module";
  gotoxy(24,12); cout<<"(3) Exit";
  gotoxy(27,14); cout<<"Enter choice : [ ]";
  gotoxy(43,14); cin>>num;
  return num;
 };

//----------------------------Function inv_mainmenu-----------------------------
char inv_mainmenu (void)
//Display the inventory module main menu.
 {
  char num = '0';
  gotoxy(24,4); cout<<"Orchard Rental Bookshop";
  gotoxy(24,5); cout<<"~~~~~~~~~~~~~~~~~~~~~~~";
  gotoxy(25,6); cout<<"Inventory Module Menu";
  gotoxy(22,8); cout<<"(1) Add New Inventory Module";
  gotoxy(22,9); cout<<"(2) Delete Inventory Module";
  gotoxy(22,12); cout<<"(3) Exit";
  gotoxy(27,14); cout<<"Enter choice : [ ]";
  gotoxy(43,14); cin>>num;
  return num;
 };

//---------------------------Function trans_mainmenu----------------------------
char trans_mainmenu (void)
//Display the transaction module main menu.
 {
  char num = '0';
  gotoxy(24,4); cout<<"Orchard Rental Bookshop";
  gotoxy(24,5); cout<<"~~~~~~~~~~~~~~~~~~~~~~~";
  gotoxy(24,6); cout<<"Transaction Module Menu";
  gotoxy(28,8); cout<<"(1) Borrow Book";
  gotoxy(28,9); cout<<"(2) Return Book";
  gotoxy(28,12); cout<<"(3) Exit";
  gotoxy(27,14); cout<<"Enter choice : [ ]";
  gotoxy(43,14); cin>>num;
  return num;
 };

//----------------------------Function rep_mainmenu-----------------------------
char rep_mainmenu (void)
//Display the report module main menu.
 {
  char num = '0';
  gotoxy(24,4); cout<<"Orchard Rental Bookshop";
  gotoxy(24,5); cout<<"~~~~~~~~~~~~~~~~~~~~~~~";
  gotoxy(26,6); cout<<"Report Module Menu";
  gotoxy(21,8); cout<<"(1) Membership Report Module";
  gotoxy(21,9); cout<<"(2) Book Report Module";
  gotoxy(21,10); cout<<"(3) Inventory Report Module";
  gotoxy(21,11); cout<<"(4) Transaction Report Module";
  gotoxy(21,12); cout<<"(5) Exit";
  gotoxy(27,14); cout<<"Enter choice : [ ]";
  gotoxy(43,14); cin>>num;
  return num;
 };

//----------------------------Function call_member------------------------------
void call_member (Member *mbr)
//Call membership module and allow the user to execute the sub-modules.
 {
  char choice = '0';
  int valid = 0;
  do
	{
	 do
	  {
		clrscr();
		valid = 0;
		choice = member_mainmenu();
		if ((choice>'3') || (choice<'1'))
		 valid = 0;
		else
		 valid = 1;
		if (valid==0)
		 {
		  valid = check_char(choice);
		  dis_err_msg ("Please Enter Number Range 1 to 3");
		 }
	  }while(!valid);
	 switch(choice)
	  {
		case '1' : {
						char* lid="";
						char* lname="";
						char* lage="";
						char  ans;
						int   valid1=0;
						static int mbrcount=0;
						Member temp;

						if (mbrcount==sizearr)
						 dis_err_msg ("Member File Is Full");
						else
						  {
							cout<<""; cout<<"";
							clrscr();
							cout<<""; cout<<"";
							clrscr();
							gotoxy(10,4); cout<<"Add New Member";
							gotoxy(10,5); cout<<"~~~~~~~~~~~~~~";
							gotoxy(10,7); cout<<"Member ID   : ";
							gotoxy(10,8); cout<<"Member Name : ";
							gotoxy(10,9); cout<<"Member Age  : ";
							gotoxy(10,11); cout<<"Number of Books Borrowed : 0";
							do
							 {
							  gotoxy(24,7); clreol();
							  gotoxy(24,7); gets(lid);
							  valid1 = check_id(lid);
							  if (valid1 == 0)
								dis_err_msg ("Valid ID is [000000..999999]");
							 }while(!valid1);
							temp.setID(lid);
							valid1=0;
							do
							 {
							  gotoxy(24,8); clreol();
							  gotoxy(24,8); gets(lname);
							  valid1 = check_nta(lname);
							  if (valid1 == 0)
								dis_err_msg ("Valid Range of Characters is 20");
							 }while(!valid1);
							temp.setName(lname);
							gotoxy(24,9); gets(lage);
							temp.setAge(lage);
							temp.setStatus("0");
							valid1=0;
							do
							 {
							  gotoxy(1,15); clreol();
							  gotoxy(10,15); cout<<"Save?[Y/N] : [ ]";
							  gotoxy(24,15); cin>>ans;
							  valid1 = yesno(ans);
							  if (valid1 == 0)
								dis_err_msg ("Please Enter Only [Y/N]");
							 }while(!valid1);

							if (toupper(ans)=='Y')
							  {
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Saved...";
								mbr[mbrcount].setMember(temp.getID(), temp.getName(),
																temp.getAge(), temp.getStatus());
								mbrcount++;
							  }
							else
							  {
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Not Saved...";
							  }
							getch();
						  }
					  }; break;
		case '2' : {
						char* lid2="";
						char* temp="";
						char  ans2;
						int   valid2 = 0;
						int   found = 0;
						int   count =0;
						int   count2=0;
						int   match=0;
						Member mbrtemp[sizearr];

						clrscr();
						cout<<"";
						gotoxy(10,4); cout<<"Delete Membership";
						gotoxy(10,5); cout<<"~~~~~~~~~~~~~~~~~";
						gotoxy(10,7); cout<<"Enter Member ID : ";
						gotoxy(10,8); cout<<"Member Name     : ";
						gotoxy(10,9); cout<<"Number of Books Borrowed : ";
						do
						 {
						  gotoxy(28,7); clreol();
						  gotoxy(28,7); gets(lid2);
						  valid2 = check_id(lid2);
						  if (valid2 == 0)
							dis_err_msg ("Valid ID is [000000..999999]");
						 }while(!valid2);
						for (count=0; count<sizearr; count++)
						  {
							temp=mbr[count].getID();
							match = strcmp(temp, lid2);
							if (match==0)
							  {
								gotoxy(28,8); cout<<mbr[count].getName();
								gotoxy(37,9); cout<<mbr[count].getStatus();
								found = 1;
								break;
							  }
						  }
						if (found==0)
						 dis_err_msg ("Record NOT Found");
						else
						  {
							valid2=0;
							do
							 {
							  gotoxy(1,15); clreol();
							  gotoxy(10,15); cout<<"Delete?[Y/N] : [ ]";
							  gotoxy(26,15); cin>>ans2;
							  valid2 = yesno(ans2);
							  if (valid2 == 0)
							  dis_err_msg ("Please Enter Only [Y/N]");
							 }while(!valid2);

							if (toupper(ans2)=='Y')
							  {
								for(count=0; count<sizearr; count++)
								  {
									temp="";
									temp=mbr[count].getID();
									match = strcmp(temp, lid2);
									if (match==1)
									 {
										mbrtemp[count2].setMember(mbr[count].getID(),
																		  mbr[count].getName(),
																		  mbr[count].getAge(),
																		  mbr[count].getStatus());
										count2++;
									 }
									else
									 {
									  mbrtemp[count2].setMember("x", "x", "x", "x");
									  count2++;
									 }
								  }
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Deleted...";
								*mbr = *mbrtemp;
							  }
							else
							  {
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Not Deleted...";
							  }
							getch();
						  }
					  }; break;
	  }
	}while(choice!='3');
 };

//-----------------------------Function call_book-------------------------------
void call_book (Book *bk)
//Call book module and allow the user to execute the sub-modules.
 {
  char choice = '0';
  int valid = 0;
  do
	{
	 do
	  {
		clrscr();
		valid = 0;
		choice = book_mainmenu();
		if ((choice>'3') || (choice<'1'))
		 valid = 0;
		else
		 valid = 1;
		if (valid==0)
		 {
		  valid = check_char(choice);
		  dis_err_msg ("Please Enter Number Range 1 to 3");
		 }
	  }while(!valid);
	 switch(choice)
	  {
		case '1' : {
						char* lid="";
						char* ltitle="";
						char* lauthor="";
						char* ltype="";
						char* lprice="";
						char  ans;
						int   valid1 = 0;
						static int bkcount=0;
						Book temp;

						if (bkcount==sizearr)
						 dis_err_msg ("Book File Is Full");
						else
						  {
							clrscr();
							cout<<"";
							gotoxy(10,4); cout<<"Add New Book";
							gotoxy(10,5); cout<<"~~~~~~~~~~~~";
							gotoxy(10,7); cout<<"Book ID : ";
							gotoxy(10,8); cout<<"Book Title  : ";
							gotoxy(10,9); cout<<"Book Author : ";
							gotoxy(10,10); cout<<"Book Type   : ";
							gotoxy(10,11); cout<<"Book Status : A";
							gotoxy(10,12); cout<<"Book Price  : ";
							do
							 {
							  gotoxy(20,7); clreol();
							  gotoxy(20,7); gets(lid);
							  valid1 = check_id(lid);
							  if (valid1 == 0)
								dis_err_msg ("Valid ID is [000000..999999]");
							 }while(!valid1);
							temp.setID(lid);
							valid1=0;
							do
							 {
							  gotoxy(24,8); clreol();
							  gotoxy(24,8); gets(ltitle);
							  valid1 = check_nta(ltitle);
							  if (valid1 == 0)
								dis_err_msg ("Valid Range of Characters is 20");
							 }while(!valid1);
							temp.setTitle(ltitle);
							valid1=0;
							do
							 {
							  gotoxy(24,9); clreol();
							  gotoxy(24,9); gets(lauthor);
							  valid1 = check_nta(lauthor);
							  if (valid1 == 0)
								dis_err_msg ("Valid Range of Characters is 20");
							 }while(!valid1);
							temp.setAuthor(lauthor);
							gotoxy(10,14); cout<<"SEC - Sencondary   COL - College   UNI - University";
							gotoxy(24,10); gets(ltype);
							gotoxy(1,14); clreol();
							temp.setType(ltype);
							valid1=0;
							gotoxy(24,12); gets(lprice);
							temp.setStatus("A");
							temp.setPrice(lprice);
							valid1=0;
							do
							 {
							  gotoxy(1,15); clreol();
							  gotoxy(10,15); cout<<"Save?[Y/N] : [ ]";
							  gotoxy(24,15); cin>>ans;
							  valid1 = yesno(ans);
							  if (valid1 == 0)
								dis_err_msg ("Please Enter Only [Y/N]");
							 }while(!valid1);

							if (toupper(ans)=='Y')
							  {
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Saved...";
								bk[bkcount].setBook(temp.getID(), temp.getTitle(),
														  temp.getAuthor(), temp.getType(),
														  temp.getStatus(), temp.getPrice());
								bkcount++;
							  }
							else
							  {
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Not Saved...";
							  }
							getch();
						  }
					  }; break;
		case '2' : {
						char* lid2="";
						char* temp="";
						char  ans2;
						int   valid2 = 0;
                  int   found = 0;
						int   count =0;
						int   count2=0;
						int   match=0;
						Book bktemp[sizearr];

						clrscr();
						cout<<"";
						gotoxy(10,4); cout<<"Delete Book";
						gotoxy(10,5); cout<<"~~~~~~~~~~~";
						gotoxy(10,7); cout<<"Enter Book ID : ";
						gotoxy(10,8); cout<<"Book Title  : ";
						gotoxy(10,9); cout<<"Book Author : ";
						do
						 {
						  gotoxy(26,7); clreol();
						  gotoxy(26,7); gets(lid2);
						  valid2 = check_id(lid2);
						  if (valid2 == 0)
							dis_err_msg ("Valid ID is [000000..999999]");
						 }while(!valid2);
						for (count=0; count<sizearr; count++)
						  {
							temp=bk[count].getID();
							match = strcmp(temp, lid2);
							if (match==0)
							  {
								gotoxy(26,8); cout<<bk[count].getTitle();
								gotoxy(26,9); cout<<bk[count].getAuthor();
								found = 1;
								break;
							  }
						  }
						if (found==0)
						 dis_err_msg ("Record NOT Found");
						else
						  {
							valid2=0;
							do
							 {
							  gotoxy(1,15); clreol();
							  gotoxy(10,15); cout<<"Delete?[Y/N] : [ ]";
							  gotoxy(26,15); cin>>ans2;
							  valid2 = yesno(ans2);
							  if (valid2 == 0)
								dis_err_msg ("Please Enter Only [Y/N]");
							 }while(!valid2);

							if (toupper(ans2)=='Y')
							  {
								for(count=0; count<sizearr; count++)
								  {
									temp="";
									temp=bk[count].getID();
									match = strcmp(temp, lid2);
									if (match==1)
									 {
										bktemp[count2].setBook(bk[count].getID(),
																	  bk[count].getTitle(),
																	  bk[count].getAuthor(),
																	  bk[count].getType(),
																	  bk[count].getStatus(),
																	  bk[count].getPrice());
										count2++;
									 }
									else
									 {
									  bktemp[count2].setBook("x", "x", "x", "x", "x", "x");
									  count2++;
									 }
								  }
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Deleted...";
								*bk = *bktemp;
							  }
							else
							  {
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Not Deleted...";
							  }
							getch();
						  }
					  }; break;
	  }
	}while(choice!='3');
 };

//-----------------------------Function call_inv--------------------------------
void call_inv (Inventory *inv)
//Call inventory module and allow the user to execute the sub-modules.
 {
  char choice = '0';
  int valid = 0;
  do
	{
	 do
	  {
		clrscr();
		valid = 0;
		choice = inv_mainmenu();
		if ((choice>'3') || (choice<'1'))
		 valid = 0;
		else
		 valid = 1;
		if (valid==0)
		 {
		  valid = check_char(choice);
		  dis_err_msg ("Please Enter Number Range 1 to 3");
		 }
	  }while(!valid);
	 switch(choice)
	  {
		case '1' : {
						char* lid="";
						char* ltitle="";
						char* ltype="";
						char* lqty="";
						char  ans;
						int   valid1 = 0;
						static int invcount=0;
						Inventory temp;

						if (invcount==sizearr)
						 dis_err_msg ("Inventory File Is Full");
						else
						  {
							clrscr();
							cout<<"";
							gotoxy(10,4); cout<<"Add New Inventory";
							gotoxy(10,5); cout<<"~~~~~~~~~~~~~~~~~";
							gotoxy(10,7); cout<<"Inventory ID : ";
							gotoxy(10,8); cout<<"Inventory Title  : ";
							gotoxy(10,9); cout<<"Inventory Type   : ";
							gotoxy(10,10); cout<<"Quantity On Hand : ";
							do
							 {
							  gotoxy(25,7); clreol();
							  gotoxy(25,7); gets(lid);
							  valid1 = check_id(lid);
							  if (valid1 == 0)
								dis_err_msg ("Valid ID is [000000..999999]");
							 }while(!valid1);
							temp.setID(lid);
							valid1=0;
							do
							 {
							  gotoxy(29,8); clreol();
							  gotoxy(29,8); gets(ltitle);
							  valid1 = check_nta(ltitle);
							  if (valid1 == 0)
								dis_err_msg ("Valid Range of Characters is 20");
							 }while(!valid1);
							temp.setTitle(ltitle);
							gotoxy(10,14); cout<<"SEC - Sencondary   COL - College   UNI - University";
							gotoxy(29,9); gets(ltype);
							gotoxy(1,14); clreol();
							temp.setType(ltype);
							gotoxy(29,10); gets(lqty);
							temp.setQty(lqty);
							valid1=0;
							do
							 {
							  gotoxy(1,15); clreol();
							  gotoxy(10,15); cout<<"Save?[Y/N] : [ ]";
							  gotoxy(24,15); cin>>ans;
							  valid1 = yesno(ans);
							  if (valid1 == 0)
								dis_err_msg ("Please Enter Only [Y/N]");
							 }while(!valid1);

							if (toupper(ans)=='Y')
							  {
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Saved...";
								inv[invcount].setInventory(temp.getID(), temp.getTitle(),
																	temp.getType(), temp.getQty());
								invcount++;
							  }
							else
							  {
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Not Saved...";
							  }
							getch();
						  }
					  }; break;
		case '2' : {
						char* lid2="";
                  char* temp="";
						char  ans2;
						int   valid2 = 0;
						int   found = 0;
						int   count =0;
						int   count2=0;
						int   match=0;
						Inventory invtemp[sizearr];

						clrscr();
						cout<<"";
						gotoxy(10,4); cout<<"Delete Inventory";
						gotoxy(10,5); cout<<"~~~~~~~~~~~~~~~~";
						gotoxy(10,7); cout<<"Enter Inventory ID : ";
						gotoxy(10,8); cout<<"Inventory Title  : ";
						gotoxy(10,9); cout<<"Inventory Type   : ";
						gotoxy(10,10); cout<<"Quantity On Hand : ";
						do
						 {
						  gotoxy(31,7); clreol();
						  gotoxy(31,7); gets(lid2);
						  valid2 = check_id(lid2);
						  if (valid2 == 0)
							dis_err_msg ("Valid ID is [000000..999999]");
						 }while(!valid2);
						for (count=0; count<sizearr; count++)
						  {
							temp=inv[count].getID();
							match = strcmp(temp, lid2);
							if (match==0)
							  {
								gotoxy(29,8); cout<<inv[count].getTitle();
								gotoxy(29,9); cout<<inv[count].getType();
								gotoxy(29,10); cout<<inv[count].getQty();
								found = 1;
								break;
							  }
						  }
						if (found==0)
						 dis_err_msg ("Record NOT Found");
						else
						  {
							valid2=0;
							do
							 {
							  gotoxy(1,15); clreol();
							  gotoxy(10,15); cout<<"Delete?[Y/N] : [ ]";
							  gotoxy(26,15); cin>>ans2;
							  valid2 = yesno(ans2);
							  if (valid2 == 0)
								dis_err_msg ("Please Enter Only [Y/N]");
							 }while(!valid2);

							if (toupper(ans2)=='Y')
							  {
								for(count=0; count<sizearr; count++)
								  {
									temp="";
									temp=inv[count].getID();
									match = strcmp(temp, lid2);
									if (match==1)
									 {
										invtemp[count2].setInventory(inv[count].getID(),
																			  inv[count].getTitle(),
																			  inv[count].getType(),
																			  inv[count].getQty());
										count2++;
									 }
									else
									 {
									  invtemp[count2].setInventory("x", "x", "x", "x");
									  count2++;
									 }
								  }
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Deleted...";
								*inv = *invtemp;
							  }
							else
							  {
								gotoxy(1,15); clreol();
								gotoxy(10,15); cout<<"Record Not Deleted...";
							  }
							getch();
						  }
					  }; break;
	  }
	}while(choice!='3');
 };

//-----------------------------Function call_trans------------------------------
void call_trans (Member *mbr, Book *bk, Transaction *trans)
//Call transaction module and allow the user to execute the sub-modules.
 {
  char choice = '0';
  int valid = 0;
  do
	{
	 do
	  {
		clrscr();
		valid = 0;
		choice = trans_mainmenu();
		if ((choice>'3') || (choice<'1'))
		 valid = 0;
		else
		 valid = 1;
		if (valid==0)
		 {
		  valid = check_char(choice);
		  dis_err_msg ("Please Enter Number Range 1 to 3");
		 }
	  }while(!valid);
	 switch(choice)
	  {
		case '1' : {
						char* lmid="";
						char* temp1="";
						char* lbid="";
						char* temp2="";
						char* ldate="";
						char  ans;
						int   valid1 = 0;
						int   found=0;
						int   match=0;
						int   count=0;
						static int transcount=0;
						Transaction temp;

						if (transcount==sizearr)
						 dis_err_msg ("Transaction File Is Full");
						else
						  {
							clrscr();
							cout<<"";
							gotoxy(10,4); cout<<"Borrow Transaction";
							gotoxy(10,5); cout<<"~~~~~~~~~~~~~~~~~~";
							gotoxy(10,7); cout<<"Member ID   : ";
							gotoxy(10,8); cout<<"Member Name : ";
							gotoxy(10,9); cout<<"Book ID     : ";
							gotoxy(10,10); cout<<"Book Title  : ";
							gotoxy(10,11); cout<<"Due Date Issue : ";
							do
							 {
							  gotoxy(24,7); clreol();
							  gotoxy(24,7); gets(lmid);
							  valid1 = check_id(lmid);
							  if (valid1 == 0)
								dis_err_msg ("Valid ID is [000000..999999]");
							 }while(!valid1);
							temp.setMID(lmid);
							for (count=0; count<sizearr; count++)
							  {
								temp1=mbr[count].getID();
								match = strcmp(temp1, lmid);
								if (match==0)
								  {
									mbr[count].setStatus("1");
									gotoxy(24,8); cout<<mbr[count].getName();
									found = 1;
									break;
								  }
							  }
							if (found==0)
							 dis_err_msg ("Record NOT Found OR Member Cannot Borrow Book");
							else
							  {
								valid1=0;
								do
								 {
								  gotoxy(24,9); clreol();
								  gotoxy(24,9); gets(lbid);
								  valid1 = check_id(lbid);
								  if (valid1 == 0)
									dis_err_msg ("Valid ID is [000000..999999]");
								 }while(!valid1);
								temp.setBID(lbid);
								found = 0;
								for (count=0; count<sizearr; count++)
								  {
									temp2=bk[count].getID();
									match = strcmp(temp2, lbid);
									if (match==0)
									  {
										bk[count].setStatus("B");
										gotoxy(24,10); cout<<bk[count].getTitle();
										found = 1;
										break;
									  }
								  }
								if (found==0)
								 dis_err_msg ("Record NOT Found Or Book Is Been Borrowed");
								else
								  {
									valid1=0;
									gotoxy(27,11); gets(ldate);
									temp.setDate(ldate);

									gotoxy(1,15); clreol();
									gotoxy(10,15); cout<<"Transaction Saved...";
									trans[transcount].setTransaction(temp.getMID(),
																				temp.getBID(),
																				temp.getDate());
									transcount++;
									getch();
								  }
							  }
						  }
					  }; break;
		case '2' : {
						char* lmid2="";
						char* temp3="";
						char* lbid2="";
						char* temp4="";
						char  ans2;
						int   valid2 = 0;
						int   found1 =0;
						int   match1=0;
						int   match2=0;
						int   count1=0;
						int   count2=0;
						Transaction transtemp[sizearr];

						clrscr();
						cout<<"";
						gotoxy(10,4); cout<<"Return Transaction";
						gotoxy(10,5); cout<<"~~~~~~~~~~~~~~~~~~";
						gotoxy(10,7); cout<<"Member ID : ";
						gotoxy(10,8); cout<<"Book ID   : ";
						gotoxy(10,9); cout<<"Due Date  : ";
						gotoxy(10,10); cout<<"Current Date : ";
						do
						 {
						  gotoxy(22,7); clreol();
						  gotoxy(22,7); gets(lmid2);
						  valid2 = check_id(lmid2);
						  if (valid2 == 0)
							dis_err_msg ("Valid ID is [000000..999999]");
						 }while(!valid2);
						for (count1=0; count1<sizearr; count1++)
							{
							 match1=0;
							 temp3=trans[count1].getMID();
							 match1 = strcmp(temp3, lmid2);
							 if (match1==0)
								{
								 temp4=trans[count1].getBID();
								 gotoxy(22,8); cout<<trans[count1].getBID();
								 gotoxy(22,9); cout<<trans[count1].getDate()<<endl;
								 struct date d;
								 getdate(&d);
								 gotoxy(25,10); cout<<d.da_year<<"/"<<d.da_mon<<"/"<<d.da_day;
								 found1 = 1;
								 break;
								}
							}
						if (found1==0)
						 dis_err_msg ("Record NOT Found");
						else
						  {
							valid2=0;
							for (count1=0; count1<sizearr; count1++)
							  {
								match1=0;
								temp3=trans[count1].getMID();
								match1 = strcmp(temp3, lmid2);
								if (match1==0)
								  {
									for (count1=0; count1<sizearr; count1++)
									  {
										match1=0;
										match1 = strcmp(temp3, mbr[count1].getID());
										if (match1==0)
										  {
											mbr[count1].setStatus("0");
											break;
										  }
									  }
									for (count1=0; count1<sizearr; count1++)
									  {
										match1=0;
										match1 = strcmp(temp4, bk[count1].getID());
										if (match1==0)
										  {
											bk[count1].setStatus("A");
											break;
										  }
									  }
									transtemp[count2].setTransaction(trans[count1].getMID(),
																				trans[count1].getBID(),
																				trans[count1].getDate());
									count2++;
								  }
								else
								  {
									transtemp[count2].setTransaction("x", "x", "x");
									count2++;
								  }
							  }
							gotoxy(1,15); clreol();
							gotoxy(10,15); cout<<"Transaction Saved...";
							*trans = *transtemp;
							getch();
						  }
					  }; break;
	  }
	}while(choice!='3');
 };

//-----------------------------Function call_rep--------------------------------
void call_rep (Member *mbr, Book *bk, Inventory *inv, Transaction *trans)
//Call report module and allow the user to execute the sub-modules.
 {
  char choice = '0';
  int valid = 0;
  do
	{
	 do
	  {
		clrscr();
		valid = 0;
		choice = rep_mainmenu();
		if ((choice>'5') || (choice<'1'))
		 valid = 0;
		else
		 valid = 1;
		if (valid==0)
		 {
		  valid = check_char(choice);
		  dis_err_msg ("Please Enter Number Range 1 to 5");
		 }
	  }while(!valid);
	 switch(choice)
	  {
		case '1' : {
						int page=1;
						int counter=0;
						int stop=10;
						int y=6;

						clrscr();
						gotoxy(1,2); cout<<"Page : "<<page;
						gotoxy(30,2); cout<<"Membership Report"<<endl;
						cout<<"________________________________________________________________________________";
						cout<<"            Member ID  Name                            Age  Status"<<endl;
						cout<<"________________________________________________________________________________";

						for (counter=0, y=6; counter<sizearr; counter++, y++)
						  {
							gotoxy(13,y); cout<<mbr[counter].getID()<<endl;
							gotoxy(24,y); cout<<mbr[counter].getName()<<endl;
							gotoxy(56,y); cout<<mbr[counter].getAge()<<endl;
							gotoxy(61,y); cout<<mbr[counter].getStatus()<<endl;
							if (counter==stop)
							  {
								 gotoxy(27,20); cout<<"Press Any Key To Continue..";
								 getch();
								 clrscr();
								 page++;
								 gotoxy(1,2); cout<<"Page : "<<page;
								 gotoxy(30,2); cout<<"Membership Report"<<endl;
								 cout<<"________________________________________________________________________________";
								 cout<<"            Member ID  Name                            Age  Status"<<endl;
								 cout<<"________________________________________________________________________________";
								 y=5;
							  }
						  }
						getch();
					  }; break;
		case '2' : {
						int page1=1;
						int counter1=0;
						int stop1=10;
						int y1=6;

						clrscr();
						gotoxy(1,2); cout<<"Page : "<<page1;
						gotoxy(34,2); cout<<"Book Report"<<endl;
						cout<<"________________________________________________________________________________";
						cout<<" Book ID  Title                Author                Type  Status        Price"<<endl;
						cout<<"________________________________________________________________________________";

						for (counter1=0, y1=6; counter1<sizearr; counter1++, y1++)
						  {
							gotoxy(2,y1); cout<<bk[counter1].getID()<<endl;
							gotoxy(11,y1); cout<<bk[counter1].getTitle()<<endl;
							gotoxy(32,y1); cout<<bk[counter1].getAuthor()<<endl;
							gotoxy(54,y1); cout<<bk[counter1].getType()<<endl;
							gotoxy(60,y1); cout<<bk[counter1].getStatus()<<endl;
							gotoxy(74,y1); cout<<bk[counter1].getPrice()<<endl;
							if (counter1==stop1)
							  {
								 gotoxy(27,20); cout<<"Press Any Key To Continue..";
								 getch();
								 clrscr();
								 page1++;
								 gotoxy(1,2); cout<<"Page : "<<page1;
								 gotoxy(34,2); cout<<"Book Report"<<endl;
								 cout<<"________________________________________________________________________________";
								 cout<<" Book ID  Title                Author                Type  Status        Price"<<endl;
								 cout<<"________________________________________________________________________________";
								 y1=5;
							  }
						  }
						getch();
					  }; break;
		case '3' : {
						int page2=1;
						int counter2=0;
						int stop2=10;
						int y2=6;

						clrscr();
						gotoxy(1,2); cout<<"Page : "<<page2;
						gotoxy(32,2); cout<<"Inventory Report"<<endl;
						cout<<"________________________________________________________________________________";
						cout<<"     Inventory ID  Title                        Type     Quantity On Hand"<<endl;
						cout<<"________________________________________________________________________________";

						for (counter2=0, y2=6; counter2<sizearr; counter2++, y2++)
						  {
							gotoxy(6,y2); cout<<inv[counter2].getID()<<endl;
							gotoxy(20,y2); cout<<inv[counter2].getTitle()<<endl;
							gotoxy(49,y2); cout<<inv[counter2].getType()<<endl;
							gotoxy(58,y2); cout<<inv[counter2].getQty()<<endl;
							if (counter2==stop2)
							  {
								 gotoxy(27,20); cout<<"Press Any Key To Continue..";
								 getch();
								 clrscr();
								 page2++;
								 gotoxy(1,2); cout<<"Page : "<<page2;
								 gotoxy(32,2); cout<<"Inventory Report"<<endl;
								 cout<<"________________________________________________________________________________";
								 cout<<"     Inventory ID  Title                        Type     Quantity On Hand"<<endl;
								 cout<<"________________________________________________________________________________";
								 y2=5;
							  }
						  }
						getch();
					  }; break;
		case '4' : {
						int page3=1;
						int counter3=0;
						int stop3=10;
						int y3=6;

						clrscr();
						gotoxy(1,2); cout<<"Page : "<<page3;
						gotoxy(25,2); cout<<"Borrow Book Transaction Report"<<endl;
						cout<<"________________________________________________________________________________";
						cout<<"                        Member ID   Book ID    Due Date"<<endl;
						cout<<"________________________________________________________________________________";

						for (counter3=0, y3=6; counter3<sizearr; counter3++, y3++)
						  {
							gotoxy(25,y3); cout<<trans[counter3].getMID()<<endl;
							gotoxy(37,y3); cout<<trans[counter3].getBID()<<endl;
							gotoxy(48,y3); cout<<trans[counter3].getDate()<<endl;
							if (counter3==stop3)
							  {
								 gotoxy(27,20); cout<<"Press Any Key To Continue..";
								 getch();
								 clrscr();
								 page3++;
								 gotoxy(1,2); cout<<"Page : "<<page3;
								 gotoxy(25,2); cout<<"Borrow Book Transaction Report"<<endl;
								 cout<<"________________________________________________________________________________";
								 cout<<"                        Member ID   Book ID    Due Date"<<endl;
								 cout<<"________________________________________________________________________________";
								 y3=5;
							  }
						  }
						getch();
					  }; break;
	  }
	}while(choice!='5');
 };

//-------------------------------Function yesno---------------------------------
int yesno (char check)
//Check if character enter is only 'y', 'Y', 'n' or 'N'.
 {
  if ((toupper(check)=='Y') || (toupper(check)=='N'))
	return 1;
  else
	return 0;
 };

//-----------------------------Function check_id--------------------------------
int check_id (char* tempid)
//Check for the member, book and inventory id is entered correctly.
 {
  if ((strlen(tempid)==6))
	return 1;
  else
	 if ((tempid>"999999")||(tempid<"000001"))
	  return 0;
	 else
	  return 1;
 };

//-----------------------------Function check_nta-------------------------------
int check_nta (char* tempvar)
//Check if member name, book title and author, and inventory title is entered
//correctly.
 {
  if ((strlen(tempvar) > 20))
	 return 0;
  else
	 return 1;
 };

//-----------------------------Function storemember-----------------------------
void storemember (Member *mbrarray)
//Store the array of member objects into the file.
 {
  ofstream mbrFile("Member.txt");
  for (int counter=0; counter<sizearr; counter++)
	{
	 mbrFile<<mbrarray[counter].getID()<<'\n';
	 mbrFile<<mbrarray[counter].getName()<<'\n';
	 mbrFile<<mbrarray[counter].getAge()<<'\n';
	 mbrFile<<mbrarray[counter].getStatus()<<'\n';
	}
 };

//-----------------------------Function storebook-------------------------------
void storebook (Book *bkarray)
//Store the array of book objects into the file.
 {
  ofstream bkFile("Book.txt");
  for (int counter=0; counter<sizearr; counter++)
	{
	 bkFile<<bkarray[counter].getID()<<'\n';
	 bkFile<<bkarray[counter].getTitle()<<'\n';
	 bkFile<<bkarray[counter].getAuthor()<<'\n';
	 bkFile<<bkarray[counter].getType()<<'\n';
	 bkFile<<bkarray[counter].getStatus()<<'\n';
	 bkFile<<bkarray[counter].getPrice()<<'\n';
	}
 };

//------------------------------Function storeinv-------------------------------
void storeinv (Inventory *invarray)
//Store the array of inventory objects into the file.
 {
  ofstream invFile("Inventory.txt");
  for (int counter=0; counter<sizearr; counter++)
	{
	 invFile<<invarray[counter].getID()<<'\n';
	 invFile<<invarray[counter].getTitle()<<'\n';
	 invFile<<invarray[counter].getType()<<'\n';
	 invFile<<invarray[counter].getQty()<<'\n';
	}
 };

//-----------------------------Function storetrans------------------------------
void storetrans (Transaction *transarray)
//Store the array of transaction objects into the file.
 {
  ofstream transFile("Transaction.txt");
  for (int counter=0; counter<sizearr; counter++)
	{
	 transFile<<transarray[counter].getMID()<<'\n';
	 transFile<<transarray[counter].getBID()<<'\n';
	 transFile<<transarray[counter].getDate()<<'\n';
	}
 };

//---------------------------------Main Program---------------------------------
void main()
//Accept user's choice for the following modules available in the program.
 {
  Member      mbr[sizearr];
  Book        bk[sizearr];
  Inventory   inv[sizearr];
  Transaction trans[sizearr];

  retrievemember (mbr);
  retrievebook   (bk);
  retrieveinv    (inv);
  retrievetrans  (trans);

  char choice = '0';
  int valid = 0;
  do
	{
	 do
	  {
		clrscr();
		valid = 0;
		choice = mainmenu();
		if ((choice>'6') || (choice<'1'))
		 valid = 0;
		else
		 valid = 1;
		if (valid==0)
		 {
		  valid = check_char(choice);
		  dis_err_msg ("Please Enter Number Range 1 to 6");
		 }
	  }while(!valid);
	 switch(choice)
	  {
		case '1' : call_member(mbr); break;
		case '2' : call_book(bk); break;
		case '3' : call_inv(inv); break;
		case '4' : call_trans(mbr, bk, trans); break;
		case '5' : call_rep(mbr, bk, inv, trans); break;
	  }
	}while(choice!='6');

  storemember (mbr);
  storebook   (bk);
  storeinv    (inv);
  storetrans  (trans);

  clrscr();
  gotoxy(33,12); cout<<"END OF PROGRAM";
 }

//------------------------------------THE END-----------------------------------
