#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#define YES 1
#define NO 0
#define NAME_LEN 11
#define PHONE_LEN 9
#define MAIL_LEN 31

/* functions decleration*/
void enter_data(FILE *fp);/*ask user for input*/
void display_data(FILE *fp);/* diplay all the records*/
void search(FILE *fp);/*search for names in a record*/
void del(FILE *fp);/*function to delete the data*/
void change_fname(FILE *fp);/*change the First name in a record*/
void change_lname(FILE *fp);/*change the Last name in a record*/
void change_mail(FILE *fp);/* change the E-Mail in a record*/
void change_phone(FILE *fp);/* change the phone number in a record*/

/* validation functions*/
void check_name(char *string_check, int length_check);/*validate all name input*/
void check_mail(char *string_check, int length_check);/*validate all mail */
void check_phone(char *string_check, int length_check);/*validat all phone numbers*/

/*misc functions*/
int continue_function(void);/*for continuation*/
void new_gets(char *str, int len, char *fld);

/* structure declearation*/
struct profile
{
	char fname[NAME_LEN];/* First Name of Length 20*/
    char lname[NAME_LEN];/* Last Name of Length 20*/
    char mail[MAIL_LEN]; /* E-Mail Address of Length 30*/
	char phone[PHONE_LEN]; /*Phone Number of Length 8*/
	
}rec;


int main(void)
{
	
	int cont = YES;
	char ch, buf[20];
	FILE *fp;
	char field[6] ="Input";
	/* initial test to create file when program starts*/
	if( (fp = fopen("add.phn","a+")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	fclose(fp);
	/*close the file after test is positive*/
	
	while( cont == YES)
	{
		printf("\n");
		printf("\n\t                 [Address BOOK Menu]                   ");
		printf("\n\t+=====================================================+");
		printf("\n\t|[1]Enter Records       |[5]Change FIRST Name         |");
		printf("\n\t|-----------------------+-----------------------------|");
		printf("\n\t|[2]View Records        |[6]Change LAST Name          |");
		printf("\n\t|-----------------------+-----------------------------|");
		printf("\n\t|[3]Search Name         |[7]Change Email              |");
		printf("\n\t|-----------------------+-----------------------------|");
		printf("\n\t|[4]Delete Name         |[8]Change Phone Number       |");
		printf("\n\t|-----------------------------------------------------|");
		printf("\n\t|                     [9]QUIT                         |");
		printf("\n\t+=====================================================+\n");
		printf("\nEnter Selection From [1]-[9]: ");
		
		new_gets(buf,20,field);
		ch = *buf;
		
		switch( ch)
		{
		case '1' : enter_data(fp);
			break;
		case '2' : display_data(fp);
			break;
		case '3' : search(fp);
			break;
		case '4' : del(fp);
			break;
		case '5' : change_fname(fp);
			break;
		case '6' : change_lname(fp);
			break;
		case '7' : change_mail(fp);
			break;
		case '8' : change_phone(fp);
			break;
		case '9' :
			printf("\n\n\n%45s\n\n","---==< \\[ Thank You ]/ >==--");
			
			cont = NO;/* sets cont to NO and break from loop*/
			break;
		default  : printf("\n\tINVALID Choice!!! Please select from[1-9] \n");
			break;
		}
	}
	
	return 0;
}

/*************************************************************************
Function: enter_datal()
Purpose : To allow user to enter data and to be written to a file.
The input is passed to a validation function which is named
check_* where * is the approprite field to check for.

  Local Variables:
  FILE *fp		Decalres the file pointer
  int cont = YES  Sets the initial flag to YES so that the user will be
  able to make subsequent enteries immediately by calling
  the continue_function()
****************************************************************************/
void enter_data(FILE *fp)
{
	
	
	int cont = YES;/* used for the countinue() set it to YES initially */
	
	/* test File Open*/
	if( (fp = fopen("add.phn","a")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	while(cont == YES)/* repeat loop while user inoputs 'Yy' in the continue_function()*/
	{
		printf("\nEnter FIRST Name: ");
		check_name(rec.fname,NAME_LEN);
		
		printf("\nEnter LAST Name: ");
		check_name(rec.lname,NAME_LEN);
		
		printf("\nEnter EMAIL Address: ");
		check_mail(rec.mail,MAIL_LEN);
		
		printf("\nEnter PHONE Number: ");
		check_phone(rec.phone,PHONE_LEN);
		
		
		
		if(fwrite(&rec,1,sizeof(rec),fp) != sizeof(rec) )
		{
			fprintf(stderr,"Error writing to file\n");
			exit(1);
		}
		
		printf("\nDo you wish to [Add] Another Record?");
		cont = continue_function();/*call on countinue() so that use can inout another*/
		
	}
	
	fclose(fp);
}

/*************************************************************************
Function: display_datal()
Purpose : To Display all the records in the file in a formatted output.
The Data here is diplayed in a tabular form.

  Local Variables:
  FILE *fp		    Decalres file pointer
  int number_of_recs  Counts the number of records in the file
****************************************************************************/

void display_data(FILE *fp)
{
	int ctr = 0;
	
	/* test File Open*/
	if( (fp = fopen("add.phn","r+")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	/* Start of formatted print of the screen*/
	printf("\n%45s","Phone BOOK Report");
	printf("\n+=============================================================================+");
	printf("\n|%-4s|%-12s|%-12s|%-33s|%-12s|",
		"No.","FIRST Name","LAST Name","E-Mail Address","Phone NO.");
	printf("\n+-----------------------------------------------------------------------------+");
	
	
	/*read the first record form the file*/
	fread(&rec, 1, sizeof(rec),fp);
	while(!feof(fp)) /* read file until end of file has been reached*/
	{
		printf("\n|%-4d|%-12s|%-12s|%-33s|%-12s|",
			ctr+1,rec.fname, rec.lname, rec.mail, rec.phone);
		printf("\n|----+------------+------------+---------------------------------+------------|");
		
		ctr++;/* used as a counter to determin how many records are they in the file*/
		
		fread(&rec,1,sizeof(rec),fp);/* read next record*/
	}
	printf("\n|\t\t--== Total number of Records [%d] ==--%26s", ctr,"|");
	printf("\n+-----------------------------------------------------------------------------+");
	
	
	printf("\n%40s","End of Report");
	printf("\n%45s","- Press ENTER to continue -");
	getchar();
	
	/* END of formmted Out of Report to the user*/
	
	fclose(fp);
	
}

/*************************************************************************
Function: searchl()
Purpose : To Search for any record stored in a file that the user specifies

  Local Variables:
  FILE *fp			    Decalres file pointer
  char tmp_name[NAME_LEN] To hold the name to search for.
  The FIRST NAME is used as the key field to search for.
  int ctr = 0             Used as a counter to determine if name matches
  int cont                To prompt the user if he wants to search for another record
****************************************************************************/
void search(FILE *fp)
{
	
	char search_name[NAME_LEN];
	int ctr;
	int cont = YES;
	
	/*test file open*/
	if( (fp = fopen("add.phn","r")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	/* set initial flag to YES so that user can input field to search*/
	while(cont == YES)
	{
		if(fseek(fp,0,SEEK_SET) == 0)
		{
			ctr = 0;
			printf("Enter the [FIRST Name] to be found OR the [Person's Initials]: ");
			check_name(search_name,NAME_LEN);
			printf("\n+=============================================================================+");
			printf("\n|%-4s|%-12s|%-12s|%-33s|%-12s|",
				"No.","FIRST Name","LAST Name","E-Mail Address","Phone NO.");
			printf("\n+-----------------------------------------------------------------------------+");
			
			
			fread(&rec,1,sizeof(rec),fp);/* reads data from file*/
			while(!feof(fp))
			{
				if(strncmp( rec.fname,search_name,strlen(search_name) )== 0 )/* compares two strings*/
				{	/*if matched*/
					/* print the Report to the users screen*/
					
					printf("\n|%-4d|%-12s|%-12s|%-33s|%-12s|",
						ctr+1,rec.fname, rec.lname, rec.mail, rec.phone);
					printf("\n|----+------------+------------+---------------------------------+------------|");
					
					ctr++;/* used as a counter to determine if a record if actually found*/
				}
				fread(&rec,1,sizeof(rec),fp);/* reads the next record in the file*/
			}
			printf("\nThere are [%d] RECORDS of people names starting with [%s]",ctr,search_name);
			printf("\n%45s","- Press ENTER to continue -");
			getchar();
			if(ctr == 0)
			{/* If the counter is not incremented that means no file is found*/
				printf("\nYou Might want to Enter [%s] as a NEW records in Option[1]",search_name);
				
			}
			
			/* promt the user to seach for another and call the continue function to receive prompt*/
			printf("\n\nDo you want to Search for another RECORD?: ");
			
			cont = continue_function();
		}
	}
	fclose(fp);
}

/*************************************************************************
Function: del()
Purpose : To delete any record stored in a file that the user specifies

  Local Variables:
  FILE *fp,*temp:			 Decalre two file pointers
  char el_name[NAME_LEN]   To hold the name to delete.
  In this case the FIRST NAME is used as the key field
  int ctr = 0 :            Used as a counter to determine if name matches
  int reply :              Used to hold the reply to delete or not to delete
****************************************************************************/
void del(FILE *fp)
{
	
	FILE *temp;
	char del_name[NAME_LEN];
	int reply, ctr=0;
	
	/* test of both file can be opened*/
	if( (fp = fopen("add.phn","r")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	
	if( (temp = fopen("temp.$hn","w")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	
	printf("Enter the [First Name] of the Person's Record to DELETE: ");
	check_name(del_name,NAME_LEN);
	
	fread(&rec,1,sizeof(rec),fp);/* read first record*/
	while(!feof(fp))/* read until the end of file has been read*/
	{
		if( strncmp(rec.fname,del_name,strlen(del_name)) == 0)/* compare the delete name with name in record*/
		{/*if matched*/
			/*promt user to confirm deletion of the record*/
			printf("\nIs this the name that you want to  DELETE [%s %s]??: ",rec.fname,rec.lname);
			reply = continue_function();
			
			if(reply == NO)
			{/* if the user does want to delete write ORIGINAL name to record*/
				printf("\nRecord [%s] was NOT deleted ",rec.fname);
				fwrite(&rec,1,sizeof(rec),temp);
				
			}
			else/*if user decides not to delete*/
			{
				printf("\n[%s %s's] RECORD was Deleted!!!!:",rec.fname,rec.lname);
				
			}
			
			
			
			ctr++;/*counter will increase every time a name is found*/
		}
		
		else
		{/* if the user deletes write name the new name to file*/
			
			fwrite(&rec,1,sizeof(rec),temp);
		}
		fread(&rec,1,sizeof(rec),fp);
	}
	
	/* tells the user that no file in the record*/
	if (ctr == 0)
	{
		printf("\nName [%s] is NOT in the list.",del_name);
		printf("\nYou might want to View all Records in option[2] FIRST.");
	}
	
	fclose(fp);
	fclose(temp);/* close both files*/
	remove("add.phn");/* delete the whole file*/
	rename("temp.$hn","add.phn");/* rename the temporary file to the new file*/
}

/*************************************************************************
Function: change_fname()
Purpose : To change the First Name of a person  stored in a file

  Local Variables:
  FILE *fp,*temp:			 Decalre two file pointers
  char temp_name[NAME_LEN] To hold the temporary Name to search for
  char new_name[NAME_LEN]  Holds the new name that will be written
  int ctr = 0 :            Used as a counter to determine of name matches
  int reply :              Used to hold the reply to delete or not to delete
****************************************************************************/

void change_fname(FILE *fp)
{
	
	FILE *temp;
	char temp_name[NAME_LEN], new_name[NAME_LEN];
	int ctr = 0, reply;
	
	/* Test if file can be opened*/
	if( (fp = fopen("add.phn","r")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	if( (temp = fopen("temp.$hn","w")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	printf("\nPlease enter the [FIRST Name] that you want to CHANGE: ");
	check_name(temp_name,NAME_LEN);
	
	
	fread(&rec,1,sizeof(rec),fp);
	while(!feof(fp))
	{
		if( strncmp(rec.fname,temp_name,strlen(temp_name))  == 0)
		{/*if matched*/
			/*prompts user if this is the name that he wants to delete*/
			
			printf("\nDo you want to change [%s] %s FIRST name: ",rec.fname,rec.lname);
			reply = continue_function();
			if(reply == YES)
			{/* IF The aswer is yes then The user is promted for a NEW NAME*/
				printf("\nEnter the The New Name to change [%s]: ",rec.fname);
				check_name(new_name,NAME_LEN);
				/* Tell user that the name was deleted*/
				printf("\n%s FIRST name is now changed to [%s] %s", rec.fname, new_name,rec.lname);
				/*copy new name to old name and write to the temp file*/
				strcpy(rec.fname,new_name);
				fwrite(&rec,1,sizeof(rec),temp);
				
			}
			
			else
			{/* User anwer is NO ORIGINAL name is written to temporary file*/
				printf("\n[%s]'s %s FIRST NAME was NOT changed\n",rec.fname,rec.lname);
				fwrite(&rec,1,sizeof(rec),temp);
				
			}
			
			
			ctr++;/* Used as a counter to determine if records were found*/
		}
		else
		{/* if no file is found write Original data to Temporary File*/
			
			fwrite(&rec,1,sizeof(rec),temp);
		}
		
		fread(&rec,1,sizeof(rec),fp);/* reads the next record*/
	}
	
	/* if ctr if 0 means that No Record has is on the list*/
	/* promt user to Carry out the NEXT best Action*/
	if (ctr == 0)
	{
		printf("\nName [%s] NOT in the list",temp_name);
		printf("\nYou might want to View all Records in option[2] FIRST.");
		
	}
	
	fclose(fp);
	fclose(temp);/* close both files*/
	remove("add.phn");/* delete the ORIGINAL FILE*/
	rename("temp.$hn","add.phn");/* Rename Temporary file to ORIGINAL Filename*/
}

/*************************************************************************
Function: change_lname()
Purpose : To change the First Name of a person  stored in a file

  Local Variables:
  FILE *fp,*temp:			 Decalre two file pointers
  char temp_name[NAME_LEN] To hold the temporary Name to search for
  char new_name[NAME_LEN]  Holds the new name that will be written
  int ctr = 0 :            Used as a counter to determine of name matches
  int reply :              Used to hold the reply to delete or not to delete
****************************************************************************/

void change_lname(FILE *fp)
{
	
	FILE *temp;
	char temp_name[NAME_LEN], new_name[NAME_LEN];
	int ctr = 0;
	int reply;
	
	/* test if both the file can be opened*/
	if( (fp = fopen("add.phn","r")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	
	if( (temp = fopen("temp.$hn","w")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	printf("\nPlease enter the [LAST Name] that you want to CHANGE: ");
	check_name(temp_name,NAME_LEN);
	
	
	fread(&rec,1,sizeof(rec),fp);/* reads the first record*/
	while(!feof(fp))/* read until the End of file has been reached*/
	{
		if( strncmp(rec.lname,temp_name,strlen(temp_name))  == 0)
		{/*if matched*/
			/*prompts user if this is the name that he wants to delete*/
			printf("\nDo you want to CHANGE %s's LAST NAME  [%s]: ",rec.fname,rec.lname);
			reply = continue_function();
			
			if(reply == YES)
			{/* IF The aswer is yes then The user is promted for a NEW NAME*/
				printf("\nEnter the The New Name to change [%s]: ",rec.lname);
				check_name(new_name,NAME_LEN);
				/* Tell user that the name was deleted*/
				printf("\n%s is now changed to %s [%s]", rec.lname,rec.fname, new_name);
				/*copy new name to old name and write to the temp file*/
				strcpy(rec.lname,new_name);
				fwrite(&rec,1,sizeof(rec),temp);
			}
			
			else
			{/* User anwer is NO ORIGINAL name is written to temporary file*/
				printf("\n%s's Last Name [%s] was NOT Changed\n",rec.fname,rec.lname);
				fwrite(&rec,1,sizeof(rec),temp);
			}
			
			ctr++;/* used as a counter to determine if any record were found*/
		}
		
		else
		{/*No record were found write ORIGINAL data to temporary file*/
			fwrite(&rec,1,sizeof(rec),temp);
		}
		fread(&rec,1,sizeof(rec),fp);
		/*read the next record*/
	}
	
	
	/* if the counter ctr is not incremented tell user no name in record*/
	/* Tell the user the next course of action*/
	if (ctr == 0)
	{
		printf("\nName %s NOT in the list",temp_name);
		printf("\nYou might want to View all Records in option[2] FIRST.");
		
	}
	
	fclose(fp);
	fclose(temp);/*close both files*/
	remove("add.phn");/* delete old file*/
	rename("temp.$hn","add.phn");/* rename Temporary file to Original file name*/
}
/*************************************************************************
Function: change_mail()
Purpose : To change the First Name of a person  stored in a file

  Local Variables:
  FILE *fp,*temp:			 Decalres two file pointers
  char temp_mail[MAIL_LEN] To hold the temporary Name to search for
  char new_mail[MAIL_LEN]  Holds the new name that will be written
  int ctr = 0 :            Used as a counter to determine of name matches
  int reply :              Used to hold the reply to delete or not to delete
****************************************************************************/
void change_mail(FILE *fp)
{
	
	FILE *temp;
	char temp_mail[MAIL_LEN], new_mail[MAIL_LEN];
	int ctr = 0;
	int reply;
	char field[7]="E-Mail";
	/* test if file can open*/
	if( (fp = fopen("add.phn","r")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	
	if( (temp = fopen("temp.$hn","w")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	printf("\nPlease enter the [EMAIL Address] to CHANGE: ");
	/* Do not test the string for valid EMAIL ADDRESS
	* Only in this case is new_gets used instead of check_mail
	* Allows user to type in partial E-MAIL Adress*/
	new_gets(temp_mail,MAIL_LEN,field);
	
	fread(&rec,1,sizeof(rec),fp);/* reads the first record*/
	while(!feof(fp))/* read until the End of file has been reached*/
	{
		if( strncmp(rec.mail,temp_mail,strlen(temp_mail))  == 0)
		{/*if matched*/
			/*prompts user if this is the E-Mail Address that he wants to delete*/
			printf("\nDo you want to change %s's %s E-Mail Address [%s]: ",rec.fname,rec.lname,rec.mail);
			reply = continue_function();
			if(reply == YES)
			{/* IF The aswer is yes then The user is promted for a NEW E-Mail*/
				printf("\nEnter New E-Mail Address to replace[%s]: ",rec.mail);
				check_mail(new_mail,MAIL_LEN);
				/* Tell user that the name was deleted*/
				printf("\n%s's %s E-MAIL %s is changed to [%s]",rec.fname,rec.lname,rec.mail, new_mail);
				/*copy new name to old name and write to the temp file*/
				strcpy(rec.mail,new_mail);
				fwrite(&rec,1,sizeof(rec),temp);
			}
			
			else
			{/* User anwer is NO ORIGINAL name is written to temporary file*/
				printf("\n%s's E-Mail: [%s] was NOT deleted\n",rec.fname, rec.mail);
				fwrite(&rec,1,sizeof(rec),temp);
			}
			
			ctr++;/* used as a counter to determine if any record were found*/
		}
		
		else
		{	/*No record were found write ORIGINAL data to temporary file*/
			fwrite(&rec,1,sizeof(rec),temp);
		}
		fread(&rec,1,sizeof(rec),fp);	/*read the next record*/
	}
	
	/* if the counter ctr is not incremented tell user no name in record*/
	/* Advise User for the next best course of action*/
	if (ctr == 0)
	{
		printf("\nE-MAIL Address %s NOT in the list",temp_mail);
		printf("\nYou might want to View all Records in option[2] FIRST.");
	}
	fclose(fp);
	fclose(temp);/*close both files*/
	remove("add.phn");/* delete old file*/
	rename("temp.$hn","add.phn");/* rename Temporary file to Original file name*/
	
}

/*************************************************************************
Function: change_phone()
Purpose : To change the First Name of a person  stored in a file

  Local Variables:
  FILE *fp,*temp:			   Declare two file pointers
  char temp_phone[PHONE_LEN] To hold the temporary Phone number to search for
  char new_phone[PHONE_LEN]  Holds the NEW PHONE NUMBER that will be written
  int ctr = 0 :              Used as a counter to determine of name matches
  int reply :                Used to hold the reply to delete or not to delete
****************************************************************************/

void change_phone(FILE *fp)
{
	
	FILE *temp;
	char temp_phone[PHONE_LEN], new_phone[PHONE_LEN];
	int ctr = 0;
	int reply;
	
	if( (fp = fopen("add.phn","r")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	
	if( (temp = fopen("temp.$hn","w")) == NULL)
	{
		fprintf(stderr,"Error opening file\n");
		exit(1);
	}
	
	printf("\nPlease enter the [PHONE NUMBER] that you want to CHANGE: ");
	check_phone(temp_phone,PHONE_LEN);
	
	
	fread(&rec,1,sizeof(rec),fp);/* reads the first record*/
	while(!feof(fp))/* read until the End of file has been reached*/
	{
		if( strncmp(rec.phone,temp_phone,strlen(temp_phone))  == 0)
		{/*if matched*/
			/*prompts user if this is the phone number that he wants to delete*/
			printf("\nDo you want to change %s's Phone Number [%s]: ",rec.fname, rec.phone);
			reply = continue_function();
			if(reply == YES)
			{/* IF The aswer is yes then The user is promted for a NEW PHONE NO.*/
				printf("\nEnter the New Phone Number to replace:%s ",rec.phone);
				check_phone(new_phone,PHONE_LEN);
				/* Tell user that the name was deleted*/
				printf("\n%s Phone Number is changed form %s to [%s]", rec.fname,rec.phone,new_phone);
				/*copy new name to old name and write to the temp file*/
				strcpy(rec.phone,new_phone);
				fwrite(&rec,1,sizeof(rec),temp);
			}
			
			else
			{/* User anwer is NO ORIGINAL phone is written to temporary file*/
				printf("\n%s's Phone Number [%s] was NOT Changed\n",rec.fname, temp_phone);
				fwrite(&rec,1,sizeof(rec),temp);
			}
			
			ctr++;/* used as a counter to determine if any record were found*/
		}
		
		else
		{	/*No record were found write ORIGINAL data to temporary file*/
			fwrite(&rec,1,sizeof(rec),temp);
		}
		fread(&rec,1,sizeof(rec),fp);/*read the next record*/
		
	}
	
	
	/* if the counter ctr is not incremented tell user no name in record*/
	/* Advise the user the next best course of action*/
	if (ctr == 0)
	{
		printf("\nPHONE Number: %s NOT in the list",temp_phone);
		printf("\nYou might want to View all Records in option[2] FIRST.");
	}
	fclose(fp);
	fclose(temp);/*close both files*/
	remove("add.phn");/* delete old file*/
	rename("temp.$hn","add.phn");/* rename Temporary file to Original file name*/
}

int continue_function(void)
{
	char field[6] ="Input";
	char ch, buf[20];
	do{
		printf("\n[Y]es [N]no?: ");
		new_gets(buf,20,field);
		
		/*character at location buf[0] is copied to ch*/
		ch = *buf;
		
	}while( strchr( "NnYy", ch) == NULL);
	
	if(toupper(ch) == 'N' )
		return NO;
	
	else
		return YES;
}

/*************************************************************************
Function: check_name(char *string_check, int length_check)
Purpose : To validate the first and the last name that the user enters
It will attempt to tell the user what mistakes he has made
and then ask the user for another input.

  Local Variables:
  int i		 used to hold each character so as to verify that it is a valid alphabet
  and is used to adjust the case of the characters passed to it
  int wrong	 set wrong to true if the input are not valid alphabets
  int length	 Used to calculate the length of the string
  int ctr = 0; Used as a counter everytime the do..while loop get repeated
  prompt user for another input
****************************************************************************/
void check_name(char *string_check, int length_check)
{
	int i, wrong, length;
	char field[5] = "NAME";
	int ctr = 0;
	
	do{
		/* in the first loop do not execute this*/
		if(ctr != 0)
		{
			printf("\nPlease Enter [NAME] again: ");
		}
		/* pass to new_gets to remove trailing newline*/
		new_gets(string_check,length_check,field);
		
		
		/**************************** [ START ] verifing AlPAHBETS ******************/
		
		length = strlen(string_check);
		
		wrong = 0;/* set initial wrong to false*/
		
		/* check every character entered*/
		for (i = 0; i < length; i++)   /* <----------------  Using the length */
		{
			if ( !isalpha(string_check[i]) && strchr(string_check,' ') == NULL)
			{/* if a characters that are non-alphabets
			 * set wrong to true
				*/
				wrong = 1;
				printf("\nEnter ONLY aplhabets");
				break;
			}
		}
		
		/************************ [ END ] of verifying ALPHABETS *********************?
		
		  
		/************************** [START] Adjusting Case *******************/
		
		/* adjust the first character to Uppercase*/
		string_check[0] = toupper(string_check[0]);
		
		/*adjust the rest of the character to Lower Case*/
		for(i = 1; string_check[i] != '\0'; i++)
			string_check[i] = tolower(string_check[i]);
		
		/*************************** [ END ] Adjusting Case ***********************/
		
		
		
		ctr++;
	}while(wrong);
	
}

/*************************************************************************
Function: check_mail(char *string_check, int length_check)
Purpose : To validate  e-mail address that is passed  to this function.
It will attempt to tell the user what mistakes he has made
and  then ask the user for another input.

  Local Variables:
  int ctr = 0 Used as a counter everytime the do..while loop get repeated
  It will prompt the user if loops get repeated
****************************************************************************/
void check_mail(char *string_check, int length_check)
{
	
	int ctr = 0;
	char field[7] = "E-Mail";
	do{
		
		if(ctr != 0)
		{
			printf("\nPlease Enter [E-MAIL] again: ");
		}
		
		new_gets(string_check,length_check,field);
		
		ctr++;
	}while(strchr(string_check,'@.')== NULL && strchr(string_check,' ') == NULL);
	
}

/*************************************************************************
Function: check_phonel(char *string_check, int length_check)
Purpose : To validate  phone numbers  that is passed  to this function.
It will attempt to tell the user what mistakes he has made
and  then ask the user for another input.

  Local Variables:
  int i		  used to hold each character so as to verify that it is a valid number
  int wrong	  set wrong to true if the input are not valid numerals
  int length	  Used to calculate the length of the string
  int ctr = 0;  Used as a counter everytime the do..while loop get repeated
  prompt user for another input
****************************************************************************/
void check_phone(char *string_check, int length_check)
{
	int wrong ,length, i;
	int ctr = 0;
	char field[13] = "Phone Number";
	do{
		/*Will not execute if loop is not repeated*/
		if(ctr != 0)
		{
			printf("\nPlese Enter [Phone Number] Again: ");
		}
		new_gets(string_check,length_check,field);
		
		
		/*************** [ START ] CHECKING OF VALID NUMERALS ***********************/
		wrong = 0;  /* reset flag at top of loop */
		
		length = strlen(string_check);
		/* used to check if all digits are entered*/
		for (i = 0; i < length; i++)   /* <----------------  Using the length */
		{
			if ( !isdigit(string_check[i]) )
			{
				wrong = 1;
				printf("\nUse only NUMBERS ");
				break;
			}
			
		}
		/*********************** [ END ]OF NUMBER CHECK  ************************/
		
		
		
		ctr++;
		/* note: the checking for space here is not necessary
		* as the a [space] is not a valid numera thus an error will occur
		*/
	}while(wrong);
}


/*************************************************************************
Function: void new_gets(char *str, int len)
Purpose : Get rid of the trailing new_line character
It will empty the string if the maximum number of character have been
entered.
It will also clearn any string that is left inside the buffer

  Local Variables:
  int c        To get hold of extra characters that are still in the buffer
****************************************************************************/
void new_gets(char *str, int len, char *fld)
{
	int c;
	int ctr = 0;
	do
	{
		if(ctr != 0)
		{
			printf("\nPlease RE-ENTER [%s]: ",fld);
		}
		fgets(str,len+1,stdin);/* length is intentionally +1 so as to make room for and '\0'*/
		
		
		if (strchr(str, '\n') != NULL)
		{/* if \n is found*/
			
			str[strlen(str)-1] = 0;/* get rid of it*/
		}
		
		else /* the '\n' cannot be found because size to large */
		{/* The input was too large to fit. */
			/* Get Rid of extra characcters in the buffer. */
			while ((c = getchar()) != '\n' && c != EOF);
			
			/* Empty my_name, so that the loop will run* again.*/
			str[0] = '\0';
		}
		
		if(strchr(str,' ') != NULL)
		{
			printf("\nNo spaces between characters allowed");
		}
		
		
		if(strlen(str) == 0)
		{
			printf("\nPlease enter between [1-%d] Characters",len-1);
		}
		ctr++;
		
	}while( strlen(str) == 0 || strchr(str,' ') != NULL);
	
}
