unit fspl;
(*
 TFormatSpeller     
  
:  . 
Created 03.03.2000
http://move.to/ahasoft/
mailto:ahasoft@mail.ru
*)

interface
uses
 classes,sysutils,ivkernel;

type
 TFormatSpeller=class(TObject)
 private
  FlstMoney,FlstInt:TList;
  FssMoney,FssInt:TStringList;
  FssNumbers:TStringList;
  FMoneyNames,FIntNames:TStringList;
  FMoneyCaptions,FIntCaptions:TStringList;
  function PowerToStr(a:integer;ssNames:TStringList;idxFrom:integer;aSex:char):string;
  function NumberCase(a:integer):integer;
   {   0:for 1; 1 for 1..4; 2 for 0, 5..}
 public
  MoneySex:char;
  MoneySpell:boolean;
  CentSex:char;
  CentSpell:boolean;
  IntSex:char;
  IntSpell:boolean;
  LetterCase:char;//'C':Capital, 'L':lower, 'U':Upper, 'S':Sentence(first capital)
  constructor Create;
  destructor Destroy;override;
  procedure AssignDefault;
  procedure Clear;
//  procedure LoadFromFile(const FileName:TFileName);
  function CurrToText(const c:currency):string;
  function IntToText(a:integer):string;
  procedure SelectMoney(MoneyName:string);
  procedure SelectInt(IntName:string);
  procedure SelectMoneyIndex(Index:integer);
  procedure SelectIntIndex(Index:integer);
  property ssMoney:TStringList read FssMoney;
  property ssInt:TStringList read FssInt;
  property ssNumbers:TStringList read FssNumbers;
  property MoneyNames:TStringList read FMoneyNames;
  property MoneyCaptions:TStringList read FMoneyCaptions;
  property IntNames:TStringList read FIntNames;
  property IntCaptions:TStringList read FIntCaptions;
 end;

function CurrToStrP(const c:currency):string;{ currency    }
function StrToCurrP(s:string):currency;{          currency}
function FloatToStrP(c:extended):string;{ float    }
function StrToFloatP(s:string):extended;{          float}

implementation

const
 Number_Last=51;
 ss_Number:array[0..Number_Last]of string=
 ('','','','','','','','','','','','','',
 '','','','','','','','','','',
 '','','','','','','','',
 '','','','','','','','','',
 '','','',
 '','','',
 '','','',
 '','','');
 Money_LastC=9;
 Money_LastR=6;
 Money_PosName=0;
 Money_PosCaption=1;
 Money_PosMoneyProp=5;
 Money_PosCentProp=Money_LastC;
 ss_Money:array[0..Money_LastR,0..Money_LastC] of string=
 (('RUR','  .','','','','MS','.','.','.','FD'),
  ('RUR1','  ','','','','MS','','','','FD'),
  ('USD','  ','','','','MS','','','','MD'),
  ('DM','  ','','','','FS','','','','FD'),
  ('DEM','  ','','','','FS','','','','MD'),
  ('UE',' ',' ',' ',' ','FS','','','','MD'),
  ('EUR','  ','','','','NS','','','','MD'));
 s_minus='';
 Int_LastC=5;
 Int_LastR=10;
 Int_PosName=0;
 Int_PosCaption=1;
 Int_PosProp=Int_LastC;
 ss_Int:array[0..Int_LastR,0..Int_LastC] of string=
 (('PIECE','','','','','FS'),
  ('UNIT','','','','','FS'),
  ('POS','','','','','FS'),
  ('NAME','','','','','NS'),
  ('ITEM','','','','','MS'),
  ('VIEW','','','','','MS'),
  ('SORT','','','','','MS'),
  ('SIZE','','','','','MS'),
  ('EX','','','','','MS'),
  ('SUBJ','','','','','MS'),
  ('PACK','','','','','FS'));


function CurrToStrP(const c:currency):string;
{ currency    }
var
 i:integer;
begin
 Result:=currtostr(c);
 for i:=1 to length(Result) do begin
  if Result[i]=',' then begin
   Result[i]:='.';
   break;
  end;
 end;
end;

function StrToCurrP(s:string):currency;
{          currency}
var
 i:integer;
begin
 for i:=1 to length(s) do begin
  if s[i]in [',','.'] then begin
   s[i]:=decimalseparator;
   break;
  end;
 end;
 Result:=strtocurr(s);
end;

function FloatToStrP(c:extended):string;{ float    }
var
 i:integer;
begin
 Result:=floattostr(c);
 for i:=1 to length(Result) do begin
  if Result[i]=',' then begin
   Result[i]:='.';
   break;
  end;
 end;
end;

function StrToFloatP(s:string):extended;{          float}
var
 i:integer;
begin
 for i:=1 to length(s) do begin
  if s[i]in [',','.'] then begin
   s[i]:=decimalseparator;
   break;
  end;
 end;
 Result:=strtofloat(s);
end;

function StrAddSpaceStr(const sSource,sAdd:string):string;
begin
 if sSource<>'' then Result:=sSource+' '+sAdd
 else Result:=sAdd;
end;
{TFormatSpeller}
constructor TFormatSpeller.Create;
begin
 inherited Create;
 FlstMoney:=TList.Create;
 FlstInt:=TList.Create;
 FssNumbers:=TStringList.Create;
 FMoneyNames:=TStringList.Create;
 FMoneyCaptions:=TStringList.Create;
 FIntNames:=TStringList.Create;
 FIntCaptions:=TStringList.Create;
 AssignDefault;
end;

destructor TFormatSpeller.Destroy;
begin
 Clear;
 FlstMoney.Free;
 FlstInt.Free;
 FssNumbers.Free;
 FMoneyNames.Free;
 FMoneyCaptions.Free;
 FIntNames.Free;
 FIntCaptions.Free;
 inherited Destroy;
end;

procedure TFormatSpeller.Clear;
var
 i:integer;
 ss:TStringList;
begin
 for i:=FlstMoney.Count-1 downto 0 do begin
  ss:=FlstMoney[i];
  ss.Free;
 end;
 FlstMoney.Clear;
 for i:=FlstInt.Count-1 downto 0 do begin
  ss:=FlstInt[i];
  ss.Free;
 end;
 FlstInt.Clear;
 FssNumbers.Clear;
 FMoneyNames.Clear;
 FMoneyCaptions.Clear;
 FIntNames.Clear;
 FIntCaptions.Clear;
end;

procedure TFormatSpeller.AssignDefault;
var
 i,j:integer;
begin
 Clear;
 for i:=0 to Number_Last do FssNumbers.Add(ss_Number[i]);
 for i:=0 to Money_LastR do begin
  FssMoney:=TStringList.Create;
  for j:=0 to Money_LastC do FssMoney.Add(ss_Money[i,j]);
  FlstMoney.Add(FssMoney);
  MoneyNames.Add(FssMoney[0]);
  MoneyCaptions.Add(FssMoney[1]);
 end;
 for i:=0 to Int_LastR do begin
  FssInt:=TStringList.Create;
  for j:=0 to Int_LastC do FssInt.Add(ss_Int[i,j]);
  FlstInt.Add(FssInt);
  IntNames.Add(FssInt[0]);
  IntCaptions.Add(FssInt[1]);
 end;
 SelectMoneyIndex(0);
 SelectIntIndex(0);
 LetterCase:='S';
end;

procedure TFormatSpeller.SelectMoney(MoneyName:string);
begin
 SelectMoneyIndex(MoneyNames.IndexOf(MoneyName));
end;

procedure TFormatSpeller.SelectInt(IntName:string);
begin
 SelectIntIndex(IntNames.IndexOf(IntName));
end;

procedure TFormatSpeller.SelectMoneyIndex(Index:integer);
var
 s:string;
begin
 FssMoney:=FlstMoney[Index];
 s:=FssMoney[Money_PosMoneyProp];
 MoneySex:=s[1];
 MoneySpell:=s[2]='S';
 s:=FssMoney[Money_PosCentProp];
 CentSex:=s[1];
 CentSpell:=s[2]='S';
end;

procedure TFormatSpeller.SelectIntIndex(Index:integer);
var
 s:string;
begin
 FssInt:=FlstInt[Index];
 s:=FssInt[Int_PosProp];
 IntSex:=s[1];
 IntSpell:=s[2]='S';
end;

function TFormatSpeller.NumberCase(a:integer):integer;
{  
0:for 1; 1 for 1..4; 2 for 0, 5..}
var
 m:integer;
begin
 if ((a>=5)and(a<=20))then Result:=2 else begin
  m:=a mod 10;
  if (m>=2)and(m<=4)then Result:=1
  else if m=1 then Result:=0
  else Result:=2;
 end;
end;

function TFormatSpeller.PowerToStr(a:integer;ssNames:TStringList;idxFrom:integer;aSex:char):string;
var
 mh,md,me,idx:integer;
 idxPad:integer;
begin
 if a=0 then begin
  Result:=ssNumbers[0];
  idxPad:=2;
 end else begin
  mh:=a div 100;
  Result:='';
  if mh>=1 then Result:=ssNumbers[30+mh];
  mh:=a mod 100;
  md:=mh div 10;
  me:=mh mod 10;
  if (mh>=10)and(mh<=20)then begin
   Result:=StrAddSpaceStr(Result,ssNumbers[3+mh]);
   idxPad:=2;
  end else begin
   if md>=2 then Result:=StrAddSpaceStr(Result,ssNumbers[18+3+md]);
   if (me=1) then begin
    if asex='M' then idx:=1
    else if asex='F' then idx:=2
    else idx:=3;
    Result:=StrAddSpaceStr(Result,ssNumbers[idx]);
    idxPad:=0;
   end else if (me=2) then begin
    if asex='F' then idx:=5
    else idx:=4;
    Result:=StrAddSpaceStr(Result,ssNumbers[idx]);
    idxPad:=1;
   end else if (me>=3) then begin
    idx:=me-1+4;
    Result:=StrAddSpaceStr(Result,ssNumbers[idx]);
    if me>=5 then idxPad:=2
    else idxPad:=1;
   end else idxPad:=2;
  end;
 end;
 idx:=idxPad+idxFrom;
 if (ssNames<>nil)and(ssNames.Count>idx) then begin
  Result:=Result+' '+ssNames[idx];
 end;
end;

function TFormatSpeller.CurrToText(const c:currency):string;
var
 s:string;
 i,ipower:integer;
 scent,smain:string;
 cent,m:integer;
 idx:integer;
 sminus:string;
begin
 Result:='';
 s:=Formatcurr('0.00',c);
 scent:=copy(s,length(s)-1,2);
 smain:=copy(s,1,length(s)-3);
 if (smain[1]='-')and(MoneySpell) then begin
  sminus:=s_minus+' ';
  delete(smain,1,1);
 end else sminus:='';
 cent:=strtoint(scent);
 if CentSpell=false then begin
  idx:=NumberCase(cent)+6;
  Result:=scent+' '+ssMoney[idx];
 end else begin
  Result:=PowerToStr(cent,ssMoney,6,CentSex);
 end;
 if MoneySpell then begin
  if sMain='0' then Result:=PowerToStr(0,ssMoney,2,MoneySex)+' '+Result
  else begin
   s:='';
   ipower:=0;
   for i:=length(smain) downto 1 do begin
    s:=smain[i]+s;
    if (length(s)=3)or(i=1) then begin
     m:=strtoint(s);
     if m<>0 then begin
      case ipower of
      0:Result:=PowerToStr(m,ssMoney,2,MoneySex)+' '+Result;
      1:Result:=PowerToStr(m,ssNumbers,40,'F')+' '+Result;
      2:Result:=PowerToStr(m,ssNumbers,43,'M')+' '+Result;
      3:Result:=PowerToStr(m,ssNumbers,46,'M')+' '+Result;
      4:Result:=PowerToStr(m,ssNumbers,49,'M')+' '+Result;
      end;
     end else if (m=0)and(iPower=0)then Result:=ssMoney[4]+' '+Result;
     s:='';
     inc(ipower);
    end;
   end;
  end;
 end else begin
  s:='';
  for i:=length(smain) downto 1 do begin
   s:=smain[i]+s;
   if length(s)=3 then break;
  end;
  m:=strtoint(s);
  idx:=NumberCase(m)+2;
  Result:=formatcurr('0,',strtocurr(smain))+' '+ssMoney[idx]+' '+Result;
 end;
 Result:=sminus+Result;
 if LetterCase='L' then Result:=LowerCaseRus(result)
 else if LetterCase='S' then begin
  Result:=LowerCaseRus(Result);
  Result[1]:=UpCaseRus(Result[1])
 end else if LetterCase='C' then Result:=CapCaseRus(result)
 else if LetterCase='U' then Result:=UpperCaseRus(result)
end;

function TFormatSpeller.IntToText(a:integer):string;
var
 s:string;
 i,ipower:integer;
 smain:string;
 m:integer;
 idx:integer;
 sminus:string;
begin
 Result:='';
 smain:=inttostr(a);
 if (smain[1]='-')and(IntSpell) then begin
  sminus:=s_minus+' ';
  delete(smain,1,1);
 end else sminus:='';
 if IntSpell then begin
  if sMain='0' then Result:=PowerToStr(0,ssInt,2,IntSex)+' '+Result
  else begin
   s:='';
   ipower:=0;
   for i:=length(smain) downto 1 do begin
    s:=smain[i]+s;
    if (length(s)=3)or(i=1) then begin
     m:=strtoint(s);
     if m<>0 then begin
      case ipower of
      0:Result:=PowerToStr(m,ssInt,2,IntSex)+' '+Result;
      1:Result:=PowerToStr(m,ssNumbers,40,'F')+' '+Result;
      2:Result:=PowerToStr(m,ssNumbers,43,'M')+' '+Result;
      3:Result:=PowerToStr(m,ssNumbers,46,'M')+' '+Result;
      4:Result:=PowerToStr(m,ssNumbers,49,'M')+' '+Result;
      end;
     end else if (m=0)and(iPower=0)then Result:=ssInt[4]+' '+Result;
     s:='';
     inc(ipower);
    end;
   end;
  end;
 end else begin
  s:='';
  for i:=length(smain) downto 1 do begin
   s:=smain[i]+s;
   if length(s)=3 then break;
  end;
  m:=strtoint(s);
  idx:=NumberCase(m)+2;
  Result:=formatcurr('0,',a)+' '+ssInt[idx]+' '+Result;
 end;
 Result:=sminus+Result;
 if LetterCase='L' then Result:=LowerCaseRus(result)
 else if LetterCase='S' then begin
  Result:=LowerCaseRus(Result);
  Result[1]:=UpCaseRus(Result[1])
 end else if LetterCase='C' then Result:=CapCaseRus(result)
 else if LetterCase='U' then Result:=UpperCaseRus(result)
end;

end.
