unit ivkernel;
{
(c) 1999 Victor P. Ivlichev
Kernel Library
it's Freeware
If you find bugs, has ideas for missing featurs, feel free to contact me
   ivlich@mail.ru
The latest version can be found at:
  http://www.fortunecity.com/skyscraper/pixel/1000/delphi.htm
Last Update 27 Oct 1999  
}
interface
uses
 windows,sysutils;

const
 Deg_To_Rad:extended=pi/180;
 Rad_To_Deg:extended=180/pi;
 sin_45:extended=0.7071067811865;
 Bits_Per_Int=SizeOf(Integer)*8;
type
 PLongintArray=^TLongintArray;
 TLongintArray = array[0..(Maxint div 16) - 1] of Longint;

{bit utils}
procedure SetBit(var Data:longint;nPos:integer);{ =1  }
procedure ResetBit(var Data:longint;nPos:integer);{ =0  }
procedure InvertBit(var Data:longint;nPos:integer);{   }
procedure PutBit(var Data:longint;nPos:integer;Value:boolean);{ =Value  }
function TestBit(const Data:longint;nPos:integer):boolean;{  }
procedure ResetBits(var Data:longint;Mask:longint);{ =0}
procedure PutBits(var Data:longint;Mask:longint;Value:boolean);{ =Value}
function TestBits(const Data:longint;Mask:longint):boolean;{Result:=((Mask and Data)=Mask);}

{byte utils}
procedure RotateBytes(PBuffer:Pointer;size:integer;NToRight:integer);
procedure ReverseBytes(p:PByteArray;idxLast:integer);
 {  }
procedure ReverseLongs(p:PLongintArray;idxLast:integer);
 {  longint}
procedure ReverseWords(p:PWordArray;idxLast:integer);
 {  word}
procedure ReverseTriples(p:PByteArray;idxLast:integer);
 {   }

{string utils}
function UpperCaseRus(const S: string): string;
function LowerCaseRus(const S: string): string;
function CapCaseRus(const S: string): string;
function InvertCaseRus(const S: string): string;
function UpCaseRus( ch : Char ) : Char;
function LoCaseRus( ch : Char ) : Char;
function InvCaseRus( ch : Char ) : Char;
function whatCaseRusCh(ch:char):byte;
 {return case of character 0:not letter 1:locase; 2:upcase}
function whatCaseRus(s_word:string):byte;
 {return case of characters in word 0:different,1:locase,2:upcase,3:capcase}
function ReplaceStr(const S, Srch, Replace: string): string;
{(c)RX: Returns string with every occurrence of Srch string replaced with
  Replace string. }
function Growstr(s:string;maxlen:integer):string;
function BinaryToStr(PBuffer:Pointer;size:integer;Delimiter:char):string;
function StrToBinary(Data:string;PBuffer:Pointer;MaxSize:integer;Delimiter:char):integer;//return size
function StrToPoint(const s:string):TPoint;
 {     ,   }
function PointToStr(const pt:TPoint):string;
 {   -23;56}
function StrToRect(const s:string):TRect;
 {    4 ,   }
function RectToStr(const R:TRect):string;
 {   2,2,40,30}
function RotateStr(const s:string;NToRight:integer):string;
function DoValidName(s:string;Flags:longint):string;{     }
 {1:allow English Letters; 2:allow Rus Letters; 4:allow digits; 8:allow digits in first pos;
  16:replace other to _}
procedure AddStrToFile(S:string;const FileName:string;doNextLine:boolean);{doNextLine -  }

{calc utils}
function SignInt(const Value: Integer): SmallInt;
function Between(A1,A2,Value:integer):boolean;
 {  Value  A1  A2 , A1        A2 }
function BetweenExt(const A1,A2,Value:extended):boolean;
 {  Value  A1  A2 , A1        A2 }
procedure ExchangeInt(var a1,a2:integer);{}
procedure ExchangeWord(var a1,a2:word);{}
procedure ExchangeByte(var a1,a2:byte);{}
procedure ExchangeFloat(var a1,a2:extended);{}
procedure ExchangeDateTime(var a1,a2:TdateTime);{}
function intPower10(L:integer):integer;{result=(10   L)}
function MaxInteger(a1,a2:integer):integer;
function MinInteger(a1,a2:integer):integer;
function MaxFloat(a1,a2:extended):extended;
function MinFloat(a1,a2:extended):extended;
function InIntegers(Value:integer;const Data: array of Integer):boolean;//   

{File string Utils}
function NormalPath(const DirName: string): string;//obsolet to DirToPath 
function DirToPath(const DirName: string): string;
 {  ,   '\'}
function PathToDir(const DirName: string): string;
 {    '\'   }
function ExtractFileRoot(FileName:string):string;
 {     /,
        }
function DoValidFileName(const s:string):string;{     }
function ChangeEmptyFileExt(const FileName,Ext:string):string;
 {   ,      }

{system utils}
function GetExePath:string;
function GetTempPath:string;
function GetWindowsPath: string;
function GetSystemPath: string;
function GetFileSize(const FileName: string): Longint;
function DriveByteToRoot(Drive:byte):string;
function DriveByteExists(Drive:byte):boolean;
function GetDriveTypeOf(FileorPath:string):integer;
function GetUserName:string;
function GetComputerName:string;
function IsDelphiRun:boolean;{  Delphi}

{geometry utils}
function isPointInRect(const Point:TPoint;const Rect:TRect):boolean;
function isRectInRect(const ALeft,ATop,ARight,ABottom,subLeft,subTop,subRight,subBottom:integer):boolean;
 {   sub   A }
function isPtInEllipse(const x,y:integer;const ALeft,ATop,ARight,ABottom:integer):boolean;
function isRectCrossRect(const ALeft,ATop,ARight,ABottom,subLeft,subTop,subRight,subBottom:integer):boolean;
 {   sub  A }
function StdRectangle(R:Trect):Trect;
 {     left<=right,top<=bottom}
function BoundRects(const Rect1,rect2:Trect):Trect;
 {,    }
function StdRect(var Left,Top,Right,Bottom:integer):TRect{  
   left<=right,top<=bottom};
function ScaleRect(R:TRect;Scale:double):TRect;//   

implementation

{bit utils}
procedure SetBit(var Data:longint;nPos:integer);{ =1  }
var
 Mask:longint;
begin
 Mask:=1;
 Mask:=Mask shl nPos;
 Data:=Data or Mask;
end;

procedure ResetBit(var Data:longint;nPos:integer);{ =0  }
var
 Mask:longint;
begin
 Mask:=1;
 Mask:=Mask shl nPos;
 Mask:=not Mask;
 Data:=Data and Mask;
end;

procedure InvertBit(var Data:longint;nPos:integer);{   }
var
 Mask:longint;
begin
 Mask:=1;
 Mask:=Mask shl nPos;
 Data:=Data xor Mask;
end;

procedure PutBit(var Data:longint;nPos:integer;Value:boolean);{ =Value  }
var
 Mask:longint;
begin
 Mask:=1;
 Mask:=Mask shl nPos;
 if Value=true then Data:=Data or Mask
 else begin
  Mask:=not Mask;
  Data:=Data and Mask;
 end;
end;

function TestBit(const Data:longint;nPos:integer):boolean;{  }
var
 Mask:longint;
begin
 Mask:=1;
 Mask:=Mask shl nPos;
 if (Mask and Data)=Mask then Result:=true else Result:=false;
end;

procedure ResetBits(var Data:longint;Mask:longint);{ =0}
begin
 Mask:=not Mask;
 Data:=Data and Mask;
end;

procedure PutBits(var Data:longint;Mask:longint;Value:boolean);{ =Value}
begin
 if Value=true then Data:=Data or Mask
 else begin
  Mask:=not Mask;
  Data:=Data and Mask;
 end;
end;

function TestBits(const Data:longint;Mask:longint):boolean;{Result:=((Mask and Data)=Mask);}
begin
 Result:=((Mask and Data)=Mask);
// if (Mask and Data)=Mask then Result:=true else Result:=false;
end;

{byte utils}
procedure RotateBytes(PBuffer:Pointer;size:integer;NToRight:integer);
var
 i,j,last:integer;
 b:byte;
begin
 if Size<2 then exit;
 last:=size-1;
 if NToRight>0 then begin
  for i:=1 to NToRight do begin
   b:=PByteArray(PBuffer)^[last];
   for j:=last downto 1 do begin
    PByteArray(PBuffer)^[j]:=PByteArray(PBuffer)^[j-1];
   end;
   PByteArray(PBuffer)^[0]:=b;
  end;
 end else begin
  for i:=-1 downto NToRight do begin
   b:=PByteArray(PBuffer)^[0];
   for j:=1 to last do begin
    PByteArray(PBuffer)^[j-1]:=PByteArray(PBuffer)^[j];
   end;
   PByteArray(PBuffer)^[last]:=b;
  end;
 end;
end;

procedure ReverseBytes(p:PByteArray;idxLast:integer);
{  }
var
 i,iopp:integer;
 b:byte;
begin
 for i:=0 to (idxLast div 2) do begin
  iopp:=idxLast-i;
  b:=p[iopp];
  p[iopp]:=p[i];
  p[i]:=b;
 end;
end;

procedure ReverseLongs(p:PLongintArray;idxLast:integer);
{  longint}
var
 i,iopp:integer;
 li:longint;
begin
 for i:=0 to (idxLast div 2) do begin
  iopp:=idxLast-i;
  li:=p[iopp];
  p[iopp]:=p[i];
  p[i]:=li;
 end;
end;

procedure ReverseWords(p:PWordArray;idxLast:integer);
{  word}
var
 i,iopp:integer;
 w:word;
begin
 for i:=0 to (idxLast div 2) do begin
  iopp:=idxLast-i;
  w:=p[iopp];
  p[iopp]:=p[i];
  p[i]:=w;
 end;
end;

procedure ReverseTriples(p:PByteArray;idxLast:integer);
{   }
var
 i,iopp,i3:integer;
 li:longint;
begin
 for i:=0 to (idxLast div 2) do begin
  i3:=i*3;
  iopp:=(idxLast-i)*3;
  move(p^[i3],li,3);
  move(p^[iopp],p^[i3],3);
  move(li,p^[iopp],3);
 end;
end;


{string utils}
function UpperCaseRus(const S: string): string;
var
  Ch: Char;
  L: Integer;
  Source, Dest: PChar;
begin
  L := Length(S);
  SetLength(Result, L);
  Source := Pointer(S);
  Dest := Pointer(Result);
  while L <> 0 do
  begin
    Ch := Source^;
    if (Ch >= 'a') and (Ch <= 'z') then Dec(Ch, 32)
    else if (Ch>='')and (Ch<='') then Dec(Ch,32)
    else if Ch='' then Ch:='';
    Dest^ := Ch;
    Inc(Source);
    Inc(Dest);
    Dec(L);
  end;
end;

function LowerCaseRus(const S: string): string;
var
  Ch: Char;
  L: Integer;
  Source, Dest: PChar;
begin
  L := Length(S);
  SetLength(Result, L);
  Source := Pointer(S);
  Dest := Pointer(Result);
  while L <> 0 do
  begin
    Ch := Source^;
    if (Ch >= 'A') and (Ch <= 'Z') then Inc(Ch, 32)
    else if (Ch>='')and (Ch<='') then Inc(Ch,32)
    else if Ch='' then Ch:='';
    Dest^ := Ch;
    Inc(Source);
    Inc(Dest);
    Dec(L);
  end;
end;

function CapCaseRus(const S: string): string;
var
 startword:boolean;
 i:integer;
begin
 startword:=true;
 Result:=s;
 for i:=1 to length(Result) do begin
  if startword then Result[i]:=UpCaseRus(Result[i])
  else Result[i]:=LoCaseRus(Result[i]);
  startword:=Result[i] in [' ','.',',',';',':','?','!','-'];
 end;
end;

function InvertCaseRus(const S: string): string;
var
 i:integer;
begin
 Result:=s;
 for i:=1 to length(s) do begin
  result[i]:=invCaseRus(Result[i]);
 end;
end;

function UpCaseRus( ch : Char ) : Char;
asm
{ ->    AL      Character       }
{ <-    AL      Result          }

        CMP     AL,'a'
        JB      @@exit
        CMP     AL,'z'
        JA      @@Rus
        SUB     AL,'a' - 'A'
        RET
@@Rus:
        CMP     AL,''
        JA      @@Exit
        CMP     AL,''
        JB      @@yo
        SUB     AL,'' - ''
        RET
@@yo:
        CMP     AL,''
        JNE      @@exit
        MOV     AL,''
@@exit:
end;

function LoCaseRus( ch : Char ) : Char;
asm
{ ->    AL      Character       }
{ <-    AL      Result          }

        CMP     AL,'A'
        JB      @@exit
        CMP     AL,'Z'
        JA      @@Rus
        ADD     AL,'a' - 'A'
        RET
@@Rus:
        CMP     AL,''
        JA      @@Exit
        CMP     AL,''
        JB      @@yo
        ADD     AL,'' - ''
        RET
@@yo:
        CMP     AL,''
        JNE      @@exit
        MOV     AL,''
@@exit:
end;

function InvCaseRus( ch : Char ) : Char;
asm
{ ->    AL      Character       }
{ <-    AL      Result          }

        CMP     AL,'A'
        JB      @@up
        CMP     AL,'Z'
        JA      @@Rus
        ADD     AL,'a' - 'A'
        RET
@@Rus:
        CMP     AL,''
        JA      @@up
        CMP     AL,''
        JB      @@yo
        ADD     AL,'' - ''
        RET
@@yo:
        CMP     AL,''
        JNE      @@up
        MOV     AL,''
@@up:
        CMP     AL,'a'
        JB      @@exit
        CMP     AL,'z'
        JA      @@upRus
        SUB     AL,'a' - 'A'
        RET
@@upRus:
        CMP     AL,''
        JA      @@Exit
        CMP     AL,''
        JB      @@upyo
        SUB     AL,'' - ''
        RET
@@upyo:
        CMP     AL,''
        JNE      @@exit
        MOV     AL,''
@@exit:
end;


function whatCaseRusCh(ch:char):byte;
 {return case of character 0:not letter 1:locase; 2:upcase}
asm
{ ->    AL      Character       }
{ <-    AL      Result          }
{CHECK UP LAT}
        CMP     AL,'A'
        JB      @@lo_lat
        CMP     AL,'Z'
        JA      @@lo_lat
        MOV     AL,2
        RET
@@lo_lat:
        CMP     AL,'a'
        JB      @@up_rus
        CMP     AL,'z'
        JA      @@up_rus
        MOV     AL,1
        RET
@@up_Rus:
        CMP     AL,''
        JA      @@up_yo
        CMP     AL,''
        JB      @@up_yo
        MOV     AL,2
        RET
@@up_yo:
        CMP     AL,''
        JNE      @@lo_Rus
        MOV     AL,2
        RET
@@lo_Rus:
        CMP     AL,''
        JA      @@lo_yo
        CMP     AL,''
        JB      @@lo_yo
        MOV     AL,1
        RET
@@lo_yo:
        CMP     AL,''
        JNE      @@not_letter
        MOV     AL,1
        RET
@@not_letter:
        MOV     AL,0
end;

function whatCaseRus(s_word:string):byte;
 {return case of caharacters in word 0:different,1:locase,2:upcase,3:capcase}
var
 i:integer;
 case1:byte;
{ nonletters,}locases,upcases:integer;
begin
 if s_word='' then begin
  result:=0;
  exit;
 end;
 case1:=whatCaseRusCh(s_word[1]);
 if length(s_word)=1 then begin
  Result:=case1;
  exit;
 end;
// nonletters:=0;
 locases:=0;
 upcases:=0;
 for i:=2 to length(s_word) do begin
  case whatCaseRusCh(s_word[i]) of
//  0:inc(nonletters);
  1:inc(locases);
  2:inc(upcases);
  end;
 end;
 if locases=0 then Result:=2
 else if upcases=0 then Result:=1
 else Result:=0;
 if (Result=1)and (case1=2) then Result:=3
 else if (Result=2)and (case1=1) then Result:=0;
end;

function ReplaceStr(const S, Srch, Replace: string): string;
var
  I: Integer;
  Source: string;
begin
  Source := S;
  Result := '';
  repeat
    I := Pos(Srch, Source);
    if I > 0 then begin
      Result := Result + Copy(Source, 1, I - 1) + Replace;
      Source := Copy(Source, I + Length(Srch), MaxInt);
    end
    else Result := Result + Source;
  until I <= 0;
end;

function Growstr(s:string;maxlen:integer):string;
var
 i:integer;
begin
 result:=s;
 for i:=length(s)+1 to maxlen do Result:=Result+' ';
end;

function BinaryToStr(PBuffer:Pointer;size:integer;Delimiter:char):string;
var
 s:string;
 i:integer;
begin
 result:='';
 for i:=0 to Size-1 do begin
  s:=inttohex((PByteArray(PBuffer))^[i],2);
  if (Delimiter<>#0) then s:=s+Delimiter;
  Result:=Result+s;
 end;
 if (Result<>'')and(Delimiter<>#0)then setlength(Result,length(Result)-1);
end;

function StrToBinary(Data:string;PBuffer:Pointer;MaxSize:integer;Delimiter:char):integer;//return size
const
 h_prefix='$';
var
 l,p:integer;
 s:string;
begin
 l:=length(Data);
 p:=1;
 Result:=0;
 if Delimiter=#0 then begin
  while p<=l do begin
   s:=h_prefix+copy(Data,p,2);
   PByteArray(PBuffer)^[Result]:=strtoint(s);
   inc(p,2);
   inc(Result);
   if Result>MaxSize then break;
  end;
 end else begin
  s:='';
  for p:=1 to l do begin
   if (Data[p]=Delimiter)or(p=l)then begin
    PByteArray(PBuffer)^[Result]:=strtoint(s);
    s:=h_prefix+'0';
    inc(Result);
    if Result>MaxSize then break;
   end else s:=s+Data[p];
  end;
 end;
end;

function StrToPoint(const s:string):TPoint;
 {     ,   }
const
 digsgn='0123456789+-';
var
 i,l:integer;
 sx,sy:string;
begin
 sx:='';
 sy:='';
 i:=1;
 l:=length(s);
 while i<=l do begin //  1- 
  if pos(s[i],digsgn)>0 then break;
  inc(i);
 end;
 while i<=l do begin // 1- 
  if pos(s[i],digsgn)>0 then begin
   sx:=sx+s[i];
  end else break;
  inc(i);
 end;
 while i<=l do begin //  2- 
  if pos(s[i],digsgn)>0 then break;
  inc(i);
 end;
 while i<=l do begin  // 2- 
  if pos(s[i],digsgn)>0 then begin
   sy:=sy+s[i];
  end else break;
  inc(i);
 end;
 Result.x:=strtoint(sx);
 Result.y:=strtoint(sy);
end;

function PointToStr(const pt:TPoint):string;
begin
 Result:=inttostr(pt.x)+';'+inttostr(pt.y);
end;

function StrToRect(const s:string):TRect;
 {    4 ,   }
const
 digsgn='0123456789+-';
var
 i,l:integer;
 sleft,stop,sright,sbottom:string;
begin
 sleft:='';
 stop:='';
 sright:='';
 sbottom:='';
 i:=1;
 l:=length(s);
 while i<=l do begin //  1- 
  if pos(s[i],digsgn)>0 then break;
  inc(i);
 end;
 while i<=l do begin // 1- 
  if pos(s[i],digsgn)>0 then begin
   sleft:=sleft+s[i];
  end else break;
  inc(i);
 end;
 while i<=l do begin //  2- 
  if pos(s[i],digsgn)>0 then break;
  inc(i);
 end;
 while i<=l do begin  // 2- 
  if pos(s[i],digsgn)>0 then begin
   stop:=stop+s[i];
  end else break;
  inc(i);
 end;
 while i<=l do begin //  3- 
  if pos(s[i],digsgn)>0 then break;
  inc(i);
 end;
 while i<=l do begin  // 3- 
  if pos(s[i],digsgn)>0 then begin
   sright:=sright+s[i];
  end else break;
  inc(i);
 end;
 while i<=l do begin //  4- 
  if pos(s[i],digsgn)>0 then break;
  inc(i);
 end;
 while i<=l do begin  // 4- 
  if pos(s[i],digsgn)>0 then begin
   sbottom:=sbottom+s[i];
  end else break;
  inc(i);
 end;
 Result.Left:=strtoint(sLeft);
 Result.Top:=strtoint(sTop);
 Result.Right:=strtoint(sRight);
 Result.Bottom:=strtoint(sBottom);
end;

function RectToStr(const R:TRect):string;
begin
 Result:=inttostr(R.Left)+';'+inttostr(R.Top)+';'+inttostr(R.Right)+';'+inttostr(R.Bottom);
end;

function RotateStr(const s:string;NToRight:integer):string;
var
 i,l:integer;
 ch:char;
begin
 Result:=s;
 l:=length(Result);
 if l<2 then exit;
 if NToRight>0 then begin
  for i:=1 to NToRight do begin
   ch:=Result[l];
   Result:=ch+copy(Result,1,l-1);
  end;
 end else begin
  for i:=-1 downto NToRight do begin
   ch:=Result[1];
   delete(Result,1,1);
   Result:=Result+ch;
  end;
 end;
end;

function DoValidName(s:string;Flags:longint):string;{     }
 {1:allow English Letters; 2:allow Rus Letters; 4:allow digits; 8:allow digits in first pos;
  16:replace other to _}
var
 i:integer;
 ch:char;
begin
 Result:='';
 for i:=1 to length(s) do begin
  ch:=s[i];
  if ((flags and 1)=1)and (ch in['a'..'z','A'..'Z']) then result:=Result+ch
  else if ((flags and 2)=2)and (ch in[''..'',''..'','','']) then result:=Result+ch
  else if ((flags and 4)=4)and (ch in['0'..'9']) then begin
   if ((flags and 8)=8)or(length(s)>0)
   then Result:=Result+ch;
  end else if ((flags and 16)=16) then Result:=Result+'_';
 end;
end;

procedure AddStrToFile(S:string;const FileName:string;doNextLine:boolean);
{doNextLine -  }
var
 f: TextFile;
 oldsize:integer;
begin
 oldsize:=getfilesize(FileName);
 AssignFile(f,FileName);
 if oldsize<0 then Rewrite(f);
 Append(f);
 if (doNextLine)and(oldSize>0) then writeln(f,'');
 Write(f,S);
 Flush(f);
 CloseFile(f);
end;

{calc utils}
function SignInt(const Value: Integer): SmallInt;
begin
 if Value > 0 then Result := 1
 else if Value = 0 then Result := 0
 else Result := -1;
end;

function Between(A1,A2,Value:integer):boolean;
{  Value  A1  A2 , A1        A2 }
begin
 if (Value<=A1) and (Value>=A2) then Result:=true
 else if (Value>=A1) and (Value<=A2) then Result:=true
 else Result:=false;
end;


function BetweenExt(const A1,A2,Value:extended):boolean;
 {  Value  A1  A2 , A1        A2 }
begin
 if (Value<=A1) and (Value>=A2) then Result:=true
 else if (Value>=A1) and (Value<=A2) then Result:=true
 else Result:=false;
end;

function intPower10(L:integer):integer;{result=(10   L)}
begin
 case L of
 0:Result:=1;
 1:Result:=10;
 2:Result:=100;
 3:Result:=1000;
 4:Result:=10000;
 5:Result:=100000;
 6:Result:=1000000;
 7:Result:=10000000;
 8:Result:=100000000;
 9:Result:=1000000000;
 else raise exception.Create('Invalid argument in intPower10');
 end;{case}
end;

function MaxInteger(a1,a2:integer):integer;
begin
 if a1>a2 then Result:=a1 else Result:=a2;
end;

function MaxFloat(a1,a2:extended):extended;
begin
 if a1>a2 then Result:=a1 else Result:=a2;
end;

function MinInteger(a1,a2:integer):integer;
begin
 if a1<a2 then Result:=a1 else Result:=a2;
end;

function MinFloat(a1,a2:extended):extended;
begin
 if a1<a2 then Result:=a1 else Result:=a2;
end;

procedure ExchangeInt(var a1,a2:integer);{}
var
 x:integer;
begin
 x:=a1;
 a1:=a2;
 a2:=x;
end;

procedure ExchangeWord(var a1,a2:word);{}
var
 x:word;
begin
 x:=a1;
 a1:=a2;
 a2:=x;
end;

procedure ExchangeByte(var a1,a2:byte);{}
var
 x:byte;
begin
 x:=a1;
 a1:=a2;
 a2:=x;
end;

procedure ExchangeFloat(var a1,a2:extended);{}
var
 x:extended;
begin
 x:=a1;
 a1:=a2;
 a2:=x;
end;

procedure ExchangeDateTime(var a1,a2:TdateTime);{}
var
 x:TDateTime;
begin
 x:=a1;
 a1:=a2;
 a2:=x;
end;

function InIntegers(Value:integer;const Data: array of Integer):boolean;//  
var
  I: Integer;
begin
 for I:=Low(Data) to High(Data) do begin
  Result:=(Data[I]=Value);
  if Result then exit;
 end; 
 Result:=false;
end;

{file string utils}
function NormalPath(const DirName: string): string;
{  ,   '\'}
begin
  Result := DirName;
  if (Result <> '') and not (Result[Length(Result)] in [':', '\']) then
  begin
    if (Length(Result) = 1) and (UpCase(Result[1]) in ['A'..'Z']) then
      Result := Result + ':\'
    else Result := Result + '\';
  end;
end;

function DirToPath(const DirName: string): string;
{  ,   '\'}
begin
  Result := DirName;
  if (Result <> '') and not (Result[Length(Result)] in [':', '\']) then
  begin
    if (Length(Result) = 1) and (UpCase(Result[1]) in ['A'..'Z']) then
      Result := Result + ':\'
    else Result := Result + '\';
  end;
end;

function PathToDir(const DirName: string): string;
{    '\'   }
begin
  Result := NormalPath(DirName);
  if length(Result)>3 then delete(result,length(Result),1)
end;

function ExtractFileRoot(FileName:string):string;
 {     /,
        }
begin
 FileName:=extractfilepath(FileName);
 if FileName='' then FileName:=GetCurrentDir
 else if (length(fileName)=2) and(FileName[2]=':')
 then FileName:=FileName+'\';
 Result:=copy(FileName,1,3);
end;

function DoValidFileName(const s:string):string;
{inv}
const
 InvalidChars='?*:><\/|"'';,=+[]';
// InvalidChars='?*:><\/|"'';,';
var
 i,j:integer;
 ch:char;
begin
 Result:=s;
 for i:=1 to length(Result) do begin
  ch:=result[i];
  for j:=1 to length(InvalidChars) do begin
   if ch=InvalidChars[j] then begin
    Result[i]:=' ';
    break;
   end;
  end;
 end;
 Result:=trim(Result);
end;

function ChangeEmptyFileExt(const FileName,Ext:string):string;
 {   ,      }
var
 NewExt,OldExt:string;
begin
 OldExt:=ExtractFileExt(FileName);
 if (OldExt='')or(oldExt='.') then begin
  if (Ext='') or (Ext='.')then NewExt:=''
  else if Ext[1]<>'.' then NewExt:='.'+Ext
  else NewExt:=Ext;
  Result:=ChangeFileExt(FileName,NewExt);
 end else Result:=Filename;
end;

{system utils}
function GetExePath:string;
begin
 Result:=ExtractFilePath(paramstr(0));
end;

function GetWindowsPath: string;
var
 Buffer: array[0..MAX_PATH] of Char;
begin
 SetString(Result, Buffer, windows.GetWindowsDirectory(Buffer,SizeOf(Buffer)));
 Result:=NormalPath(Result);
end;

function GetSystemPath: string;
var
 Buffer: array[0..MAX_PATH] of Char;
begin
 SetString(Result, Buffer, windows.GetSystemDirectory(Buffer,SizeOf(Buffer)));
 Result:=NormalPath(Result);
end;

function GetFileSize(const FileName: string): Longint;
var
 SearchRec: TSearchRec;
begin
 if FindFirst(ExpandFileName(FileName), faAnyFile, SearchRec) = 0 then
  Result := SearchRec.Size
 else Result := -1;
 FindClose(SearchRec);
end;

function GetTempPath:string;
var
 Buffer: array[0..MAX_PATH*2] of Char;
begin
 SetString(Result, Buffer,windows.GetTempPath(Sizeof(Buffer)-1,Buffer));
 if GetDriveTypeOf(Result)<>DRIVE_FIXED then begin
  Result:=ExtractFileRoot(GetWindowsPath);
 end;
end;

function IsDelphiRun:boolean;
 {  Delphi}
var H1, H2, H3, H4 : Hwnd;
const
  A1 : array[0..12] of char = 'TApplication'#0;
  A2 : array[0..15] of char = 'TAlignPalette'#0;
  A3 : array[0..18] of char = 'TPropertyInspector'#0;
  A4 : array[0..11] of char = 'TAppBuilder'#0;
begin
  H1:=FindWindow(A1, nil);
  H2:=FindWindow(A2, nil);
  H3:=FindWindow(A3, nil);
  H4:=FindWindow(A4, nil);
  Result:=(H1 <> 0) and (H2 <> 0) and (H3 <> 0) and (H4 <> 0) ;
end;

function GetUserName:string;
var
 Buffer: array[0..MAX_PATH] of Char;
 sz:DWord;
begin
 sz:=MAX_PATH-1;
 if windows.GetUserName(Buffer,sz)
 then begin
  if sz>0 then dec(sz);
  SetString(Result,Buffer,sz);
 end else if GetLastError<>0 then  Result:='#Error#'+inttostr(GetLastError)
 else Result:='';
end;

function GetComputerName:string;
var
 Buffer: array[0..MAX_PATH] of Char;
 sz:DWord;
begin
 sz:=MAX_PATH-1;
 if windows.GetComputerName(Buffer,sz)
 then begin
//  if sz>0 then dec(sz);
  SetString(Result,Buffer,sz);
 end else if GetLastError<>0 then  Result:='#Error#'+inttostr(GetLastError)
 else Result:='';
end;

function DriveByteToRoot(Drive:byte):string;
{convert Number of Logical Drive to path
for example: 0->A, 1->B}
Begin
 result:=Chr(Drive+$41)+':\';
End;

function DriveByteExists(Drive:byte):boolean;
{A:0; B:1; C:3}
Begin
 Result:=Boolean(GetLogicalDrives AND (1 shl Drive))
End;

function GetDriveTypeOf(FileorPath:string):integer;
var
 Root:string;
begin
 Root:=ExtractFileRoot(FileOrPath);
 Result:=GetDriveType(PChar(Root));
end;

function isPointInRect(const Point:TPoint;const Rect:TRect):boolean;
begin
 with Rect do begin
  Result:=(Point.x>=Left)and(Point.x<Right)
  and(Point.y>=Top)and(Point.y<Bottom);
 end;
(*
 if (Point.x<Rect.Left) then Result:=false
 else if (Point.x>Rect.Right)then Result:=false
 else if (Point.y<Rect.Top) then Result:=false
 else if (Point.y<=Rect.Bottom) then Result:=true
 else Result:=false;*)
end;

function isPtInEllipse(const x,y:integer;const ALeft,ATop,ARight,ABottom:integer):boolean;
{   ,    ,    
.  PINC # 1}
var
 x0,y0:extended;{center of circle}
 EHeight,EWidth:integer;{ }
 xs,ys:extended;{    }
 ek:extended;{     }
 dx,dy,R,Dist:extended;
begin
{   }
 if (x<ALeft) then Result:=false
 else if (x>ARight)then Result:=false
 else if (y<ATop) then Result:=false
 else if (y<=ABottom) then Result:=true
 else Result:=false;
 if Result=false then exit;
 Result:=false;
 EWidth:=ARight-ALeft;
 EHeight:=ABottom-ATop;
 if (EHeight=0) or (EWidth=0) then exit;
 x0:=(ARight+ALeft)*0.5;
 y0:=(ABottom+ATop)*0.5;
 xs:=x;
 ys:=y;
 R:=EHeight*0.5;
 if EWidth<EHeight then begin
  ek:=EHeight/EWidth;
  x0:=x0*ek;
  xs:=xs*ek;
 end else if EWidth>EHeight then begin
  ek:=EWidth/EHeight;
  y0:=y0*ek;
  ys:=ys*ek;
  R:=R*ek;
 end;
 dx:=xs-x0;
 dy:=ys-y0;
 Dist:=sqrt(dx*dx+dy*dy);
 if Dist<=R then Result:=true;
end;

function isRectInRect(const ALeft,ATop,ARight,ABottom,subLeft,subTop,subRight,subBottom:integer):boolean;
begin
 if between(Aleft,Aright,subLeft)=false then result:=false
 else if between(Aleft,Aright,subRight)=false then result:=false
 else if between(ATop,ABottom,subTop)=false then result:=false
 else if between(ATop,ABottom,subBottom)=false then result:=false
 else Result:=true;
end;

function isRectCrossRect(const ALeft,ATop,ARight,ABottom,subLeft,subTop,subRight,subBottom:integer):boolean;
var
 isLeft,isRight,isTop,isBottom:boolean;
begin
 isleft:=between(Aleft,Aright,subLeft);
 isRight:=between(Aleft,Aright,subRight);
 isTop:=between(ATop,ABottom,subTop);
 isBottom:=between(ATop,ABottom,subBottom);
 if isTop and isLeft then Result:=true
 else if isTop and isRight then Result:=true
 else if isBottom and isLeft then Result:=true
 else if isBottom and isRight then Result:=true
 else Result:=false;
end;

function StdRect(var Left,Top,Right,Bottom:integer):TRect{     left<=right,top<=bottom};
var
 x:integer;
begin
 if Left>Right then begin
  x:=Left;
  Left:=Right;
  Right:=x;
 end;
 if Top>Bottom then begin
  x:=Top;
  Top:=Bottom;
  Bottom:=x;
 end;
 Result.Left:=Left;
 Result.Right:=Right;
 Result.Top:=Top;
 Result.Bottom:=Bottom;
end;

function ScaleRect(R:TRect;Scale:double):TRect;//   
begin
 with Result do begin
  Left:=Round(R.Left*Scale);
  Right:=Round(R.Right*Scale);
  Top:=Round(R.Top*Scale);
  Bottom:=Round(R.Bottom*Scale);
 end;
end;

function BoundRects(const Rect1,rect2:Trect):Trect;
 {,    }
var
 i1,i2:integer;
begin
 i1:=MinInteger(Rect1.Left,Rect2.Left);
 i2:=MinInteger(Rect1.Right,rect2.Right);
 Result.Left:=MinInteger(i1,i2);
 i1:=MaxInteger(Rect1.Left,Rect2.Left);
 i2:=MaxInteger(Rect1.Right,rect2.Right);
 Result.Right:=MaxInteger(i1,i2);
 i1:=MaxInteger(Rect1.Top,Rect2.Top);
 i2:=MaxInteger(Rect1.Bottom,rect2.Bottom);
 Result.Bottom:=MaxInteger(i1,i2);
 i1:=MinInteger(Rect1.Top,Rect2.Top);
 i2:=MinInteger(Rect1.Bottom,rect2.Bottom);
 Result.Top:=MinInteger(i1,i2);
(* Result.Left:=MinIntValue([Rect1.Left,Rect2.Left,Rect1.Right,rect2.Right]);
 Result.Right:=MaxIntValue([Rect1.Left,Rect2.Left,Rect1.Right,rect2.Right]);
 Result.Bottom:=MaxIntValue([Rect1.Top,Rect2.Top,Rect1.Bottom,rect2.Bottom]);
 Result.Top:=MinIntValue([Rect1.Top,Rect2.Top,Rect1.Bottom,rect2.Bottom]);*)
end;

function StdRectangle(R:Trect):Trect;
 {     left<=right,top<=bottom}
begin
 Result:=R;
 if R.Left>R.Right then begin
  Result.Left:=R.Right;
  Result.Right:=R.Left;
 end;
 if R.Top>R.Bottom then begin
  Result.Top:=R.Bottom;
  Result.Bottom:=R.Top;
 end;
end;

end.
