unit main;
(*
 TFormatSpeller     
  
:  . 
Created 03.03.2000
http://move.to/ahasoft/
mailto:ahasoft@mail.ru
*)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,propis,fspl;

type

  TForm1 = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    Label1: TLabel;
    cbMoneyNames: TComboBox;
    cbMoneyCaptions: TComboBox;
    Label2: TLabel;
    cbIntNames: TComboBox;
    cbIntCaptions: TComboBox;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cbMoneyNamesChange(Sender: TObject);
    procedure cbMoneyCaptionsChange(Sender: TObject);
    procedure cbIntNamesChange(Sender: TObject);
    procedure cbIntCaptionsChange(Sender: TObject);
  private
  public
   fs:TFormatSpeller;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.FormActivate(Sender: TObject);
var
 i,q:integer;
 c:currency;
 s:string;
begin
 memo1.lines.beginupdate;
 for i:=0 to memo1.lines.count-1 do begin
  c:=strtocurrp(memo1.lines[i]);
  s:=fs.CurrtoText(c);
  memo1.lines[i]:=memo1.lines[i]+': '+s;
 end;
 memo1.lines.endupdate;
 memo2.lines.beginupdate;
 for i:=0 to memo2.lines.count-1 do begin
  q:=strtoint(memo2.lines[i]);
  s:=fs.InttoText(q);
  memo2.lines[i]:=memo2.lines[i]+': '+s;
 end;
 memo2.lines.endupdate;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 fs:=TFormatSpeller.Create;
 cbMoneyNames.Items.Assign(fs.MoneyNames);
 cbMoneyCaptions.Items.Assign(fs.MoneyCaptions);
 cbIntNames.Items.Assign(fs.IntNames);
 cbIntCaptions.Items.Assign(fs.IntCaptions);
 cbMoneyNames.ItemIndex:=0;
 cbMoneyCaptions.ItemIndex:=0;
 cbIntNames.ItemIndex:=0;
 cbIntCaptions.ItemIndex:=0;
//s.SelectMoney('RUR');
// fs.CentSpell:=true;
// fs.MoneySpell:=false;
// fs.loadfromfile('rur.spl');
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 fs.Free;
end;

procedure TForm1.cbMoneyNamesChange(Sender: TObject);
var
 i,p:integer;
 c:currency;
 s,s1:string;
begin
 fs.SelectMoney(cbMoneyNames.Text);
 cbMoneyCaptions.ItemIndex:=cbMoneyNames.ItemIndex;
 memo1.lines.beginupdate;
 for i:=0 to memo1.lines.count-1 do begin
  s1:=memo1.lines[i];
  p:=pos(':',s1);
  s1:=copy(s1,1,p-1);
  c:=strtocurrp(s1);
  s:=fs.CurrtoText(c);
  memo1.lines[i]:=s1+': '+s;
 end;
 memo1.lines.endupdate;
end;

procedure TForm1.cbMoneyCaptionsChange(Sender: TObject);
begin
 if cbMoneyNames.ItemIndex<>cbMoneyCaptions.ItemIndex
 then begin
  cbMoneyNames.ItemIndex:=cbMoneyCaptions.ItemIndex;
  cbMoneyNamesChange(nil);
 end;
end;

procedure TForm1.cbIntNamesChange(Sender: TObject);
var
 i,p,q:integer;
 s,s1:string;
begin
 fs.SelectInt(cbIntNames.Text);
 cbIntCaptions.ItemIndex:=cbIntNames.ItemIndex;
 memo2.lines.beginupdate;
 for i:=0 to memo2.lines.count-1 do begin
  s1:=memo2.lines[i];
  p:=pos(':',s1);
  s1:=copy(s1,1,p-1);
  q:=strtoint(s1);
  s:=fs.InttoText(q);
  memo2.lines[i]:=s1+': '+s;
 end;
 memo2.lines.endupdate;
end;

procedure TForm1.cbIntCaptionsChange(Sender: TObject);
begin
 if cbIntNames.ItemIndex<>cbIntCaptions.ItemIndex
 then begin
  cbIntNames.ItemIndex:=cbIntCaptions.ItemIndex;
  cbIntNamesChange(nil);
 end;
end;

end.
