unit Propis;

interface
function FCurrencyToString(f:Double;vKopeiki,vRubles,vPowers,vKopAsNumbers :Integer):String ;export;
procedure FCurrencyToPChar(f:Double;vKopeiki,vRubles,vPowers,vKopAsNumbers :Integer;r:PChar);export;
implementation

uses SysUtils,WinTypes;

type
  Sex = (Male,Female);
  Powers =(Kop,R,T,Mln,Mlrd,Trln);
  NumbersAsStrings = array[1..4,1..9] of String;
const
  arrayNAS:NumbersAsStrings =
  (
   ('','','','','',
    '','','',''), {[1,x]}
   ('','','','','',
    '','','',''),{[2,x]}
   ('','','','','',
    '','','',''), {[3,x]}
   ('','','','','',
    '','','','')   {[4,x]}
  );

function FloatToInt(f:Double):Longint;
begin
  Result:=Round(f);
end;

function NumAsStr(fi,fj:Double):String;
begin
   Result:=arrayNAS[FloatToInt(fi),FloatToInt(fj)];
end;

function Modulus(i,j:Double):Double;
begin
  Result:=i-Int(i/j)*j;
end;

procedure Incr(var _dbl:double; d:double);
begin
  _dbl:=_dbl+d;
end;

procedure Decr(var _dbl:double; d:double);
begin
  _dbl:=_dbl-d;
end;

procedure splitTriada(triada:Double;var i1,i10,i100:Double);
var
   Temp:Double;
begin
 i1:=Modulus(triada,10);

 Decr(triada,i1);
 Temp := triada/10;//Anti-optimizator
 triada:=Int(Temp);
 i10:=Modulus(triada,10);

 Decr(triada,i10);
 Temp := triada/10;//Anti-optimizator
 triada:=Int(Temp);
 i100:=Modulus(triada,10);
end;

function DigitAsStr(i1:Double;aSex:Sex):String;
begin
   if i1=1 then begin
      if aSex=Male then Result:=NumAsStr(1,i1)+''
      else Result:=NumAsStr(1,i1)+''
   end else if i1=2 then begin
      if aSex=Male then Result:=NumAsStr(1,i1)+''
      else Result:=NumAsStr(1,i1)+''
   end else Result:=NumAsStr(1,i1);
end;

function DecodedDiadaAsStr(i1,i10 :Double;aSex:Sex):String;
begin
  if((i10=0)and(i1=0))then Result:=''
  else if i10=0 then Result:=DigitAsStr(i1,aSex)
  else if i1=0  then Result:=NumAsStr(3,i10)
  else if i10=1 then Result:= NumAsStr(2,i1)
  else Result:=NumAsStr(3,i10)+' '+DigitAsStr(i1,aSex);
end;

function TriadaAsStr(triada:Double;aSex:Sex):String;
var i1,i10,i100 :Double;
begin
  splitTriada(triada,i1,i10,i100);
  if i100>0 then Result:=NumAsStr(4,i100)+' '+DecodedDiadaAsStr(i1,i10,aSex)
  else Result:=DecodedDiadaAsStr(i1,i10,aSex);
  Result := Trim(Result);
end;

procedure splitSum(CurrentSum:Double;var fR,fT,fMln,fMlrd,fTrln:Double);
var
   Temp : Double;
begin
 fR:=Modulus(CurrentSum,1000);
 Decr(CurrentSum,fR);
 Temp := CurrentSum/1000;//Anti-optimizator
 CurrentSum:=Int(Temp);

 fT:=Modulus(CurrentSum,1000);
 Decr(CurrentSum,fT);
 Temp := CurrentSum/1000;//Anti-optimizator
 CurrentSum:=Int(Temp);

 fMln:=Modulus(CurrentSum,1000);
 Decr(CurrentSum,fMln);
 Temp := CurrentSum/1000;//Anti-optimizator
 CurrentSum:=Int(Temp);

 fMlrd:=Modulus(CurrentSum,1000);
 Decr(CurrentSum,fMlrd);
 Temp := CurrentSum/1000;
 CurrentSum:=Int(Temp);

 fTrln:=Modulus(CurrentSum,1000);
end;

function getSexOfPower(aPwr:Powers):Sex;
begin
  case aPwr of
    R,Mln,Mlrd,Trln :Result:=Male;
    T,Kop     :Result:=Female;
  end;
end;

function getCurrency(f1,f10:Double;aPwr:Powers;vKopeiki,vRubles,vPowers :Integer):String;
var i:Longint;
begin

  if f10=1 then i:=0
    else i:=FloatToInt(f1);

  if aPwr=R then begin
    case vRubles of
      0:Result:='';
      1:Result:='.';
      2:case i of
          0,5..9:Result:='';
          2..4: Result:='';
          1:Result:='';
        end;
    end;
  end else if aPwr=Kop then begin
    case vKopeiki of
      0:Result:='';
      1:Result:='.';
      2:case i of
          0,5..9:Result:='';
          2..4: Result:='';
          1:Result:='';
        end;
    end;
  end else
    case vPowers of
      1:case aPwr of
          T:Result:='.';
          Mln:Result:='.';
          Mlrd:Result:='.';
          Trln:Result:='.';
        end;
      2:case aPwr of
          T:case i of
              0,5..9:Result:='';
              2..4: Result:='';
              1:Result:='';
            end;
          Mln:case i of
                0,5..9:Result:='';
                2..4: Result:='';
                1:Result:='';
              end;
          Mlrd:case i of
                 0,5..9:Result:='';
                 2..4: Result:='';
                 1:Result:='';
               end;
          Trln:case i of
                 0,5..9:Result:='';
                 2..4: Result:='';
                 1:Result:='';
               end;
          end;
  end;
end;

function TriadaWithCurrencyAsStr(triada:Double;aPwr:Powers;vKopeiki,vRubles,vPowers :Integer):String;
var f1,f10:Double;
    fTemp: Double;
begin
    Result:=TriadaAsStr(triada,getSexOfPower(aPwr));
    f1:=Modulus(triada,10);
    Decr(triada,f1);
    fTemp:=triada/10; //Anti-optimizator
    triada:=Int(fTemp);
    f10:=Modulus(triada,10);
    Result:=Trim(Result)+' '+getCurrency(f1,f10,aPwr,vKopeiki,vRubles,vPowers);
end;

function  MUpperCase(aStr:String):String;
begin
  if aStr[1] in [''..''] then
    Result:=Chr(Ord(aStr[1])+Ord('')-Ord(''))
  else Result:=aStr;
end;

function FCurrencyToString(f:Double;vKopeiki,vRubles,vPowers,vKopAsNumbers :Integer):String ;
var fR,fT,fMln,fMlrd,fTrln,fKop:Double;
    f1,f10,f100:Double;
    tmp:String;
    fTemp: Double;
begin
  if(Int(f)>0) then begin
    splitSum(Int(f),fR,fT,fMln,fMlrd,fTrln);
    Result:='';
    if fTrln>0 then Result:=TriadaWithCurrencyAsStr(fTrln,Trln,vKopeiki,vRubles,vPowers)+' ';
    if fMlrd>0 then Result:=Result+TriadaWithCurrencyAsStr(fMlrd,Mlrd,vKopeiki,vRubles,vPowers)+' ';
    if fMln>0 then Result:=Result+TriadaWithCurrencyAsStr(fMln,Mln,vKopeiki,vRubles,vPowers)+' ';
    if fT>0 then Result:=Result+TriadaWithCurrencyAsStr(fT,T,vKopeiki,vRubles,vPowers)+' ';
    if fR>0 then Result:=Result+TriadaWithCurrencyAsStr(fR,R,vKopeiki,vRubles,vPowers)
    else case vRubles of
           1:Result:=Result +'.';
           2:Result:=Result +'';
         end;
  end else case vRubles of
             0:Result:='';
             1:Result:=' .';
             2:Result:=' ';
           end;

  if vKopeiki>0 then begin
    fTemp := Modulus(f,1)*100+0.5;
    fKop:=Int(fTemp);
    if vKopAsNumbers = 0 then begin
       if fKop=0 then Result:=Trim(Result)+' ';
       Result:=Trim(Result)+' '+ TriadaWithCurrencyAsStr(fKop,Kop,vKopeiki,vRubles,vPowers);
    end else begin
        splitTriada(fKop,f1,f10,f100);
        Result:=Trim(Result)+' '+FormatFloat('00',fKop)+' '+getCurrency(f1,f10,Kop,vKopeiki,vRubles,vPowers);
    end;
  end;
  tmp:=MUpperCase(Copy(Result,1,1));
  Result:=Concat(tmp,Copy(Result,2,Length(Result)-1));
end;

procedure FCurrencyToPChar(f:Double;vKopeiki,vRubles,vPowers,vKopAsNumbers :Integer;r:PChar);
begin
  StrPCopy(r,FCurrencyToString(f,vKopeiki,vRubles,vPowers,vKopAsNumbers));
end;

end.
