unit ivstring;

interface
uses classes,ivkernel,sysutils,inifiles;

function TranslitStrEnglRus(S:string):string;
 {    }
function TranslitStrEnglRus1(S:string):string;
 {    }
function TranslitStrRusEngl(S:string):string;
 {     }
function CompareStrRus(S1, S2: string): Integer;
 { CompareStrRus compares S1 to S2, with case-sensitivity. The return value is
  less than 0 if S1 < S2, 0 if S1 = S2, or greater than 0 if S1 > S2.
  Sort Order: [SPACE]_-.*0123456789AaBbCcDd...Zz......Ÿ...[OTHER SYMBOLS]
  }
function SaveSpaces1(S: string): string;
{      ,  }
function IsWildStr(InputStr, Wilds: string; IgnoreCase: Boolean): Boolean;
 { IsWildStr  InputStr   Wilds
  :
  # - 
  ? - / 
  @ -  
  * -    }
function IsWildPolyStr(InputStr, Wilds: string; IgnoreCase: Boolean): Boolean;
 { isWildStr,      ,  }
function StrExtractEndInteger(s:string):integer;
 {    "str12"  12;   ,  0}
function StrIncEndInteger(s:string):string;
 {      1,    ,  1}
function StrExtractValue(s:string):string;
 {extract 'val1' from string 'par= val1  '}
procedure StrToParam_Value(Source:string;var sParam,sValue:string);
 {split string 'par=val1' to 'par' and 'val1'}
{doNextLine -  }
function NumberToUpperA_Z(i:integer):char;{ 0:A, 1:B ...}
procedure SplitString(Source:string;delimiter:char;ssWords:TStrings);{  *.*;*.b?;rt*.*,    }
procedure SplitStringE(Source:string;delimiter:char;ssWords:TStrings);{  *.*;;*.b?;rt*.*,   }
procedure SortStringsByFloat(SL:TStrings);
 {must be SL.Sorted=false}
procedure SortStringListRus(SL:TStrings);
 {must be SL.Sorted=false}
procedure RevertStrings(SL:TStrings);{ }
function SSIndexOfNCR(ss:TStrings;s:string):integer;
 {   ss    /no case}
procedure PutStringToIni(Section,iDent,value:string);
 {   Ident   Section  ini-,
  exe-;
 DefaultValue -   }
function  GetStringFromIni(Section,Ident,defaultValue:string):string;
 {   Ident   Section  ini-,
  exe-;
 DefaultValue -   }
function LoadStringFromFile(FileName:string;Raw:integer):string;
 {  raw  ,    Raw=0}
procedure SaveStringToFile(S:string;FileName:string);
 {   1 }


implementation
const
 RusAlfabet='';
 TransLitCodes:array[1..length(RusAlfabet)] of string= (
 'a','b','v','g','d',
 'e','yo','zh','z','i',
 'y','k','l','m','n',
 'o','p','r','s','t',
 'u','f','h','ts','ch',
 'sh','sh''','`','i''','''',
 'e''' ,'yu','ya','c','ph','th','w','kh','ja','jo','ju','ck','sch');
 TransLitCodes1:array[1..length(RusAlfabet)] of string= (
 'a','b','v','g','d',
 'e','jo','zh','z','i',
 'j','k','l','m','n',
 'o','p','r','s','t',
 'u','f','h','ts','ch',
 'sh','sh''','`','y','''',
 'e''' ,'ju','ja','c','ph','th','w','kh','ya','yo','yu','ck','sch');


function TranslitStrRusEngl(S:string):string;
 {     }
var
 i:integer;
 n:integer;
 ch:char;
 sa,sl:string;
begin
 Result:='';
 sl:=lowercaserus(s);
 for i:=1 to length(S) do begin
  ch:=s[i];
  n:=pos(sl[i],RusAlfabet);
  if n=0 then Result:=Result+S[i]
  else begin
   sa:=TranslitCodes[n];
   if whatCaseRus(ch)=1 then sa:=lowercaserus(sa)
   else sa:=uppercaserus(sa);
   Result:=result+sa;
  end;
 end;
end;

function TranslitStrEnglRus(S:string):string;
 {    }
const
 szAlfabet=length(RusAlfabet);
var
 j,CodePos,CodeLen,L:integer;
 ch:char;
 sl:string;
begin
 Result:='';
 sl:=lowercaserus(s);
 while length(S)>0 do begin
  L:=length(s);
  if sl[1]='c' then begin
   if L=1 then begin
    sl[1]:='k';
    if s[1]='c' then s[1]:='k'
    else s[1]:='K'
   end else if sl[2] in ['e','y','i','j','h','k']=false then begin
    sl[1]:='k';
    if s[1]='c' then s[1]:='k'
    else s[1]:='K'
   end;
  end;
  CodeLen:=0;
  CodePos:=0;
  for j:=1 to szAlfabet do begin
   if (pos(TransLitCodes[j],sl)=1) and (length(TransLitCodes[j])>CodeLen)
   then begin
    CodeLen:=length(TransLitCodes[j]);
    CodePos:=j;
   end;
  end;
  if CodeLen=0 then begin
   result:=Result+S[1];
   delete(S,1,1);
   delete(Sl,1,1);
  end else begin
   ch:=RusAlfabet[CodePos];
   if whatCaseRus(s[1])=2 then ch:=UpCaseRus(ch)
   else ch:=LoCaseRus(ch);
   Result:=Result+ch;
   delete(S,1,CodeLen);
   delete(Sl,1,CodeLen);
  end;
 end;
end;

function TranslitStrEnglRus1(S:string):string;
 {    }
const
 szAlfabet=length(RusAlfabet);
var
 j,CodePos,CodeLen,L:integer;
 ch:char;
 sl:string;
begin
 Result:='';
 sl:=lowercaserus(s);
 while length(S)>0 do begin
  L:=length(s);
  if sl[1]='c' then begin
   if L=1 then begin
    sl[1]:='k';
    if s[1]='c' then s[1]:='k'
    else s[1]:='K'
   end else if sl[2] in ['e','y','i','j','h','k']=false then begin
    sl[1]:='k';
    if s[1]='c' then s[1]:='k'
    else s[1]:='K'
   end;
  end;
  CodeLen:=0;
  CodePos:=0;
  for j:=1 to szAlfabet do begin
   if (pos(TransLitCodes1[j],sl)=1) and (length(TransLitCodes1[j])>CodeLen)
   then begin
    CodeLen:=length(TransLitCodes1[j]);
    CodePos:=j;
   end;
  end;
  if CodeLen=0 then begin
   result:=Result+S[1];
   delete(S,1,1);
   delete(Sl,1,1);
  end else begin
   ch:=RusAlfabet[CodePos];
   if whatCaseRus(s[1])=2 then ch:=UpCaseRus(ch)
   else ch:=LoCaseRus(ch);
   Result:=Result+ch;
   delete(S,1,CodeLen);
   delete(Sl,1,CodeLen);
  end;
 end;
end;


function SaveSpaces1(S: string): string;
{      ,  }
var
  I: Integer;
begin
 Result := Trim(S);
 for i:=1 to length(S) do if s[i]=#9 then s[i]:=' ';
 for I := Length(Result) downto 2 do begin
  if (Result[I] = ' ') and (Result[I - 1] = ' ') then
   Delete(Result, I, 1);
 end;
end;


function CompareStrRus(S1, S2: string): Integer;
 { CompareStrRus compares S1 to S2, with case-sensitivity. The return value is
  less than 0 if S1 < S2, 0 if S1 = S2, or greater than 0 if S1 > S2.
  Sort Order: [SPACE]_-.*0123456789AaBbCcDd...Zz......Ÿ...[OTHER SYMBOLS]
  }
const
 Order=' _-.*123456789AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz娸';
var
 i,l1,l2,minl:integer;
 ch1,ch2:char;
 P1,P2:integer;
begin
 l1:=length(s1);
 l2:=length(s2);
 if l1>l2 then minl:=l2 else minl:=l1;
 for i:=1 to minl do begin
  ch1:=s1[i];
  ch2:=s2[i];
  if ch1=ch2 then continue;
  P1:=pos(ch1,Order);
  if P1=0 then P1:=255+ord(ch1);
  P2:=pos(ch2,Order);
  if P2=0 then P2:=255+ord(ch2);
  if P2<>P1 then begin
   Result:=P1-P2;
   exit;
  end;
 end;
 Result:=l1-l2;
end;

function IsWildStr(InputStr, Wilds: string; IgnoreCase: Boolean): Boolean;
{Converted from RX.STRutils
 IsWild compare InputString with WildCard string and return True
  if corresponds.
 # -   
 ? -   / 
 @ -  
 * -    
   }
 function isEqualChar(ch,maskch:char):boolean;
 begin
  Result:=true;
  if ch=maskch then exit;
  case maskch of
  '@':exit;
  '#':if ch in ['0'..'9'] then exit;
  '?':if ch in ['A'..'Z','a'..'z',''..'',''..'','',''] then exit;
  end;{case}
  Result:=false;
 end;

 function FindPart(const HelpWilds, InputStr: string): Integer;
{ compares a string with '@','?','#' and another, returns the position of
  HelpWilds in InputStr }
 var
   I, J: Integer;
   Diff: Integer;
 begin
   I := Pos('@', HelpWilds);
   if I=0 then I:=pos('?', HelpWilds);
   if I=0 then I:=pos('#', HelpWilds);
   if I = 0 then begin
     { if no '@','#','?' in HelpWilds }
     Result := Pos(HelpWilds, InputStr);
     Exit;
   end;
   { '@','#','?' in HelpWilds }
   Diff := Length(InputStr) - Length(HelpWilds);
   if Diff < 0 then begin
     Result := 0;
     Exit;
   end;
   { now move HelpWilds over InputStr }
   for I := 0 to Diff do begin
     for J := 1 to Length(HelpWilds) do begin
       if isEqualChar(InputStr[I + J],HelpWilds[J])=true
       then begin
         if J = Length(HelpWilds) then begin
           Result := I + 1;
           Exit;
         end;
       end
       else Break;
     end;
   end;
   Result := 0;
 end;

 function SearchNext(var Wilds: string): Integer;
 { looking for next *, returns position and string until position }
 begin
   Result := Pos('*', Wilds);
   if Result > 0 then Wilds := Copy(Wilds, 1, Result - 1);
 end;

var
  CWild, CInputWord: Integer;{ counter for positions }
  I, LenHelpWilds: Integer;
  MaxInputWord, MaxWilds: Integer; { Length of InputStr and Wilds }
  HelpWilds: string;
begin
  Result := False;
  if Wilds = InputStr then begin
    Result := True;
    Exit;
  end;
  { for fast end, if Wilds only '*' }
  if Wilds = '*' then begin
    Result := True;
    Exit;
  end;
  if Wilds='' then begin
   Exit;
  end;
  MaxInputWord := Length(InputStr);
  MaxWilds := Length(Wilds);
  { upcase all letters }
  if IgnoreCase then begin
    for I := 1 to MaxInputWord do
      InputStr[I] := UpCaseRus(InputStr[I]);
    for I := 1 to MaxWilds do
      Wilds[I] := UpCaseRus(Wilds[I]);
  end;
  { set initialization }
  CInputWord := 1;
  CWild := 1;
  Result := True;
  repeat
    { equal letters }
    if isEqualChar(InputStr[CInputWord],Wilds[CWild]) then begin
     Inc(CWild);
     Inc(CInputWord);
     Continue;
    end;
    { handling of '*' }
    if Wilds[CWild] = '*' then begin
      { takes the rest of Wilds }
      HelpWilds := Copy(Wilds, CWild + 1, MaxWilds);
      { search the next '*' }
      I := SearchNext(HelpWilds);
      LenHelpWilds := Length(HelpWilds);
      if I = 0 then begin
        { no '*' in the rest, compare the ends }
        if HelpWilds = '' then Exit; { '*' is the last letter }
        { check the rest for equal Length and no '@' }
        for I := 0 to LenHelpWilds - 1 do begin
          if isEqualChar(InputStr[MaxInputWord - I],HelpWilds[LenHelpWilds - I])=false
          then begin
            Result := False;
            Exit;
          end;
        end;
        Exit;
      end;
      { handle all to the next '*' }
      Inc(CWild, 1 + LenHelpWilds);
      I := FindPart(HelpWilds, Copy(InputStr, CInputWord, MaxInt));
      if I= 0 then begin
        Result := False;
        Exit;
      end;
      CInputWord := I + LenHelpWilds;
      Continue;
    end;
    Result := False;
    Exit;
  until (CInputWord > MaxInputWord) or (CWild > MaxWilds);
  { no completed evaluation }
  if CInputWord <= MaxInputWord then Result := False;
  if CWild <= MaxWilds then Result := False;
  if (CInputWord=MaxInputWord+1) and (MaxWilds=CWild)
  and (wilds[CWild]='*') then Result:=true;
end;

function IsWildPolyStr(InputStr, Wilds: string; IgnoreCase: Boolean): Boolean;
 { isWildStr,      ,  }
var
 n:integer;
 subFilter,tmpFilter:string;
begin
 Result:=false;
 tmpFilter:=Wilds;
 repeat
  n:=pos(',',tmpFilter);
  if n<>0 then begin
   subFilter:=copy(tmpFilter,1,n-1);
   delete(tmpFilter,1,n);
  end else subFilter:=tmpFilter;
  if IsWildStr(InputStr, subFilter,IgnoreCase) then begin
   Result:=true;
   exit;
  end;
 until n=0;
end;

function StrExtractEndInteger(s:string):integer;
 {  ,  0}
var
 sNumber:string;
 i:integer;
begin
 sNumber:='';
 for i:=length(s) downto 1 do begin
  if s[i] in ['0'..'9']then sNumber:=s[i]+sNumber
(*  else if s[i]='-' then begin
   if sNumber='' then break
   else begin
    sNumber:=s[i]+sNumber;
    break;
   end;
  end;*)
  else break;
 end;
 if sNumber='' then Result:=0
 else Result:=strtoint(sNumber);
end;

function StrIncEndInteger(s:string):string;
 {      1,    ,  1}
 {  ,  0}
var
 sNumber,sLeft:string;
 i,ip,Number:integer;
begin
 ip:=0;
 for i:=length(s) downto 1 do begin
  if s[i] in ['0'..'9']then ip:=i
  else break;
 end;
 if ip=0 then begin
  Number:=0;
  sLeft:=s;
 end else begin
  sNumber:=copy(s,ip,MaxInt);
  Number:=strtoint(sNumber);
  sLeft:=copy(s,1,ip-1);
 end;
 inc(Number);
 Result:=sLeft+inttostr(Number);
end;

procedure StrToParam_Value(Source:string;var sParam,sValue:string);
{split string 'par=val1' to 'par' and 'val1'}
var
 pos_e:integer;
begin
 pos_e:=pos('=',Source);
 if pos_e>0 then begin
  sParam:=trim(copy(Source,1,pos_e-1));
  sValue:=trim(copy(Source,pos_e+1,length(Source)));
 end else begin
  sParam:=Source;
  sValue:='';
 end;
end;

function StrExtractValue(s:string):string;
 {extract 'val1' from string 'par= val1  '}
var
 pos_e:integer;
begin
 pos_e:=pos('=',S);
 if pos_e>0 then begin
  Result:=trim(copy(S,pos_e+1,maxint));
 end else begin
  Result:='';
 end;
end;

procedure SplitString(Source:string;delimiter:char;ssWords:TStrings);{  *.*;*.b?;rt*.*}
{  *.*;*.b?;rt*.*,    }
var
 i:integer;
 s:string;
begin
 ssWords.Clear;
 s:='';
 for i:=1 to length(Source) do begin
  if (Source[i]=Delimiter)and(s<>'') then begin
   ssWords.Add(s);
   s:='';
  end else if (Source[i]<>delimiter) then s:=s+Source[i];
 end;
 if (s<>'')then ssWords.Add(s);
end;

procedure SplitStringE(Source:string;delimiter:char;ssWords:TStrings);{  *.*;;*.b?;rt*.*,   }
var
 i,ic:integer;
 s:string;
begin
 ssWords.Clear;
 s:='';
 ic:=0;
 for i:=1 to length(Source) do begin
  if (Source[i]=Delimiter) then begin
   ssWords.Add(s);
   s:='';
   ic:=0;
  end else if (Source[i]<>delimiter) then begin
   s:=s+Source[i];
   inc(ic);
  end;
 end;
 if ic<>0 then  ssWords.Add(s);
end;

function NumberToUpperA_Z(i:integer):char;{ 0:A, 1:B ...}
begin
 Result:=char(ord('A')+i);
end;

function LoadStringFromFile(FileName:string;Raw:integer):string;
 {  raw  ,    Raw=0}
var
 sl:TStringList;
begin
 Result:='';
 if fileexists(FileName) then begin
  sl:=tstringlist.create;
  sl.loadfromfile(FileName);
  if sl.Count-1<Raw then Result:='' else Result:=sl[Raw];
  sl.free;
 end;
end;

procedure SaveStringToFile(S:string;FileName:string);
 {   1 }
var
 sl:TStringList;
begin
 sl:=tstringlist.create;
 sl.Add(S);
 sl.SaveToFile(FileName);
 sl.free;
end;

procedure PutStringToIni(Section,iDent,value:string);
 {   Ident   Section  ini-,
  exe-;
 DefaultValue -   }
var
 Ini:TIniFile;
 fIni:string;
begin
 fIni:=ChangeFileExt(paramstr(0),'.ini');
 ini:=TIniFile.Create(fIni);
 ini.WriteString(Section, Ident,value);
 ini.Free;
end;

function  GetStringFromIni(Section,Ident,defaultValue:string):string;
 {   Ident   Section  ini-,
  exe-;
 DefaultValue -   }
var
 Ini:TIniFile;
 fIni:string;
begin
 fIni:=ChangeFileExt(paramstr(0),'.ini');
 ini:=TIniFile.Create(fIni);
 Result:=ini.ReadString(Section, Ident,DefaultValue);
 ini.Free;
end;

procedure QuickSortStringsByFloat(SL:TStrings;L, R: Integer);
 function Compare(s1,s2:string):integer;
 var
  e1,e2:extended;
  ok1,ok2:boolean;
 begin
  ok1:=TextToFloat(PChar(S1), e1, fvExtended);
  ok2:=TextToFloat(PChar(S2), e2, fvExtended);
  if (ok1 and ok2) then begin
   if e1<e2 then Result:=-1
   else if e1>e2 then Result:=1
   else result:=0;
  end else if ((ok1=false)and ok2)then Result:=1
  else if  (ok2=false)and(ok1)then Result:=-1
  else Result:=CompareStrRus(S1,S2);
 end;

var
  I, J: Integer;
  P: string;
begin
  repeat
    I := L;
    J := R;
    P:=SL[(L+R)shr 1];
    repeat
      while Compare(SL[I],P)<0 do inc(I);
      while Compare(SL[J],P)>0 do dec(J);
      if I <= J then
      begin
        SL.Exchange(I, J);
        Inc(I);
        Dec(J);
      end;
    until I > J;
    if L < J then QuickSortStringsByFloat(SL,L, J);
    L := I;
  until I >= R;
end;

procedure SortStringsByFloat(SL:TStrings);
 {must be SL.Sorted=false}
begin
 if SL.Count =0 then exit;
 QuickSortStringsByFloat(SL,0, SL.Count - 1);
end;

procedure QuickSortStringListRus(SL:TStrings;L, R: Integer);
var
  I, J: Integer;
  P: string;
begin
  repeat
    I := L;
    J := R;
    P:=SL[(L+R)shr 1];
    repeat
      while CompareStrRus(SL[I], P) < 0 do Inc(I);
      while CompareStrRus(SL[J], P) > 0 do Dec(J);
      if I <= J then
      begin
        SL.Exchange(I, J);
        Inc(I);
        Dec(J);
      end;
    until I > J;
    if L < J then QuickSortStringListRus(SL,L, J);
    L := I;
  until I >= R;
end;

procedure SortStringListRus(SL:TStrings);
begin
 if SL.Count =0 then exit;
 QuickSortStringListRus(SL,0, SL.Count - 1);
end;

procedure RevertStrings(SL:TStrings);
var
 i:integer;
begin
 for i:=0 to SL.Count shr 1 do SL.Exchange(i,SL.Count-1-i);
end;

function SSIndexOfNCR(ss:TStrings;s:string):integer;
var
 si,sUp:string;
begin
 sUp:=UpperCaseRus(s);
 for Result:=0 to ss.Count-1 do begin
  si:=UpperCaseRus(ss[Result]);
  if si=sUp then exit;
 end;
 Result:=-1;
end;

end.
