unit ivsys;

interface
 uses windows,registry,sysutils,classes,ivkernel,filectrl,ivstring;
const
 Reg_Root_Last=6;
 Reg_Root_Names:array[0..Reg_Root_Last] of string=(
  'HKEY_CLASSES_ROOT','HKEY_CURRENT_USER',
  'HKEY_LOCAL_MACHINE','HKEY_USERS',
  'HKEY_PERFORMANCE_DATA','HKEY_CURRENT_CONFIG',
  'HKEY_DYN_DATA');
 Reg_Root_Keys:array[0..Reg_Root_Last] of HKey=(
  HKEY_CLASSES_ROOT,HKEY_CURRENT_USER,
  HKEY_LOCAL_MACHINE,HKEY_USERS,
  HKEY_PERFORMANCE_DATA,HKEY_CURRENT_CONFIG,
  HKEY_DYN_DATA);
 REG_CURRENT_VERSION = 'Software\Microsoft\Windows\CurrentVersion';
 REG_COMPUTERNAME_PATH='System\CurrentControlSet\control\ComputerName\ComputerName';
 REG_COMPUTERNAME='ComputerName';
 REG_OWNER    = 'RegisteredOwner';
 REG_COMPANY = 'RegisteredOrganization';

{ registry functions }
function  regReadString(aKey: hKey;Path: String): String;
procedure regWriteString(aKey: hKey;Path,Value: String);
procedure regDelValue(aKey: hKey;Path: String);
function  regInfoString(const sParam: String): String;
function  regOwner: String;
function  regCompany: String;
function  regComputerName: String;
function regPathToRootKey(sPath:string):HKey;
function regRootKeyToName(RootKey:HKey):string;
procedure regSplitFullPath(var Path:string;var RootKey:HKey);{    RootKey and Path}

{system utils}
function GetProcessorType:integer;
 {constants defined in windows;result may be:
 PROCESSOR_INTEL_386
 PROCESSOR_INTEL_486
 PROCESSOR_INTEL_PENTIUM
 Windows NT only: PROCESSOR_MIPS_R4000
 Windows NT only: PROCESSOR_ALPHA_21064}
function GetCPUSpeed: double;{  }
function GetBIOSDate: string;{ BIOS for Win 95}
procedure GetEnvironmentStrings(ss:TStrings);{ }
function GetFirstCDROM:string;{ 1-  CD-ROM}
function GetVolumeInfoFVS(const Dir:string;var FileSystemName,VolumeName:string;var Serial:longint):boolean;
 {   ,     }
function CompareFiles(Filename1,FileName2:string):longint;
 //      ;
 //  0 -   ,
 // -1 -   1
 // -2 -   2
 // -3 -  
function CountFileSum(FileName:string;Method:integer):integer;
 //Method:
 //0:sum of bytes
 //1:sum with shl
 //2:xor with shl
procedure GetDriveRoots(list:TStrings;Types:array of integer;doInclude:boolean);
{Types-/   ;
 Types=[-1]  doInclude=false -    
 Types=[DRIVE_FIXED]  doInclude=false -    
0	The drive type cannot be determined.
1	The root directory does not exist.
DRIVE_REMOVABLE	The drive can be removed from the drive.
DRIVE_FIXED	The disk cannot be removed from the drive.
DRIVE_REMOTE	The drive is a remote (network) drive.
DRIVE_CDROM	The drive is a CD-ROM drive.
DRIVE_RAMDISK	The drive is a RAM disk.
}
procedure GetDirFiles(FileNames:TStrings;const Path:string);
procedure GetPathList(LS:TStrings;Dir:string);{   }
function GetPathLevel(Path:string):integer;
 {  '\'  }
 { GetPathLevel('C:\dir1\subdir2\')=3}
function EmptyDir(const Dir: string;Delete:boolean): Boolean;
 {      Path   .
   Delete   True,    
  ,   Path    .
      Read-Only.
       True,
    - False}
procedure AddSearchFiles(Dir:string;Mask:string;MinSize,MaxSize:longint;ssFileList:TStrings);
 {    ,    Dir   Mask, - 
   ,     -1}
function DeleteFiles(Dir:string;Mask:string):boolean;
 {     }
function CopyFiles(SourceDir,DestDir:string;Mask,NewName:string):boolean;
 {   , NewName without ext
 if NewName='' then old names used}


implementation

{registry utils}
procedure regParsePath(const Path: String; var aPath, aValue: String);
begin
  aPath:=Path;
  aValue:= '';
  while (Length(aPath)>0) and (aPath[length(aPath)]<>'\') do
  begin
    aValue:=aPath[length(aPath)]+aValue;
    if Length(aPath) > 0 then Delete(aPath,Length(aPath),1);
  end;
end;

function regReadString(aKey: HKEY;Path: String): String;
var
 aRegistry : TRegistry;
 aPath     : String;
 aValue    : String;
begin
 if aKey=0 then regSplitFullPath(Path,aKey);
 aRegistry:=TRegistry.Create;
 try
  with aRegistry do begin
   RootKey:=aKey;
   regParsePath(Path, aPath, aValue);
   OpenKey(aPath,true);
   Result:=ReadString(aValue);
  end;
 finally
  aRegistry.Free;
 end;
end;

procedure regWriteString(aKey: HKEY;Path,Value: String);
var
 aRegistry : TRegistry;
 aPath     : String;
 aValue    : String;
begin
 if aKey=0 then regSplitFullPath(Path,aKey);
 aRegistry:=TRegistry.Create;
 try
  with aRegistry do begin
   RootKey:=aKey;
   regParsePath(Path, aPath, aValue);
   OpenKey(aPath,True);
   WriteString(aValue,Value);
  end;
 finally
  aRegistry.Free;
 end;
end;

procedure regDelValue(aKey: hKey;Path: String);
var
 aRegistry : TRegistry;
 aPath     : String;
 aValue    : String;
begin
 if aKey=0 then regSplitFullPath(Path,aKey);
 aRegistry:=TRegistry.Create;
 try
  with aRegistry do begin
   RootKey:=aKey;
   regParsePath(Path, aPath, aValue);
   OpenKey(aPath,True);
   DeleteValue(aValue);
  end;
 finally
  aRegistry.Free;
 end;
end;

function regInfoString(const sParam: String): String;
var
 aKey : hKey;
begin
 Result:='';
 if RegOpenKeyEx(HKEY_LOCAL_MACHINE,REG_CURRENT_VERSION,0,KEY_READ,aKey)=ERROR_SUCCESS
 then begin
  Result:=regReadString(aKey,sParam);
  RegCloseKey(aKey);
 end;
end;

function regOwner: String;
begin
 Result:=regInfoString(REG_OWNER);
end;

function regCompany: String;
begin
 Result:=regInfoString(REG_COMPANY);
end;

function regComputerName: String;
var
 aKey : hKey;
begin
 Result:='';
 if RegOpenKeyEx(HKEY_LOCAL_MACHINE,REG_COMPUTERNAME_PATH,0,KEY_READ,aKey)=ERROR_SUCCESS then
 begin
  Result:=regReadString(aKey,REG_COMPUTERNAME);
  RegCloseKey(aKey);
 end;
end;

function regPathToRootKey(sPath:string):HKey;
var
 i:integer;
begin
 sPath:=UpperCase(sPath);
 Result:=0;
 for i:=0 to Reg_Root_Last do begin
  if pos(Reg_Root_Names[i],sPath)=1 then begin
   Result:=Reg_Root_Keys[i];
   break;
  end;
 end;
end;

function regRootKeyToName(RootKey:HKey):string;
var
 i:integer;
begin
 Result:='';
 for i:=0 to Reg_Root_Last do begin
  if Reg_Root_Keys[i]=RootKey then begin
   Result:=Reg_Root_Names[i];
   break;
  end;
 end;
end;

procedure regSplitFullPath(var Path:string;var RootKey:HKey);{    RootKey and Path}
var
 i:integer;
 UpPath:string;
begin
 UpPath:=UpperCase(Path);
 for i:=0 to Reg_Root_Last do begin
  if pos(Reg_Root_Names[i],UpPath)=1 then begin
   RootKey:=Reg_Root_Keys[i];
   Delete(Path,1,length(Reg_Root_Names[i])+1);
   break;
  end;
 end;
end;

{system utils}
function GetprocessorType:integer;
{constants defined in windows;result may be:
PROCESSOR_INTEL_386
PROCESSOR_INTEL_486
PROCESSOR_INTEL_PENTIUM
Windows NT only: PROCESSOR_MIPS_R4000
Windows NT only: PROCESSOR_ALPHA_21064}
var
 sysInfo:PSystemInfo;
begin
 getmem(sysInfo,sizeof(sysinfo^));
 GetSystemInfo(sysInfo^);
 Result:=sysInfo^.dwProcessorType;
 freemem(sysInfo,sizeof(sysinfo^));
end;

function GetCPUSpeed: double;
{  }
const DelayTime = 500; //    
var TimerHi, TimerLo: DWORD;
    PriorityClass, Priority: integer;
begin
  PriorityClass := GetPriorityClass(GetCurrentProcess);
  Priority := GetThreadPriority(GetCurrentThread);
  SetPriorityClass(GetCurrentProcess, REALTIME_PRIORITY_CLASS);
  SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_TIME_CRITICAL);
  Sleep(10);
  asm
    dw 310Fh // rdtsc
    mov TimerLo, eax
    mov TimerHi, edx
  end;
  Sleep(DelayTime);
  asm
    dw 310Fh // rdtsc
    sub eax, TimerLo
    sbb edx, TimerHi
    mov TimerLo, eax
    mov TimerHi, edx
  end;
  SetThreadPriority(GetCurrentThread, Priority);
  SetPriorityClass(GetCurrentProcess, PriorityClass);
  Result := TimerLo / (1000.0 * DelayTime);
end;

function GetBIOSDate: string;
 { BIOS}
type Ts=array[0..7] of char;
var s:TS;
    p:^TS;
begin
  p:=@s;
  asm
    push esi
    push edi
    push ecx
    mov esi,$0ffff5
    mov edi,p
    mov cx,8
@@1:mov al,[esi]
    mov [edi],al
    inc edi
    inc esi
    loop @@1
    pop ecx
    pop edi
    pop esi
  end;
  setstring(result,s,8);
end;

procedure GetEnvironmentStrings(ss:TStrings);
 { }
var ptr: PChar;
    s: string;
    Done: boolean;
begin
  ptr := windows.GetEnvironmentStrings;
  Done := FALSE;
  s:='';
  ss.Clear;
  while not Done do begin
    if ptr^ = #0 then begin
      inc(ptr);
      if ptr^ = #0 then
        Done := TRUE
      else
       ss.Add(s);
       s:=ptr^;
    end else
      s:=s+ptr^;
    inc(ptr);
  end;
end;

function GetFirstCDROM:string;
 {  1-  CD-ROM   }
var
 w:dword;
 Root:string;
 i:integer;
begin
 w:=GetLogicalDrives;
 Root:='#:\';
 for i:=0 to 25 do begin
  Root[1] := Char(Ord('A')+i);
  if (W and (1 shl i))>0
  then if GetDriveType(Pchar(Root)) = DRIVE_CDROM then begin
   Result:=Root[1];
   exit;
  end;
 end;
 Result:='';
end;

function GetVolumeInfoFVS(const Dir:string;var FileSystemName,VolumeName:string;var Serial:longint):boolean;
var
 root:pchar;
 res:longbool;
 VolumeNameBuffer,FileSystemNameBuffer:pchar;
 VolumeNameSize,FileSystemNameSize:DWord;
 VolumeSerialNumber,MaximumComponentLength,FileSystemFlags:DWORD;
 s:string;
begin
 s:=copy(Dir,1,3);
 root:=pchar(s);
 getMem(VolumeNameBuffer,256);
 getMem(FileSystemNameBuffer,256);
 VolumeNameSize:=255;
 FileSystemNameSize:=255;
 res:=GetVolumeInformation(Root,VolumeNameBuffer,VolumeNameSize
 ,@VolumeSerialNumber,
 MaximumComponentLength, FileSystemFlags
 ,FileSystemNameBuffer,FileSystemNameSize);
 Result:=res;
 VolumeName:=VolumeNameBuffer;
 FileSystemName:=FileSystemNameBuffer;
 Serial:=VolumeSerialNumber;
 freeMem(VolumeNameBuffer,256);
 freeMem(FileSystemNameBuffer,256);
end;

procedure GetDriveRoots(list:TStrings;Types:array of integer;doInclude:boolean);
{Types-/   ;
 Types=[-1]  doInclude=false -    
 Types=[DRIVE_FIXED]  doInclude=false -    
0	The drive type cannot be determined.
1	The root directory does not exist.
DRIVE_REMOVABLE	The drive can be removed from the drive.
DRIVE_FIXED	The disk cannot be removed from the drive.
DRIVE_REMOTE	The drive is a remote (network) drive.
DRIVE_CDROM	The drive is a CD-ROM drive.
DRIVE_RAMDISK	The drive is a RAM disk.
}
var
 DriveType:UInt;
 D,i:byte;
 DriveRoot:string;
 foundEx,foundInc:boolean;
begin
 list.Clear;
 for D:=0 to 25 do begin
  if DriveByteExists(D) then begin
   DriveRoot:=DriveByteToRoot(D);
   DriveType:=GetDriveType(PChar(DriveRoot));
   foundEx:=false;
   foundInc:=false;
   for i:=0 to High(Types) do begin
    if Types[i]=DriveType then foundInc:=true
    else FoundEx:=true;
   end;
   if (doInclude and foundInc)
   or ((doInclude=false) and FoundEx)
   then list.add(DriveRoot);
  end;
 end;
end;

function EmptyDir(const Dir: string;Delete:boolean): Boolean;
var
 FileInfo: TSearchRec;
 DosCode: Integer;
 Path:string;
begin
 Result := DirectoryExists(Dir);
 if Result=false then exit;
 Path:=NormalPath(Dir);
 DosCode := FindFirst(Path + '*.*', faAnyFile, FileInfo);
 try
  while DosCode = 0 do begin
   if (FileInfo.Name[1] <> '.') and (FileInfo.Attr <> faVolumeID) then begin
    if (FileInfo.Attr and faDirectory = faDirectory)
    then Result := EmptyDir(Path + FileInfo.Name,Delete) and Result
    else if (FileInfo.Attr and faVolumeID <> faVolumeID) then begin
     if (FileInfo.Attr and faReadOnly = faReadOnly)
     then FileSetAttr(Path + FileInfo.Name, faArchive);
     Result := DeleteFile(Path + FileInfo.Name) and Result;
    end;
   end;
   DosCode := FindNext(FileInfo);
  end;
  if Delete and Result and (DosCode = 18) and not ((Length(Path) = 2) and (Path[2] = ':'))
  then begin
   RmDir(Path);
   Result := (IOResult = 0) and Result;
  end;
 finally
  FindClose(FileInfo);
 end;
end;

function GetPathLevel(Path:string):integer;
//  '\'  
// GetPathLevel('C:\dir1\subdir2\')=3
var
 i:integer;
Begin
 result:=0;
 for i:=1 to length(Path) do begin
  if Path[i]='\' then inc(Result);
 end;
End;

procedure GetDirFiles(FileNames:TStrings;const Path:string);
var
 Found:integer;
 SRec:TSearchRec;
begin
 FileNames.Clear;
 Found:=FindFirst(Path+'*.*',faAnyFile,SRec);
 try
  while Found=0 do begin
   if ((SRec.Attr and faDirectory)=0) and (SRec.Name<>'.')
   then FileNames.Add(Path+SRec.Name);
   Found:=FindNext(SRec);
  end;
 finally
  FindClose(SRec);
 end;
end;

procedure GetPathList(LS:TStrings;Dir:string);
var
 Found,iMax,i,PathLevel,CurPathLevel:Integer;
 SRec:TSearchRec;
 isNotFound:boolean;
Begin
 Dir:=PathToDir(Dir);
 LS.Clear;
 if not DirectoryExists(Dir) then exit;
 Dir:=NormalPath(Dir);
 LS.Add(Dir);
 Found:=FindFirst(Dir+'*.*',faAnyFile,SRec);
 try
  while Found=0 do begin
   if ((SRec.Attr and faDirectory)<>0) and (SRec.Name[1]<>'.')
   then LS.Add(Dir+SRec.Name+'\');
   Found:=FindNext(SRec);
  end;
 finally
  FindClose(SRec);
 end;
 PathLevel:=GetPathLevel(Dir)+1;
 repeat
  isNotFound:=true;
  iMax:=LS.Count-1;
  for i:=0 to iMax do begin
   CurPathLevel:=GetPathLevel(LS[i]);
   if CurPathLevel<>PathLevel then continue;
   Found:=FindFirst(LS[i]+'*.*',faDirectory,SRec);
   try
    while Found=0 do begin
     if ((SRec.Attr and faDirectory)<>0) and (SRec.Name[1]<>'.')then begin
      LS.Add(LS[i]+SRec.Name+'\');
      isNotFound:=false;
     end;
     Found:=FindNext(SRec);
    end;
   finally
    FindClose(SRec);
   end;
  end;{for i:=0 to Count}
  inc(PathLevel);
 until isNotFound;
End;

function CompareFiles(Filename1,FileName2:string):longint;
 {   ;
  0 -   ,
 -1 -   1
 -2 -   2
 -3 -  }
const
 sz_Buffer=16384;
var
 F1,F2:TFileStream;
 i:longint;
 pBuff1,pBuff2:PByteArray;
 BytesRead1,BytesRead2:integer;
begin
 Result:=0;
 try
  F1:=TFileStream.Create(FileName1,fmShareDenyNone);
 except
  Result:=-1;
  exit;
 end;
 try
  F2:=TFileStream.Create(FileName2,fmShareDenyNone);
 except
  Result:=-2;
  F1.Free;
  exit;
 end;
 GetMem(pBuff1, sz_Buffer);
 GetMem(pBuff2, sz_Buffer);
 try
  if F1.Size>F2.Size then Result:=F2.Size+1
  else if F1.Size<F2.Size then Result:=F1.Size+1
  else begin
   while (F1.size>F1.Position) and (Result=0) do begin
    BytesRead1 :=F1.Read(pBuff1^,sz_Buffer);
    BytesRead2 :=F2.Read(pBuff2^,sz_Buffer);
    if (BytesRead1=BytesRead2) then begin
     for i:= 0 to BytesRead1-1 do begin
      if pBuff1^[i]<>pBuff2^[i]
      then begin
       result:=F1.Position-BytesRead1+i+1;
       break;
      end;
     end;
    end else begin
     Result:=-3;
     break;
    end;
   end;
  end;
 except
  Result:=-3;
 end;
 F1.Free;
 F2.Free;
 FreeMem(pBuff1,sz_Buffer);
 FreeMem(pBuff2,sz_Buffer);
end;

function CountFileSum(FileName:string;Method:integer):integer;
//Method:
//0:sum of bytes
//1:sum with shl
//2:xor with shl
const
 sz_Buffer=16384;
var
 f:TFileStream;
 Buff:PByteArray;
 BytesRead,i: integer;
begin
 Result:=0;
 getmem(Buff,sz_Buffer);
 f:=TFileStream.Create(FileName,fmOPenRead+fmShareDenyNone);
 repeat
  BytesRead :=f.Read(Buff^,sz_Buffer);
  if BytesRead > 0 then begin
   case Method of
   0:begin
    for i := 0 to BytesRead - 1 do begin
     Result:=Result+Buff^[i];
    end;
   end;1:begin
    for i := 0 to BytesRead - 1 do begin
     Result:=Result+(Result shl 1)+Buff^[i];
    end;
   end;2:begin
    for i := 0 to BytesRead - 1 do begin
     Result:=(Result+(Result shl 1)) xor Buff^[i];
    end;
   end;end;{case}
  end;
 until BytesRead = 0;
 freemem(Buff,sz_Buffer);
 f.Free;
end;

procedure AddSearchFiles(Dir:string;Mask:string;MinSize,MaxSize:longint;ssFileList:TStrings);
// Mask is '*.wav;borl*.*'
var
 Found,iMax,i,j,iMask:Integer;
 SRec:TSearchRec;
 SL,ListMask:TStringList;
 doAdd:boolean;
Begin
 SL:=TStringList.Create;
 ListMask:=TStringList.Create;
 GetPathList(SL,Dir);
 SplitString(Mask,';',ListMask);
 if Dir='' then SL.Add('');
 iMax:=SL.Count-1;
 iMask:=ListMask.Count-1;
 for i:=0 to iMax do Begin
  for j:=0 to iMask do Begin
   Found:=FindFirst(SL[i]+ListMask[j],faAnyFile,SRec);
   try
    while Found=0 do begin
     doAdd:=false;
     if ((SRec.Attr and (faDirectory+faVolumeID))=0) then begin
      if (MinSize>=0)and(MaxSize>=0)
      then doAdd:=(SRec.Size>=MinSize) and (SRec.Size<=MaxSize)
      else if (MinSize>=0) then doAdd:=(SRec.Size>=MinSize)
      else if (MaxSize>=0) then doAdd:=(SRec.Size<=MaxSize)
      else doAdd:=true;
     end;
     if doAdd then begin
      if Dir='' then ssFileList.Add(ExtractFilePath(ListMask[j])+SRec.Name)
      else ssFileList.Add(SL[i]+SRec.Name);
     end;
     Found:=FindNext(SRec);
    end;
   finally
    FindClose(SRec);
   end;
  end;{j}
 end;
 SL.Free;
 ListMask.Free;
End;

function DeleteFiles(Dir:string;Mask:string):boolean;
var
 ssFiles:TStringList;
 Path:string;
 s:string;
 i:integer;
begin
 Dir:=PathToDir(Dir);
 Path:=NormalPath(Dir);
 Result:=true;
 ssFiles:=TStringList.Create;
 AddSearchFiles(Dir,Mask,-1,-1,ssFiles);
 for i:=0 to ssFiles.Count-1 do begin
  s:=ssFiles[i];
  deletefile(s);
  if fileexists(s) then Result:=false;
 end;
 ssFiles.Free;
end;

function CopyFiles(SourceDir,DestDir:string;Mask,NewName:string):boolean;
{NewName without ext}
var
 ssFiles:TStringList;
 DestPath:string;
 s1,s2:string;
 i:integer;
begin
 DestPath:=NormalPath(DestDir);
 Result:=true;
 ssFiles:=TStringList.Create;
 AddSearchFiles(PathToDir(SourceDir),Mask,-1,-1,ssFiles);
 for i:=0 to ssFiles.Count-1 do begin
  s1:=ssFiles[i];
  if NewName='' then s2:=DestPath+extractFileName(s1)
  else s2:=DestPath+NewName+ExtractFileExt(s1);
  if copyfile(pchar(s1),pchar(s2),false)=false then Result:=false;
 end;
 ssFiles.Free;
end;

end.
