unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,winamp, ExtCtrls, Buttons, ComCtrls, Menus;

type
  TForm1 = class(TForm)
    od: TOpenDialog;
    pnPlayer: TPanel;
    btForward5s: TSpeedButton;
    btPause: TSpeedButton;
    btNext: TSpeedButton;
    btRewind5s: TSpeedButton;
    btPrev: TSpeedButton;
    btPlay: TSpeedButton;
    btStop: TSpeedButton;
    btOpenFiles: TSpeedButton;
    tbPosition: TTrackBar;
    lbPos: TLabel;
    Timer1: TTimer;
    btMore: TSpeedButton;
    pmMore: TPopupMenu;
    pmOpenLocation: TMenuItem;
    pmAbout: TMenuItem;
    pmPlayFiles: TMenuItem;
    pmPreferences: TMenuItem;
    pmToggle: TMenuItem;
    pmToggleEQ: TMenuItem;
    pmToggleStayOnTop: TMenuItem;
    pmTogglePlayList: TMenuItem;
    tbPanning: TTrackBar;
    tbVolume: TTrackBar;
    cbTrack: TComboBox;
    lbTrack: TLabel;
    pmVersion: TMenuItem;
    btAddFiles: TButton;
    btListClear: TButton;
    cbVisible: TCheckBox;
    btOpen: TButton;
    btClose: TButton;
    btChangeExeFile: TButton;
    odExe: TOpenDialog;
    btHideAll: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btPlayClick(Sender: TObject);
    procedure btPauseClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
    procedure btPrevClick(Sender: TObject);
    procedure btNextClick(Sender: TObject);
    procedure btRewind5sClick(Sender: TObject);
    procedure btForward5sClick(Sender: TObject);
    procedure btOpenFilesClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure pmOpenLocationClick(Sender: TObject);
    procedure pmAboutClick(Sender: TObject);
    procedure btMoreMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure tbPositionChange(Sender: TObject);
    procedure pmPlayFilesClick(Sender: TObject);
    procedure pmPreferencesClick(Sender: TObject);
    procedure pmToggleEQClick(Sender: TObject);
    procedure pmTogglePlayListClick(Sender: TObject);
    procedure pmToggleStayOnTopClick(Sender: TObject);
    procedure tbPanningChange(Sender: TObject);
    procedure tbVolumeChange(Sender: TObject);
    procedure cbTrackChange(Sender: TObject);
    procedure pmVersionClick(Sender: TObject);
    procedure btStopMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btAddFilesClick(Sender: TObject);
    procedure btListClearClick(Sender: TObject);
    procedure cbVisibleClick(Sender: TObject);
    procedure btOpenClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure btChangeExeFileClick(Sender: TObject);
    procedure btHideAllClick(Sender: TObject);
  private
  public
   ws:TWinamp;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
 ws:=TWinamp.Create(Self);
 ws.AutoClose:=false;
end;

procedure TForm1.btPlayClick(Sender: TObject);
begin
 ws.Open;
 ws.Play;
end;

procedure TForm1.btPauseClick(Sender: TObject);
begin
 ws.Pause;
end;

procedure TForm1.btStopClick(Sender: TObject);
begin
 ws.Stop;
end;

procedure TForm1.btPrevClick(Sender: TObject);
begin
 ws.Back;
end;

procedure TForm1.btNextClick(Sender: TObject);
begin
 ws.Next;
end;

procedure TForm1.btRewind5sClick(Sender: TObject);
begin
 ws.Back;
end;

procedure TForm1.btForward5sClick(Sender: TObject);
begin
 ws.Step;
end;

procedure TForm1.btOpenFilesClick(Sender: TObject);
begin
 ws.PlayFilesDlg;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
 ti:TAMPTrackInfo;
 ListCount,i:integer;
 ilen,ipos:integer;
begin
 lbPos.Caption:=ws.GetPositionStr(true);
 ilen:=ws.TrackLength*1000;
 ipos:=ws.Position;
 if ilen>=0 then tbPosition.Max:=ilen;
 if ipos>=0 then tbPosition.Position:=ipos;
 ti:=ws.TrackInfo;
 lbTrack.Caption:=format('Track%d (%s) %dkbps %dkHz',
 [ws.ListPosition+1,SecundTimeToStr(ti.Length), ti.Bitrate,
 ti.Samplerate]);
 ListCount:=ws.ListCount;
 if ListCount<>cbTrack.Items.Count then begin
  cbTrack.Items.Clear;
  for i:=0 to ListCount-1 do begin
   cbTrack.Items.Add('Track'+inttostr(i+1));
  end;
 end;
 if cbTrack.Focused=false then cbTrack.ItemIndex:=ws.ListPosition;
 cbVisible.Checked:=ws.Visible;
end;

procedure TForm1.pmOpenLocationClick(Sender: TObject);
begin
 ws.OpenLocationDlg;
end;

procedure TForm1.pmAboutClick(Sender: TObject);
begin
 ws.AboutDlg;
end;

procedure TForm1.btMoreMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
 pt:TPoint;
begin
 GetCursorPos(pt);
 pmMore.Popup(pt.x,pt.y);
end;

procedure TForm1.tbPositionChange(Sender: TObject);
begin
 ws.Position:=tbPosition.Position;
end;

procedure TForm1.pmPlayFilesClick(Sender: TObject);
begin
 ws.PlayFilesDlg;
end;

procedure TForm1.pmPreferencesClick(Sender: TObject);
begin
 ws.PreferencesDlg;
end;

procedure TForm1.pmToggleEQClick(Sender: TObject);
begin
 ws.ToggleEQ;
end;

procedure TForm1.pmTogglePlayListClick(Sender: TObject);
begin
 ws.ToggleList;
end;

procedure TForm1.pmToggleStayOnTopClick(Sender: TObject);
begin
 ws.ToggleStayOnTop;
end;

procedure TForm1.tbPanningChange(Sender: TObject);
begin
 ws.Panning:=tbPanning.Position;
end;

procedure TForm1.tbVolumeChange(Sender: TObject);
begin
 ws.Volume:=tbVolume.Position;
end;

procedure TForm1.cbTrackChange(Sender: TObject);
begin
 ws.Stop;
 ws.ListPosition:=cbTrack.ItemIndex;
 ws.Play;
end;

procedure TForm1.pmVersionClick(Sender: TObject);
begin
 showmessage('Winamp version '+ws.VersionStr);
end;

procedure TForm1.btStopMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 if ssShift in Shift then ws.StopFadeOut;
end;

procedure TForm1.btAddFilesClick(Sender: TObject);
begin
 if od.Execute then begin
  ws.AddFiles(od.Files);
 end;
end;

procedure TForm1.btListClearClick(Sender: TObject);
begin
 ws.ListClear;
end;

procedure TForm1.cbVisibleClick(Sender: TObject);
begin
 ws.Visible:=cbVisible.Checked;
end;

procedure TForm1.btOpenClick(Sender: TObject);
begin
 ws.Open;
end;

procedure TForm1.btCloseClick(Sender: TObject);
begin
 ws.Close;
end;

procedure TForm1.btChangeExeFileClick(Sender: TObject);
begin
 odExe.FileName:=ws.ExeFile;
 if odExe.Execute then begin
  if ws.ExeFile<>odExe.FileName then begin
   ws.ExeFile:=odExe.FileName;
   ws.Close;
   ws.Open;
  end;
 end;
end;

procedure TForm1.btHideAllClick(Sender: TObject);
begin
 ws.HideAll;
end;

end.

