unit edparam;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Grids,edtext,Menus,ivvcl,ivkernel;

type
  TfmEditParams = class(TForm)
    Grid: TStringGrid;
    Panel1: TPanel;
    Panel2: TPanel;
    btOk: TButton;
    btCancel: TButton;
    btAsText: TButton;
    pmMenu: TPopupMenu;
    pmDeleteRow: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure GridKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btAsTextClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure pmDeleteRowClick(Sender: TObject);
  private
  public
   ssParams:TStrings;
   procedure StringsToGrid(ss:TStrings);
   procedure GridToStrings(ss:TStrings);
  end;

var
  fmEditParams: TfmEditParams;

function EditParams(ss:Tstrings;ACaption,GridTitle1,GridTitle2:string):boolean;
procedure gridDeleteRow(Grid:TstringGrid);
implementation

{$R *.DFM}

function EditParams(ss:Tstrings;ACaption,GridTitle1,GridTitle2:string):boolean;
var
 f:TfmEditParams;
begin
 f:=TfmEditParams.Create(Application);
 if Acaption<>'' then f.Caption:=Acaption;
 if GridTitle1<>'' then f.Grid.Cells[0,0]:=GridTitle1;
 if GridTitle2<>'' then f.Grid.Cells[1,0]:=GridTitle2;
 f.ssParams:=ss;
 f.StringsToGrid(ss);
 Result:=(f.ShowModal=mrOk);
 f.Free;
end;

procedure gridDeleteRow(Grid:TstringGrid);
var
 i,j:integer;
begin
 if (Grid.Row<Grid.FixedRows)or(Grid.Row>=Grid.RowCount)then exit;
 if Grid.RowCount>Grid.FixedRows+1  then begin
  for i:=grid.Row+1 to grid.RowCount-1 do begin
   for j:=0 to Grid.ColCount-1 do begin
    grid.cells[j,i-1]:=grid.cells[j,i];
    grid.Objects[j,i-1]:=grid.Objects[j,i];
   end;
  end;
 Grid.RowCount:=Grid.RowCount-1;
 end else begin
  i:=Grid.Row;
  for j:=0 to Grid.ColCount-1 do begin
   grid.cells[j,i]:='';
   grid.Objects[j,i]:=nil;
  end;
 end;
end;

procedure TfmEditParams.StringsToGrid(ss:TStrings);
var
 i:integer;
 s:string;
begin
 if ss.Count>0 then Grid.RowCount:=ss.Count+1
 else Grid.RowCount:=2;
 for i:=0 to ss.Count-1 do begin
  s:=ss.Names[i];
  Grid.Cells[0,i+1]:=s;
  Grid.Cells[1,i+1]:=ss.Values[s];
 end;
 if ss.Count=0 then begin
  Grid.Cells[0,1]:='';
  Grid.Cells[1,1]:='';
 end;
end;

procedure TfmEditParams.GridToStrings(ss:TStrings);
var
 i,j:integer;
 s,s1:string;
 ssc:TStringList;
begin
 ssc:=TStringList.Create;//   
 for i:=1 to Grid.RowCount-1 do begin
  Grid.cells[0,i]:=trim(Grid.cells[0,i]);
  Grid.cells[1,i]:=trim(Grid.cells[1,i]);
  ssc.Add(UpperCaseRus(Grid.cells[0,i]));
 end;
 for i:=0 to ssc.Count-1 do begin
  s:=ssc[i];
  for j:=i+1 to ssc.Count-1 do begin
   if AnsiCompareText(ssc[j],s)=0 then begin
    ssc.Free;
    raise Exception.Create('   '+Grid.cells[0,i+1]+'  '+Grid.cells[0,j+1]);
   end;
  end;
 end;
 ssc.Free;
 ss.Clear;
 for i:=1 to Grid.RowCount-1 do begin
  s1:=Grid.cells[0,i];
  if s1='' then continue;
  if (pos('=',s1)<>0)or(pos('=',Grid.cells[1,i])<>0) then raise Exception.Create('   "="');
  s:=s1+'='+Grid.cells[1,i];
  ss.Add(s);
 end;
end;

procedure TfmEditParams.FormCreate(Sender: TObject);
begin
 Grid.Cells[0,0]:='';
 Grid.Cells[1,0]:='';
 frmLeftCenterToMouse(Self);
end;

procedure TfmEditParams.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
 if ModalResult=mrOk then GridToStrings(ssParams);
end;

procedure TfmEditParams.GridKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 case Key of
 VK_DOWN,VK_NEXT:begin
  if Grid.Row=Grid.RowCount-1 then Grid.RowCount:=Grid.RowCount+1;
 end;end;
end;

procedure TfmEditParams.btAsTextClick(Sender: TObject);
var
 ssText:TStringList;
begin
 ssText:=TStringList.Create;
 GridToStrings(ssText);
 if EditText(ssText,'') then StringsToGrid(ssText);
 ssText.Free;
end;

procedure TfmEditParams.FormActivate(Sender: TObject);
begin
 frmLeftCenterToMouse(Self); 
end;

procedure TfmEditParams.pmDeleteRowClick(Sender: TObject);
begin
 gridDeleteRow(Grid);
end;

end.
