unit edtext;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Grids;

type
  TfmEditText = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    btOk: TButton;
    btCancel: TButton;
    Memo: TMemo;
    btLoad: TButton;
    btSave: TButton;
    od: TOpenDialog;
    sd: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure btLoadClick(Sender: TObject);
    procedure btSaveClick(Sender: TObject);
  private
  public
  end;

var
  fmEditText: TfmEditText;

function EditText(ss:Tstrings;ACaption:string):boolean;
procedure FormToMouseLeftCenter(f:TCustomForm);

implementation

{$R *.DFM}

procedure FormToMouseLeftCenter(f:TCustomForm);
var
 p:TPoint;
 w,h:integer;
begin
 getCursorPos(p);
 w:=f.Width;
 h:=f.Height;
 p.y:=p.y-H div 2;
 if p.x<0 then p.x:=0;
 if p.y<0 then p.y:=0;
 if p.x+W>Screen.Width then p.x:=Screen.Width-W;
 if p.y+H>Screen.Height then p.y:=Screen.Height-H;
 f.Left:=p.x;
 f.Top:=p.y;
end;

function EditText(ss:Tstrings;ACaption:string):boolean;
var
 f:TfmEditText;
begin
 f:=TfmEditText.Create(Application);
 FormToMouseLeftCenter(f);
 if Acaption<>'' then f.Caption:=Acaption;
 if ss<>nil then f.Memo.Lines.assign(ss);
 Result:=(f.ShowModal=mrOk);
 if (Result)and(ss<>nil) then ss.Assign(f.Memo.Lines);
 f.Free;
end;


procedure TfmEditText.FormCreate(Sender: TObject);
begin
 FormToMouseLeftCenter(self);
end;

procedure TfmEditText.btLoadClick(Sender: TObject);
begin
 if od.execute then memo.lines.loadfromfile(od.filename);
end;

procedure TfmEditText.btSaveClick(Sender: TObject);
begin
 if sd.execute then memo.lines.SaveToFile(sd.filename);
end;

end.
