unit ivvcl;
(*
(C) Victor P.Ivlichev 1999
*)
interface

uses
 windows,sysutils,controls,forms,inifiles,shellapi;

procedure frmLeftCenterToMouse(f:TCustomForm);
procedure frmCenterToMouse(f:TCustomForm);
procedure frmLeftUpToMouse(f:TCustomForm);
procedure frmFitTray(f:TCustomForm;Traydelta:integer);
procedure StartWait;
procedure StopWait;
function ExecuteFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
function ExecuteFileWait(CmdLine,CurrentDirectory:string):boolean;{    ,   }

implementation

procedure StartWait;
begin
 Screen.Cursor:=-11;//crHourGlass;
 Application.ProcessMessages;
end;

procedure StopWait;
begin
 Screen.Cursor:=0;//crDefault;
 Application.ProcessMessages;
end;

procedure frmLeftCenterToMouse(f:TCustomForm);
var
 p:TPoint;
 w,h:integer;
begin
 getCursorPos(p);
 w:=f.Width;
 h:=f.Height;
 p.y:=p.y-H div 2;
 if p.x<30 then p.x:=30;
 if p.y<30 then p.y:=30;
 if p.x+W+30>Screen.Width then p.x:=Screen.Width-W-30;
 if p.y+H+30>Screen.Height then p.y:=Screen.Height-H-30;
 f.Left:=p.x;
 f.Top:=p.y;
end;

procedure frmLeftUpToMouse(f:TCustomForm);
var
 p:TPoint;
 w,h:integer;
begin
 getCursorPos(p);
 w:=f.Width;
 h:=f.Height;
// p.y:=p.y-H div 2;
 if p.x<30 then p.x:=30;
 if p.y<30 then p.y:=30;
 if p.x+W+30>Screen.Width then p.x:=Screen.Width-W-30;
 if p.y+H+30>Screen.Height then p.y:=Screen.Height-H-30;
 f.Left:=p.x;
 f.Top:=p.y;
end;

procedure frmCenterToMouse(f:TCustomForm);
var
 p:TPoint;
 w,h:integer;
begin
 getCursorPos(p);
 w:=f.Width;
 h:=f.Height;
 p.y:=p.y-H div 2;
 p.x:=p.x-W div 2;
 if p.x<30 then p.x:=30;
 if p.y<30 then p.y:=30;
 if p.x+W+30>Screen.Width then p.x:=Screen.Width-W-30;
 if p.y+H+30>Screen.Height then p.y:=Screen.Height-H-30;
 f.Left:=p.x;
 f.Top:=p.y;
end;
(*
procedure gridDeleteRow(Grid:TstringGrid);
var
 i,j:integer;
begin
 if (Grid.Row<Grid.FixedRows)or(Grid.Row>=Grid.RowCount)then exit;
 if Grid.RowCount>Grid.FixedRows+1  then begin
  for i:=grid.Row+1 to grid.RowCount-1 do begin
   for j:=0 to Grid.ColCount-1 do begin
    grid.cells[j,i-1]:=grid.cells[j,i];
    grid.Objects[j,i-1]:=grid.Objects[j,i];
   end;
  end;
 Grid.RowCount:=Grid.RowCount-1;
 end else begin
  i:=Grid.Row;
  for j:=0 to Grid.ColCount-1 do begin
   grid.cells[j,i]:='';
   grid.Objects[j,i]:=nil;
  end;
 end;
end;
*)

procedure frmFitTray(f:TCustomForm;Traydelta:integer);
const
 def_TraySize=30;
var
 h:Thandle;
 TrayRect:Trect;
 trWidth,trHeight:integer;
begin
 h:=(FindWindow('Shell_TrayWnd', nil));
 if windows.getwindowrect(h,TrayRect) then begin
  with TrayRect do begin
   trWidth:=Right-Left+TrayDelta;
   trHeight:=Bottom-Top+TrayDelta;
  end;
  if TrayRect.Top>0
  then f.SetBounds(0,0,Screen.Width,Screen.Height-(trHeight)){bottom}
  else if Trayrect.right < screen.width
  then f.SetBounds(trWidth,0,Screen.Width-trWidth,Screen.Height){left}
  else if Trayrect.bottom < screen.height
  then f.SetBounds(0,trHeight,Screen.Width,Screen.Height-trHeight){top}
  else f.SetBounds(0,0,Screen.Width-(trWidth),Screen.Height){right};
 end else begin
  trWidth:=def_TraySize+TrayDelta;
  f.SetBounds(trWidth,trWidth,Screen.Width-trWidth*2,Screen.Height-trWidth*2);
 end;
end;
(*
procedure frmFitDownTray(f:TCustomForm;Traydelta:integer);
const
 def_TraySize=30;
var
 h:Thandle;
 TrayRect,BR:Trect;
 trWidth,trHeight:integer;
begin
 h:=(FindWindow('Shell_TrayWnd', nil));
 if windows.getwindowrect(h,TrayRect) then begin
  with TrayRect do begin
   trWidth:=Right-Left+TrayDelta;
   trHeight:=Bottom-Top+TrayDelta;
  end;
  if TrayRect.Top>0
  then BR:=Rect(0,0,Screen.Width,Screen.Height-(trHeight)){bottom}
  else if Trayrect.right < screen.width
  then BR:=Rect(trWidth,0,Screen.Width-trWidth,Screen.Height){left}
  else if Trayrect.bottom < screen.height
  then BR:=Rect(0,trHeight,Screen.Width,Screen.Height-trHeight){top}
  else BR:=Rect(0,0,Screen.Width-(trWidth),Screen.Height){right};
 end else begin
  trWidth:=def_TraySize+TrayDelta;
  BR:=Rect(trWidth,trWidth,Screen.Width-trWidth*2,Screen.Height-trWidth*2);
 end;
 if (f.Width>BR.Right-BR.Left) then
end;
*)
function ExecuteFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..MAX_PATH*2] of Char;
begin
  Result := ShellExecute(Application.MainForm.Handle, nil,
    StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
    StrPCopy(zDir, DefaultDir), ShowCmd);
end;

function ExecuteFileWait(CmdLine,CurrentDirectory:string):boolean;
var
 si:TStartupInfo;
 pi:TProcessInformation;
 pCurrentDirectory:pchar;
begin
 if CurrentDirectory<>'' then pCurrentDirectory:=pchar(CurrentDirectory)
 else pCurrentDirectory:=nil;
 ZeroMemory(@si,sizeof(si));
 si.cb:=SizeOf(si);
 if not CreateProcess( nil, // No module name (use command line).
  PChar(cmdline),  // Command line.
  nil,             // Process handle not inheritable.
  nil,             // Thread handle not inheritable.
  False,           // Set handle inheritance to FALSE.
  0,               // No creation flags.
  nil,             // Use parent's environment block.
  pCurrentDirectory,// **Use parent's starting directory.
  si,              // Pointer to STARTUPINFO structure.
  pi )             // Pointer to PROCESS_INFORMATION structure.
 then begin
  Result:=false;//        ShowMessage( 'CreateProcess failed.' );
  Exit;
 end;
 WaitForSingleObject( pi.hProcess, INFINITE );
 CloseHandle( pi.hProcess );
 CloseHandle( pi.hThread );
 Result:=true;//      ShowMessage('Done !');
end;

end.
