unit main;
(*
(C) Victor P.Ivlichev 1999
*)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,comobj,
  StdCtrls, Menus, ComCtrls,edParam,cnsword,cnsexcel, ExtCtrls;

type
  TfmMain = class(TForm)
    PageControl: TPageControl;
    tsExcel: TTabSheet;
    tsCalculator: TTabSheet;
    MainMenu: TMainMenu;
    mnFile: TMenuItem;
    mnFileNew: TMenuItem;
    mnFileOpen: TMenuItem;
    mnFileClose: TMenuItem;
    mnFileBreak1: TMenuItem;
    mnFileSave: TMenuItem;
    mnFileSaveAs: TMenuItem;
    mnFileBreak2: TMenuItem;
    mnFileExit: TMenuItem;
    mnFileBreak3: TMenuItem;
    mnFilePreview: TMenuItem;
    mnFilePrint: TMenuItem;
    mnEdit: TMenuItem;
    mnEditCut: TMenuItem;
    mnEditCopy: TMenuItem;
    mnEditPaste: TMenuItem;
    mnEditBreak1: TMenuItem;
    mnEditClear: TMenuItem;
    mnEditClearAll: TMenuItem;
    mnEditClearFormats: TMenuItem;
    mnEditClearContents: TMenuItem;
    mnEditClearNotes: TMenuItem;
    mnEditDeleteSheet: TMenuItem;
    mnInsert: TMenuItem;
    mnInsertSheet: TMenuItem;
    mnInsertHyperLink: TMenuItem;
    mnInsertHint: TMenuItem;
    mnFormat: TMenuItem;
    mnFormatCell: TMenuItem;
    mnFormatSheet: TMenuItem;
    mnFormatSheetRename: TMenuItem;
    mnFormatSheetHide: TMenuItem;
    mnFormatSheetShow: TMenuItem;
    cbExcelVisible: TCheckBox;
    Label1: TLabel;
    edSheetsInNewWorkbook: TEdit;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    cbExcelDisplayAlerts: TCheckBox;
    cbWorkBooks: TComboBox;
    lbWorkBooks: TLabel;
    lbSheets: TLabel;
    cbSheets: TComboBox;
    edExpr1: TEdit;
    Label2: TLabel;
    btCalcExpr1: TButton;
    lbResExpr1: TLabel;
    Label3: TLabel;
    edExpr2: TEdit;
    lbResExpr2: TLabel;
    btCalcExpr2: TButton;
    Label5: TLabel;
    edExpr3: TEdit;
    btCalcExpr3: TButton;
    lbResExpr3: TLabel;
    tsExamples: TTabSheet;
    btExample1: TButton;
    btExample2: TButton;
    btExample3: TButton;
    btExample5: TButton;
    Panel1: TPanel;
    btExcelStart: TButton;
    btExcelConnect: TButton;
    btDisConnect: TButton;
    btExcelQuit: TButton;
    btExample4: TButton;
    mnEditSelectAll: TMenuItem;
    tsCell: TTabSheet;
    Label4: TLabel;
    edCellRow: TEdit;
    UpDownCellRow: TUpDown;
    Label6: TLabel;
    edCellCol: TEdit;
    UpDown1: TUpDown;
    lbCellAddress: TLabel;
    procedure btExample1Click(Sender: TObject);
    procedure btCalcExpr1Click(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
    procedure btExcelStartClick(Sender: TObject);
    procedure btExcelQuitClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cbExcelVisibleClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btExcelConnectClick(Sender: TObject);
    procedure mnFileNewClick(Sender: TObject);
    procedure mnFileOpenClick(Sender: TObject);
    procedure mnFileCloseClick(Sender: TObject);
    procedure mnFileSaveClick(Sender: TObject);
    procedure mnFileSaveAsClick(Sender: TObject);
    procedure mnFilePreviewClick(Sender: TObject);
    procedure mnFilePrintClick(Sender: TObject);
    procedure mnFileExitClick(Sender: TObject);
    procedure mnEditCutClick(Sender: TObject);
    procedure mnEditCopyClick(Sender: TObject);
    procedure mnEditPasteClick(Sender: TObject);
    procedure mnEditClearAllClick(Sender: TObject);
    procedure mnEditClearFormatsClick(Sender: TObject);
    procedure mnEditClearNotesClick(Sender: TObject);
    procedure mnEditClearContentsClick(Sender: TObject);
    procedure mnEditDeleteSheetClick(Sender: TObject);
    procedure cbExcelDisplayAlertsClick(Sender: TObject);
    procedure btDisConnectClick(Sender: TObject);
    procedure mnInsertSheetClick(Sender: TObject);
    procedure mnFormatSheetRenameClick(Sender: TObject);
    procedure mnFormatSheetShowClick(Sender: TObject);
    procedure mnFormatSheetHideClick(Sender: TObject);
    procedure mnFormatCellClick(Sender: TObject);
    procedure cbWorkBooksChange(Sender: TObject);
    procedure cbSheetsChange(Sender: TObject);
    procedure btCalcExpr2Click(Sender: TObject);
    procedure btCalcExpr3Click(Sender: TObject);
    procedure edExpr1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edExpr2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edExpr3KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btExample2Click(Sender: TObject);
    procedure btExample3Click(Sender: TObject);
    procedure btExample5Click(Sender: TObject);
    procedure btExample4Click(Sender: TObject);
    procedure mnEditSelectAllClick(Sender: TObject);
    procedure UpDownCellRowClick(Sender: TObject; Button: TUDBtnType);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure edCellColKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edCellRowKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
   Excel:variant;
   isConnected:boolean;
  public
   procedure RefreshInfo;
   procedure RefreshCellInfo;
  end;

var
  fmMain: TfmMain;

function CalcExcel(arg:string):string;

implementation

uses vlist;

{$R *.DFM}

(*var
 WorkBook:variant;*)

function CalcExcel(arg:string):string;
var
 XL, WorkBook, Sheet: Variant;
 svAlerts:boolean;
begin
 XL:= CreateOleObject('Excel.Application');
 WorkBook := Xl.WorkBooks.Add;
 Sheet := WorkBook.WorkSheets[1];
 if pos('=',arg)<>1 then arg:='='+arg;
 Sheet.Cells[1,1].formula:=arg;
 Result:=Sheet.Cells[1,1].value;
 svAlerts:=XL.DisplayAlerts;
 XL.DisplayAlerts:=false;
 XL.QUIT;
 XL.DisplayAlerts:=svAlerts;
 XL:=unassigned;
end;


function VarTypeStr(const v:variant):string;
var
 vt:integer;
begin
 vt:=VarType(v);
 case vt of
 varEmpty:Result:='Empty';
 varNull:Result:='Null';
 varSmallint:Result:='Smallint';
 varInteger:Result:='Integer';
 varSingle:Result:='Single';
 varDouble:Result:='Double';
 varCurrency:Result:='Currency';
 varDate:Result:='Date';
 varOleStr:Result:='OleStr';
 varDispatch:Result:='Dispatch';
 varError:Result:='Error';
 varBoolean:Result:='Boolean';
 varVariant:Result:='Variant';
 varUnknown:Result:='Unknown';
 varByte:Result:='Byte';
 varString:Result:='String';
 else Result:='VarType'+inttostr(vt and varTypeMask)
 end;{of}
 if (vt and varArray)<>0 then Result:=Result+'+Array';
 if (vt and varByRef)<>0 then Result:=Result+'+ByRef';
end;

function VarToStrL(const v:variant):string;
begin
 try
  Result:=vartostr(v)+': '+VarTypeStr(v);
 except
  Result:='N/A:'+VarTypeStr(v);
 end;
end;

procedure TfmMain.RefreshInfo;
var
 ok:boolean;
 i,iLast:integer;
 v,v1,vActiveWorkBook:variant;
 idx:integer;
begin
 ok:=VarIsEmpty(Excel)=false;
 btExcelQuit.Enabled:=ok;
 PageControl.Enabled:=ok;
 for i:=0 to Mainmenu.Items.Count-1 do MainMenu.Items[i].Enabled:=ok;
 if ok then begin
  if PageControl.ActivePage=tsExcel then begin
   cbExcelVisible.Checked:=Excel.Visible;
   cbExcelDisplayAlerts.Checked:=Excel.DisplayAlerts;
   edSheetsInNewWorkbook.Text:=Excel.SheetsInNewWorkbook;
   cbWorkBooks.items.clear;
   cbSheets.Items.Clear;
   iLast:=Excel.WorkBooks.Count;
   lbWorkBooks.Caption:='WorkBooks ('+inttostr(iLast)+')';
   vActiveWorkBook:=Excel.ActiveWorkBook;
   idx:=-1;
   for i:=1 to iLast do begin
    v:=Excel.WorkBooks[i];
    cbWorkBooks.Items.Add(v.Name);
    if TVarData(v).VDispatch=TVarData(vActiveWorkBook).VDispatch then idx:=i-1;
   end;
   cbWorkBooks.ItemIndex:=idx;
   if VarIsEmpty(vActiveWorkBook)=false then begin
    lbSheets.Caption:='Sheets ('+inttostr(iLast)+')';
    iLast:=vActiveWorkBook.Sheets.Count;
    for i:=1 to iLast do begin
     cbSheets.Items.Add(vActiveWorkBook.Sheets[i].Name);
    end;
    v1:=vActiveWorkBook.ActiveSheet;
    if VarIsEmpty(v1)=false then cbSheets.ItemIndex:=v1.Index-1;
   end;
  end;
 end;
end;

procedure TfmMain.RefreshCellInfo;
var
 Sheet,Cell:variant;
 Col,Row:integer;
 s:string;
begin
 Sheet:=Excel.ActiveSheet;
 if VarIsEmpty(Sheet)=true then begin
  showmessage('Sheet no found');
  exit;
 end;
 Col:=strtoint(edCellCol.Text);
 Row:=strtoint(edCellRow.Text);
 cell:=Sheet.Cells[Row,Col];
 s:=cell.Address;
 lbCellAddress.caption:='Address='+s;
end;

procedure TfmMain.btExample1Click(Sender: TObject);
var
 WorkBook, Sheet: Variant;
 Col, Row,iRow : Integer;
 s:string;
begin
 Excel.SheetsInNewWorkbook := 1;
 WorkBook := Excel.WorkBooks.Add;
 Sheet := WorkBook.WorkSheets[1];
 Sheet.Cells.VerticalAlignment := $FFFFEFF4;// xlCenter
 Sheet.Name:='Fill Cells';
 Row := 2;
 Sheet.Rows[Row].Font.Bold := True;
 inc(Row,2);
 Sheet.Rows[Row].Font.Bold := True;
 for Col := 1 to 10 do begin
  Sheet.Cells[Row, Col] := 'Column'+inttostr(Col);
 end;
 inc(Row);
 for iRow:=1 to 10 do begin
  for Col := 1 to 10 do begin
   s:=format('iRow=%d iCol=%d',[Row,Col]);
   Sheet.Cells[Row, Col]:=s;
  end;
  Inc(Row);
 end;
 Sheet.Cells.Columns.AutoFit;
 Sheet.Cells[2, 2] := 'Data Created at '+datetostr(now);
end;

procedure TfmMain.btCalcExpr1Click(Sender: TObject);
begin
 lbResExpr1.Caption:=calcexcel(edExpr1.text);
end;

procedure TfmMain.PageControlChange(Sender: TObject);
begin
 RefreshInfo;
end;

procedure TfmMain.btExcelStartClick(Sender: TObject);
begin
 Excel:=UnAssigned;
 Excel:=CreateOleObject('Excel.Application');
 Excel.Visible:=cbExcelVisible.Checked;
 Excel.DisplayAlerts:=false;
 Excel.WorkBooks.Add;
 isConnected:=false;
 RefreshInfo;
 SetForegroundWindow(Handle);
end;

procedure TfmMain.btExcelQuitClick(Sender: TObject);
begin
 try
  Excel.Quit;
 finally
  Excel:=Unassigned;
 end;
 RefreshInfo;
end;

procedure TfmMain.FormDestroy(Sender: TObject);
begin
 if (isConnected=false) and (VarIsEmpty(Excel)=false)then Excel.Quit;
 Excel:=Unassigned;
end;

procedure TfmMain.cbExcelVisibleClick(Sender: TObject);
begin
 Excel.Visible:=cbExcelVisible.Checked;
 SetForegroundWindow(Handle);
end;

procedure TfmMain.FormActivate(Sender: TObject);
begin
 RefreshInfo;
end;

procedure TfmMain.btExcelConnectClick(Sender: TObject);
var
 Excel1:variant;
begin
 try
  Excel1:=GetActiveOleObject('Excel.Application');
  Excel:=Unassigned;
  Excel1:=Unassigned;
  Excel:=GetActiveOleObject('Excel.Application');
  isConnected:=true;
 except
  Excel:=Unassigned;
  showmessage('Active Excel not found');
 end;
 RefreshInfo;
 SetForegroundWindow(Handle);
end;

procedure TfmMain.mnFileNewClick(Sender: TObject);
var
 SheetsInNewWorkbook:integer;
begin
 SheetsInNewWorkbook:=strtoint(edSheetsInNewWorkbook.Text);
 if (SheetsInNewWorkbook<1)or(SheetsInNewWorkbook>255)then begin
  raise Exception.Create('SheetsInNewWorkbook must be from 1 to 255');
 end;
 Excel.SheetsInNewWorkbook:=strtoint(edSheetsInNewWorkbook.Text);
 Excel.WorkBooks.Add;
 RefreshInfo;
end;

procedure TfmMain.mnFileOpenClick(Sender: TObject);
begin
 if OpenDialog.Execute then begin
  Excel.WorkBooks.Open(OpenDialog.FileName);
  RefreshInfo;
 end;
end;

procedure TfmMain.mnFileCloseClick(Sender: TObject);
var
 book:variant;
begin
 book:=Excel.ActiveWorkBook;
 if VarIsEmpty(book)=false then book.Close;
 RefreshInfo;
end;

procedure TfmMain.mnFileSaveClick(Sender: TObject);
var
 book:variant;
begin
 book:=Excel.ActiveWorkBook;
 if VarIsEmpty(book)=false then book.Save;
end;

procedure TfmMain.mnFileSaveAsClick(Sender: TObject);
var
 book:variant;
begin
 book:=Excel.ActiveWorkBook;
 if (VarIsEmpty(book)=false)then begin
  SaveDialog.FileName:=book.FullName;
  if (SaveDialog.Execute) then book.SaveAs(SaveDialog.FileName);
  RefreshInfo;
 end;
end;

procedure TfmMain.mnFilePreviewClick(Sender: TObject);
var
 sheet:variant;
begin
 sheet:=Excel.ActiveSheet;
 if VarIsEmpty(Sheet)=false then begin
  Sheet.PrintPreview;
 end;
end;

procedure TfmMain.mnFilePrintClick(Sender: TObject);
var
 sheet:variant;
begin
 sheet:=Excel.ActiveSheet;
 if VarIsEmpty(Sheet)=false then begin
  Sheet.PrintOut;
 end;
end;

procedure TfmMain.mnFileExitClick(Sender: TObject);
begin
 Close;
end;

procedure TfmMain.mnEditCutClick(Sender: TObject);
begin
 Excel.Selection.Cut;
end;

procedure TfmMain.mnEditCopyClick(Sender: TObject);
begin
 Excel.Selection.Copy;
end;

procedure TfmMain.mnEditPasteClick(Sender: TObject);
begin
 Excel.ActiveSheet.PasteSpecial;
end;

procedure TfmMain.mnEditClearAllClick(Sender: TObject);
begin
 Excel.Selection.Clear;
end;

procedure TfmMain.mnEditClearFormatsClick(Sender: TObject);
begin
 Excel.Selection.ClearFormats;
end;

procedure TfmMain.mnEditClearNotesClick(Sender: TObject);
begin
 Excel.Selection.ClearNotes;
end;

procedure TfmMain.mnEditClearContentsClick(Sender: TObject);
begin
 Excel.Selection.ClearContents;
end;

procedure TfmMain.mnEditDeleteSheetClick(Sender: TObject);
var
 sheet:variant;
 book:variant;
begin
 sheet:=Excel.ActiveSheet;
 if VarIsEmpty(Sheet)=false then begin
  book:=Excel.ActiveWorkBook;
  if book.Sheets.Count<=1 then showmessage('Not allowed delete last sheet')
  else Sheet.Delete;
 end;
 RefreshInfo;
end;

procedure TfmMain.cbExcelDisplayAlertsClick(Sender: TObject);
begin
 Excel.DisplayAlerts:=cbExcelDisplayAlerts.Checked;
end;

procedure TfmMain.btDisConnectClick(Sender: TObject);
begin
 Excel:=Unassigned;
 RefreshInfo;
end;

procedure TfmMain.mnInsertSheetClick(Sender: TObject);
var
 book:variant;
begin
 book:=Excel.ActiveWorkBook;
 if VarIsEmpty(book)=false then book.Worksheets.add
 else showmessage('ActiveWorkBook needed');
 RefreshInfo;
end;

procedure TfmMain.mnFormatSheetRenameClick(Sender: TObject);
var
 Sheet:variant;
 SheetName:string;
 idx:integer;
begin
 Sheet:=Excel.ActiveSheet;
 SheetName:=Sheet.Name;
 idx:=Sheet.Index;
 if InputQuery('Rename Sheet',format('Sheet(%d) Name',[idx]),SheetName)
 then Sheet.Name:=SheetName;
 RefreshInfo;
end;

procedure TfmMain.mnFormatSheetShowClick(Sender: TObject);
var
 book:variant;
 i:integer;
 SheetName:string;
begin
 book:=Excel.ActiveWorkBook;
 if VarIsEmpty(book)then exit;
 fmList:=TfmList.Create(Application);
 fmList.Caption:='Select hidden sheets';
 for i:=1 to book.Sheets.Count do begin
  if book.Sheets[i].Visible=false
  then fmList.ListBox.Items.Add(book.Sheets[i].Name);
 end;
 if fmList.ListBox.Items.Count>0 then begin
  if fmList.ShowModal=mrOk then begin
   for i:=0 to fmList.ListBox.Items.Count-1 do begin
    if fmList.ListBox.Selected[i] then begin
     SheetName:=fmList.ListBox.Items[i];
     book.Sheets[SheetName].Visible:=true;
    end;
   end;
  end;
 end else showmessage('Hidden sheets not found');
 fmList.Free;
 RefreshInfo;
end;

procedure TfmMain.mnFormatSheetHideClick(Sender: TObject);
var
 Sheet:variant;
begin
 Sheet:=Excel.ActiveSheet;
 Sheet.Visible:=false;
 RefreshInfo;
end;

procedure TfmMain.mnFormatCellClick(Sender: TObject);
var
 Range,v:variant;
 ss:TStringList;
begin
 Range:=Excel.Selection;
 ss:=TStringList.Create;
 v:=Range.Address;
 ss.Add('Address='+VarToStrL(v));
 ss.Add('AddressLocal='+VarToStrL(Range.AddressLocal));
 ss.Add('Application='+VarToStrL(Range.Application));
 ss.Add('Areas='+VarToStrL(Range.Areas));
 ss.Add('Borders='+VarToStrL(Range.Borders));
 ss.Add('Cells='+VarToStrL(Range.Cells));
 ss.Add('Characters='+VarToStrL(Range.Characters));
 ss.Add('Column='+VarToStrL(Range.Column));
 ss.Add('Columns='+VarToStrL(Range.Columns));
 ss.Add('ColumnWidth='+VarToStrL(Range.ColumnWidth));
 ss.Add('Comment='+VarToStrL(Range.Comment));
 if EditParams(ss,'Cells Properties','Prameter','Value')then begin

 end;
 ss.Free;
end;

procedure TfmMain.cbWorkBooksChange(Sender: TObject);
var
 s:string;
begin
 if cbWorkBooks.ItemIndex>=0 then begin
  s:=cbWorkBooks.Text;
  Excel.WorkBooks[s].Activate;
 end;
end;

procedure TfmMain.cbSheetsChange(Sender: TObject);
var
 s:string;
begin
 if cbSheets.ItemIndex>=0 then begin
  s:=cbSheets.Text;
  Excel.ActiveWorkBook.Sheets[s].Activate;
 end;
end;

procedure TfmMain.btCalcExpr2Click(Sender: TObject);
begin
 lbResExpr2.Caption:=calcexcel(edExpr2.text);
end;

procedure TfmMain.btCalcExpr3Click(Sender: TObject);
begin
 lbResExpr3.Caption:=calcexcel(edExpr3.text);
end;

procedure TfmMain.edExpr1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key=VK_RETURN then btCalcExpr1Click(Sender);
end;

procedure TfmMain.edExpr2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key=VK_RETURN then btCalcExpr2Click(Sender);
end;

procedure TfmMain.edExpr3KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key=VK_RETURN then btCalcExpr3Click(Sender);
end;

procedure TfmMain.btExample2Click(Sender: TObject);
var
 WorkBook,Sheet,Cell: Variant;
 Col,iRow,Row : Integer;
 cl:integer;
 s:string;
begin
 WorkBook:=Excel.WorkBooks.Add;
 Sheet:=WorkBook.WorkSheets[1];
 Sheet.Name:='Colors';
 Row:=1;
 Sheet.Cells[Row,1]:='Red';
 Sheet.Cells[Row,2]:='Green';
 Sheet.Cells[Row,3]:='Blue';
 Sheet.Cells[Row,4]:='Color Sum';
 Sheet.Rows[Row].Font.Bold:=true;
 for iRow:=0 to 8 do begin
  Row:=iRow+2;
  if iRow<8 then cl:=iRow*32 else cl:=$FF;
  for Col:=1 to 3 do begin
   Cell:=Sheet.Cells[Row,Col];
   Cell.Value:=cl;
   if Col=1 then Cell.Font.Color:=cl//red
   else if Col=2 then Cell.Font.Color:=cl*256//green
   else Cell.Font.Color:=cl*256*256;//blue
  end;
  Cell:=Sheet.Cells[Row,4];
  s:=format('=A%d+256*B%d+256*256*C%d',[Row,Row,Row]);
  Cell.Formula:=s;
  Cell.Font.Color:=Cell.Value;
 end;
 Sheet.Cells.Columns.AutoFit;
end;

procedure TfmMain.btExample3Click(Sender: TObject);
var
 WorkBook,Sheet,Cell: Variant;
 iRow,Row : Integer;
 NPaletteColors:integer;
begin
 WorkBook:=Excel.WorkBooks.Add;
 Sheet:=WorkBook.WorkSheets[1];
 Sheet.Name:='Palette';
 Row:=1;
 Sheet.Cells[Row,1]:='Index';
 Sheet.Cells[Row,2]:='Color';
 Sheet.Cells[Row,3]:='RGB';
 Sheet.Rows[Row].Font.Bold:=true;
 NPaletteColors:=56;{WorkBook.Colors;}
 for iRow:=1 to NPaletteColors do begin
  Row:=iRow+2;
  Cell:=Sheet.Cells[Row,1];
  Cell.Value:=iRow;
  Cell:=Sheet.Cells[Row,2];
  Cell.Interior.ColorIndex:=iRow;
  Sheet.Cells[Row,3]:='0x'+inttohex(WorkBook.Colors[iRow],6);
 end;
 Sheet.Cells.Columns.AutoFit;
end;

procedure TfmMain.btExample5Click(Sender: TObject);
var
 WorkBook,Sheet1,Sheet2,Chart:variant;
 Sheet,SeriesCollection:Variant;
 vrange:variant;
 WD,WordDocument,wRange,Shape:variant;
 i,j:integer;
begin
 Excel.SheetsInNewWorkbook := 2;
 WorkBook:=Excel.Workbooks.Add;
 Sheet1:=WorkBook.WorkSheets[1];
 Sheet2:=WorkBook.WorkSheets[2];
 Chart:=WorkBook.Charts.Add;
 Sheet1.Name:='Table 1';
 Sheet2.Name:='Table 2';
 for j:=1 to 2 do begin
  Sheet:=WorkBook.WorkSheets[j];
  for i:=1 to 11 do begin
   Sheet.Cells.Item[i,1].Value:=i;
   Sheet.Cells.Item[i,2].Value:=i*2;
  end;
 end;
 vrange:=Sheet1.range['A1:A10'];
 SeriesCollection:=Chart.SeriesCollection;
 SeriesCollection.Add(vrange);
 vrange:=Sheet2.Range['B1:B10'];
 SeriesCollection.Add(vrange);
 Chart.Select;
 Excel.Selection.Copy;
 WD:=CreateOleObject('Word.Application');
 WordDocument:=WD.Documents.Add;
 if Chart.PageSetup.Orientation=xlLandscape
 then WordDocument.PageSetup.Orientation:=wdOrientLandscape
 else WordDocument.PageSetup.Orientation:=wdOrientPortrait;
 for i:=1 to 5 do begin
  WordDocument.Paragraphs.Add;
 end;
 wRange:=WordDocument.Range(0,1);
 wRange.Paste;
 Shape:=WordDocument.Shapes.Item(WordDocument.Shapes.Count);
 Shape.Height:=round(0.75*Shape.Height);
 wRange:=WordDocument.Range(2,2);
 wRange.Text:='Chart From Excel ';
 WD.visible:=true;
 WD:=unassigned;
end;

procedure TfmMain.btExample4Click(Sender: TObject);
var
 WorkBook,Sheet1,Sheet2,Chart:variant;
 Sheet,SeriesCollection:Variant;
 vrange:variant;
 i,j:integer;
begin
 Excel.SheetsInNewWorkbook := 2;
 WorkBook:=Excel.Workbooks.Add;
 Sheet1:=WorkBook.WorkSheets[1];
 Sheet2:=WorkBook.WorkSheets[2];
 Chart:=WorkBook.Charts.Add;
 Sheet1.Name:='Table 1';
 Sheet2.Name:='Table 2';
 for j:=1 to 2 do begin
  Sheet:=WorkBook.WorkSheets[j];
  for i:=1 to 11 do begin
   Sheet.Cells.Item[i,1].Value:=i;
   Sheet.Cells.Item[i,2].Value:=i*2;
  end;
 end;
 vrange:=Sheet1.range['A1:A10'];
 SeriesCollection:=Chart.SeriesCollection;
 SeriesCollection.Add(vrange);
 vrange:=Sheet2.Range['B1:B10'];
 SeriesCollection.Add(vrange);
end;

procedure TfmMain.mnEditSelectAllClick(Sender: TObject);
var
 sheet:variant;
begin
 sheet:=Excel.ActiveSheet;
 showmessage(inttostr(sheet.Type));
 if sheet.Type=xlWorksheet then begin
  sheet.range['1:65536'].select;
 end else if (sheet.Type=xlExcel4MacroSheet)or (Sheet.type=xlChart) then begin
  sheet.select;
 end else showmessage('Unknown type');
end;

procedure TfmMain.UpDownCellRowClick(Sender: TObject; Button: TUDBtnType);
var
 i:integer;
begin
 i:=strtointdef(edCellRow.Text,1);
 if Button=btNext then begin
  inc(i);
 end else begin
  dec(i);
 end;
 if i<1 then i:=1;
 if i>65536 then i:=65536;
 edCellRow.Text:=inttostr(i);
 RefreshCellInfo;
end;

procedure TfmMain.UpDown1Click(Sender: TObject; Button: TUDBtnType);
var
 i:integer;
begin
 i:=strtointdef(edCellCol.Text,1);
 if Button=btNext then begin
  inc(i);
 end else begin
  dec(i);
 end;
 if i<1 then i:=1;
 if i>256 then i:=256;
 edCellCol.Text:=inttostr(i);
 RefreshCellInfo;
end;

procedure TfmMain.edCellColKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key=VK_RETURN then RefreshCellInfo;
end;

procedure TfmMain.edCellRowKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key=VK_RETURN then RefreshCellInfo;
end;

end.



