//
// HiCall, version 02.21
// Programmed by Dmitrii Zapaschikov and Ashod Apakian.
// (c) 1998,1999 Apakian pty.ltd, All rights reserved.
//
// Header file for HiCall
/////////////////////////////////////////////////////////////////////////////////////

#ifndef INC_HICALL
#define INC_HICALL

#ifndef INC_WINDOWS
#include <windows.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

 /*******************************************
  General defines
  *******************************************/

 typedef char             C;
 typedef unsigned char    B;
 typedef short            I;
 typedef unsigned short   W;
 typedef long             L;
 typedef unsigned long    H;
 typedef void             V;
 typedef float            F;
 typedef double           D;

 typedef char           * CP;
 typedef unsigned char  * BP;
 typedef short          * IP;
 typedef unsigned short * WP;
 typedef long           * LP;
 typedef unsigned long  * HP;
 typedef void           * VP;
 typedef float          * FP;
 typedef double         * DP;

 #define structure        typedef struct

 #define YES              1
 #define NO               0
 #define CANCELED         2
 #define UNKNOWN          3

 #define OK               0

 #define LOGICAL_AND      1
 #define LOGICAL_OR       2

 #define NOTEQUAL         1
 #define LESSER           2
 #define EQUALLESSER      3
 #define EQUAL            4
 #define EQUALGREATER     5
 #define GREATER          6

 #define F8               0xFF
 #define F16              0xFFFF
 #define F32              0xFFFFFFFF

 #define _1K              1024L
 #define _2K              2048L
 #define _4K              4096L
 #define _8K              8192L
 #define _16K             16384L
 #define _32K             32678L
 #define _64K             65536L
 #define _128K            131072L
 #define _256K            262144L
 #define _512K            524288L
 #define _1MEG            1048576L
 #define _2MEG            2097152L
 #define _4MEG            4194304L
 #define _8MEG            8388608L
 #define _16MEG           16777216L
 #define _32MEG           33554432L
 #define _64MEG           67108864L

 /*******************************************
  Macros
  *******************************************/

 #define Bool(arg)        (!(!(arg)))
 #define BitSet(arg,posn) ((arg) | (1L << (posn)))
 #define BitClr(arg,posn) ((arg) & ~(1L << (posn)))
 #define BitFlp(arg,posn) ((arg) ^ (1L << (posn)))
 #define BitTst(arg,posn) Bool((arg) & (1L << (posn)))

 #define Cast(type,obj)   (*((type*)(&(obj))))

 #define OOPS             HiCallWindowMessageBox(__FILE__,"Line number: %lu",__LINE__);

 /*******************************************
  Windows Platforms
  *******************************************/

 #define PLATFORM_WIN32S  0
 #define PLATFORM_WIN32   1
 #define PLATFORM_WIN32NT 2
 #define PLATFORM_UNKNOWN 0xffffffff

 /*******************************************
  Application entry and processing
  *******************************************/

 W HiCallVersion          (V);
CP HiCallEntry            (CP cmdLine);
 I HiCallMessageHandle    (V);
 V HiCallSleep            (W ms);
 B HiCallWindowsVersion   (HP major,HP minor,HP build,HP buildmajor,HP buildminor,HP platform);
 V HiCallGetScreenSize    (WP width,WP height);

 #define YIELD_BRK()           if ( !HiCallMessageHandle() ) break
 #define YIELD_RET(msg)        if ( !HiCallMessageHandle() ) return msg
 #define YIELD                 HiCallMessageHandle
 #define SlowCall(Hvar,cnt,f)  if ( ((Hvar++)%cnt)==0) f
 #define SlowBlock(Hvar,cnt)   if ( ((Hvar++)%cnt)==0)


 /*******************************************
  Memory managment
  *******************************************/

 #define STACKRET_NoProblem   0
 #define STACKRET_NotStack    1
 #define STACKRET_Limit       2
 #define STACKRET_BadSize     3

BP HiCallMemoryLock       (H bytes,B zeroflag,B onlyphysical);
 B HiCallMemoryFree       (BP memory);
 H HiCallMemoryAvailable  (V);
 V HiCallMemorySetBytes   (VP memory, H bytes, B value);
 V HiCallMemorySetWords   (VP memory, H words, W value);
 V HiCallMemorySetDwords  (VP memory, H dwords, H value);
 V HiCallMemoryCopyBytes  (VP dst, VP src, H bytes);
 V HiCallMemoryCopyWords  (VP dst, VP src, H words);
 V HiCallMemoryCopyDwords (VP dst, VP src, H dwords);
 V HiCallMemoryMoveBytes  (VP dst, VP src, H bytes);
 V HiCallMemoryMoveWords  (VP dst, VP src, H words);
 V HiCallMemoryMoveDwords (VP dst, VP src, H dwords);
 V HiCallMemoryPokeByte   (VP dst,B val);
 V HiCallMemoryPokeWord   (VP dst,W val);
 V HiCallMemoryPokeDword  (VP dst,H val);
 B HiCallMemoryPeekByte   (VP dst);
 W HiCallMemoryPeekWord   (VP dst);
 H HiCallMemoryPeekDword  (VP dst);
 H HiCallMemoryRangeByte  (VP mem,H skip,H next,H count,B op1,B val1,B logic,B op2,B val2,HP boff);
 H HiCallMemoryRangeWord  (VP mem,H skip,H next,H count,B op1,W val1,B logic,B op2,W val2,HP boff);
 H HiCallMemoryRangeDword (VP mem,H skip,H next,H count,B op1,H val1,B logic,B op2,H val2,HP boff);
 V HiCallMemoryZero       (VP mem,H bytes);
BP HiCallStackLock        (H bytes);
 I HiCallStackPush        (BP stackbuf,VP mem,H bytes);
 I HiCallStackPop         (BP stackbuf,VP mem,H bytes);
 I HiCallStackInfo        (BP stackbuf,HP size,HP remain);

 /*******************************************
  Window managment
  *******************************************/

 #define WIN_HIDE         0
 #define WIN_SHOW         1
 #define WIN_MAXIMIZE     2
 #define WIN_MINIMIZE     3
 #define WIN_RESTORE      4
 #define WIN_UNKNOWN      5

 #define FRAMETYPE_OFF    0
 #define FRAMETYPE_THIN   1
 #define FRAMETYPE_THICK  2

 V HiCallWindowSetTitlef  (CP text,...);
 B HiCallWindowGetTitle   (CP title,B maxlen);
 V HiCallWindowSet        (W x,W y,W width, W height);
 V HiCallWindowGet        (IP x,IP y,WP width,WP height);
 V HiCallWindowGetClientXY(WP clientx, WP clienty);
 V HiCallWindowSetClientXY(W clientx, W clienty);
 V HiCallWindowCentre     (V);
 V HiCallWindowShow       (B cmd);
 B HiCallWindowSee        (V);
 I HiCallWindowSystray    (B state, H resourceicon,B exitX,CP tooltip);
 I HiCallWindowSetIcon    (H resource);
 V HiCallWindowFlash      (V);
 V HiCallWindowFlashStop  (V);
 V HiCallWindowSetTool    (B flag);
 V HiCallWindowGetTool    (BP flag);
 V HiCallWindowSetFrame   (B type);
 B HiCallWindowFind       (CP windowtitle,HWND*handle);
 B HiCallWindowAttach     (CP windowtitle,HWND handle);
 B HiCallWindowKill       (CP windowtitle,HWND handle);
 B HiCallWindowActivate   (CP windowtitle,HWND handle);
 V HiCallWindowMessageBox (CP title,CP string,...);
 B HiCallWindowMessageYN  (CP title,CP string,...);
 V HiCallWindowAlwaysOnTop(B flag);
 V HiCallWindowCaret      (W x,W y,W width,W height,W speed,B state);
 B HiCallWindowPaths      (CP windowpath,W windowpathlen,CP systempath,W systempathlen);

 /*******************************************
  Graphic primitives
  *******************************************/

 #define UP               1
 #define DOWN             2
 #define LEFT             3
 #define RIGHT            4

 #define FONT4x8          0
 #define FONT8x8          1
 #define FONT8x16         2
 #define FONT16x8         3
 #define FONT16x16        4

 structure { B b,g,r,a; } _rgba;
 structure { H donepixels; _rgba RGBA[2048]; } _raster;
 structure { W frames,width,height; _rgba background; } _gifinfo;

BP HiCallVideoMakeSurface (W width,W height);
 V HiCallVideoUpdate      (W x1,W y1,W x2,W y2,B now);
 V HiCallVideoSetRgba     (B r,B g,B b,B a,_rgba*rgba);
 V HiCallVideoGetRgba     (BP r,BP g,BP b,BP a,_rgba*rgba);
 V HiCallVideoAdjustRgba  (B amount,B brightenflag,_rgba*rgba);
 V HiCallVideoCopyRgba    (_rgba*torgba,_rgba*fromrgba);
 V HiCallVideoPaste       (BP img,W imgwidth,W x1,W y1,W x2,W y2,W clientx,W clienty);
 V HiCallVideoSetDot      (BP img,W imgwidth,W x1,W y1,_rgba*rgba);
 V HiCallVideoGetDot      (BP img,W imgwidth,W x1,W y1,_rgba*rgba);
 V HiCallVideoFill        (BP img,W imgwidth,W x1,W y1,W x2,W y2,_rgba*rgba);
 V HiCallVideoLine        (BP img,W imgwidth,W x1,W y1,W x2,W y2,_rgba*rgba);
 V HiCallVideoRectangle   (BP img,W imgwidth,W x1,W y1,W x2,W y2,_rgba*rgba);
 V HiCallVideoButton      (BP img,W imgwidth,W x1,W y1,W x2,W y2,_rgba*face,B frameopacity,B pressed);
 V HiCallVideoScrollLeft  (BP img,W imgwidth,W x1,W y1,W x2,W y2,W pixels);
 V HiCallVideoScrollRight (BP img,W imgwidth,W x1,W y1,W x2,W y2,W pixels);
 V HiCallVideoScrollUp    (BP img,W imgwidth,W x1,W y1,W x2,W y2,W pixels);
 V HiCallVideoScrollDown  (BP img,W imgwidth,W x1,W y1,W x2,W y2,W pixels);
 V HiCallVideoString      (BP img,W imgwidth,W x1,W y1,_rgba*bg,_rgba*fg,B fontsize,BP string);
 V HiCallVideoStringf     (BP img,W imgwidth,W x1,W y1,_rgba*bg,_rgba*fg,B fontsize,BP string,...);
 V HiCallVideoPutImg      (BP img,W imgwidth,W x1,W y1,W imgW,W imgH,W newW,W newH,B hflip,B vflip,BP img2);
BP HiCallVideoCutImg      (BP img,W imgwidth,W x1,W y1,W width,W height);
 V HiCallVideoEllipse     (BP img,W imgwidth,W x1,W y1,W x2,W y2,_rgba*rgba);
 V HiCallVideoEllipseFill (BP img,W imgwidth,W x1,W y1,W x2,W y2,_rgba*rgba);
 V HiCallVideoEdge        (BP img,W imgwidth,W x1,W y1,W x2,W y2,B dir,_rgba*c1,_rgba*c2);
 V HiCallVideoRasterGrab  (BP img,W imgwidth,W x1,W y1,W x2,W y2,_raster*RASTER);
 V HiCallVideoRasterLine  (BP img,W imgwidth,W x1,W y1,W x2,W y2,_raster*RASTER);
 V HiCallVideoSetOpacity  (BP img,W imgwidth,W x1,W y1,W width,W height,B opacity);
BP HiCallVideoImg2Font    (BP img,W imgwidth,_rgba*color);
 V HiCallVideoFontString  (BP img,W imgwidth,W x1,W y1,BP font,BP string);
 V HiCallVideoFontStringf (BP img,W imgwidth,W x1,W y1,BP font,BP string,...);
 V HiCallVideoFontInfo    (BP font,WP width,WP height,BP string,...);
BP HiCallVideoFontCut     (BP font,WP width,WP height,B ch);
 V HiCallVideoSetArea     (B allowflag,W x1,W y1,W x2,W y2);
 B HiCallVideoGetArea     (BP allowflag,WP x1,WP y1,WP x2,WP y2);
 V HiCallVideoSplineMap   (W control[8],W numpoints,WP xpoints,WP ypoints);
BP HiCallVideoLoadGif     (CP filename,_gifinfo*GI);
BP HiCallVideoLoadGifRes  (H resource,_gifinfo*GI);
BP HiCallVideoGrabGifImg  (BP gif,W frame,WP width,WP height,WP x,WP y,HP delay);
BP HiCallVideoLoadBmp     (CP filename,WP width,WP height);
BP HiCallVideoLoadBmpRes  (H resource,WP width,WP height);
BP HiCallVideoLoadIcon    (CP filename,WP width,WP height);
BP HiCallVideoLoadIconRes (H resource,WP width,WP height);
BP HiCallVideoLoadPcx     (CP filename,WP width,WP height);
BP HiCallVideoLoadPcxRes  (H resource,WP width,WP height);


 /*******************************************
  Keyboard
  *******************************************/

 #define KBD_SHIFT_BIT    0x0800
 #define KBD_CTRL_BIT     0x0400
 #define KBD_ALT_BIT      0x0200
 #define KBD_VK_BIT       0x0100
 #define KBD_ASCII(ch)    ((ch) & 0xFF)
 #define KBD_SHIFT(ch)    ((ch) & KBD_SHIFT_BIT)
 #define KBD_CTRL(ch)     ((ch) & KBD_CTRL_BIT)
 #define KBD_ALT(ch)      ((ch) & KBD_ALT_BIT)
 #define KBD_VK(ch)       ((ch) & KBD_VK_BIT)

 W HiCallKeyboardGet      (V);
 V HiCallKeyboardClear    (V);
 W HiCallKeyboardHit      (V);
 V HiCallKeyboardStatus   (BP array256);

 /*******************************************
  Mouse
  *******************************************/

 #define LEFTBUTTON       1
 #define MIDDLEBUTTON     2
 #define RIGHTBUTTON      4

 structure
 {
 B reset;
 W x,y,px,py;
 B b,pb;
 B leftdraging;
 B middledraging;
 B rightdraging;
 }
 _mouse;

 B HiCallMouseStatus      (_mouse*MOUSE);
 B HiCallMouseCursor      (CP filename);
 B HiCallMouseCursorRes   (H resource);

 /*******************************************
  Audio
  *******************************************/

 #define AUDIORET_NoProblem     0
 #define AUDIORET_NotAvailable  1
 #define AUDIORET_InUse         2
 #define AUDIORET_NoFullDuplex  3
 #define AUDIORET_NotReady      4
 #define AUDIORET_OutOfMemory   5
 #define AUDIORET_Paused        6
 #define AUDIORET_Playing       7
 #define AUDIORET_Failed        8

 #define AUDIOSTOP        0
 #define AUDIO11M8        1
 #define AUDIO11M16       2
 #define AUDIO11S8        3
 #define AUDIO11S16       4
 #define AUDIO22M8        5
 #define AUDIO22M16       6
 #define AUDIO22S8        7
 #define AUDIO22S16       8
 #define AUDIO44M8        9
 #define AUDIO44M16       10
 #define AUDIO44S8        11
 #define AUDIO44S16       12

 structure
 {
 B PlayingMode;
 B RecordingMode;
 B MaxPlayBlocks;
 B MaxRecordBlocks;
 B CurrentPlayBlocks;
 B CurrentRecordBlocks;
 H PlaySamples;
 H RecordSamples;
 }
 _audiostatus;


 structure
 {
 B mode;
 H samples;
 H bytes;
 B channels;
 B bits;
 W hz;
 }
 _audioinfo;

 I HiCallAudioPlay        (B mode,B blockcount,W samples);
 I HiCallAudioRecord      (B mode,B blockcount,W samples);
 I HiCallAudioRecordStop  (V);
 I HiCallAudioPlayStop    (V);
 I HiCallAudioRead        (BP block);
 I HiCallAudioWrite       (BP block);
 I HiCallAudioStatus      (_audiostatus*AUDIOSTATUS);
 I HiCallAudioPlayPurge   (V);
 I HiCallAudioRecordPurge (V);
BP HiCallAudioLoadWave    (CP filename,_audioinfo*AI);
BP HiCallAudioLoadWaveRes (H resource,_audioinfo*AI);
 I HiCallAudioPlayPause   (B flag);
 H HiCallAudioPitch       (W rate,B spitch,B dpitch,B finetune);

 /*******************************************
  Video capture
  *******************************************/

 #define VIDCAPRET_NoProblem    0
 #define VIDCAPRET_NotReady     1
 #define VIDCAPRET_NotAvailable 2

 #define VIDCAP_NULLPREVIEW     0xffff,0xffff

 structure
 {
 B frame_ready;
 W x1,y1;
 W width,height;
 W fps;
 H frame_count;
 }
 _vidcapstatus;

 I HiCallVideoCaptureStart  (V);
 I HiCallVideoCaptureStop   (V);
 I HiCallVideoCaptureFormat (V);
 I HiCallVideoCaptureDisplay(V);
 I HiCallVideoCaptureSource (V);
 I HiCallVideoCaptureStatus (_vidcapstatus*VIDCAPSTATUS);
 I HiCallVideoCapturePreview(W x1,W y1,W fps);
BP HiCallVideoCaptureFrame  (WP width,WP height,HP framecount);
 I HiCallVideoCaptureSize   (W width,W height);

 /*******************************************
  Internet
  *******************************************/

 #define IPRET_NoProblem     0
 #define IPRET_NotStarted    1
 #define IPRET_PortBusy      2
 #define IPRET_NotFound      3
 #define IPRET_NoCalls       4
 #define IPRET_TableFull     5
 #define IPRET_NotConnected  6
 #define IPRET_BadPort       7
 #define IPRET_NotReady      8
 #define IPRET_BadAddress    9
 #define IPRET_Unknown       10
 #define IPRET_NotComplete   11

 #define TCP_INCOMING        1
 #define TCP_OUTGOING        2
 #define TCP_CONNECTED       3
 #define TCP_CLOSED          4

 #define DNS_INPROGRESS      0
 #define DNS_COMPLETED       1
 #define DNS_NOTFOUND        2
 #define DNS_FAILED          3

 structure
 {
 I status;
 H xmitsize;
 H rcvsize;
 H xmitcount;
 H rcvcount;
 H bytesin;
 H bytesout;
 }
 _tcpstatus;

 structure
 {
 W packetsin;
 W packetsout;
 H bytesin;
 H bytesout;
 }
 _udpstatus;

 structure
 {
 B status;
 B hostname[80];
 H ipaddress[64];
 }
 _dnsstatus;

 I HiCallGetIp            (HP myip);
 I HiCallIpAddressToBin   (BP ipadrs,HP binaddress);
 I HiCallBinToIpAddress   (H binaddress,BP ipadrs);

 I HiCallTcpCreatePort    (W port);
 I HiCallTcpDestroyPort   (W port);
 I HiCallTcpGetCalls      (W port, HP callid);
 I HiCallTcpAnswerCall    (H callid, H xmitsize, H rcvsize);
 I HiCallTcpDestroyCall   (H callid);
 I HiCallTcpStatus        (H callid, _tcpstatus *TCPSTATUS);
 I HiCallTcpMakeCall      (HP callid, H destip, W destport, W myport, H xmitsize, H rcvsize);
 I HiCallTcpRead          (H callid, W length, VP buffer);
 I HiCallTcpWrite         (H callid, W length, VP buffer);
 I HiCallTcpWritef        (H callid,BP string,...);
 I HiCallTcpNagleOption   (H callid, B enable);
 I HiCallTcpQueryCall     (H callid,HP ip,WP port);
 I HiCallTcpScan          (H call,BP scanfor,W scanlen,BP ch,WP rsv);

 I HiCallUdpCreatePort    (W port);
 I HiCallUdpDestroyPort   (W port);
 I HiCallUdpStatus        (W port, _udpstatus *UDPSTATUS);
 I HiCallUdpPurgeReceive  (W port, W size);
 I HiCallUdpPurgeTransmit (W port, W size);
 I HiCallUdpRead          (HP destip,WP destport,W port,WP length,VP buffer);
 I HiCallUdpWrite         (H  destip,W  destport,W port,W  length,VP buffer);

 I HiCallDnsForward       (BP hostname,IP handle);
 I HiCallDnsBackward      (H ipaddress,IP handle);
 I HiCallDnsCancel        (I handle);
 I HiCallDnsStatus        (I handle,_dnsstatus*DNS);

 /*******************************************
  File system
  *******************************************/

 #define FILERET_NoProblem          0
 #define FILERET_Failed             1
 #define FILERET_NotFound           2
 #define FILERET_UnknownDrive       3
 #define FILERET_OutOfBounds        4

 #define FILESEEK_START             FILE_BEGIN
 #define FILESEEK_CURRENT           FILE_CURRENT
 #define FILESEEK_END               FILE_END

 #define DISK_REMOVABLE             1
 #define DISK_HARD                  2
 #define DISK_NETWORK               3
 #define DISK_CD                    4
 #define DISK_RAM                   5

 structure
 {
 B archive,compressed,directory,hidden,normal,readonly,system,temporary;
 B fileday,filemonth,filedow;
 W fileyear;
 B filehour,fileminute,filesecond;
 B accessday,accessmonth,accessdow;
 W accessyear;
 B accesshour,accessminute,accessecond;
 B writeday,writemonth,writedow;
 W writeyear;
 B writehour,writeminute,writesecond;
 H size;
 H size64;
 C name[1024];
 C alternate[14];
 }
 _filefindinfo;


 structure
 {
 B type;
 H sectors_per_cluster;
 H bytes_per_sector;
 H free_clusters;
 H used_clusters;
 H total_clusters;
 C volume[256];
 H serial_number;
 H filename_length;
 C file_system[256];
 }
 _drveinfo;


 I HiCallFileCreate       (CP filename, HP handle);
 I HiCallFileOpen         (CP filename, HP handle);
 I HiCallFileClose        (H handle);
 I HiCallFileSizeByHandle (H handle, HP bytes);
 I HiCallFileSize         (CP filename,HP bytes);
 I HiCallFileWrite        (H handle, H bytes, VP data, HP done);
 I HiCallFileRead         (H handle, H bytes, VP data, HP done);
 I HiCallFileDelete       (CP filename);
 I HiCallFileCreateDir    (CP directory);
 I HiCallFileDeleteDir    (CP directory);
BP HiCallFileLoad         (CP filename, HP bytes);
BP HiCallFileLoadRes      (H resource,HP bytes);
BP HiCallFileLoadRandom   (CP filename,H startbyte,H endbyte,HP bytes);
 I HiCallFileLoadBuf      (CP filename,H maxbytes,VP buffer,HP bytes);
 I HiCallFileSave         (CP filename, H bytes, VP data);
 I HiCallFileExists       (CP filename);
 I HiCallFileSeek         (H handle,L offset,B seekmode,HP newoffset);
 H HiCallFileFindFirst    (CP filename,_filefindinfo*FILEFINDINFO);
 I HiCallFileFindNext     (H handle,_filefindinfo*FILEFINDINFO);
 I HiCallFileFindStop     (H handle);
 I HiCallDriveInfo        (CP drivepath,_drveinfo*drveinfo);
BP HiCallFileCreateFile   (CP filename,H size,B force);
 I HiCallFileSaveRandom   (CP filename,H startbyte,H endbyte,VP data,HP bytes);


 /*******************************************
  MilliSecond timer ( 1/1000th ) + TIME
  *******************************************/

 #define TIMER_1SECOND   1000
 #define TIMER_1MINUTE   60000
 #define TIMER_1HOUR     1440000
 #define TIMER_BPM(bpm)  (TIMER_1MINUTE/bpm)
 #define TIMER_PS(ps)    (TIMER_1SECOND/ps)

 extern CP Month[12],MonthEx[12],Day[7],DayEx[7];

 H HiCallTimerRead       (V);
 H HiCallTimerDifference (H previous);
 H HiCallTimerProfile    (HP seed,HP accumulator);


 /*******************************************
  Registry
  *******************************************/

 #define REGRET_NoProblem        0
 #define REGRET_Failed           1
 #define REGRET_BadSecurity      2

 #define REGSECURITY_READ        0
 #define REGSECURITY_WRITE       1
 #define REGSECURITY_READWRITE   2

 #define REGTYPE_BINARY          0
 #define REGTYPE_H               1
 #define REGTYPE_H_NONINTEL      2
 #define REGTYPE_EXPANDABLE      3
 #define REGTYPE_LINK            4
 #define REGTYPE_MULTISTRING     5
 #define REGTYPE_RAW             6
 #define REGTYPE_RESOURCELIST    7
 #define REGTYPE_STRING          8

 #define REG_LOCALMACHINE        ((H)HKEY_LOCAL_MACHINE)
 #define REG_CLASSESROOT         ((H)HKEY_CLASSES_ROOT)
 #define REG_USERS               ((H)HKEY_USERS)
 #define REG_CURRENTUSER         ((H)HKEY_CURRENT_USER)
 #define REG_DYNDATA             ((H)HKEY_DYN_DATA)
 #define REG_CURRENTCONFIG       ((H)HKEY_CURRENT_CONFIG)

 I HiCallRegistryOpen     (H key,BP subkey,B security,HP newkey);
 I HiCallRegistryClose    (H key);
 I HiCallRegistryCreate   (H key,BP subkey,B volatility,B security,HP newkey);
 I HiCallRegistryDelete   (H key,BP subkey);
 I HiCallRegistryFlush    (H key);
 I HiCallRegistryRead     (H key,BP valuename,HP type,BP buffer,H buffersize,HP requiredsize);
 I HiCallRegistryWrite    (H key,BP valuename,H type,BP buffer,H buffersize);
 I HiCallRegistryRemove   (H key,BP valuename);

 /*******************************************
  Events
  *******************************************/

 B HiCallEventAny        (V); 
 B HiCallEventSysPal     (V);
 B HiCallEventMetrics    (V);
 B HiCallEventSize       (V);
 B HiCallEventScrollBar  (V);
 B HiCallEventSystray    (BP clickcount);

 /*******************************************
  HiCall Debug Window
  *******************************************/

 #define DEBUG_FGBLUE         FOREGROUND_BLUE
 #define DEBUG_FGRED          FOREGROUND_RED
 #define DEBUG_FGGREEN        FOREGROUND_GREEN
 #define DEBUG_FGBRIGHT       FOREGROUND_INTENSITY
 #define DEBUG_BGBLUE         BACKGROUND_BLUE
 #define DEBUG_BGRED          BACKGROUND_RED
 #define DEBUG_BGGREEN        BACKGROUND_GREEN
 #define DEBUG_BGBRIGHT       BACKGROUND_INTENSITY

 B HiCallDebugOpen       (W width,W height,CP title,...);
 B HiCallDebugClose      (V);
 B HiCallDebugPrintf     (CP string,...);
 B HiCallDebugSetCursor  (W x,W y,B size,B caretflag);
 B HiCallDebugSetColor   (W color);
 B HiCallDebugRead       (V);
 B HiCallDebugFill       (W x1,W y1,W x2,W y2,B ch,W color);
 B HiCallDebugClearInput (V);
 B HiCallDebugMove       (W x1,W y1,W x2,W y2,W destx,W desty,B chfill,W colorfill);

 /*******************************************
  HiCall HotSpots
  *******************************************/

 #define HOTSPOTRET_NoProblem           0
 #define HOTSPOTRET_InUse               1
 #define HOTSPOTRET_BadId               2
 #define HOTSPOTRET_NotFound            3
 #define HOTSPOTRET_NoHit               4

 I HiCallHotSpotZap       (V);
 I HiCallHotSpotAdd       (W x1,W y1,W x2,W y2,W id);
 I HiCallHotSpotDestroy   (W id);
 I HiCallHotSpotCheck     (W x,W y,WP id);

 /*******************************************
  Tool Tips
  *******************************************/

 B HiCallTooltipCreate    (HP id,W x1,W y1,W x2,W y2,CP text);
 B HiCallTooltipDestroy   (H id);

 /*******************************************
  IPC
  *******************************************/

 #define IPCRET_NoProblem         0
 #define IPCRET_Unknown           1
 #define IPCRET_Exists            2
 #define IPCRET_MutexExists       3
 #define IPCRET_NotFound          4
 #define IPCRET_NotReady          5
 #define IPCRET_BadSize           6

 structure { HANDLE objecthandle,mutexhandle; BP pagememory; } _ipc;

 I HiCallIpcCreate            (BP name,_ipc*IPC);
 I HiCallIpcOpen              (BP name,_ipc*IPC);
 I HiCallIpcExist             (BP name);
 I HiCallIpcClose             (_ipc*IPC);
 I HiCallIpcWrite             (_ipc*IPC,H size,VP buffer);
 I HiCallIpcRead              (_ipc*IPC,HP size,VP buffer);
 I HiCallIpcPeek              (_ipc*IPC,HP size,VP buffer);
 I HiCallIpcPoke              (_ipc*IPC,H size,VP buffer);
 I HiCallIpcPurge             (_ipc*IPC);
 I HiCallIpcMaxSize           (HP size);

 /*******************************************
  PROCESS's
  *******************************************/

 #define PROCESSRET_NoProblem     0
 #define PROCESSRET_StillActive   1
 #define PROCESSRET_Failed        2

 I HiCallProcessCreate        (BP processname,BP cmdline,BP curdir,HP handle);
 I HiCallProcessGetExit       (H handle);

 /*******************************************
  COMMS
  *******************************************/

 #define BAUD110       CBR_110
 #define BAUD300       CBR_300
 #define BAUD600       CBR_600
 #define BAUD1200      CBR_1200
 #define BAUD2400      CBR_2400
 #define BAUD4800      CBR_4800
 #define BAUD9600      CBR_9600
 #define BAUD14400     CBR_14400
 #define BAUD19200     CBR_19200
 #define BAUD38400     CBR_38400
 #define BAUD57600     CBR_57600
 #define BAUD115200    CBR_115200
 #define BAUD128000    CBR_128000
 #define BAUD256000    CBR_256000

 #define N71           NOPARITY,7,ONESTOPBIT
 #define N715          NOPARITY,7,ONE5STOPBIT
 #define N72           NOPARITY,7,TWOSTOPBIT
 #define N81           NOPARITY,8,ONESTOPBIT
 #define N815          NOPARITY,8,ONE5STOPBIT
 #define N82           NOPARITY,8,TWOSTOPBIT
 #define E71	        EVENPARITY,7,ONESTOPBIT
 #define E715          EVENPARITY,7,ONE5STOPBIT
 #define E72           EVENPARITY,7,TWOSTOPBIT
 #define E81           EVENPARITY,8,ONESTOPBIT
 #define E815          EVENPARITY,8,ONE5STOPBIT
 #define E82           EVENPARITY,8,TWOSTOPBIT
 #define M71	        MARKPARITY,7,ONESTOPBIT
 #define M715          MARKPARITY,7,ONE5STOPBIT
 #define M72           MARKPARITY,7,TWOSTOPBIT
 #define M81           MARKPARITY,8,ONESTOPBIT
 #define M815          MARKPARITY,8,ONE5STOPBIT
 #define M82           MARKPARITY,8,TWOSTOPBIT
 #define O71	        ODDPARITY,7,ONESTOPBIT
 #define O715          ODDPARITY,7,ONE5STOPBIT
 #define O72           ODDPARITY,7,TWOSTOPBIT
 #define O81           ODDPARITY,8,ONESTOPBIT
 #define O815          ODDPARITY,8,ONE5STOPBIT
 #define O82           ODDPARITY,8,TWOSTOPBIT


 structure
 {
 H inque;
 H outque;
 }
 _commstatus;

 #define COMMRET_NoProblem        0
 #define COMMRET_Failed           1

 I HiCallCommOpen             (CP commname,H baud,B parity,B bytesize,B stopbits,H ilen,H olen,HP handle);
 I HiCallCommClose            (H handle);
 I HiCallCommWrite            (H handle,H bytes,VP data,HP done);
 I HiCallCommRead             (H handle,H bytes,VP data,HP done);
 I HiCallCommStatus           (H handle,_commstatus*COMMSTATUS);


 /*******************************************
  PREBUILT DIALOG BOXES
  *******************************************/

 #define FILEDLGRET_NoProblem          0
 #define FILEDLGRET_InUse              1
 #define FILEDLGRET_Failed             2
 #define FILEDLGRET_NotOpen            3
 #define FILEDLGRET_Canceled           4
   
 structure
 {
 C filter[256];
 C initial_file[256];
 C initial_dir[256];
 C default_extension[3];
 C selection[_32K];
 B allowmulti;
 B saveflag;
 HANDLE handle;
 }
 _dialogfile;

 I HiCallDialogFileOpen        (_dialogfile*df);
 I HiCallDialogFileStatus      (_dialogfile*df);

 /*******************************************
  Security
  *******************************************/

 structure { B state[256],x,y; W keylen; B key[256];} _rc4;
 #define swap_byte(x,y) t = *(x); *(x) = *(y); *(y) = t


BP HiCallCryptoCreate         (BP key,W keylen);
 V HiCallCrypto               (BP buf,W buflen,B reset,BP handle);
BP HiCallRandomCreate         (W seed);
 W HiCallRandom               (BP handle);


 /*******************************************
  Global variables
  *******************************************/

 extern CP ModulePath;
 extern CP WindowTitle;
 extern  H WindowIcon;
 extern  W MinWindowWidth;
 extern  W MinWindowHeight;
 extern  W MaxWindowWidth;
 extern  W MaxWindowHeight;
 extern  W ClientWidthExtra;
 extern  W ClientHeightExtra;
 extern  B ClientAllowScrollH;
 extern  B ClientAllowScrollV;
 extern  W ClientWidth;
 extern  W ClientHeight;
 extern BP ClientScreen;
 extern  B WindowInFront;

 #define CLIENTINFO    ClientScreen,ClientWidth
 #define CLIENTRECT    0,0,(W)(ClientWidth-1),(W)(ClientHeight-1)

 extern  _rgba
 COL_NULL,                //None, i.e fully transparent pen
 COL_3DDKSHADOW,          //Windows 95 only: Dark shadow for three-dimensional display elements.
 COL_3DFACE,              //Windows 95 only: Face color for three-dimensional display elements.
 COL_3DHILIGHT,           //Windows 95 only: Highlight color for three-dimensional display elements (for edges facing the light source.)
 COL_3DLIGHT,             //Windows 95 only: Light color for three-dimensional display elements (for edges facing the light source.)
 COL_3DSHADOW,            //Windows 95 only: Shadow color for three-dimensional display elements (for edges facing away from the light source).
 COL_ACTIVEBORDER,        //Active window border.
 COL_ACTIVECAPTION,       //Active window caption.
 COL_APPWORKSPACE,        //Background color of multiple document interface (MDI) applications.
 COL_BACKGROUND,          //Desktop.
 COL_BTNFACE,             //Windows NT only: Face shading on push buttons.
 COL_BTNHILIGHT,          //Windows 95 only: Highlight color
 COL_BTNSHADOW,           //Edge shading on push buttons.
 COL_BTNTEXT,             //Text on push buttons.
 COL_CAPTIONTEXT,         //Text in caption,          // size box,          // and scroll bar arrow box.
 COL_GRAYTEXT,            //Grayed (disabled) text. This color is set to 0 if the current display driver does not support a solid gray color.
 COL_HIGHLIGHT,           //Item(s) selected in a control.
 COL_HIGHLIGHTTEXT,       //Text of item(s) selected in a control.
 COL_INACTIVEBORDER,      //Inactive window border.
 COL_INACTIVECAPTION,     //Inactive window caption.
 COL_INACTIVECAPTIONTEXT, //Color of text in an inactive caption.
 COL_INFOBK,              //Windows 95 only: Background color for tooltip controls.
 COL_INFOTEXT,            //Windows 95 only: Text color for tooltip controls.
 COL_MENU,                //Menu background.
 COL_MENUTEXT,            //Windows NT only: Text in menus.
 COL_SCROLLBAR,           //Scroll bar gray area.
 COL_WINDOW,              //Window background.
 COL_WINDOWFRAME,         //Window frame.
 COL_WINDOWTEXT,          //Text in windows.
 COL_BLACK,
 COL_WHITE,
 COL_BLUE,
 COL_RED,
 COL_GREEN,
 COL_YELLOW,
 COL_PURPLE,
 COL_AQUA,
 COL_GRAY,
 COL_DARKBLUE,
 COL_DARKRED,
 COL_DARKGREEN,
 COL_DARKYELLOW,
 COL_DARKPURPLE,
 COL_DARKAQUA,
 COL_DARKGRAY
 ;



#ifdef __cplusplus
}
#endif

#endif

