DECLARE SUB pause (ticks%)
DEFINT A-Z
DECLARE SUB box (start.l%, col%, ecol%, wth%, lines%, btyp%, new.box%, from.view%)
DECLARE SUB bright (xxon%, xxoff%)
DECLARE SUB clearwindow (start.l%, col%, ecol%, lines%, clr%)
DECLARE SUB printstring (st$, cm$, Row%, col%, cga%, ega%, scn%, bg%, fg%)

REM -- Sample program demostrating:
REM -- 1) window (box)
REM -- 2) true 16 color text for CGA,EGA,VGA
REM -- 3) Selective clearing of portions of screen (clearwindow)
REM -- 4) right to left scrolling
REM -- 5) the use of call interrupt,interruptx
REM -- 6) Poke, Out statements
REM -- Requires QB.QLB to be loaded. Use: >QB /L or QB /LQB
REM -- You must use printstring to print text with bright background. using
REM -- a print statement will cause QB to revert back to 8 color background
REM -- and cause the text to blink.

    COMMON cm$
'type def from QB.BI file.
    TYPE regtype
        Ax    AS INTEGER
        BX    AS INTEGER
        CX    AS INTEGER
        DX    AS INTEGER
        BP    AS INTEGER
        si    AS INTEGER
        di    AS INTEGER
        Flags AS INTEGER
     END TYPE
'Dim the type def to a variable name
    DIM Regs AS regtype
    TYPE regtypeX
        Ax AS INTEGER
        BX AS INTEGER
        CX AS INTEGER
        DX AS INTEGER
        BP AS INTEGER
        si AS INTEGER
        di AS INTEGER
        Flags AS INTEGER
        ds AS INTEGER
        ES AS INTEGER
     END TYPE
    DIM inreg AS regtype, outreg AS regtype

Main.routine:
    GOSUB init
    GOSUB screen.display
    GOSUB close.files
    LOCATE 1, 1
    PRINT STRING$(1920, 176); 'this clears the box and avoids blinking
                              'when bright attribute is turned off
    GOSUB Turn.Bright.off
    SYSTEM

init:
'find out if color display
    Regs.Ax = 15 * 256
        CALL INTERRUPT(&H10, Regs, Regs)
    'if AL=7 then card is monochrome.
        IF (Regs.Ax AND 255) = 7 THEN
            cm$ = "N"
        ELSE
            cm$ = "Y"
        END IF
    RETURN

screen.display:
    clr1% = 15: clr2% = 1: clr3% = 14: clr4% = 4
  'set color to white on blue and clear the screen
    COLOR clr1%, clr2%
    CLS
 'print chr$(176) on screen 1920 times (24 x 80)
    LOCATE 1, 1
    PRINT STRING$(1920, 176);
 
  ' print box
    start.l% = 4: col% = 8: ecol% = 72: wth% = ecol% - col% - 1
    btyp% = 1: lines% = 8
    box start.l%, col%, ecol%, wth%, lines%, btyp%, new.box%, from.view%
 
  'clear the box with bright white - set bright on
    bright -1, 0
    clearwindow start.l%, col%, ecol%, lines%, 15
 
  'print some text in the box
    bg% = 15: fg% = 0
    '' not needed LOCATE start.l% + 1, col% + 2
        st$ = "This example shows printing in text mode with 16 colors"
        Row% = start.l% + 1: Pcol% = col% + 2
    printstring st$, cm$, Row%, Pcol%, cga%, ega%, scn%, bg%, fg%
        st$ = "(background is normally limited to 8 colors in QB.)."
        Row% = start.l% + 2: Pcol% = col% + 2
    printstring st$, cm$, Row%, Pcol%, cga%, ega%, scn%, bg%, fg%
        st$ = "Press any key to continue and I will clear the box."
        Row% = start.l% + 3: Pcol% = col% + 2
    printstring st$, cm$, Row%, Pcol%, cga%, ega%, scn%, bg%, fg%
        WHILE INKEY$ = "": WEND
    clearwindow start.l%, col%, ecol%, lines%, 15
    st$ = "this is an example of text scrolling from right to left"
    FOR K% = ecol% - 1 TO ecol% - LEN(st$) STEP -1
       st1$ = MID$(st$, 1, ecol% - K%) + " "
      
       printstring st1$, cm$, start.l% + 3, K% - 2, cga%, ega%, scn%, 15, 1
       
       pause 2
    NEXT
    LOCATE 25, 1: PRINT "Press any key ";
    WHILE INKEY$ = "": WEND
    RETURN

close.files:
    RETURN

Turn.Bright.off:
    bright 0, -1
    RETURN

SUB box (start.l%, col%, ecol%, wth%, lines%, btyp%, new.box%, from.view%) STATIC
    SHARED clr1%, clr2%, clr3%, clr4%
    SHARED cm$

        IF btyp% = 1 THEN
            ulc$ = CHR$(218): urc$ = CHR$(191): lv$ = CHR$(179): rv$ = CHR$(179)
            hor$ = CHR$(196): llc$ = CHR$(192): lrb$ = CHR$(217)
        ELSEIF btyp% = 2 THEN
            ulc$ = CHR$(201): urc$ = CHR$(187): llc$ = CHR$(200)
            lrb$ = CHR$(188): hor$ = CHR$(205): lv$ = CHR$(186): rv$ = CHR$(186)
        ELSEIF btyp% = 0 THEN
             ulc$ = CHR$(221): hor$ = CHR$(32): urc$ = CHR$(222)
             llc$ = CHR$(221): lrb$ = CHR$(222)
             hor2$ = CHR$(32)
             lv$ = CHR$(221)
             rv$ = CHR$(222)
        ELSEIF btyp% = -1 THEN
             ulc$ = CHR$(32): hor$ = CHR$(32): urc$ = CHR$(222)
             llc$ = CHR$(32): lrb$ = CHR$(222)
             hor2$ = CHR$(32)
             lv$ = CHR$(32): rv$ = CHR$(222)
      
        ELSE
            ulc$ = CHR$(32)
            urc$ = CHR$(32)
            llc$ = CHR$(32)
            lrb$ = CHR$(32)
            hor$ = CHR$(223)
            lv$ = CHR$(32)
            rv$ = CHR$(32)
        END IF

        VIEW PRINT
       
        LOCATE start.l%, col%, 0: PRINT ulc$; STRING$(wth%, hor$); urc$;
        IF cm$ = "Y" AND btyp% = 3 THEN COLOR clr4%, clr2%: LOCATE start.l%, col% + 1: PRINT STRING$(wth%, hor$); : COLOR clr3%, clr4%
        IF wth% = 5 THEN
            IF cm$ = "Y" THEN COLOR 15, 7
            LOCATE start.l%, col%: PRINT ulc$; STRING$(wth%, hor$);
            COLOR 0, 7
        END IF
      
        FOR j = start.l% + 1 TO start.l% + lines%
            IF j < 26 THEN
                LOCATE j, col%: PRINT lv$;
                END IF
            LOCATE j, ecol%: PRINT rv$;
        NEXT
        IF lines% = 0 THEN
             LOCATE start.l% + 1, col%: PRINT lv$; SPACE$(wth%); rv$;
             'LOCATE Start.L% + 1, ecol%: PRINT rv$;
        END IF
        IF lines% > 20 AND wth% = 78 THEN llc$ = lv$: hor$ = CHR$(176): lrb$ = rv$
        IF start.l% + lines% + 1 < 26 THEN
            IF hor2$ <> "" THEN hor$ = hor2$
            LOCATE start.l% + lines% + 1, col%: PRINT llc$; STRING$(wth%, hor$); lrb$;
            hor2$ = ""
        END IF
        IF cm$ = "Y" AND btyp% = 3 THEN COLOR clr2%, clr4%: LOCATE start.l% + lines% + 1, col% + 1: PRINT STRING$(wth%, hor$); : COLOR clr3%, clr4%
        IF new.box% <> -99 THEN
            IF wth% <= 76 AND ecol% < 79 AND wth% <> 5 THEN
                IF btyp% > -1 THEN '''<> 0 THEN
                  
                    IF cm$ = "Y" THEN
                        clearwindow start.l%, ecol%, ecol% + 3, lines% + 2, 0
                        clearwindow start.l% + lines% + 1, col% + 1, ecol% + 3, 1, 0
                    END IF
                END IF
            END IF
        END IF

END SUB

SUB bright (xxon%, xxoff%) STATIC
        SHARED inreg AS regtype
        SHARED outreg AS regtype
        SHARED cm$
        IF cm$ <> "Y" THEN EXIT SUB
        inreg.Ax = &H1200
        inreg.BX = &H10
        inreg.CX = &HFFFF
        CALL INTERRUPT(&H10, inreg, outreg)
        IF outreg.CX = &HFFFF THEN
            cga% = -1
        ELSE
            ega% = -1
        END IF
'chip info for CGA monitors      
        MODEREG = &H3D8: '  colorreg = &H3D9        'control registers
        MODESAVE = &H465': colorsave = &H466       'BIOS saves the regs here
'crtreg = &H3D4:   crtdata = &H3D5         '6845 CRT controller regs
       
         IF xxon% THEN
            IF cga% THEN
              
                DEF SEG = 0
                smode = 9 'High resolution
                POKE MODESAVE, smode: OUT MODEREG, smode
                DEF SEG
            END IF
            IF ega% THEN
                inreg.Ax = &H1003
                inreg.BX = &H0
                CALL INTERRUPTX(&H10, inreg, outreg)
            END IF
         END IF
       
         IF xxoff% THEN
            IF cga% THEN
                DEF SEG = 0
                smode = 41 'Blink restored
                POKE MODESAVE, smode: OUT MODEREG, smode
                DEF SEG
            END IF
            IF ega% THEN
                inreg.Ax = &H1003
                inreg.BX = &H1
                CALL INTERRUPTX(&H10, inreg, outreg)
            END IF
         END IF
'INT 10 - VIDEO - TOGGLE INTENSITY/BLINKING BIT (EGA, VGA)
'    AX = 1003h
'    BL = 00h enable intensity
'       = 01h enable blink

END SUB

SUB clearwindow (start.l%, col%, ecol%, lines%, clr%) STATIC
CLEAR.WINDOW:
    SHARED Regs AS regtype
    SHARED clr1%, clr2%, clr3%, clr4%
'MinX = Col% + 1: MinY = Start.l% + 1
'MaxX = ecol% - 1: MaxY = Start.l% + lines%
    Regs.Ax = &H600
    clr& = clr%
    a& = clr& * 4096
    IF clr% > 7 THEN
        IF clr% = 8 THEN Regs.BX = &H8000
        IF clr% = 9 THEN Regs.BX = &H9000
        IF clr% = 10 THEN Regs.BX = &HA000
        IF clr% = 11 THEN Regs.BX = &HB000
        IF clr% = 12 THEN Regs.BX = &HC000
        IF clr% = 13 THEN Regs.BX = &HD000
        IF clr% = 14 THEN Regs.BX = &HE000
        IF clr% = 15 THEN Regs.BX = &HF000
    ELSE
        Regs.BX = a&
    END IF
    Regs.CX = ((start.l% + 1) * 256&) + col% + 1 - 257
    Regs.DX = ((start.l% + lines%) * 256&) + ecol% - 1 - 257
    CALL INTERRUPT(&H10, Regs, Regs)

END SUB

SUB pause (ticks%) STATIC
    DEF SEG = 0: testtick% = 0
    DO
        LastTick% = GetTick%
        GetTick% = PEEK(&H46C)
         IF LastTick% <> GetTick% THEN
           testtick% = testtick% + 1
         END IF
    LOOP WHILE testtick% < ticks%
    DEF SEG
    LastTick% = 0: testtick% = 0
    GetTick% = 0

END SUB

SUB printstring (st$, cm$, Row%, col%, cga%, ega%, scn%, bg%, fg%) STATIC

REM -- remove the or ega% to test ega/vga mode
        DIM inreg AS regtypeX
        DIM outreg AS regtypeX
        IF cm$ <> "Y" THEN
            'IF fg% + bg% <> 0 THEN COLOR fg%, bg%
            LOCATE Row%, col% + col.offset%: PRINT st$;
            EXIT SUB
        END IF
      
        inreg.Ax = &H1300
        IF fg% + bg% <> 0 THEN
            inreg.BX = (scn% * 256) + (bg% * 16) + fg%
        ELSE
            inreg.BX = scn% * 256 + 240''240=&HF0 '''&H2F0
        END IF
        inreg.CX = LEN(st$)
        inreg.ES = VARSEG(st$)
        inreg.BP = SADD(st$)
        inreg.DX = ((Row% - 1) * 256) + col% + col.offset% - 1
        CALL INTERRUPT(&H10, inreg, outreg)

END SUB

