DECLARE SUB clrit ()
DEFINT A-Z               ' Default variable type is integer

TYPE MonthType
   Number AS INTEGER     ' Number of days in the month
   MName AS STRING * 9   ' Name of the month
END TYPE
DECLARE FUNCTION IsLeapYear% (N%)
DECLARE FUNCTION GetInput% (Prompt$, Row%, LowVal%, HighVal%)

DECLARE SUB PrintCalendar (Year%, Month%)
DECLARE SUB ComputeMonth (Year%, Month%, StartDay%, TotalDays%)
DIM MonthData(1 TO 12) AS MonthType
user$ = COMMAND$
IF user$ <> "SBP" THEN END
COLOR 12, 1: clrit
FOR i = 1 TO 12
   READ MonthData(i).MName, MonthData(i).Number
NEXT

' Main loop, repeat for as many months as desired:
DO
CALL clrit

  
   ' Get year and month as input:
   LOCATE 3, 3
   COLOR 15: PRINT "               C H O O S E    Y O U R    C A L E N D A R"
   COLOR 3: Year = GetInput("     Year (1900 to 2050): ", 12, 1899, 2050)
   Month = GetInput("     Month (1 to 12): ", 13, 1, 12)
   PRINT : PRINT
   PrintCalendar Year, Month
   COLOR 0, 0: LOCATE 1, 1: PRINT STRING$(80, 32);
   COLOR 7, 1
   LOCATE 21, 53: PRINT "SYSTEM TIME/DATE"
   LOCATE 23, 55: PRINT DATE$
   COLOR 23, 4: LOCATE 1, 17: PRINT " Press Any Key "
   COLOR 7, 4: LOCATE 1, 34: PRINT " OR "
   LOCATE 1, 40: PRINT " Shift + Print Screen ": COLOR 7, 1
   
DO
   COUNT = COUNT + 1
   SLEEP 1
   COLOR 7: LOCATE 22, 56: PRINT TIME$
   IF COUNT = 1 THEN GOTO RIGHT
   IF COUNT > 1 THEN COUNT = 0
LEFT:
   LOCATE 1, 32: K$ = INKEY$
   GOTO LFTLOOP
RIGHT:
   LOCATE 1, 16: K$ = INKEY$
LFTLOOP:
LOOP WHILE K$ = ""
   COLOR 7, 4: LOCATE 1, 17: PRINT " Press Any Key "
   COLOR 20, 1: LOCATE 22, 26
   PRINT : PRINT "     New Calendar?";
   COLOR 4: PRINT " (y or n)   ";
   LOCATE , , 1, 0, 13
   Resp$ = INPUT$(1)
   PRINT Resp$
LOOP WHILE UCASE$(Resp$) = "Y"
CALL clrit
END

' Data for the months of a year:
DATA January, 31, February, 28, March, 31
DATA April, 30, May, 31, June, 30, July, 31, August, 31
DATA September, 30, October, 31, November, 30, December, 31

SUB clrit
  COLOR 0
  FOR i = 1 TO 24
        LOCATE i + 1, 1: PRINT STRING$(80, 32)
  NEXT i
END SUB

'
SUB ComputeMonth (Year, Month, StartDay, TotalDays) STATIC
   SHARED MonthData() AS MonthType
   CONST LEAP = 366 MOD 7
   CONST NORMAL = 365 MOD 7
   NumDays = 0
   FOR i = 1899 TO Year - 1
      IF IsLeapYear(i) THEN         ' If year is leap, add
         NumDays = NumDays + LEAP   ' 366 MOD 7.
      ELSE                          ' If normal year, add
         NumDays = NumDays + NORMAL ' 365 MOD 7.
      END IF
   NEXT
   FOR i = 1 TO Month - 1
      NumDays = NumDays + MonthData(i).Number
   NEXT
   TotalDays = MonthData(Month).Number
   IF IsLeapYear(Year) THEN
      IF Month > 2 THEN
         NumDays = NumDays + 1
      ELSEIF Month = 2 THEN
         TotalDays = TotalDays + 1

      END IF
   END IF

   StartDay = NumDays MOD 7
END SUB

'
'
FUNCTION GetInput (Prompt$, Row, LowVal, HighVal) STATIC
   LOCATE Row, 40, 1, 0, 13
   PRINT Prompt$;
   Column = POS(0)
   DO
      LOCATE Row, Column   ' Locate cursor at end of prompt
      PRINT SPACE$(10)     ' Erase anything already there
      LOCATE Row, Column   ' Relocate cursor at end of prompt
      INPUT "", Value      ' Input value with no prompt
   LOOP WHILE (Value < LowVal OR Value > HighVal)
   GetInput = Value

END FUNCTION

'
FUNCTION IsLeapYear (N) STATIC
   IsLeapYear = (N MOD 4 = 0 AND N MOD 100 <> 0) OR (N MOD 400 = 0)
END FUNCTION

'
SUB PrintCalendar (Year, Month) STATIC
SHARED MonthData() AS MonthType
   ComputeMonth Year, Month, StartDay, TotalDays
   
   Header$ = RTRIM$(MonthData(Month).MName) + "," + STR$(Year)
   LeftMargin = (35 - LEN(Header$)) \ 2
   LOCATE 10, 1
   PRINT TAB(LeftMargin); Header$
   PRINT
   PRINT "Su    M   Tu    W   Th    F   Sa"
   PRINT
   LeftMargin = 5 * StartDay + 1
   PRINT TAB(LeftMargin);
   FOR i = 1 TO TotalDays
      PRINT USING "##   "; i;
      IF POS(0) > 35 THEN PRINT
     
   NEXT

END SUB

