DECLARE SUB CURVE (X1!, Y1!, X2!, Y2!)
DECLARE FUNCTION DIST! (X1!, Y1!, X2!, Y2!)
DECLARE FUNCTION RADIANS! (X!)
DECLARE FUNCTION MOVEX! (X1!, Y1!, X2!, Y2!)
DECLARE FUNCTION MOVEY! (X1!, Y1!, X2!, Y2!)
                '*********************************
                '*                               *
                '*  A FRACTAL COASTLINE-RECURSE  *
                '*                               *
                '*********************************

DEFSNG A-Z
CLEAR , , 12000
SCREEN 2
CONST PI = 3.14159

WINDOW (-500!, 500!)-(500!, -500!)
X1 = -250: Y1 = 200
X2 = 250: Y2 = 200
CALL CURVE(X1, Y1, X2, Y2)
CALL CURVE(X2, Y2, 0, -Y2)
CALL CURVE(0, -Y2, X1, Y1)
SLEEP: END

SUB CURVE (X1, Y1, X2, Y2)
DEFSNG A-Z
DISPT = DIST(X1, Y1, X2, Y2)
IF DISPT < 10 THEN
    EXIT SUB
END IF
NX1 = X1 + MOVEX(X1, Y1, X2, Y2)    'FIND THE COORDINATES FOR THE SPIKE
NY1 = Y1 + MOVEY(X1, Y1, X2, Y2)
LINE (X1, Y1)-(X2, Y2), 0           'ERASE THE PREVIOUS LINE
LINE (X1, Y1)-(NX1, NY1)            'MAKES THE SPIKE
LINE -(X2, Y2)
CALL CURVE(X1, Y1, NX1, NY1)
CALL CURVE(NX1, NY1, X2, Y2)        'RECURSES ON THE SPIKES
END SUB

FUNCTION DIST (X1, Y1, X2, Y2)
X = (X2 - X1) * (X2 - X1)       'FINDS THE DISTANCE BETWEEN POINTS
Y = (Y2 - Y1) * (Y2 - Y1)
DIST = SQR(X + Y)
END FUNCTION

FUNCTION MOVEX! (X1!, Y1!, X2!, Y2!)
'local variables: angle(in radians), d, xshift,yshift

ANGLE = RADIANS!(15 + 60 * RND(1))         'A
IF RND(1) > .5 THEN ANGLE = -ANGLE
D = DIST(X1, X2, Y1, Y2)
R = (.15 + (.6 * RND(1))) * D               'B
XSHIFT = COS(ANGLE) * (X2 - X1)
YSHIFT = SIN(ANGLE) * (Y2 - Y1)
MOVEX = (R / D) * (XSHIFT - YSHIFT)
END FUNCTION

FUNCTION MOVEY! (X1!, Y1!, X2!, Y2!)
ANGLE = RADIANS(45)
D = DIST(X1, X2, Y1, Y2)
R = (SQR(2) / 2) * D
XSHIFT = SIN(ANGLE) * (X2 - X1)
YSHIFT = COS(ANGLE) * (Y2 - Y1)
MOVEY! = R / D * (XSHIFT + YSHIFT)
END FUNCTION

FUNCTION RADIANS! (X!)
RADIANS! = X! * PI / 180                'CONVERTS DEGREES TO RADIANS
END FUNCTION

