DECLARE SUB Banner (st$, row%)
DECLARE SUB instr2 ()
DECLARE SUB instr1 ()
DECLARE SUB menu ()
DECLARE SUB logo ()
'       ͻ
'         STOCK.BAS                "NewYork Stock Exchange"    
'         Developed:                                           
'         for use with the RolePlaying Game: "GangBusters",    
'         or similar 1920's games. (c)96/97 Kevin Everingham   
'       ͼ 
'          
REM
REM           "Mock" Stock Market Program for use with games
REM                       completed: 1-20-97
REM
TYPE STOCKID        '_____defines format of the main database_____
  nameof AS STRING * 30 ' Name of Stock
  descrp AS STRING * 30 ' Description of stock
  grade1 AS STRING * 5  ' last change = (up, down, or even)
  grade2 AS SINGLE      ' amount of last change  ex.(.75 or 1.25)
  Flux   AS SINGLE      ' variable of stock (flux number)
  value1 AS SINGLE      ' last stock value
  value2 AS SINGLE      ' current stock value
END TYPE
DIM Stock AS STOCKID
colr = 0: CLS : pnt = 0: rand1 = 0: rand2 = 0: rand3 = 0
    LOCATE 2, 10: PRINT "New York": LOCATE 18, 10: PRINT "E     X     C     H     A     N     G     E"
    COLOR 8: LOCATE 1, 52: PRINT "for RolePlaying games.": COLOR 15: LOCATE 25, 48: PRINT "(c)1997 Kevin Everingham ";
'   loop below simply changes main screen logo colors each second
DO
        colr = colr + 3
        IF colr = 15 THEN colr = 14
        IF colr = 17 THEN colr = 2
        IF colr = 8 THEN colr = 7
        IF colr = 10 THEN colr = 3
        COLOR colr: CALL logo
        IF INKEY$ <> "" THEN EXIT DO
        SLEEP 1
LOOP UNTIL INKEY$ <> ""
REM     temp skips below
menu:
COLOR 7
CLS
GOSUB count
COLOR 2, 0: CALL menu
LOCATE 5, 29: COLOR 0, 10: PRINT " Choose an option: ": COLOR 7, 0
LOCATE 7, 29: PRINT "("; : COLOR 14: PRINT "x"; : COLOR 7: PRINT ") to exit program": COLOR 2
LOCATE 9, 21:  PRINT "    Editing Choices:"; : COLOR 12: PRINT "    CAUTION": COLOR 7
LOCATE 10, 21: PRINT "(a) Add NEW Stock to the Stock list."
LOCATE 11, 21: PRINT "(c) Calculate (NEW) Stock values."
LOCATE 12, 21: PRINT "(e) Edit a current Stock File. "
LOCATE 13, 21: PRINT "(f) Edit a Stock's Flux level.": COLOR 10
LOCATE 15, 21:  PRINT "    Information Choices:": COLOR 7
LOCATE 16, 21: PRINT "("; : COLOR 15: PRINT "s"; : COLOR 7: PRINT ")  Show all Current Stock values."
LOCATE 17, 21: PRINT "("; : COLOR 15: PRINT "v"; : COLOR 7: PRINT ")  View a "; CHR$(34); "single"; CHR$(34); " Stock"
LOCATE 18, 21: PRINT "("; : COLOR 15: PRINT "p"; : COLOR 7: PRINT ")  Print the current Stock values."
LOCATE 19, 21: PRINT "("; : COLOR 15: PRINT "i"; : COLOR 7: PRINT ")  Basic operation Instructions."
menu2:
a$ = INKEY$: a$ = UCASE$(a$)
'  Fellow programmer's or RolePlayers:
'  line below is scrolling banner text    MY PLAN: gosub to a routine
'  here that selects a random file number from the database.  Then let
'  st$ = nameof + grade1 + grade2 + "to: $" + value2
'  You would then only gosub every 4 to 6 loops so info would scroll nice.
'  Meaning: scrolls a random stock event saying: (stock name up .25 to: $ 12
'  if you add this, contact me, I'd like a copy!   (abacus@pathwaynet.com)
'  if you have any questions, or have your own role-playing program, or
'  if you know of RolePlayer groups who may use this program, let me know.
st$ = "..(s) to see value of all Stocks"
row% = 4    'row of scrolling banner
        CALL Banner(st$, row%)  'STATIC
        SLEEP 1
IF a$ = "X" THEN END
IF a$ = "A" THEN GOSUB addstock
IF a$ = "V" THEN GOSUB viewstock
IF a$ = "E" THEN GOSUB editstock
IF a$ = "F" THEN GOSUB editflux
IF a$ = "S" THEN pnt = 0: GOSUB showstock
IF a$ = "P" THEN pnt = 1: GOSUB showstock
IF a$ = "C" THEN GOSUB calculate
IF a$ = "I" THEN CALL instr1: CALL instr2
GOTO menu2
END
addstock:
        LOCATE 3, 14: COLOR 30: PRINT "are you sure you want to add a NEW stock? (y/n)"; : INPUT a$
        IF a$ = "n" THEN RETURN
        IF a$ = "N" THEN RETURN
        CLS : COLOR 7
        GOSUB count
        RcrdNmbr = RcrdNmbr + 1
        OPEN "stock.id" FOR RANDOM AS #1 LEN = LEN(Stock)
        LOCATE 4, 23: COLOR 7: PRINT "              (Give Name of New Stock Below...)": COLOR 3
        LOCATE 6, 23: INPUT " New active Stock name : "; Stock.nameof
        LOCATE 8, 23: COLOR 7: PRINT "              (Give a Description of the New Stock...)": COLOR 3
        LOCATE 10, 23: INPUT " What type of Stock is it? : "; Stock.descrp
        LOCATE 12, 23: COLOR 7: PRINT "   Enter the (Flux) level or stability of this stock.": COLOR 3
        LOCATE 14, 23: INPUT "   Flux level (1-5)        :"; Stock.Flux!: IF Stock.Flux! > 5 THEN Stock.Flux! = 5: IF Stock.Flux! < 1 THEN Stock.Flux! = 1
        LOCATE 16, 23: COLOR 7: PRINT "   Enter the starting value of this stock. ": COLOR 3
        LOCATE 18, 23: INPUT "  Value? (common .10 - 2.00)"; Stock.value2!: Stock.value1! = Stock.value2!
        Stock.grade1 = "even": Stock.grade2! = 0
        PUT #1, RcrdNmbr, Stock
        CLOSE #1
RETURN
REM                          below... stock editor....
REM
editstock:
     CLS : CLOSE : RcrdNmbr = 0: c$ = "0": a = 0
     LOCATE 7, 7: COLOR 8: PRINT " Enter N to Edit Stock by it's Number."
     LOCATE 8, 16: PRINT " ENTER X TO EXIT": COLOR 7
     LOCATE 10, 2: PRINT "Enter the name of the stock you wish to EDIT: "; : INPUT a$
     a$ = UCASE$(a$): IF a$ = "X" THEN RETURN
     IF a$ = "N" THEN c$ = "1": INPUT "Enter the number of the Stock you wish to Edit: "; a
        OPEN "stock.id" FOR RANDOM AS #3 LEN = LEN(Stock)
DO
        RcrdNmbr = RcrdNmbr + 1
        GET #3, RcrdNmbr, Stock
        b$ = Stock.nameof
        IF a$ = Stock.nameof THEN GOTO found2
        IF a$ = LEFT$(b$, 8) THEN GOTO found2                 ' as typed in
        IF UCASE$(a$) = LEFT$(b$, 6) THEN GOTO found2         ' all caps
        IF UCASE$(a$) = UCASE$(LEFT$(b$, 8)) THEN GOTO found2 ' search 8 chrs.
        IF UCASE$(a$) = UCASE$(LEFT$(b$, 6)) THEN GOTO found2 ' narrow search.
        IF LCASE$(a$) = LCASE$(LEFT$(b$, 6)) THEN GOTO found2 ' all low case
        IF LCASE$(a$) = LEFT$(b$, 6) THEN GOTO found2         '
        IF c$ = "1" AND a = RcrdNmbr THEN GOTO found2         ' search by #
LOOP UNTIL EOF(3)
LOCATE 15, 10: COLOR 12: PRINT "Stock not found...   Please be sure to type it correctly."
SLEEP 3: GOTO editstock
found2:
        CLS : LOCATE 5, 13: PRINT "  Match Found..."
        LOCATE 6, 13: PRINT "  Active Stock name : "; : COLOR 10: PRINT Stock.nameof: COLOR 7
        LOCATE 7, 5: INPUT " New Name (enter same as above if unchanged): "; Stock.nameof
        LOCATE 8, 13: PRINT "Description of this Stock : "; : COLOR 9: PRINT Stock.descrp: COLOR 7
        LOCATE 9, 5: INPUT " Enter new Description or same as above : "; Stock.descrp
        LOCATE 10, 13: PRINT "      Flux level (1-5)    :"; : COLOR 9: PRINT Stock.Flux!: COLOR 7
        LOCATE 11, 5: PRINT "1=very poor stock/low risk  5=above average/ High Risk & Performance Stock"
        LOCATE 12, 5: INPUT "Enter the new Flux level (normal range 2-4)  :"; Stock.Flux!: IF Stock.Flux! > 5 THEN Stock.Flux! = 5: IF Stock.Flux! < 1 THEN Stock.Flux! = 1
        LOCATE 13, 13: PRINT "  Stock's Previous Value  $"; : COLOR 9: PRINT USING "####.##"; Stock.value1!: COLOR 7
        LOCATE 14, 13: PRINT "  Current Value at Close  $"; : COLOR 4: PRINT USING "####.##"; Stock.value2!: COLOR 7
        LOCATE 15, 5: INPUT "Enter new value of this stock  $"; Stock.value2!
        LOCATE 22, 25: PRINT "press any key to return."; : COLOR 7
        PUT #3, RcrdNmbr, Stock
SLEEP
RETURN
REM                             Flux number Editor... Below
REM
editflux:
     CLS : CLOSE : RcrdNmbr = 0: c$ = "0": a = 0
     LOCATE 5, 16: PRINT " Flux level Editor"
     LOCATE 7, 7: COLOR 8: PRINT " Enter N to Edit Stock by it's Number."
     LOCATE 8, 16: PRINT " ENTER X TO EXIT": COLOR 7
     LOCATE 10, 2: PRINT "Enter the name of the stock you wish to EDIT: "; : INPUT a$
     a$ = UCASE$(a$): IF a$ = "X" THEN RETURN
     IF a$ = "N" THEN c$ = "1": INPUT "Enter the number of the Stock you wish to Edit: "; a
        OPEN "stock.id" FOR RANDOM AS #3 LEN = LEN(Stock)
DO
        RcrdNmbr = RcrdNmbr + 1
        GET #3, RcrdNmbr, Stock
        b$ = Stock.nameof
        IF a$ = Stock.nameof THEN GOTO found3
        IF a$ = LEFT$(b$, 6) THEN GOTO found3                    ' as typed in
        IF UCASE$(a$) = LEFT$(b$, 6) THEN GOTO found3            ' all caps
        IF UCASE$(a$) = UCASE$(LEFT$(b$, 8)) THEN GOTO found3    '
        IF UCASE$(a$) = UCASE$(LEFT$(b$, 6)) THEN GOTO found3    '
        IF LCASE$(a$) = LCASE$(LEFT$(b$, 6)) THEN GOTO found3    '
        IF LCASE$(a$) = LEFT$(b$, 6) THEN GOTO found3            ' all lower case
        IF c$ = "1" AND a = RcrdNmbr THEN GOTO found3            ' search by #
LOOP UNTIL EOF(3)
LOCATE 15, 10: COLOR 12: PRINT "Stock not found...   Please be sure to type it correctly."
LOCATE 17, 10: COLOR 10: PRINT "                      Or try to locate by it's number!"
SLEEP 3: GOTO editstock
found3:
        CLS : LOCATE 5, 13: PRINT "  Match Found..."
        LOCATE 6, 13: PRINT "  Active Stock name : "; : COLOR 10: PRINT Stock.nameof: COLOR 7
        LOCATE 9, 13: PRINT "      Flux level (1-5)    :"; : COLOR 9: PRINT Stock.Flux!: COLOR 7
        LOCATE 12, 5: PRINT "1=very poor stock/low risk  5=above average/ High Risk & Performance Stock"
        LOCATE 13, 5: PRINT "  ~~~~~~~~~~~~~~~             ~~~~~~~~~~~~~"
        LOCATE 15, 5: INPUT "Enter the new Flux level (normal range 2-4)  :"; Stock.Flux!: IF Stock.Flux! > 5 THEN Stock.Flux! = 5: IF Stock.Flux! < 1 THEN Stock.Flux! = 1
        LOCATE 19, 25: PRINT "press any key to return."; : COLOR 7
        PUT #3, RcrdNmbr, Stock
SLEEP
RETURN
REM
REM                         Main Search area...  Show all info.
viewstock:
     CLS : CLOSE : RcrdNmbr = 0
     LOCATE 8, 16: COLOR 8: PRINT " ENTER X TO EXIT": COLOR 7
     LOCATE 10, 2: PRINT "Enter the name of the stock your searching for: "; : INPUT a$
     IF a$ = "X" THEN RETURN
     IF a$ = "x" THEN RETURN
        OPEN "stock.id" FOR RANDOM AS #3 LEN = LEN(Stock)
DO
        RcrdNmbr = RcrdNmbr + 1
        GET #3, RcrdNmbr, Stock
        b$ = Stock.nameof
        IF a$ = Stock.nameof THEN GOTO found
        IF a$ = LEFT$(b$, 6) THEN GOTO found                    ' as typed in
        IF UCASE$(a$) = LEFT$(b$, 6) THEN GOTO found           ' all caps
        IF UCASE$(a$) = UCASE$(LEFT$(b$, 10)) THEN GOTO found ' 10 character
        IF UCASE$(a$) = UCASE$(LEFT$(b$, 8)) THEN GOTO found  ' 8 chr. search
        IF UCASE$(a$) = UCASE$(LEFT$(b$, 6)) THEN GOTO found  ' narrow search
        IF LCASE$(a$) = LEFT$(b$, 6) THEN GOTO found           ' all lower case
        IF LCASE$(a$) = LCASE$(LEFT$(b$, 6)) THEN GOTO found    '
LOOP UNTIL EOF(3)
LOCATE 15, 10: COLOR 12: PRINT "Stock not found...   Please be sure to type it correctly."
SLEEP 3: GOTO viewstock
found:
        CLS : LOCATE 5, 13: PRINT "  Match Found..."
        LOCATE 6, 13: PRINT "  Active Stock name : "; : COLOR 10: PRINT Stock.nameof: COLOR 7
        LOCATE 8, 13: PRINT "Description of this Stock : "; : COLOR 9: PRINT Stock.descrp: COLOR 7
        LOCATE 10, 13: PRINT "      Flux level (1-5)    :"; : COLOR 9: PRINT Stock.Flux!: COLOR 7
        LOCATE 12, 13: PRINT "  Stock's Previous Value  $"; : COLOR 9: PRINT USING "####.##"; Stock.value1!: COLOR 7
        LOCATE 14, 13: PRINT "  Current Value at Close  $"; : COLOR 4: PRINT USING "####.##"; Stock.value2!: COLOR 7
        LOCATE 16, 13: PRINT "  Level of Change: "; : COLOR 9: PRINT Stock.grade1; " "; : COLOR 3: PRINT Stock.grade2!; : COLOR 7: PRINT " Points.": COLOR 8
        LOCATE 22, 25: PRINT "press any key to return."; : COLOR 7
        CLOSE #3
SLEEP
RETURN
showstock:                              '< show all current values and levels.
     CLS : CLOSE : GOSUB count          '< get total # of files (total)
     RcrdNmbr = 0: LOCATE 5, 1: COLOR 2
        OPEN "stock.id" FOR RANDOM AS #3 LEN = LEN(Stock)
        LOCATE 4, 1: PRINT "______Stock Name_________Opening Value__"; : COLOR 10: PRINT "___Closing_(up/down/even)________Value__": COLOR 3: PRINT
        IF pnt = 1 THEN LPRINT TAB(55); "(c)1997 Abacus Computers": LPRINT : LPRINT : LPRINT "______Stock Name___________Opening Value___Closing:__Performance_Range___Value_"
        IF pnt = 1 THEN LPRINT "*******************************************************************************": LPRINT
FOR RcrdNmbr = 1 TO total
        GET #3, RcrdNmbr, Stock
        COLOR 7: PRINT USING "###"; RcrdNmbr; : COLOR 3: PRINT " "; Stock.nameof; : PRINT USING "$####.##"; Stock.value1!; : COLOR 11: PRINT " at Close: "; : COLOR 14: PRINT Stock.grade1; TAB(60); : COLOR 11: PRINT USING "##.##"; Stock.grade2!; : _
        COLOR 3: PRINT TAB(66); "Points"; : COLOR 12: PRINT TAB(72); USING "####.##"; Stock.value2!
        IF pnt = 1 THEN LPRINT " "; Stock.nameof; : LPRINT USING "$####.##"; Stock.value1!; : LPRINT "   at Close:  "; Stock.grade1; TAB(60); : LPRINT USING "##.##"; Stock.grade2!; : LPRINT TAB(66); "Points"; TAB(72); : LPRINT USING "####.##"; Stock _
.value2!
        REM    line above prints out all stock movement data (current)
        REM    it does NOT calculate any changes!
        IF RcrdNmbr = 18 THEN SLEEP 4              ' pause at page 1
        SLEEP 1
NEXT RcrdNmbr
        IF pnt = 1 THEN LPRINT CHR$(12)            ' form feed end of page.
        pnt = 0
        CLOSE #3
SLEEP
RETURN      '     ^^^^^^^  end of showing of all stock values. ^^^^^^
REM         '          BELOW... calculation of stock's new value.
REM
calculate:
        GOSUB count
        OPEN "stock.id" FOR RANDOM AS #1 LEN = LEN(Stock)
FOR RcrdNmbr = 1 TO total
        GET #1, RcrdNmbr, Stock
        Stock.value1! = Stock.value2!       'saves current as old value.
        GOSUB rando
        rand2 = rand1
        GOSUB rando
        IF rand1 = rand2 THEN rand3 = 20
        IF rand1 = 1 THEN rand2 = 2
        IF rand1 = 2 THEN rand2 = 1
        IF rand1 = 3 THEN rand2 = .75
        IF rand1 = 4 THEN rand2 = .5
        IF rand1 = 5 THEN rand2 = .25          ' numbers here are randomly
        IF rand1 = 6 THEN rand2 = .5           ' used to calculate multiples
        IF rand1 = 7 THEN rand2 = .75          ' of 1/100 of stock value.
        IF rand1 = 8 THEN rand2 = 1
        IF rand1 = 9 THEN rand2 = 1.5
        IF rand1 = 10 THEN rand2 = 3.75
        IF rand1 = 11 THEN rand2 = 0
        IF rand1 = 12 THEN rand2 = .5
        IF rand1 = 13 THEN rand2 = .75
        IF rand3 = 20 THEN rand2 = rand2 + rand3
        IF rand1 < 12 AND Stock.Flux! > 2 THEN rand2 = rand2 - 1
        IF rand1 < 12 THEN rand2 = rand2 + Stock.Flux! - 1: Stock.grade2! = rand2
        IF rand1 < 12 AND Stock.Flux! > 1 THEN rand2 = rand2 - 1
        IF rand1 > 11 THEN Stock.grade2! = rand2
        REM________line below helps penny stocks grow quick at first.______
        IF Stock.value1! < 1 THEN rand2 = rand2 + 60: IF rand1 < 5 THEN rand2 = rand2 - 60
        rand3 = (Stock.value2! / 100) * rand2
        IF rand1 > 4 THEN Stock.value2! = Stock.value2! + rand3: Stock.grade1 = "up"
        IF rand1 < 5 THEN Stock.value2! = Stock.value2! - rand3: Stock.grade1 = "down"
        IF value2 < .01 THEN value2 = 0
        IF rand1 = 11 THEN Stock.grade2! = 0: Stock.grade1 = "even": Stock.value2! = Stock.value1!
        PUT #1, RcrdNmbr, Stock             ' < this line enters all new data.
        rand1 = 0: rand2 = 0: rand3 = 0     ' < this line clears random data.
NEXT RcrdNmbr
        CLOSE #1
CLS
LOCATE 10, 10: PRINT "----Please wait for Calculations.": SLEEP 1: COLOR 10
'LOCATE 10, 10: PRINT "\": SLEEP 1: LOCATE 10, 10: PRINT "|": SLEEP 1: LOCATE 10, 10: PRINT "/": SLEEP 1
LOCATE 10, 10: COLOR 3: PRINT "All Stocks are now Re-Calculated.": COLOR 2
LOCATE 18, 30: PRINT "press any key to return to Menu"
SLEEP
RETURN
REM
REM
rando:
rand1 = INT((13 - 1 + 1) * RND + 1)
RETURN
count:
        CLOSE
        RcrdNmbr = 0
        OPEN "stock.id" FOR RANDOM AS #2 LEN = LEN(Stock)
DO
        RcrdNmbr = RcrdNmbr + 1
        GET #2, RcrdNmbr, Stock
LOOP UNTIL EOF(2)
        CLOSE #2: RcrdNmbr = RcrdNmbr - 1
        COLOR 9: LOCATE 25, 27: PRINT "Total Stock Options : "; RcrdNmbr; : total = RcrdNmbr
RETURN

SUB Banner (st$, row%) STATIC
    temPrime$ = ""
    IF NOT (bannerFlag) THEN
      bannerFlag = -1
      text$ = st$
    END IF
    FOR n = 1 TO LEN(text$) - 1
      temPrime$ = temPrime$ + MID$(text$, n + 1, 1)
    NEXT n
    temPrime$ = temPrime$ + LEFT$(text$, 1)
    text$ = temPrime$
    x% = INT((76 - (LEN(text$))) / 2) + 1
    LOCATE row%, x%, 0
    PRINT text$;
END SUB

SUB instr1
CLS
COLOR 10
LOCATE 3, 15: PRINT "Operation of this Stock Program.": COLOR 2
LOCATE 4, 9: PRINT "(for game use and entertainment purpose only.": COLOR 11
LOCATE 6, 5: PRINT "To Add an new stock to the list:"
LOCATE 7, 5: PRINT "    Select (a) from the main menu.  Enter the name of the new stock"
LOCATE 8, 5: PRINT "    then the description, then Flux level."
LOCATE 9, 5: PRINT " What is Flux level?"
LOCATE 10, 5: PRINT "    Flux (fluxuation) is an outside stock variable defined by the"
LOCATE 11, 5: PRINT "    program user.  It influences the (flux) up or down value amount."
LOCATE 12, 5: PRINT "    Normal Range is (2 - 3 - 4)  with extreme settings of 1 and 5."
COLOR 3: LOCATE 13, 5: PRINT "  1 = very poor stock but very low risk stocks. "
LOCATE 14, 5: PRINT "  2 = low risk, low losses when incurred & low gains."
LOCATE 15, 5: PRINT "  3 = moderate risk / could go up or down possibly no pattern."
LOCATE 16, 5: PRINT "  4 = higher risk / bigger return possible"
LOCATE 17, 5: PRINT "  5 = High Risk - biggest risk of large jumps in gains and losses."
COLOR 12: LOCATE 13, 7: PRINT "1": LOCATE 17, 7: PRINT "5": COLOR 11
LOCATE 18, 5: PRINT "                                                                     "
LOCATE 19, 5: PRINT "The final thing to add to new stock is the starting value.  The "
LOCATE 20, 5: PRINT "recommended amount to start with is from .10 / 10 to several dollars."
LOCATE 21, 5: PRINT "You may also enter real stock values (current rates)."
COLOR 8: LOCATE 24, 20: PRINT "press any key to continue"
SLEEP
END SUB

SUB instr2
COLOR 10: CLS
LOCATE 2, 15: PRINT "The Next Step...": COLOR 11
LOCATE 5, 9: PRINT "    Once you have stock entered in the system, you must choose"
LOCATE 6, 5: PRINT "(c) Calculate from the main menu to calculate the movement in the"
LOCATE 7, 5: PRINT "stock.  Stocks are then ALL calculated according to random events and"
LOCATE 8, 5: PRINT "are influenced by the stock's own Flux level as well."
LOCATE 9, 5: PRINT "  NOTE:  Stock is calculated each time you choose this option."
LOCATE 10, 5: PRINT "         this represents day end/week end or month end figures."
LOCATE 11, 5: PRINT "         whatever you need to calculate for your specific game."
LOCATE 12, 5: PRINT "  "
LOCATE 16, 5: PRINT "All other options are self-explanitory. (Editing & Viewing your Stock)"
COLOR 8: LOCATE 24, 20: PRINT "press any key to continue"
SLEEP

END SUB

SUB logo
LOCATE 5, 10: PRINT ".......  .......  .......  .......  .    .."
  LOCATE 6, 10: PRINT ":     :  :  :  :  :     :  :     :  :   . "
  LOCATE 7, 10: PRINT ":           :     :     :  :     :  :  .  "
    LOCATE 8, 10: PRINT ":           :     :     :  :        : .    "
      LOCATE 9, 10: PRINT ":......     :     :     :  :        :......"
   LOCATE 10, 10: PRINT "      :     :     :     :  :        :     :"
      LOCATE 11, 10: PRINT "      :     :     :     :  :        :     :"
    LOCATE 12, 10: PRINT "      :     :     :     :  :        :     :"
  LOCATE 13, 10: PRINT "      :     :     :     :  :        :     :"
  LOCATE 14, 10: PRINT ":     :     :     :     :  :     :  :     :"
LOCATE 15, 10: PRINT ":.....:     :     :.....:  :.....:  :     :"
END SUB

SUB menu
LOCATE 5, 18: PRINT ""
LOCATE 6, 18: PRINT ""; : LOCATE 6, 59: PRINT ""
LOCATE 7, 18: PRINT ""; : LOCATE 7, 59: PRINT ""
LOCATE 8, 18: PRINT ""; : LOCATE 8, 59: PRINT ""
LOCATE 9, 18: PRINT ""; : LOCATE 9, 59: PRINT ""
LOCATE 10, 18: PRINT ""; : LOCATE 10, 59: PRINT ""
LOCATE 11, 18: PRINT ""; : LOCATE 11, 59: PRINT ""
LOCATE 12, 18: PRINT ""; : LOCATE 12, 59: PRINT ""
LOCATE 13, 18: PRINT ""; : LOCATE 13, 59: PRINT ""
LOCATE 14, 18: PRINT ""; : LOCATE 14, 59: PRINT ""
LOCATE 15, 18: PRINT ""; : LOCATE 15, 59: PRINT ""
LOCATE 16, 18: PRINT ""; : LOCATE 16, 59: PRINT ""
LOCATE 17, 18: PRINT ""; : LOCATE 17, 59: PRINT ""
LOCATE 18, 18: PRINT ""; : LOCATE 18, 59: PRINT ""
LOCATE 19, 18: PRINT ""; : LOCATE 19, 59: PRINT ""
LOCATE 20, 18: PRINT ""; : LOCATE 20, 59: PRINT ""
LOCATE 21, 18: PRINT ""; : LOCATE 21, 59: PRINT ""
LOCATE 22, 18: PRINT ""
        COLOR 9: LOCATE 1, 26: PRINT "(c)96/97 Kevin Everingham";
END SUB

