#ifdef __WIN32__

#define STRICT
#include <windows.h>
#include <stdlib.h>

#include "str_lib.h"
#include "mp2win.h"
#include "rfu_list.h"

RecentFileList::RecentFileList(int num_entries0, int type0)
{
	num_entries = num_entries0;
   type = type0;
   valid_entries = 0;

   int i;

   name_array = new char *[num_entries];

   for(i=0; i<num_entries; i++) {
      name_array[i] = new char[MAX_PATH];
		lstrcpy(name_array[i], "");
   }

   menu_init = new bool [num_entries];

	menu_init[0] = TRUE;
   for (i=1; i<num_entries; i++)
   	menu_init[i] = FALSE;
}

RecentFileList::~RecentFileList()
{
	int i;

   for (i=0;i<num_entries;i++) {
   	delete [] name_array[i];
   }

   delete [] name_array;
   delete [] menu_init;
}

bool RecentFileList::registry_io(bool write_mode)
{
	char ret_type[256];
   char temp_str1[32];
   char temp_str2[32];

	HKEY ret_key1;
   HKEY ret_key2;

   int i;
   DWORD disp;
   DWORD size;

   RegOpenKeyEx(HKEY_CURRENT_USER, "Software", 0, KEY_CREATE_SUB_KEY,
   		       &ret_key1);

   RegCreateKeyEx(ret_key1, "Jeff's Tacos", 0, ret_type,
                  REG_OPTION_NON_VOLATILE, KEY_CREATE_SUB_KEY,
                  NULL, &ret_key2, &disp);

	RegCloseKey(ret_key1);

   RegCreateKeyEx(ret_key2, "Maplay 1.2+ for Win32", 0, ret_type,
   			      REG_OPTION_NON_VOLATILE, KEY_CREATE_SUB_KEY,
                  NULL, &ret_key1, &disp);

	if (type == RFL_FILE_TYPE) {
		RegCreateKeyEx(ret_key1, "Recent Files", 0, ret_type,
	   			      REG_OPTION_NON_VOLATILE, KEY_WRITE,
	                  NULL, &ret_key2, &disp);
   } else {
		RegCreateKeyEx(ret_key1, "Recent Lists", 0, ret_type,
	   			      REG_OPTION_NON_VOLATILE, KEY_WRITE,
	                  NULL, &ret_key2, &disp);
	}

   RegCloseKey(ret_key1);

   if (write_mode || (disp == REG_CREATED_NEW_KEY)) {

   	if (disp == REG_CREATED_NEW_KEY)
        	valid_entries = 0;

		for (i=0; i<num_entries; i++) {

        	itoa(i, temp_str2, 10);
	      lstrcpy(temp_str1, "File ");
	      lstrcat(temp_str1, temp_str2);

	   	RegSetValueEx(ret_key2, temp_str1, 0, REG_SZ,
   	                 (CONST BYTE *) name_array[i],
                       (lstrlen(name_array[i]) + 1) * sizeof(char));
      }

   } else {

   	valid_entries = 0;
      i = 0;
      bool bad_entry = FALSE;

		while ((i<num_entries) && !bad_entry)
      {
         itoa(i, temp_str2, 10);
         lstrcpy(temp_str1, "File ");
         lstrcat(temp_str1, temp_str2);

	   	size = MAX_PATH;
		   RegQueryValueEx(ret_key2, temp_str1, 0, NULL,
      				       (LPBYTE) name_array[i], &size);

			bad_entry = (name_array[i][0] == '\0');

         if (!bad_entry)
	         valid_entries++;

         i++;
      }
   }

   RegCloseKey(ret_key2);
   return true;
}

bool RecentFileList::read_from_registry()
{
	return registry_io(false);
}

bool RecentFileList::write_to_registry()
{
	return registry_io(true);
}

char *RecentFileList::get_name_at_pos(char *name, int pos) const
{
   lstrcpy(name, name_array[pos]);

   return name;
}

void RecentFileList::push(char *filename)
{
   int i, j;

   // Check if the filename is already in the list
	for (i=0; i<valid_entries; i++) {
   	if (b_strcmpi(filename, name_array[i])) {
			for (j=i; j>0; j--) {
         	 lstrcpy(name_array[j], name_array[j-1]);
         }
         lstrcpy(name_array[0], filename);
      	return;
      }
   }

   // Push the stack down
   if (valid_entries < num_entries)
	   valid_entries++;

	for (i=valid_entries-1; i>0; i--) {
   	lstrcpy(name_array[i], name_array[i-1]);
   }

   lstrcpy(name_array[0], filename);
   return;
}

bool RecentFileList::remove(char *filename)
{
	int i, j;

	for (i=0; i<valid_entries; i++) {
   	if (b_strcmpi(filename, name_array[i])) {
			for (j=i; j<(valid_entries-1); j++) {
         	 lstrcpy(name_array[j], name_array[j+1]);
         }
         lstrcpy(name_array[valid_entries-1], "");
         valid_entries--;
      	return true;
      }
   }
   return false;
}

HMENU RecentFileList::build_menu(HMENU menu, HWND hWnd) const
{

   char menu_entry[MAX_PATH + 8];
   char num_str[8];
   int  message_base;
   int i;

   message_base = (type == RFL_FILE_TYPE) ? CM_FILERECENTF1 :
   					CM_FILERECENTL1;

   for (i=0; i<num_entries; i++) {
   	if (menu_init[i]) {
	   	RemoveMenu(menu, message_base + i, MF_BYCOMMAND);
      }
   }

  	for (i=0; i<valid_entries; i++) {

     	lstrcpy(menu_entry, "&");
      itoa(i+1, num_str, 10);
      lstrcat(menu_entry, num_str);
      lstrcat(menu_entry, " ");
      lstrcat(menu_entry, name_array[i]);

      AppendMenu(menu, MF_ENABLED | MF_STRING,
                 message_base + i, menu_entry);

      menu_init[i] = TRUE;
   }

   DrawMenuBar(hWnd);

	return menu;
}
#endif // __WIN32__
