#ifndef RFU_LIST_H
#define RFU_LIST_H
#ifdef  __WIN32__
#define STRICT
#include <windows.h>

// Types of file lists
#define RFL_FILE_TYPE 0
#define RFL_LIST_TYPE 1

class RecentFileList {

public:

	RecentFileList(int num_entries0, int type0);
   ~RecentFileList();

   char *get_name_at_pos(char *name, int pos) const;
   void push(char *filename);
	bool remove(char *filename);

   bool read_from_registry();
   bool write_to_registry();
   HMENU build_menu(HMENU menu, HWND hWnd) const;

private:

	char **name_array;
   bool *menu_init;

   int num_entries;
   int type;
   int valid_entries;

   bool registry_io(bool write_mode);

};

#endif // __WIN32__
#endif // RFU_LIST_H