#ifndef W32_COMMON_H
#define W32_COMMON_H

#include <windows.h>

#include "obuffer.h"
#include "playlist.h"

#define _export
#define GET_WM_COMMAND_ID(wp, lp)    LOWORD(wp)
#define GET_WM_COMMAND_HWND(wp, lp) (HWND)(lp)
#define GET_WM_COMMAND_CMD(wp, lp)	 HIWORD(wp)

extern OPENFILENAME ofnOpen;
extern char OpenFilter[];

extern HINSTANCE hInst;     // hInstance of application
extern HWND      hWnd;      // hWnd of main window

// Playlist edit window, and its buttons
extern HWND hWndList;
extern HWND playbut;

// the jump window
extern HWND hPlayList;

extern FileList fl;
extern FileList edit_fl;
extern PlayList pl;

// State variables set by us
extern BOOL ListMode;
extern BOOL MPEG;
extern BOOL CDMode;
extern BOOL final_track;
extern BOOL CMDLINE;
extern BOOL paused;
extern BOOL can_play;
extern BOOL can_pause;
extern BOOL can_stop;
extern BOOL playing;
extern BOOL save_mode;
extern BOOL scrolling;
extern BOOL hidden;
extern BOOL openbox_open;
extern BOOL optionsbox_open;
extern BOOL aboutbox_open;

// Behavior set by user

extern BOOL Repeat;
extern BOOL capture_mode;

extern BOOL play_after_open;
extern BOOL cmdline_exit;
extern BOOL systray_mode;
extern BOOL prompt_after_done;
extern BOOL allow_multiple;
extern BOOL auto_save;
extern HWND topness;

extern enum e_channels mode;
extern BOOL use_own_scalefac;
extern float scalefactor;
extern int priority;
extern enum e_output output_mode;

extern BOOL rand_list_on_open;

extern BOOL display_images;
extern BOOL custom_img_viewer;
extern char civ_name[MAX_PATH];
extern char iv_cmdline[MAX_PATH];

extern BOOL display_lyric_tf;
extern BOOL custom_tf_viewer;
extern char ctfv_name[MAX_PATH];
extern char tf_cmdline[MAX_PATH];

BOOL File_Init(BOOL fix_list);

extern void List_Play_Current(BOOL list_play_after_load);
BOOL list_save(FileList *plsfl, HWND hWnd0);

// Helper function for system tray
BOOL TrayMessage(DWORD dwMessage, HWND hWnd);

#endif // W32_COMMON_H
