#ifndef W32_GLOBAL_VAR_H
#define W32_GLOBAL_VAR_H

#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <shlobj.h>

#include "obuffer.h"
#include "playlist.h"
#include "w32_lview.h"
#include "w32_option.h"
#include "w32_common.h"

// variables in "w32_common.h"
OPENFILENAME ofnOpen;
char OpenFilter[] =
"All Readable Files\0"
"*.mp*;*.snd;*.wav;*.mid;*.rmi;*.cda;*.lst;*.m3u;*.txt;"
"*.au;*.aif;*.aifc;*.aiff;"
"*.avi;*.mov;*.qt;*.dat;*.enc;*.m1v;*.mpeg;*.mpg;*.mpv;"
"*.cda\0"
"Playlists (.txt, .lst, .m3u)\0*.lst;*.m3u;*.txt\0"
"MPEG Audio Streams (.mp1, .mp2, .mp3, .mpp)\0*.mp1;*.mp2;*.mp3;*.mpp\0"
"DALET Sound Files (.snd)\0*.snd\0"
"PCM Wave Files (.wav)\0*.wav\0"
"MIDI Sequencer (.mid, .rmi)\0*.mid;*.rmi\0"
"Sun/NeXT Sounds (.au)\0*.au\0"
"Apple AIFF (.aif, .aifc, .aiff)\0*.aif;*.aifc;*.aiff\0"
"Video for Windows (.avi)\0*.avi\0"
"MPEG-1 Video (.dat, .enc, .m1v, .mpe, .mpeg, .mpg, .mpv)\0"
"*.dat;*.m1v;*.mpe;*.mpeg;*.mpg;*.mpv\0"
"Quicktime Movies (.mov, .qt)\0*.mov;*.qt\0"
"CD Audio Tracks (.cda)\0*.cda\0"
"All Files (*.*)\0*.*\0";


// Variables in "w32_lview.h"
OPENFILENAME ofnListEdit;
OPENFILENAME ofnListSaveAs;
char ListSaveAsFilter[] =
"Playlists (.txt, .lst, .m3u)\0*.lst;*.m3u;*.txt\0"
"All Files (*.*)\0*.*\0";

BOOL listedit_ok = FALSE;

char ListEditAddName[MAX_FILENAME_LENGTH * 64];
char ListEditFileTitle[MAX_PATH];

// Variables in "w32_option.h"
OPENFILENAME ofnOutput;
char OutputFilter[] =
"PCM Wave Files (.wav)\0*.wav\0"
"All Files (*.*)\0*.*\0";
char OutputFilename[MAX_PATH] = ""; // Name of PCM wave output file

// Variables in "w32_common.h"
HINSTANCE hInst = NULL;      // hInstance of application
HWND      hWnd  = NULL;      // hWnd of main window

// Playlist edit window, and its buttons
HWND hWndList;
HWND playbut;

// the jump window
HWND hPlayList = NULL;

FileList fl;
PlayList pl;

// State variables set by us
BOOL ListMode    = FALSE;
BOOL MPEG        = FALSE;
BOOL CDMode      = FALSE;
BOOL final_track = FALSE;
BOOL CMDLINE     = FALSE;
BOOL paused      = FALSE;
BOOL can_play    = FALSE;
BOOL can_pause   = FALSE;
BOOL can_stop    = FALSE;
BOOL playing     = FALSE;
BOOL save_mode   = FALSE;
BOOL scrolling   = FALSE;
BOOL hidden      = FALSE;
BOOL openbox_open    = FALSE;
BOOL optionsbox_open = FALSE;
BOOL aboutbox_open   = FALSE;

// Behavior set by user
enum e_channels mode   = both;
BOOL Repeat            = FALSE;
BOOL capture_mode      = FALSE;

BOOL play_after_open   = TRUE;
BOOL cmdline_exit      = TRUE;
BOOL systray_mode      = TRUE;
BOOL use_own_scalefac  = FALSE;
float scalefactor      = 32768.0;
BOOL prompt_after_done = FALSE;
BOOL allow_multiple    = FALSE;
BOOL auto_save         = FALSE;
HWND topness           = HWND_NOTOPMOST;

enum e_output output_mode = O_WAVEMAPPER;

BOOL display_images    = TRUE;
BOOL custom_img_viewer = FALSE;
extern char civ_name[MAX_PATH] = "";
extern char iv_cmdline[MAX_PATH] = "";

BOOL rand_list_on_open  = FALSE;

int priority = THREAD_PRIORITY_ABOVE_NORMAL;

#endif // W32_GLOBAL_VAR_H
