#define  STRICT
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <shlobj.h>

#include "str_lib.h"
#include "playlist.h"

#include "w32_common.h"
#include "w32_util.h"
#include "w32_lview.h"

#include "mpw_msg.h"
#include "mp2win.h"

HWND DumbJumphWnd = NULL;

HIMAGELIST hIconList;
// raise by PlaylistWndHiliteCurrent(); distinguish between automatic
// hilited and user-select hilited
BOOL autoHilited = FALSE;

WNDPROC OldListWndProc	 = NULL;
WNDPROC OldDumButWndProc = NULL;

// buttons in the list edit dialog box
HWND save_but, test_but, remove_but, remove_all_but;
HWND rand_but, prop_but, up_but, down_but;

int  listedit_command = LIST_NEW;
BOOL listedit_ok = FALSE;

char ListEditAddName[MAX_FILENAME_LENGTH * 64];
char ListEditFileTitle[MAX_PATH];

int next_pos_to_add  = 0;

OPENFILENAME ofnListEdit;
OPENFILENAME ofnListSaveAs;
OPENFILENAME m_ofn, i_ofn, l_ofn;

char t_mfn[MAX_FILENAME_LENGTH];
char t_ifn[MAX_FILENAME_LENGTH];
char t_lfn[MAX_FILENAME_LENGTH];

char ImageFilter[] =
"All Image Types\0*.jpg;*.jpeg;*.jpe;*.gif;*.bmp;*.png;*.pcd;*.tif;*.tiff;"
"*.tga;*.pcx;*.psd;*.iff;*.wmf\0"
"JPEG Images (*.jpg, *.jpeg)\0*.jpg;*.jpeg;*.jpe\0"
"GIF Images (*.gif)\0*.gif\0"
"Windows Bitmap Images (*.bmp)\0*.bmp\0"
"Portable Network Graphics (*.png)\0*.png\0"
"Kodak PhotoCD (*.pcd)\0*.pcd\0"
"Tag Image File Format (*.tif, *.tiff)\0*.tif;*.tiff\0"
"Targa TGA Images (*.tga)\0*.tga\0"
"ZSoft Publishers Paintbrush (*.pcx)\0*.pcx\0"
"Adobe Photoshop Document (*.psd)\0*.psd\0"
"EA Interchange File Format (*.iff)\0*.iff\0"
"Windows Metafile Format (*..wmf)\0*.wmf\0"
"All Files (*.*)\0*.*\0";

char LyricFilter[] =
"All Lyric Types\0*.js;*.txt;*.doc\0"
"JacoScript Timed Lyrics (*.js)\0*.js\0"
"ASCII Text (*.txt)\0*.txt\0"
"Word Document (*.txt)\0*.doc\0"
"All Files (*.*)\0*.*\0";

char ListSaveAsFilter[] =
"Playlists (.txt, .lst, .m3u)\0*.lst;*.m3u;*.txt\0"
"All Files (*.*)\0*.*\0";

void setup_lview_ofn()
{
	 m_ofn.lStructSize       = sizeof(OPENFILENAME);
    m_ofn.hwndOwner         = NULL;  // fill this in later
    m_ofn.hInstance         = 0;
    m_ofn.lpstrFilter       = (LPSTR) OpenFilter;
    m_ofn.lpstrCustomFilter = NULL;
    m_ofn.nMaxCustFilter    = 0;
    m_ofn.nFilterIndex      = 1;
    m_ofn.lpstrFile         = (LPSTR) t_mfn;
    m_ofn.nMaxFile          = sizeof(t_mfn);
    m_ofn.lpstrFileTitle    = NULL;
    m_ofn.nMaxFileTitle     = 0;
    m_ofn.lpstrInitialDir   = NULL;
    m_ofn.lpstrTitle        = "Open Media File(s)";
    m_ofn.Flags             = OFN_PATHMUSTEXIST | OFN_EXPLORER |
                              OFN_HIDEREADONLY;
    m_ofn.nFileOffset       = 0;
    m_ofn.nFileExtension    = 0;
    m_ofn.lpstrDefExt       = "MP*";
    m_ofn.lCustData         = 0;
    m_ofn.lpfnHook          = NULL;
    m_ofn.lpTemplateName    = NULL;

	 l_ofn.lStructSize       = sizeof(OPENFILENAME);
    l_ofn.hwndOwner         = NULL;  // fill this in later
    l_ofn.hInstance         = 0;
    l_ofn.lpstrFilter       = (LPSTR) LyricFilter;
    l_ofn.lpstrCustomFilter = NULL;
    l_ofn.nMaxCustFilter    = 0;
    l_ofn.nFilterIndex      = 1;
    l_ofn.lpstrFile         = (LPSTR) t_lfn;
    l_ofn.nMaxFile          = sizeof(t_lfn);
    l_ofn.lpstrFileTitle    = NULL;
    l_ofn.nMaxFileTitle     = 0;
    l_ofn.lpstrInitialDir   = NULL;
    l_ofn.lpstrTitle        = "Open Lyric File(s)";
    l_ofn.Flags             = OFN_PATHMUSTEXIST | OFN_EXPLORER |
                              OFN_HIDEREADONLY;
    l_ofn.nFileOffset       = 0;
    l_ofn.nFileExtension    = 0;
    l_ofn.lpstrDefExt       = "JS";
    l_ofn.lCustData         = 0;
    l_ofn.lpfnHook          = NULL;
    l_ofn.lpTemplateName    = NULL;

	 i_ofn.lStructSize       = sizeof(OPENFILENAME);
    i_ofn.hwndOwner         = NULL;  // fill this in later
    i_ofn.hInstance         = 0;
    i_ofn.lpstrFilter       = (LPSTR) ImageFilter;
    i_ofn.lpstrCustomFilter = NULL;
    i_ofn.nMaxCustFilter    = 0;
    i_ofn.nFilterIndex      = 1;
    i_ofn.lpstrFile         = (LPSTR) t_ifn;
    i_ofn.nMaxFile          = sizeof(t_ifn);
    i_ofn.lpstrFileTitle    = NULL;
    i_ofn.nMaxFileTitle     = 0;
    i_ofn.lpstrInitialDir   = NULL;
    i_ofn.lpstrTitle        = "Open Image File(s)";
    i_ofn.Flags             = OFN_PATHMUSTEXIST | OFN_EXPLORER |
                              OFN_HIDEREADONLY;
    i_ofn.nFileOffset       = 0;
    i_ofn.nFileExtension    = 0;
    i_ofn.lpstrDefExt       = "JPG";
    i_ofn.lCustData         = 0;
    i_ofn.lpfnHook          = NULL;
    i_ofn.lpTemplateName    = NULL;
}


void edit_listview_entry(HWND hWndList, FileList *flp, int i,
                         BOOL add)
{
    char tp[MAX_FILENAME_LENGTH];
    char *tp1;
    LV_ITEM lvi;
    PlayListItem pli = flp->get_item_at(i);

    lvi.mask  = LVIF_TEXT | LVIF_PARAM | LVIF_STATE | LVIF_IMAGE;
    lvi.state = 0;
    lvi.stateMask = LVIS_CUT | LVIS_DROPHILITED	| LVIS_FOCUSED	| LVIS_SELECTED;
	 lvi.iItem      = i;
    lvi.iSubItem   = 0;
    flp->get_track_display_at(tp, i, true);
    lvi.pszText    = tp;
    lvi.cchTextMax = MAX_FILENAME_LENGTH;
    lvi.iImage     = LookUpIconIndex(pli.get_filename());
    lvi.lParam     = (LPARAM) i;

    if (add)
	    ListView_InsertItem(hWndList, &lvi);
    else
		 ListView_SetItem(hWndList, &lvi);

    if (pli.get_alias() != NULL) {
	    ListView_SetItemText(hWndList, i, 1, pli.get_alias());
    } else {
	    ListView_SetItemText(hWndList, i, 1, "");
    }

    tp1 = pli.get_lyric_filename();
    if (tp1 != NULL) {
       ListView_SetItemText(hWndList, i, 2, Proper_Filename(tp1));
    } else {
       ListView_SetItemText(hWndList, i, 2, "");
	 }

    tp1 = pli.get_image_filename();
    if (tp1 != NULL) {
     	 ListView_SetItemText(hWndList, i, 3, Proper_Filename(tp1));
    } else {
     	 ListView_SetItemText(hWndList, i, 3, "");
    }

    return;
}

void rebuild_listview_entries(int start_index)
{
	int i = start_index;
   BOOL nonzero;

   while (i < edit_fl.get_number_of_entries()) {
     edit_listview_entry(hWndList, &edit_fl, i, TRUE);
     i++;
   }

   nonzero = (BOOL) (edit_fl.get_number_of_entries() > 0);

   EnableWindow(test_but, nonzero);
   EnableWindow(remove_but, nonzero);
   EnableWindow(remove_all_but, nonzero);
   EnableWindow(save_but, nonzero);
   EnableWindow(rand_but, nonzero);
   EnableWindow(prop_but, nonzero);
}

BOOL CALLBACK NewListWndProc(HWND lv_hWnd, UINT message,
									  WPARAM wParam, LPARAM lParam)
{
	 switch (message) {
    	  case WM_DROPFILES:
        {
/*        		int num_to_add;
            int i;
            int insert_at;
            LV_HITTESTINFO hInfo;

            get_dropped_files(ListEditAddName, MAX_FILENAME_LENGTH,
                              (HDROP) wParam);

            DragQueryPoint((HDROP) wParam, &(hInfo.pt));

            insert_at = ListView_HitTest(lv_hWnd, &hInfo); */

         LV_FINDINFO findinfo;
         int insert_at, num_to_add, i;

         get_dropped_files(ListEditAddName, MAX_FILENAME_LENGTH,
                           (HDROP) wParam);

         DragQueryPoint((HDROP) wParam, &(findinfo.pt));

         findinfo.flags = LVFI_NEARESTXY;
         findinfo.vkDirection = VK_LEFT;

         insert_at = ListView_FindItem(lv_hWnd, -1, &findinfo);

         if (insert_at == -1)
           	insert_at = next_pos_to_add;

         num_to_add = edit_fl.read_from_string(ListEditAddName, false,
                                             PL_APPEND, insert_at);

			for (i=insert_at; i<next_pos_to_add; i++) {
				ListView_DeleteItem(hWndList, insert_at);
         }

         next_pos_to_add += num_to_add;
			rebuild_listview_entries(insert_at);
        }
        break;

        case WM_LBUTTONDOWN:
        {
 /*        LV_FINDINFO findinfo;
         int which;
         RECT r;

         GetWindowRect(lv_hWnd, &r);

         findinfo.flags = LVFI_NEARESTXY;
         findinfo.pt.x = LOWORD(lParam) + r.left;
         findinfo.pt.y = HIWORD(lParam) + r.top;
         findinfo.vkDirection = VK_LEFT;

         which = ListView_FindItem(lv_hWnd, -1, &findinfo);

         char ack[16];
         itoa(which, ack, 10);
         MessageBox(lv_hWnd, ack, ack, MB_OK);
         ListView_SetItemState(lv_hWnd, which, LVIS_SELECTED, LVIS_SELECTED);  */
        }
        break;

        case WM_LBUTTONDBLCLK:
        {
         HWND parent = GetParent(lv_hWnd);
         SendMessage(parent, WM_COMMAND, IDC_LISTPROPBUT, 0);
        }
        break;

        case WM_KEYDOWN:
        {
         HWND parent = GetParent(lv_hWnd);
         switch (wParam) {

           case 'N':
           SendMessage(parent, WM_COMMAND, IDC_LISTRANDBUT, 0);
           break;

           case VK_BACK:
           case VK_DELETE:
           SendMessage(parent, WM_COMMAND, IDC_LISTREMOVEBUT, 0);
           break;

           case 'C':
           if ((edit_fl.get_number_of_entries() > 0) &&
               (MessageBox(hWnd,
                      "Are you sure you want to delete all list items?",
                      "Confirm keyboard event",
                      MB_YESNO | MB_ICONEXCLAMATION) == IDYES)) {
	           SendMessage(parent, WM_COMMAND, IDC_LISTCLEARBUT, 0);
           }
           break;

           case VK_INSERT:
           case 'I':
           SendMessage(parent, WM_COMMAND, IDC_INSERTBUT, 0);
           break;

           case 'P':
           SendMessage(parent, WM_COMMAND, IDC_LISTPROPBUT, 0);
           break;

           case VK_SPACE:
           case 'T':
           SendMessage(parent, WM_COMMAND, IDC_LISTTESTBUT, 0);
           break;

           default:
           break;
         }
        }
        break;
    }
    return CallWindowProc(OldListWndProc, lv_hWnd, message,
                          wParam, lParam);
}

BOOL CALLBACK ListEditProc(HWND  hDlg, UINT  message,
	 	   						WPARAM  wParam, LPARAM  lParam)
{
    int32 i;
    int32 num_selected;
    int32 old_pos_to_add;
    char *t_listname;
    char t_listname_buf[256];

    LV_COLUMN lvc;
    PlayListItem pli;

    static PlayList old_pl;
    static BOOL tested = FALSE;
    static HWND hParentDlg = NULL;

	 switch (message) {

		case WM_INITDIALOG:
      listedit_ok = FALSE;

      if (listedit_command == LIST_EDIT)
         old_pl = pl;

      tested = FALSE;

      hParentDlg = GetParent(hDlg);

      test_but = GetDlgItem(hDlg, IDC_LISTTESTBUT);
      remove_but = GetDlgItem(hDlg, IDC_LISTREMOVEBUT);
      remove_all_but = GetDlgItem(hDlg, IDC_LISTCLEARBUT);
      save_but = GetDlgItem(hDlg, IDC_LISTSAVEB);
      rand_but = GetDlgItem(hDlg, IDC_LISTRANDBUT);
      prop_but = GetDlgItem(hDlg, IDC_LISTPROPBUT);

      up_but = GetDlgItem(hDlg, IDC_LISTUP);
      down_but = GetDlgItem(hDlg, IDC_LISTDOWN);

      {
        HBITMAP up_bmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_UPBMP));
        HBITMAP down_bmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_DOWNBMP));

        SendMessage(up_but, BM_SETIMAGE, 0, (LPARAM) (HANDLE) up_bmp);
        SendMessage(down_but, BM_SETIMAGE, 0, (LPARAM) (HANDLE) down_bmp);
      }

      hWndList = GetDlgItem(hDlg, IDC_LISTLVIEW);

      lvc.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH;
      lvc.fmt  = LVCFMT_LEFT;
      lvc.pszText = "File";
      lvc.cx = 125;
      lvc.iSubItem = 0;
      ListView_InsertColumn(hWndList, 0, &lvc);
      lvc.pszText = "Alias";
      lvc.iSubItem = 1;
      ListView_InsertColumn(hWndList, 1, &lvc);
      lvc.pszText = "Lyric";
      lvc.iSubItem = 2;
      ListView_InsertColumn(hWndList, 2, &lvc);
      lvc.pszText = "Image";
      lvc.iSubItem = 3;
      ListView_InsertColumn(hWndList, 3, &lvc);

		ListView_SetImageList(hWndList, hIconList, LVSIL_SMALL);
      rebuild_listview_entries(0);

      next_pos_to_add = edit_fl.get_number_of_entries();

      CommDlg_OpenSave_SetControlText(hParentDlg, IDOK, "Add");
		CommDlg_OpenSave_HideControl(hParentDlg, IDCANCEL);

      t_listname = edit_fl.get_list_name();
      if (t_listname)
	      SetDlgItemText(hDlg, IDC_LISTTITLE, t_listname);

		DragAcceptFiles(hWndList, TRUE);

      // subclassing the list view control
      OldListWndProc = (WNDPROC) SetWindowLong((HWND) hWndList,
      													  (int) GWL_WNDPROC,
				      									  (LONG) NewListWndProc);
      return TRUE;

		case WM_NOTIFY:
      switch (((NMHDR FAR *) lParam)->code) {

      	case CDN_FILEOK:

         old_pos_to_add = next_pos_to_add;

         if (multi_file_select(ListEditAddName)) {
             next_pos_to_add +=
              edit_fl.read_from_string(ListEditAddName, true, PL_APPEND, -1);
         } else {
				 next_pos_to_add += edit_fl.append_to_list(ListEditAddName);
         }

			rebuild_listview_entries(old_pos_to_add);

			SetWindowLong(hDlg, DWL_MSGRESULT, 1);
         return TRUE;

			case CDN_INITDONE:
         break;

         default:
         return FALSE;
      }
      return FALSE;

		case WM_COMMAND:
		switch (GET_WM_COMMAND_ID(wParam, lParam))  {

      	case IDC_LISTSAVEB:
			GetDlgItemText(hDlg, IDC_LISTTITLE, t_listname_buf, 256);
			edit_fl.set_list_name(t_listname_buf);
         list_save(&edit_fl, hDlg);
         return TRUE;

         case IDC_LISTOKBUT:
			GetDlgItemText(hDlg, IDC_LISTTITLE, t_listname_buf, 256);
			edit_fl.set_list_name(t_listname_buf);

         pl = edit_fl;
         listedit_ok = TRUE;
			PostMessage(hParentDlg, WM_COMMAND, IDCANCEL, 0);
         return TRUE;

         case IDC_LISTCANCELBUT:

         if (listedit_command == LIST_EDIT) {
            listedit_ok = tested;

            if (tested)
               pl = old_pl;

         } else {
         	listedit_ok = FALSE;
         }

         PostMessage(hParentDlg, WM_COMMAND, IDCANCEL, 0);
         return TRUE;

         case IDC_LISTTESTBUT:
         {
           BOOL found = FALSE;
           i=0;

           while ((i<next_pos_to_add) && !found) {
	           if (ListView_GetItemState(hWndList, i, LVIS_SELECTED)
                  & LVIS_SELECTED) {
                 found = TRUE;
                 tested = TRUE;
                 PostMessage(hWnd, WM_CMDLINEFILE, 0,
                             (LPARAM) edit_fl.get_item_at(i).get_filename());
              }
              i++;
           }
         }
         SetFocus(hWndList);
         return TRUE;

         case IDC_LISTRANDBUT:
         edit_fl.randomize_order();
		   ListView_DeleteAllItems(hWndList);
			rebuild_listview_entries(0);
         return TRUE;

         case IDC_INSERTBUT:
         {
           int insert_index=0;
           BOOL found = FALSE;
           char index_str[32];
           char fn_str[48];

           while ((insert_index<next_pos_to_add) && !found) {
	           if (ListView_GetItemState(hWndList, insert_index, LVIS_SELECTED)
                  & LVIS_SELECTED) {
                 found = TRUE;
              } else {
                 insert_index++;
              }
           }
           itoa(insert_index+1, index_str, 10);
           lstrcpy(fn_str, "Track");
           lstrcat(fn_str, index_str);
           lstrcat(fn_str, ".cda");

           edit_fl.insert_entry(fn_str, insert_index);

			  for (i=insert_index;i<next_pos_to_add; i++) {
					ListView_DeleteItem(hWndList, insert_index);
           }
     		  rebuild_listview_entries(insert_index);
           next_pos_to_add++;
         }
         return TRUE;

         case IDC_LISTREMOVEBUT:
         {
          int first_del = next_pos_to_add - 1;

          num_selected = 0;
          for (i=0; i<next_pos_to_add; i++) {
	          if (ListView_GetItemState(hWndList, i, LVIS_SELECTED)
                 & LVIS_SELECTED) {
                 edit_fl.set_del_mark_at(i);

                 if (i < first_del)
                    first_del = i;

             	  num_selected++;
             }
          }

          if (num_selected > 0) {
	          edit_fl.remove_marked_entries();

			    for (i=first_del;i<next_pos_to_add; i++) {
				 	  ListView_DeleteItem(hWndList, first_del);
             }

     		    rebuild_listview_entries(first_del);
             next_pos_to_add = edit_fl.get_number_of_entries();
          }
         }
         break;

         case IDC_LISTCLEARBUT:
         edit_fl.reset();
			ListView_DeleteAllItems(hWndList);
         rebuild_listview_entries(0);
         next_pos_to_add = 0;
         break;

         case IDC_LISTPROPBUT:
         {
           int ret_val=1;
           i=0;

           while (i<next_pos_to_add && (ret_val==1)) {
	           if (ListView_GetItemState(hWndList, i, LVIS_SELECTED)
                  & LVIS_SELECTED) {

                 ret_val = i;
	              if (DialogBoxParam(hInst, MAKEINTRESOURCE(IDD_PLIPROP),
                                    hDlg, ListPropEditProc,
                                    (LONG) &ret_val)) {
						  edit_listview_entry(hWndList, &edit_fl, i, FALSE);
                 }
              }
              i++;
           }
         }
         break;

         case IDC_LISTUP:
         {
          int first_sel = next_pos_to_add - 1;

          num_selected = 0;
          for (i=0; i<next_pos_to_add; i++) {
	          if (ListView_GetItemState(hWndList, i, LVIS_SELECTED)
                 & LVIS_SELECTED)
             {
                 edit_fl.set_select_mark_at(i);

                 if (i < first_sel)
                    first_sel = i;

             	  num_selected++;
             }
          }

          if (num_selected > 0) {
             if (edit_fl.shift_up_selected()) {

				    for (i=first_sel-1;i<next_pos_to_add; i++) {
					 	  ListView_DeleteItem(hWndList, first_sel-1);
	             }

	     		    rebuild_listview_entries(first_sel-1);

                for (i=(first_sel-1); i<(first_sel-1+num_selected);i++) {
                   ListView_SetItemState(hWndList, i,
                                         LVIS_SELECTED|LVIS_FOCUSED,
                                         LVIS_SELECTED|LVIS_FOCUSED);
                }
	          }
             ListView_EnsureVisible(hWndList, first_sel-1+num_selected, FALSE);
             SetFocus(hWndList);
           }
         }
         break;

         case IDC_LISTDOWN:
         {
          int first_sel = next_pos_to_add - 1;
          int last_sel  = 0;

          num_selected = 0;
          for (i=0; i<next_pos_to_add; i++) {
	          if (ListView_GetItemState(hWndList, i, LVIS_SELECTED)
                 & LVIS_SELECTED)
             {
                 edit_fl.set_select_mark_at(i);

                 if (i < first_sel) first_sel = i;
                 if (i > last_sel)  last_sel = i;

             	  num_selected++;
             }
          }

          if (num_selected > 0) {
             if (edit_fl.shift_down_selected()) {

				    for (i=first_sel;i<next_pos_to_add; i++) {
					 	  ListView_DeleteItem(hWndList, first_sel);
	             }

	     		    rebuild_listview_entries(first_sel);
                for (i=(last_sel+1); i>(last_sel+1-num_selected);i--) {
                   ListView_SetItemState(hWndList, i,
                                         LVIS_SELECTED|LVIS_FOCUSED,
                                         LVIS_SELECTED|LVIS_FOCUSED);
                }
   	       }
             ListView_EnsureVisible(hWndList, last_sel+1, FALSE);
             SetFocus(hWndList);
           }
         }
         break;

         default:
         return FALSE;
      }

      default:
      return FALSE;
    }
}

BOOL CALLBACK ListPropEditProc(HWND hDlg, UINT  message,
	 	   						    WPARAM  wParam, LPARAM  lParam)
{
   static int *ret_addr = NULL;
   static int which_item = 0;

	switch (message) {

		case WM_INITDIALOG:

      m_ofn.hwndOwner = hDlg;
		l_ofn.hwndOwner = hDlg;
		i_ofn.hwndOwner = hDlg;

      ret_addr = (int *) lParam;
      which_item = *ret_addr;
      {
	      PlayListItem &edit_pli = edit_fl.get_item_at(which_item);
		   char *mfn   = edit_pli.get_filename();
		   char *alias = edit_pli.get_alias();
		   char *lfn   = edit_pli.get_lyric_filename();
		   char *ifn   = edit_pli.get_image_filename();

	      SetDlgItemText(hDlg, IDC_MFN,   (mfn!=NULL)   ? mfn   : "");
	      SetDlgItemText(hDlg, IDC_ALIAS, (alias!=NULL) ? alias : "");
         SetDlgItemText(hDlg, IDC_LFN,   (lfn!=NULL)   ? lfn   : "");
         SetDlgItemText(hDlg, IDC_IFN,   (ifn!=NULL)   ? ifn   : "");
      }
      break;

      case WM_COMMAND :

      switch (GET_WM_COMMAND_ID(wParam, lParam))  {

	      case IDOK:
         {
  	         PlayListItem &edit_pli = edit_fl.get_item_at(which_item);
            char mfn[MAX_FILENAME_LENGTH];
            char alias[MAX_FILENAME_LENGTH];
				char lfn[MAX_FILENAME_LENGTH];
				char ifn[MAX_FILENAME_LENGTH];

         	GetDlgItemText(hDlg, IDC_MFN, mfn, MAX_FILENAME_LENGTH);
         	GetDlgItemText(hDlg, IDC_ALIAS, alias, MAX_FILENAME_LENGTH);
         	GetDlgItemText(hDlg, IDC_LFN, lfn, MAX_FILENAME_LENGTH);
         	GetDlgItemText(hDlg, IDC_IFN, ifn, MAX_FILENAME_LENGTH);

            edit_pli.set_filename(mfn);
            edit_pli.set_alias(alias);
            edit_pli.set_lyric_filename(lfn);
            edit_pli.set_image_filename(ifn);
         }
         *ret_addr = 1;
	      EndDialog(hDlg, TRUE);
   	   break;

         case IDCANCEL:
         *ret_addr = 1;
         EndDialog(hDlg, FALSE);
         break;

         case IDC_PLISE:
         *ret_addr = 0;
         EndDialog(hDlg, FALSE);
         break;

         case IDC_MFNS:
         if (GetOpenFileName(&m_ofn))
         	SetDlgItemText(hDlg, IDC_MFN, t_mfn);
         break;

         case IDC_LFNS:
         if (GetOpenFileName(&l_ofn))
         	SetDlgItemText(hDlg, IDC_LFN, t_lfn);
         break;

         case IDC_IFNS:
         if (GetOpenFileName(&i_ofn))
         	SetDlgItemText(hDlg, IDC_IFN, t_ifn);
         break;

         default:
         return FALSE;
      }
      break;

      default:
      return FALSE;
   }
   return TRUE;
}

BOOL CALLBACK NewDumButWndProc(HWND hWnd, UINT message,
                               WPARAM wParam, LPARAM lParam)
{
	 switch (message) {

    case WM_NOTIFY:
    if (((LPNMHDR)lParam)->hwndFrom == hPlayList &&
        ((LPNMHDR)lParam)->code == LVN_ITEMCHANGED &&
        // have to & LVIS_SELECTED to check if it's selected
        // uNewState can have other bits
       (((LPNM_LISTVIEW)lParam)->uNewState & LVIS_SELECTED)== LVIS_SELECTED)
    {
       pl.goto_index(((LPNM_LISTVIEW)lParam)->iItem);
       List_Play_Current(TRUE);
    }
    break;
    }

    return CallWindowProc(OldDumButWndProc, hWnd, message,
    							  wParam, lParam);
}

BOOL CreatePlayListWnd() {
  	 RECT r;
    LV_COLUMN lv_column;

    if (DumbJumphWnd == NULL) {
    	 DumbJumphWnd = CreateWindowEx(WS_EX_TOOLWINDOW	, "BUTTON",
       "", WS_VISIBLE | WS_POPUP, 0, 0, 0, 0, NULL,
       NULL, hInst, NULL);
       OldDumButWndProc = (WNDPROC) SetWindowLong(DumbJumphWnd,GWL_WNDPROC,
            								              (LONG) NewDumButWndProc);
    }

    if (IsWindow(hPlayList)) {
    	  // if it's already there, just bring it to the front
    	  SetForegroundWindow(hPlayList);
        return TRUE;
    }

    if (ListMode) {

   	 hPlayList=CreateWindowEx(WS_EX_TOOLWINDOW | WS_EX_CLIENTEDGE |
                     WS_EX_TOPMOST,
                     WC_LISTVIEW,
         	         (pl.get_list_name() ? pl.get_list_name() : "Playlist"),
            	      LVS_NOCOLUMNHEADER | LVS_REPORT | LVS_SHAREIMAGELISTS |
                     LVS_NOSORTHEADER | LVS_SINGLESEL | WS_VISIBLE |
                     WS_POPUPWINDOW | WS_CAPTION | WS_SIZEBOX,
                     200, 160, 150, 250,
   	               DumbJumphWnd, NULL, hInst, NULL);

	    GetWindowRect(hPlayList, &r);

	    // set up the column
   	 lv_column.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH;
	    lv_column.fmt  = LVCFMT_LEFT;
   	 lv_column.cx   = r.right-r.left;
	    lv_column.iSubItem = 0;
   	 ListView_InsertColumn(hPlayList, 0, &lv_column);

	    ListView_SetImageList(hPlayList, hIconList, LVSIL_SMALL);
	    ListView_SetImageList(hPlayList, hIconList, LVSIL_NORMAL);
   	 UpdatePlayListWnd();

	    PlayListWndHiliteCurrent(); // Jeff : btw, you should restore the
                                // last highlighted to -1 I think
   	 return TRUE;

    } else {

    	 return FALSE;

    }
}

BOOL CleanupPlayListWnd()
{
	if (DumbJumphWnd != NULL) {
      HWND temp = DumbJumphWnd;
      DumbJumphWnd = NULL;
      return DestroyWindow(temp);
   } 

   return TRUE;
}

BOOL UpdatePlayListWnd() {
	int i;
	LV_ITEM lv_item;
   char songname[MAX_FILENAME_LENGTH+6];

   if (IsWindow(hPlayList) && !ListMode) {
   	DestroyWindow(hPlayList);
      return (TRUE);
   }

   if (IsWindow(hPlayList)) {
		ListView_DeleteAllItems(hPlayList);

  	   // add item label
   	lv_item.mask = LVIF_TEXT | LVIF_IMAGE;
	   lv_item.iSubItem = 0;
	   for (i=0; i<pl.get_number_of_entries(); i++) {
          pl.get_track_display_at(songname, i);
          lv_item.pszText = songname;
   	    lv_item.iItem = i;
          lv_item.iImage = LookUpIconIndex(pl.get_item_at(i).get_filename());
          ListView_InsertItem(hPlayList, &lv_item);
	   }

      lv_item.mask = LVIF_IMAGE;
      lv_item.iImage = I_IMAGECALLBACK;
      lv_item.iItem = pl.get_number_of_entries();
      ListView_InsertItem(hPlayList, &lv_item);

      ListView_SetColumnWidth(hPlayList, 0, LVSCW_AUTOSIZE);
      SetWindowText(hPlayList,
      	(pl.get_list_name()?pl.get_list_name():"Playlist"));
   }

   return TRUE;
}

BOOL PlayListWndHiliteCurrent() {
   static int lastHilited = -1;
   if (IsWindow(hPlayList)) {
   	// find the last selected one
   	LV_FINDINFO lv_findinfo;
      LV_ITEM     lv_item;
      int         lastSelected;

      lv_findinfo.flags  = LVFI_PARAM;
      lv_findinfo.lParam = (LPARAM) &lv_item;
      lv_item.state      = LVIS_SELECTED;
      lv_item.stateMask  = LVIS_SELECTED;

      lastSelected = ListView_FindItem(hPlayList, -1, &lv_findinfo);

      // unhilited any previous ones
   	ListView_SetItemState(hPlayList, lastSelected,
      							 !LVIS_SELECTED, LVIS_SELECTED);
   	ListView_SetItemState(hPlayList, lastHilited,
      							 !LVIS_DROPHILITED, LVIS_DROPHILITED);
   	// a bit misuse of LVIS_DROPHILITED here to indicate the current song
      // also set focus so the up- down- arraow, alpha, etc., work
   	ListView_SetItemState(hPlayList, lastHilited=pl.get_current_track(),
      							 LVIS_DROPHILITED | LVIS_FOCUSED,
                            LVIS_DROPHILITED | LVIS_FOCUSED);
      ListView_EnsureVisible(hPlayList, lastHilited, FALSE);
   }
   return (TRUE);
}

char* FindExtension(char *filename) {
	char *tmp=filename;
   while (*tmp++);
   while (*(--tmp) != '.');
   return tmp;
}

BOOL InitIconList() {

   hIconList=ImageList_Create(GetSystemMetrics(SM_CXSMICON),
    				  					GetSystemMetrics(SM_CYSMICON), TRUE, 1, 1);

	return (TRUE);
}

int LookUpIconIndex(char *filename) {
   HICON hIcon;
   char plItemName[MAX_FILENAME_LENGTH];
   unsigned short iIcon = 0;
   int index;

   static ext_iconindex_pair extIconindexPair;
   ext_iconindex_pair *currentPair = &extIconindexPair, *lastPair;

   // look for the index first
   while (currentPair) {
   	if (!strcmpi(currentPair->ext, FindExtension(filename)))
      	return currentPair->index;
      lastPair = currentPair;
      currentPair = currentPair->nextPair;
   }

   // did not find it, so add the new one
   strcpy(plItemName, filename);
   hIcon = ExtractAssociatedIcon(hInst, plItemName, &iIcon);
   index = ImageList_AddIcon(hIconList, hIcon);
   currentPair = new ext_iconindex_pair(FindExtension(filename),
                                        index, NULL);
   lastPair->nextPair = currentPair;
//   DeleteObject(hIcon);
   return currentPair->index;
}

