#ifndef W32_LVIEW_H
#define W32_LVIEW_H

#define  STRICT
#include <windows.h>

#include "playlist.h"

// commands for the list editor
#define LIST_NEW  0
#define LIST_EDIT 1

extern int listedit_command;

class ext_iconindex_pair {
public:
  	char ext[MAX_FILENAME_LENGTH];
   int index;
   ext_iconindex_pair *nextPair;

   ext_iconindex_pair() {
   	*ext = '\0';
   	index=-1;
      nextPair=NULL;
   }

   ext_iconindex_pair(char *_ext, int _index, ext_iconindex_pair *_nextPair) {
		strcpy(ext, _ext);
   	index = _index;
      nextPair = _nextPair;
   }

   ~ext_iconindex_pair() {
   	if (nextPair) delete nextPair;
   }
};

extern OPENFILENAME ofnListEdit;
extern OPENFILENAME ofnListSaveAs;
extern char ListSaveAsFilter[];
extern BOOL listedit_ok;
extern char ListEditAddName[MAX_FILENAME_LENGTH * 64];
extern char ListEditFileTitle[MAX_PATH];

void setup_lview_ofn();

BOOL CALLBACK NewListWndProc(HWND, UINT, WPARAM, LPARAM);

// Playlist editor dialog box procedure and helpers
BOOL CALLBACK ListEditProc(HWND  hDlg, UINT  message,
	 	   						WPARAM  wParam, LPARAM  lParam);

void edit_listview_entry(HWND hWndList, FileList *flp, int i,
                         BOOL add);

void rebuild_listview_entries(int start_index);

// Playlist item editor dialog box procedure
BOOL CALLBACK ListPropEditProc(HWND  hDlg, UINT  message,
	 	   						    WPARAM  wParam, LPARAM  lParam);

BOOL InitIconList();
int LookUpIconIndex(char *filename);
BOOL CreatePlayListWnd();
BOOL CleanupPlayListWnd();
BOOL UpdatePlayListWnd();
BOOL PlayListWndHiliteCurrent();

#endif // W32_LVIEW_H