#define  STRICT
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <shlobj.h>

#include <stdlib.h>

#include "str_lib.h"
#include "w32_common.h"
#include "w32_option.h"
#include "mp2win.h"

OPENFILENAME exe_ofn;

char ExeFilter[] =
"Executable Files (*.exe)\0*.exe\0"
"All Files (*.*)\0*.*\0";

char exe_name[MAX_PATH];

OPENFILENAME ofnOutput;
char OutputFilter[] =
"PCM Wave Files (.wav)\0*.wav\0"
"All Files (*.*)\0*.*\0";
char OutputFilename[MAX_PATH] = ""; // Name of PCM wave output file

void setup_option_ofn(LPSTR title)
{
	static bool init = false;

   if (!init) {

      exe_ofn.lStructSize       = sizeof(OPENFILENAME);
      exe_ofn.hwndOwner         = NULL;  // fill this in later
      exe_ofn.hInstance         = 0;
      exe_ofn.lpstrFilter       = (LPSTR) ExeFilter;
      exe_ofn.lpstrCustomFilter = NULL;
      exe_ofn.nMaxCustFilter    = 0;
      exe_ofn.nFilterIndex      = 1;
      exe_ofn.lpstrFile         = (LPSTR) exe_name;
      exe_ofn.nMaxFile          = sizeof(exe_name);
      exe_ofn.lpstrFileTitle    = NULL;
      exe_ofn.nMaxFileTitle     = 0;
      exe_ofn.lpstrInitialDir   = NULL;
      exe_ofn.Flags             = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST |
                                  OFN_HIDEREADONLY | OFN_EXPLORER;
      exe_ofn.nFileOffset       = 0;
      exe_ofn.nFileExtension    = 0;
      exe_ofn.lpstrDefExt       = "EXE";
      exe_ofn.lCustData         = 0;
      exe_ofn.lpfnHook          = NULL;
      exe_ofn.lpTemplateName    = NULL;

      init = true;
   }

   exe_ofn.lpstrTitle = title;
}

void CreatePropertySheet()
{
     PROPSHEETPAGE psp[6];
     PROPSHEETHEADER psh;

     psp[0].dwSize = sizeof(PROPSHEETPAGE);
     psp[0].dwFlags = PSP_USETITLE;
     psp[0].hInstance = hInst;
     psp[0].pszTemplate = MAKEINTRESOURCE(IDD_GENDIALOG);
     psp[0].pszIcon = NULL;
     psp[0].pfnDlgProc = Gen_Options;
     psp[0].pszTitle = "General";
     psp[0].lParam = 0;

     psp[1].dwSize = sizeof(PROPSHEETPAGE);
     psp[1].dwFlags = PSP_USETITLE;
     psp[1].hInstance = hInst;
     psp[1].pszTemplate = MAKEINTRESOURCE(IDD_MPODIALOG);
     psp[1].pszIcon = NULL;
     psp[1].pfnDlgProc = MPEG_Options;
     psp[1].pszTitle = "MPEG Decoding";
     psp[1].lParam = 0;

     psp[2].dwSize = sizeof(PROPSHEETPAGE);
     psp[2].dwFlags = PSP_USETITLE;
     psp[2].hInstance = hInst;
     psp[2].pszTemplate = MAKEINTRESOURCE(IDD_OUTDIALOG);
     psp[2].pszIcon = NULL;
     psp[2].pfnDlgProc = Output_Options;
     psp[2].pszTitle = "Decoder Output";
     psp[2].lParam = 0;

     psp[3].dwSize = sizeof(PROPSHEETPAGE);
     psp[3].dwFlags = PSP_USETITLE;
     psp[3].hInstance = hInst;
     psp[3].pszTemplate = MAKEINTRESOURCE(IDD_LISTDIALOG);
     psp[3].pszIcon = NULL;
     psp[3].pfnDlgProc = PL_Options;
     psp[3].pszTitle = "Playlists";
     psp[3].lParam = 0;

     psp[4].dwSize = sizeof(PROPSHEETPAGE);
     psp[4].dwFlags = PSP_USETITLE;
     psp[4].hInstance = hInst;
     psp[4].pszTemplate = MAKEINTRESOURCE(IDD_LYRDIALOG);
     psp[4].pszIcon = NULL;
     psp[4].pfnDlgProc = Lyric_Options;
     psp[4].pszTitle = "Lyrics";
     psp[4].lParam = 0;

     psp[5].dwSize = sizeof(PROPSHEETPAGE);
     psp[5].dwFlags = PSP_USETITLE;
     psp[5].hInstance = hInst;
     psp[5].pszTemplate = MAKEINTRESOURCE(IDD_IMGDIALOG);
     psp[5].pszIcon = NULL;
     psp[5].pfnDlgProc = Image_Options;
     psp[5].pszTitle = "Images";
     psp[5].lParam = 0;

     psh.dwSize = sizeof(PROPSHEETHEADER);
     psh.dwFlags = PSH_PROPSHEETPAGE;
     psh.hwndParent = hWnd;
     psh.hInstance = hInst;
     psh.pszIcon = NULL;
     psh.pszCaption = (LPSTR) "Options";
     psh.nStartPage = 0;
     psh.nPages = 6;
     psh.ppsp = (LPCPROPSHEETPAGE) &psp;

     optionsbox_open = TRUE;
     PropertySheet(&psh);
     optionsbox_open = FALSE;
}

BOOL WINAPI Gen_Options(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    static HWND ps_hWnd   = NULL;
    BOOL   new_systray_mode;

	 switch (message) {

		case WM_INITDIALOG:

		return TRUE;

		case WM_COMMAND:
		{
			switch (GET_WM_COMMAND_ID(wParam, lParam))  {

           case IDC_OPENPLAY:
           break;

           case IDC_CMDEXIT:
           break;

           case IDC_SYSTRAY:
           break;

           case IDC_PROMPT:
           break;

           case IDC_MULTIPLE:
           break;

           case IDC_TOPWINDOW:
           break;

           case IDC_AUTOSAVE:
           break;

           case IDC_SAVESET:
           PropSheet_Apply(ps_hWnd);
           settings(TRUE);
           return TRUE;

			  default:
			  return FALSE;
			}

        	PropSheet_Changed(ps_hWnd, hDlg);
         return TRUE;

			case WM_NOTIFY:
         switch (((NMHDR FAR *) lParam)->code)
         {
            case PSN_SETACTIVE:
		    	ps_hWnd   = ((NMHDR FAR *) lParam)->hwndFrom;

            // Initialize the controls.
            CheckDlgButton(hDlg, IDC_OPENPLAY, play_after_open);
            CheckDlgButton(hDlg, IDC_CMDEXIT,  cmdline_exit);
            CheckDlgButton(hDlg, IDC_SYSTRAY,  systray_mode);
            CheckDlgButton(hDlg, IDC_PROMPT,   prompt_after_done);
            CheckDlgButton(hDlg, IDC_MULTIPLE, allow_multiple);
            CheckDlgButton(hDlg, IDC_TOPWINDOW,
                           (BOOL) (topness == HWND_TOPMOST));
            CheckDlgButton(hDlg, IDC_AUTOSAVE, auto_save);

            PropSheet_UnChanged(ps_hWnd, hDlg);

            SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
            return TRUE;

            case PSN_KILLACTIVE: // This will be called when Apply is hit also
				play_after_open   = (BOOL) IsDlgButtonChecked(hDlg, IDC_OPENPLAY);
				cmdline_exit      = (BOOL) IsDlgButtonChecked(hDlg, IDC_CMDEXIT);
  				new_systray_mode  = (BOOL) IsDlgButtonChecked(hDlg, IDC_SYSTRAY);
            prompt_after_done = (BOOL) IsDlgButtonChecked(hDlg, IDC_PROMPT);
            allow_multiple    = (BOOL) IsDlgButtonChecked(hDlg, IDC_MULTIPLE);

            topness = IsDlgButtonChecked(hDlg, IDC_TOPWINDOW) ?
                      HWND_TOPMOST : HWND_NOTOPMOST;

            auto_save         = (BOOL) IsDlgButtonChecked(hDlg, IDC_AUTOSAVE);

            if (new_systray_mode && !systray_mode) {
            	TrayMessage(NIM_ADD, hWnd);
            } else if (!new_systray_mode && systray_mode) {
            	TrayMessage(NIM_DELETE, hWnd);
               if (hidden) {
	               ShowWindow(hWnd, SW_SHOW);
                  hidden = FALSE;
               }
            }

            systray_mode = new_systray_mode;

            // apply (non)topmost
            if (topness != HWND_TOPMOST) {
     	         SetWindowPos(hWnd, HWND_BOTTOM, 0, 0, 0, 0,
                            SWP_NOMOVE | SWP_NOSIZE);
            }

	         SetWindowPos(hWnd, topness, 0, 0, 0, 0,
                         SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);

            if (auto_save)
            	settings(TRUE);

				SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
            return TRUE;

            case PSN_RESET:
            // Reset to the original values.
            return TRUE;
         }
         return FALSE;
		}

		default:
		return FALSE;
	 }
}

void apply_MPEG(HWND hDlg, HWND priority_tb)
{
	char scalefact_text[32];

   priority = SendMessage(priority_tb, TBM_GETPOS, 0, 0);
   use_own_scalefac = IsDlgButtonChecked(hDlg, IDC_OWNSCALE);

   GetDlgItemText(hDlg, IDC_SCALEFACTOR, scalefact_text, 32);
   float new_scalefactor = atof(scalefact_text);

   if ((new_scalefactor < 0) || (new_scalefactor > 200000)) {
   	MessageBox(hDlg, "Scalefactor out of range. "
"The scalefactor must be between 0 and 200000.",
"MPEG Options error", MB_ICONEXCLAMATION | MB_OK);
      return;
	} else {
   	scalefactor = new_scalefactor;
   }

	if (IsDlgButtonChecked(hDlg, IDC_STEREO))
		mode = both;
	else if (IsDlgButtonChecked(hDlg, IDC_LEFT))
		mode = left;
	else if (IsDlgButtonChecked(hDlg, IDC_RIGHT))
		mode = right;
   else
     	mode = downmix;

   if (!(playing || paused) && MPEG)
   	File_Init(TRUE);

	return;
}

BOOL WINAPI MPEG_Options(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    char scalefact_text[32];
    static HWND ps_hWnd   = NULL;
    static HWND priority_tb = NULL;

	 switch (message) {

		case WM_COMMAND:

			switch (GET_WM_COMMAND_ID(wParam, lParam))  {

			  case IDC_STEREO:
			  CheckRadioButton(hDlg, IDC_STEREO, IDC_DOWNMIX, IDC_STEREO);
           break;

			  case IDC_LEFT:
			  CheckRadioButton(hDlg, IDC_STEREO, IDC_DOWNMIX, IDC_LEFT);
           break;

			  case IDC_RIGHT:
			  CheckRadioButton(hDlg, IDC_STEREO, IDC_DOWNMIX, IDC_RIGHT);
           break;

           case IDC_DOWNMIX:
			  CheckRadioButton(hDlg, IDC_STEREO, IDC_DOWNMIX, IDC_DOWNMIX);
           break;

           case IDC_OWNSCALE:
           case IDC_SCALEFACTOR:
			  break;

			  default:
			  return FALSE;
			}

	      PropSheet_Changed(ps_hWnd, hDlg);
      	return FALSE;

		case WM_NOTIFY:

      	switch (((NMHDR FAR *) lParam)->code)
         {
            case PSN_SETACTIVE:

		    	ps_hWnd   = ((NMHDR FAR *) lParam)->hwndFrom;
            priority_tb = GetDlgItem(hDlg, IDC_PRIORITY_TRACKBAR);

            // Initialize the controls.
				switch (mode) {
				  case both:
				  CheckRadioButton(hDlg, IDC_STEREO, IDC_DOWNMIX, IDC_STEREO);
				  break;

		  		  case left:
		  		  CheckRadioButton(hDlg, IDC_STEREO, IDC_DOWNMIX, IDC_LEFT);
			     break;

			     case right:
			     CheckRadioButton(hDlg, IDC_STEREO, IDC_DOWNMIX, IDC_RIGHT);
              break;

              case downmix:
              CheckRadioButton(hDlg, IDC_STEREO, IDC_DOWNMIX, IDC_DOWNMIX);
			     break;
            }

				SendMessage(priority_tb, TBM_SETRANGEMIN, FALSE,
                        THREAD_PRIORITY_LOWEST);
				SendMessage(priority_tb, TBM_SETRANGEMAX, FALSE,
            			   THREAD_PRIORITY_HIGHEST);
				SendMessage(priority_tb, TBM_SETPOS, TRUE, priority);
				SendMessage(priority_tb, TBM_SETTICFREQ,  1, 1);
				SendMessage(priority_tb, TBM_SETLINESIZE, 0, 1);
				EnableWindow(priority_tb, TRUE);

            CheckDlgButton(hDlg, IDC_OWNSCALE, use_own_scalefac);

				itoa((int) scalefactor, scalefact_text, 10);
				SetDlgItemText(hDlg, IDC_SCALEFACTOR, scalefact_text);

		      PropSheet_UnChanged(ps_hWnd, hDlg);

            SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
            return TRUE;

            case PSN_KILLACTIVE:  // This will be called when Apply is hit also
            apply_MPEG(hDlg, priority_tb);

            if (auto_save)
            	settings(TRUE);

            SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
            return TRUE;

				case PSN_RESET:
            return TRUE;

            default:
            return FALSE;
         }

		default:
		return FALSE;
    }
}


BOOL OutputFileOpen()
{
  if (!GetSaveFileName((LPOPENFILENAME) &ofnOutput))
  {
	 if (CommDlgExtendedError() != 0) // 0 value means user selected Cancel
		MessageBox(hWnd, "Could not open file.", "Warning", MB_OK | MB_ICONSTOP);

	 return FALSE;
  }

  return TRUE;
}

BOOL WINAPI Output_Options(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    static HWND ps_hWnd   = NULL;

	 switch (message) {

		case WM_INITDIALOG:

		return TRUE;

		case WM_COMMAND:
		switch (GET_WM_COMMAND_ID(wParam, lParam))  {

         case IDC_WAVEMAPPER:
         break;

         case IDC_DIRECTSOUND:
         break;

         case IDC_WAVEFILE:
         break;

         case IDC_FILENAME:
         break;

         case IDC_FILEBUT:
         OutputFileOpen();
         SetDlgItemText(hDlg, IDC_FILENAME, OutputFilename);
         break;

         default:
			return FALSE;
      }
      PropSheet_Changed(ps_hWnd, hDlg);
      return TRUE;

      case WM_NOTIFY:
      switch (((NMHDR FAR *) lParam)->code) {

         case PSN_SETACTIVE:
      	ps_hWnd   = ((NMHDR FAR *) lParam)->hwndFrom;

         // Initialize the controls.
         switch (output_mode) {
            case O_WAVEMAPPER:
				CheckRadioButton(hDlg, IDC_WAVEMAPPER, IDC_WAVEFILE,
                             IDC_WAVEMAPPER);
            break;

		  		case O_DIRECTSOUND:
				CheckRadioButton(hDlg, IDC_WAVEMAPPER, IDC_WAVEFILE,
                             IDC_DIRECTSOUND);
            break;

			   case O_WAVEFILE:
				CheckRadioButton(hDlg, IDC_WAVEMAPPER, IDC_WAVEFILE,
                             IDC_WAVEFILE);
            break;
         }

			SetDlgItemText(hDlg, IDC_FILENAME, OutputFilename);
         PropSheet_UnChanged(ps_hWnd, hDlg);

         SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
         return TRUE;

         case PSN_KILLACTIVE: // This will be called when Apply is hit also
			if (IsDlgButtonChecked(hDlg, IDC_WAVEMAPPER))
				output_mode = O_WAVEMAPPER;
			else if (IsDlgButtonChecked(hDlg, IDC_DIRECTSOUND))
	         output_mode = O_DIRECTSOUND;
			else
				output_mode = O_WAVEFILE;

			GetDlgItemText(hDlg, IDC_FILENAME, OutputFilename, 256);

			if (!(playing || paused) && MPEG)
           	File_Init(TRUE);

         if (auto_save)
           	settings(TRUE);

			SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
         return TRUE;

         case PSN_RESET:
         // Reset to the original values.
         return TRUE;

         default:
         return FALSE;
      }

		default:
		return FALSE;
	 }
}

BOOL WINAPI PL_Options(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    static HWND ps_hWnd   = NULL;

	 switch (message) {

	   case WM_INITDIALOG:

	   return TRUE;

		case WM_COMMAND:
		{
			switch (GET_WM_COMMAND_ID(wParam, lParam))  {

			  case IDC_RANDOMIZE:
           break;

           case IDC_WARN:
           break;

           case IDC_RELPATH:
           break;

           case IDC_EXPANDLIST:
           break;

           case IDC_LISTREMOVE:
           break;

           default:
           return FALSE;
      	}

      	PropSheet_Changed(ps_hWnd, hDlg);
	      return TRUE;

	      case WM_NOTIFY:
	      switch (((NMHDR FAR *) lParam)->code)
   	   {
         	case PSN_SETACTIVE:
            ps_hWnd   = ((NMHDR FAR *) lParam)->hwndFrom;

            // Initialize the controls.
            CheckDlgButton(hDlg, IDC_RANDOMIZE, rand_list_on_open);
            CheckDlgButton(hDlg, IDC_WARN, pl.get_entry_check());
            CheckDlgButton(hDlg, IDC_RELPATH, pl.get_save_relative());
            CheckDlgButton(hDlg, IDC_EXPANDLIST, pl.get_save_expand());
				CheckDlgButton(hDlg, IDC_LISTREMOVE, FALSE);
            PropSheet_UnChanged(ps_hWnd, hDlg);

            SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
            return TRUE;

            case PSN_KILLACTIVE: // This will be called when Apply is hit also
				rand_list_on_open = (BOOL) IsDlgButtonChecked(hDlg, IDC_RANDOMIZE);
				pl.set_warn_level((bool) IsDlgButtonChecked(hDlg, IDC_WARN));
				pl.set_save_relative((bool) IsDlgButtonChecked(hDlg, IDC_RELPATH));
				pl.set_save_expand((bool) IsDlgButtonChecked(hDlg, IDC_EXPANDLIST));
			   // list remove here

            if (auto_save)
            	settings(TRUE);

				SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
            return TRUE;

            case PSN_RESET:
            return TRUE;

            default:
				return FALSE;
         }
      }

      default:
      return FALSE;
    }
}

BOOL WINAPI Image_Options(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    static HWND ps_hWnd   = NULL;

	 switch (message) {

		case WM_INITDIALOG:

		return TRUE;

		case WM_COMMAND:

		switch (GET_WM_COMMAND_ID(wParam, lParam))  {

         case IDC_LISTIMGDISP:
         break;

         case IDC_DEFIMGVIEW:
         break;

         case IDC_CUSIMGVIEW:
         break;

         case IDC_CUSVIEWNAME:
         break;

         case IDC_CUSIMGVIEWSEL:
         setup_option_ofn("Select Image Viewer");

         if (GetOpenFileName(&exe_ofn))
            SetDlgItemText(hDlg, IDC_CUSVIEWNAME, exe_name);

         break;

         case IDC_IMGCMDLINE:
         break;

         default:
         return FALSE;
      }
     	PropSheet_Changed(ps_hWnd, hDlg);
		return TRUE;

	   case WM_NOTIFY:
	   switch (((NMHDR FAR *) lParam)->code)
   	{
         case PSN_SETACTIVE:
         ps_hWnd   = ((NMHDR FAR *) lParam)->hwndFrom;

         // Initialize the controls.
         CheckDlgButton(hDlg, IDC_LISTIMGDISP, display_images);
         PropSheet_UnChanged(ps_hWnd, hDlg);

         if (custom_img_viewer) {
				CheckRadioButton(hDlg, IDC_DEFIMGVIEW, IDC_CUSIMGVIEW,
	                          IDC_CUSIMGVIEW);
         } else {
				CheckRadioButton(hDlg, IDC_DEFIMGVIEW, IDC_CUSIMGVIEW,
	                          IDC_DEFIMGVIEW);
         }

         SetDlgItemText(hDlg, IDC_CUSVIEWNAME, civ_name);
         SetDlgItemText(hDlg, IDC_IMGCMDLINE, iv_cmdline);

         SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
         return TRUE;

         case PSN_KILLACTIVE: // This will be called when Apply is hit also

         display_images = IsDlgButtonChecked(hDlg, IDC_LISTIMGDISP);
			custom_img_viewer = IsDlgButtonChecked(hDlg, IDC_CUSIMGVIEW);

			GetDlgItemText(hDlg, IDC_CUSVIEWNAME, civ_name, MAX_PATH);
			GetDlgItemText(hDlg, IDC_IMGCMDLINE, iv_cmdline, MAX_PATH);

         if (auto_save)
          	settings(TRUE);

			SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
         return TRUE;

         case PSN_RESET:
         return TRUE;

         default:
         return FALSE;
      }

      default:
      return FALSE;
    }
}

BOOL WINAPI Lyric_Options(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    static HWND ps_hWnd   = NULL;

	 switch (message) {

		case WM_INITDIALOG:

		return TRUE;

		case WM_COMMAND:

		switch (GET_WM_COMMAND_ID(wParam, lParam))  {

         case IDC_LISTLYRDISP:
         break;

         case IDC_DEFLYRVIEW:
         break;

         case IDC_CUSLYRVIEW:
         break;

         case IDC_CUSVIEWNAME:
         break;

         case IDC_CUSLYRVIEWSEL:
         setup_option_ofn("Select Lyric Viewer");

         if (GetOpenFileName(&exe_ofn))
            SetDlgItemText(hDlg, IDC_CUSVIEWNAME, exe_name);

         break;

         case IDC_LYRCMDLINE:
         break;

         default:
         return FALSE;
      }
     	PropSheet_Changed(ps_hWnd, hDlg);
		return TRUE;

	   case WM_NOTIFY:
	   switch (((NMHDR FAR *) lParam)->code)
   	{
         case PSN_SETACTIVE:
         ps_hWnd   = ((NMHDR FAR *) lParam)->hwndFrom;

         // Initialize the controls.
         CheckDlgButton(hDlg, IDC_LISTLYRDISP, display_lyric_tf);
         PropSheet_UnChanged(ps_hWnd, hDlg);

         if (custom_tf_viewer) {
				CheckRadioButton(hDlg, IDC_DEFLYRVIEW, IDC_CUSLYRVIEW,
	                          IDC_CUSLYRVIEW);
         } else {
				CheckRadioButton(hDlg, IDC_DEFLYRVIEW, IDC_CUSLYRVIEW,
	                          IDC_DEFLYRVIEW);
         }

         SetDlgItemText(hDlg, IDC_CUSVIEWNAME, ctfv_name);
         SetDlgItemText(hDlg, IDC_IMGCMDLINE, tf_cmdline);

         SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
         return TRUE;

         case PSN_KILLACTIVE: // This will be called when Apply is hit also

         display_lyric_tf = IsDlgButtonChecked(hDlg, IDC_LISTLYRDISP);
			custom_tf_viewer = IsDlgButtonChecked(hDlg, IDC_CUSLYRVIEW);

			GetDlgItemText(hDlg, IDC_CUSVIEWNAME, ctfv_name, MAX_PATH);
			GetDlgItemText(hDlg, IDC_LYRCMDLINE, tf_cmdline, MAX_PATH);

         if (auto_save)
          	settings(TRUE);

			SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
         return TRUE;

         case PSN_RESET:
         return TRUE;

         default:
         return FALSE;
      }

      default:
      return FALSE;
    }
}


void settings(BOOL write_mode)
{
	char ret_type[MAX_PATH];
   char reg_data[MAX_PATH];
   char temp_str[32];
	HKEY ret_key1;
   HKEY ret_key2;
   DWORD disp;
   DWORD size;
   DWORD dw;

   RegOpenKeyEx(HKEY_CURRENT_USER, "Software", 0, KEY_CREATE_SUB_KEY,
   		       &ret_key1);

   RegCreateKeyEx(ret_key1, "Jeff's Tacos", 0, ret_type,
                  REG_OPTION_NON_VOLATILE, KEY_CREATE_SUB_KEY,
                  NULL, &ret_key2, &disp);

	RegCloseKey(ret_key1);

   RegCreateKeyEx(ret_key2, "Maplay 1.2+ for Win32", 0, ret_type,
   			      REG_OPTION_NON_VOLATILE, KEY_CREATE_SUB_KEY,
                  NULL, &ret_key1, &disp);

	RegCreateKeyEx(ret_key1, "General", 0, ret_type,
   			      REG_OPTION_NON_VOLATILE, KEY_WRITE,
                  NULL, &ret_key2, &disp);

   if (write_mode || (disp == REG_CREATED_NEW_KEY)) {
	   RegSetValueEx(ret_key2, "Play after open", 0, REG_SZ,
      				  (CONST BYTE *) (play_after_open ? "Y" : "N"),
                    2 * sizeof(char));
	   RegSetValueEx(ret_key2, "Exit after playing from the command line",
                    0, REG_SZ, (CONST BYTE *) (cmdline_exit ? "Y" : "N"),
                    2 * sizeof(char));
	   RegSetValueEx(ret_key2, "Prompt for new file after done", 0, REG_SZ,
      				  (CONST BYTE *) (prompt_after_done ? "Y" : "N"),
                    2 * sizeof(char));
	   RegSetValueEx(ret_key2, "Allow multiple instances", 0, REG_SZ,
      				  (CONST BYTE *) (allow_multiple ? "Y" : "N"),
                    2 * sizeof(char));
	   RegSetValueEx(ret_key2, "Minimize into systray", 0, REG_SZ,
      				  (CONST BYTE *) (systray_mode ? "Y" : "N"),
                    2 * sizeof(char));
	   RegSetValueEx(ret_key2, "Window always on top", 0, REG_SZ,
      				  (CONST BYTE *) ((topness == HWND_TOPMOST) ? "Y" : "N"),
                    2 * sizeof(char));
	   RegSetValueEx(ret_key2, "Automatically save settings", 0, REG_SZ,
      				  (CONST BYTE *) (auto_save ? "Y" : "N"),
                    2 * sizeof(char));

   } else {
   	size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Play after open", 0, NULL,
      				    (LPBYTE) reg_data, &size);
      play_after_open   = (reg_data[0] == 'Y');
      size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Exit after playing from the command line",
      				    0, NULL, (LPBYTE) reg_data, &size);
      cmdline_exit      = (reg_data[0] == 'Y');
      size = MAX_PATH;
		RegQueryValueEx(ret_key2, "Prompt for new file after done",
      				    0, NULL, (LPBYTE) reg_data, &size);
      prompt_after_done = (reg_data[0] == 'Y');
      size = MAX_PATH;
		RegQueryValueEx(ret_key2, "Allow multiple instances",
      				    0, NULL, (LPBYTE) reg_data, &size);
      allow_multiple    = (reg_data[0] == 'Y');
      size = MAX_PATH;
		RegQueryValueEx(ret_key2, "Minimize into systray",
      				    0, NULL, (LPBYTE) reg_data, &size);
      systray_mode      = (reg_data[0] == 'Y');
      size = MAX_PATH;
		RegQueryValueEx(ret_key2, "Window always on top",
      				    0, NULL, (LPBYTE) reg_data, &size);
      topness = (reg_data[0] == 'Y') ? HWND_TOPMOST : HWND_NOTOPMOST;
      size = MAX_PATH;
		RegQueryValueEx(ret_key2, "Automatically save settings",
      				    0, NULL, (LPBYTE) reg_data, &size);
      auto_save         = (reg_data[0] == 'Y');
   }

   RegCloseKey(ret_key2);

	RegCreateKeyEx(ret_key1, "MPEG Decoding", 0, ret_type,
   			      REG_OPTION_NON_VOLATILE, KEY_WRITE,
                  NULL, &ret_key2, &disp);

   if (write_mode || (disp == REG_CREATED_NEW_KEY)) {

   	switch (mode) {

       case left:
       lstrcpy(temp_str, "L");
       break;

       case right:
       lstrcpy(temp_str, "R");
       break;

       case downmix:
       lstrcpy(temp_str, "D");
       break;

		 case both:
       default:
       lstrcpy(temp_str, "S");
       break;
      }

	   RegSetValueEx(ret_key2, "Decode stereo in", 0, REG_SZ,
      				  (CONST BYTE *) temp_str, 2 * sizeof(char));

	   RegSetValueEx(ret_key2, "Use own scalefactor", 0, REG_SZ,
                    (CONST BYTE *) (use_own_scalefac ? "Y" : "N"),
                    2 * sizeof(char));

		dw = (DWORD) scalefactor;
	   RegSetValueEx(ret_key2, "Scalefactor", 0, REG_DWORD,
      				  (CONST BYTE *) &dw, sizeof(DWORD));

		dw = (DWORD) priority;
	   RegSetValueEx(ret_key2, "Priority", 0, REG_DWORD,
      				  (CONST BYTE *) &dw, sizeof(DWORD));
   } else {

   	size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Decode stereo in", 0, NULL,
      				    (LPBYTE) reg_data, &size);

      switch (reg_data[0])
      {
       case 'L':
       mode = left;
       break;

       case 'R':
       mode = right;
       break;

       case 'D':
       mode = downmix;
       break;

       case 'S':
       default:
       mode = both;
      }

	   RegQueryValueEx(ret_key2, "Use own scalefactor", 0, NULL,
      					 (LPBYTE) reg_data, &size);
      use_own_scalefac = (reg_data[0] == 'Y');

      size = sizeof(DWORD);
		RegQueryValueEx(ret_key2, "Scalefactor", 0, NULL,
                      (LPBYTE) reg_data, &size);
		scalefactor = (float) *((DWORD *) reg_data);

      size = MAX_PATH;
		RegQueryValueEx(ret_key2, "Priority", 0, NULL,
      				    (LPBYTE) reg_data, &size);
		priority    =   (int) *((DWORD *) reg_data);
   }

	RegCloseKey(ret_key2);

	RegCreateKeyEx(ret_key1, "Playlists", 0, ret_type,
   			      REG_OPTION_NON_VOLATILE, KEY_WRITE,
                  NULL, &ret_key2, &disp);

   if (write_mode || (disp == REG_CREATED_NEW_KEY)) {

	   RegSetValueEx(ret_key2, "Randomize on open", 0, REG_SZ,
                    (CONST BYTE *) (rand_list_on_open ? "Y" : "N"),
                    2 * sizeof(char));

	   RegSetValueEx(ret_key2, "Invalid file warn", 0, REG_SZ,
      				  (CONST BYTE *) (pl.get_warn_level() ? "Y" : "N"),
                    2 * sizeof(char));

	   RegSetValueEx(ret_key2, "Expand list when saving", 0, REG_SZ,
      				  (CONST BYTE *) (pl.get_save_expand() ? "Y" : "N"),
                    2 * sizeof(char));

	   RegSetValueEx(ret_key2, "Use relative path when saving", 0, REG_SZ,
      				  (CONST BYTE *) (pl.get_save_relative() ? "Y" : "N"),
                    2 * sizeof(char));

	} else {

   	size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Randomize on open",
      				    0, NULL, (LPBYTE) reg_data, &size);
      rand_list_on_open = (reg_data[0] == 'Y');
   	size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Invalid file warn",
      				    0, NULL, (LPBYTE) reg_data, &size);
		pl.set_warn_level(reg_data[0] == 'Y');
   	size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Expand list when saving",
      				    0, NULL, (LPBYTE) reg_data, &size);
		pl.set_save_expand(reg_data[0] == 'Y');
   	size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Use relative path when saving",
      				    0, NULL, (LPBYTE) reg_data, &size);
      pl.set_save_relative(reg_data[0] == 'Y');
	}

	RegCreateKeyEx(ret_key1, "Images", 0, ret_type,
   			      REG_OPTION_NON_VOLATILE, KEY_WRITE,
                  NULL, &ret_key2, &disp);

   if (write_mode || (disp == REG_CREATED_NEW_KEY)) {

	   RegSetValueEx(ret_key2, "Display images", 0, REG_SZ,
                    (CONST BYTE *) (display_images ? "Y" : "N"),
                    2 * sizeof(char));

	   RegSetValueEx(ret_key2, "Use custom viewer", 0, REG_SZ,
                    (CONST BYTE *) (custom_img_viewer ? "Y" : "N"),
                    2 * sizeof(char));

		RegSetValueEx(ret_key2, "Custom viewer path", 0, REG_SZ,
                    (CONST BYTE *) civ_name,
                    (lstrlen(civ_name) + 1) * sizeof(char));

		RegSetValueEx(ret_key2, "Viewer command line arguments", 0, REG_SZ,
                    (CONST BYTE *) iv_cmdline,
                    (lstrlen(iv_cmdline) + 1) * sizeof(char));
   } else {

   	size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Display images",
      				    0, NULL, (LPBYTE) reg_data, &size);
      display_images = (reg_data[0] == 'Y');

   	size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Use custom viewer",
      				    0, NULL, (LPBYTE) reg_data, &size);
      custom_img_viewer = (reg_data[0] == 'Y');

      size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Custom viewer path",
      				    0, NULL, (LPBYTE) civ_name, &size);

      size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Viewer command line arguments",
      				    0, NULL, (LPBYTE) iv_cmdline, &size);
	}

	RegCreateKeyEx(ret_key1, "Lyrics", 0, ret_type,
   			      REG_OPTION_NON_VOLATILE, KEY_WRITE,
                  NULL, &ret_key2, &disp);

   if (write_mode || (disp == REG_CREATED_NEW_KEY)) {

	   RegSetValueEx(ret_key2, "Display lyric text files", 0, REG_SZ,
                    (CONST BYTE *) (display_lyric_tf ? "Y" : "N"),
                    2 * sizeof(char));

	   RegSetValueEx(ret_key2, "Use custom viewer", 0, REG_SZ,
                    (CONST BYTE *) (custom_tf_viewer ? "Y" : "N"),
                    2 * sizeof(char));

		RegSetValueEx(ret_key2, "Custom viewer path", 0, REG_SZ,
                    (CONST BYTE *) ctfv_name,
                    (lstrlen(ctfv_name) + 1) * sizeof(char));

		RegSetValueEx(ret_key2, "Viewer command line arguments", 0, REG_SZ,
                    (CONST BYTE *) tf_cmdline,
                    (lstrlen(tf_cmdline) + 1) * sizeof(char));
   } else {

   	size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Display images",
      				    0, NULL, (LPBYTE) reg_data, &size);
      display_lyric_tf = (reg_data[0] == 'Y');

   	size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Use custom viewer",
      				    0, NULL, (LPBYTE) reg_data, &size);
      custom_tf_viewer = (reg_data[0] == 'Y');

      size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Custom viewer path",
      				    0, NULL, (LPBYTE) ctfv_name, &size);

      size = MAX_PATH;
	   RegQueryValueEx(ret_key2, "Viewer command line arguments",
      				    0, NULL, (LPBYTE) tf_cmdline, &size);
	}

	RegCloseKey(ret_key1);
   RegCloseKey(ret_key2);
}